#include "pc.h"
#include "src/pc/pcimpl.h"
#include "sles.h"
#include "parpre_pc.h"
#include "parpre_structure.h"
#include "parpre_subdomains.h"
#include "parpre_pipeline.h"
#include "subdomains_impl.h"
#include "src/pc/pcextra.h"
#include "pinclude/pviewer.h"

#undef __FUNC__
#define __FUNC__ "PCParallelDefaultGetLocalSLES"
static int PCParallelDefaultGetLocalSLES(PC pc,SLES *sub_method)
{
  PCParallelSubdomainStruct subdomains;
  int ierr;

  ierr = PCParallelGetSubdomains(pc,&subdomains); CHKERRQ(ierr);
  *sub_method = subdomains->local_method;

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelSetLocalSLES"
int PCParallelSetLocalSLES(PC pc,SLES local_sles)
{
  PCParallelSubdomainStruct subdomains;
  int ierr;

  ierr = PCParallelGetSubdomains(pc,&subdomains); CHKERRQ(ierr);
  subdomains->local_method = local_sles;

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelGetLocalSLES"
int PCParallelGetLocalSLES(PC pc,SLES *local_sles)
{
  PCParallelSubdomainStruct subdomains;
  int ierr;

  ierr = PCParallelGetSubdomains(pc,&subdomains); CHKERRQ(ierr);
  if (!subdomains->getlocalmethod)
    SETERRQ(1,0,"PCParallelGetLocalSLES: no method");
  ierr = (subdomains->getlocalmethod)(pc,local_sles); CHKERRQ(ierr);

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelSetGetLocalSLES"
int PCParallelSetGetLocalSLES(PC pc,int(*getlocalmethod)(PC,SLES*))
{
  PCParallelSubdomainStruct subdomains;
  int ierr;

  ierr = PCParallelGetSubdomains(pc,&subdomains); CHKERRQ(ierr);
  subdomains->getlocalmethod = getlocalmethod;

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelSubdomainsSetPipeline"
int PCParallelSubdomainsSetPipeline(PC pc,VecPipeline pipe)
{
  PCParallelSubdomainStruct subdomains;
  int ierr;

  ierr = PCParallelGetSubdomains(pc,&subdomains); CHKERRQ(ierr);
  subdomains->main_pipe = pipe;

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelSubdomainsHasPipeline"
int PCParallelSubdomainsHasPipeline(PC pc,int *flag)
{
  PCParallelSubdomainStruct subdomains;
  int ierr;

  ierr = PCParallelGetSubdomains(pc,&subdomains); CHKERRQ(ierr);
  *flag = (int)(subdomains->main_pipe);

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelSubdomainsGetPipeline"
int PCParallelSubdomainsGetPipeline(PC pc,VecPipeline *pipe)
{
  PCParallelSubdomainStruct subdomains;
  int ierr;

  ierr = PCParallelGetSubdomains(pc,&subdomains); CHKERRQ(ierr);
  if (!subdomains->main_pipe)
    SETERRQ(1,0,"PCParallelSubdomainsGetPipeline: no pipe");
  *pipe = subdomains->main_pipe;

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelSubdomainPipelineSetType"
/* PCParallelSubdomainPipelineSetType
   Set the pipeline type of a parallel preconditioner. This is necessary
   because of the Schwarz methods which have an embedded GBSSOR method;
   the pipe needs to be set in both.*/
int PCParallelSubdomainPipelineSetType(PC pc,PipelineType pipe_type)
{
  PCParallelSubdomainStruct subdomains;
  int ierr;

  if (!PCIsParallel(pc)) 
    SETERRQ(1,0,"Subdomain pipelines only for parallel methods\n");

  ierr = PCParallelGetSubdomains(pc,&subdomains); CHKERRQ(ierr);
  ierr = (subdomains->pipeline_settype)(pc,pipe_type);

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelDefaultSubdomainPipelineSetType"
int PCParallelDefaultSubdomainPipelineSetType(PC pc,PipelineType pipe_type)
{
  PCParallelSubdomainStruct subdomains;
  int ierr;

  ierr = PCParallelGetSubdomains(pc,&subdomains); CHKERRQ(ierr);
  subdomains->pipe_type = pipe_type;

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelSetSubdomainPipelineSetType"
int PCParallelSetSubdomainPipelineSetType(PC pc,int(*settype)(PC,PipelineType))
{
  PCParallelSubdomainStruct subdomains;
  int ierr;

  if (!PCIsParallel(pc)) 
    SETERRQ(1,0,"Subdomain pipelines only for parallel methods\n");

  ierr = PCParallelGetSubdomains(pc,&subdomains); CHKERRQ(ierr);
  subdomains->pipeline_settype = settype;

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelSubdomainPipelineGetType"
int PCParallelSubdomainPipelineGetType(PC pc,PipelineType *pipe_type)
{
  PCParallelSubdomainStruct subdomains;
  int ierr;

  if (!PCIsParallel(pc)) 
    SETERRQ(1,0,"Subdomain pipelines only for parallel methods\n");

  ierr = PCParallelGetSubdomains(pc,&subdomains); CHKERRQ(ierr);
  if (!subdomains->pipeline_gettype)
    SETERRQ(1,0,"PCParallelSubdomainPipelineGetType: no method");
  ierr = (subdomains->pipeline_gettype)(pc,pipe_type);

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelDefaultSubdomainPipelineGetType"
int PCParallelDefaultSubdomainPipelineGetType(PC pc,PipelineType *pipe_type)
{
  PCParallelSubdomainStruct subdomains;
  int ierr;

  ierr = PCParallelGetSubdomains(pc,&subdomains); CHKERRQ(ierr);
  *pipe_type = subdomains->pipe_type;

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelSetSubdomainPipelineGetType"
int PCParallelSetSubdomainPipelineGetType
(PC pc,int(*gettype)(PC,PipelineType*))
{
  PCParallelSubdomainStruct subdomains;
  int ierr;

  if (!PCIsParallel(pc)) 
    SETERRQ(1,0,"Subdomain pipelines only for parallel methods\n");

  ierr = PCParallelGetSubdomains(pc,&subdomains); CHKERRQ(ierr);
  subdomains->pipeline_gettype = gettype;

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelSubdomainsCreate"
int PCParallelSubdomainsCreate(PC pc,int size)
{
  int ierr;
  PCParallelStruct *pc_data;

  pc_data = (PCParallelStruct *) PetscMalloc(size);
  CHKPTRQ(pc_data);
  pc->data = (void *) pc_data;

  {
    PCParallelSubdomainStruct subdomains = (PCParallelSubdomainStruct)
      PetscMalloc(sizeof(struct _PCParallelSubdomainStruct));
    CHKPTRQ(subdomains);
    ierr = PCParallelSetSubdomains(pc,subdomains); CHKERRQ(ierr);
    subdomains->main_pipe = 0;
  }

  ierr = PCParallelSetGetLocalSLES
    (pc,&PCParallelDefaultGetLocalSLES);
  CHKERRQ(ierr);
  ierr = PCParallelSetSubdomainPipelineGetType
    (pc,&PCParallelDefaultSubdomainPipelineGetType);
  CHKERRQ(ierr);
  ierr = PCParallelSetSubdomainPipelineSetType
    (pc,&PCParallelDefaultSubdomainPipelineSetType);
  CHKERRQ(ierr);

  {
    SLES local_method;
    ierr = ParPreGenerateSLES(MPI_COMM_SELF,&local_method); CHKERRQ(ierr);
    ierr = PCParallelSetLocalSLES(pc,local_method);
  }

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelDestroySubdomains"
int PCParallelDestroySubdomains(PC pc)
{
  PCParallelSubdomainStruct subdomains;
  int ierr;

  ierr = PCParallelGetSubdomains(pc,&subdomains); CHKERRQ(ierr);
  ierr = SLESDestroy(subdomains->local_method); CHKERRQ(ierr);
  if (subdomains->main_pipe) {
    ierr = VecPipelineDestroy(subdomains->main_pipe); CHKERRQ(ierr);
  }
  PetscFree(subdomains);

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelSetSubdomainSystem"
int PCParallelSetSubdomainSystem(PC pc,Mat mat, Vec vec)
{
  SLES sub_method;
  int ierr;

  ierr = PCParallelGetLocalSLES(pc,&sub_method); CHKERRQ(ierr);
  ierr = ParPreSetupSLES(sub_method,PETSC_NULL,mat,vec); CHKERRQ(ierr);

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelGetLocalPC"
int PCParallelGetLocalPC(PC pc,PC *local_pc)
{
  SLES sles;
  int ierr;

  ierr = PCParallelGetLocalSLES(pc,&sles); CHKERRQ(ierr);
  ierr = SLESGetPC(sles,local_pc); CHKERRQ(ierr);

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelLocalSolveSetFromOptions"
int PCParallelLocalSolveSetFromOptions(PC pc)
{
  SLES sles;
  char *prefix;
  int ierr;

  ierr = PCParallelGetLocalSLES(pc,&sles); CHKERRQ(ierr);
  ierr = PCGetOptionsPrefix(pc,&prefix); CHKERRQ(ierr);
  ierr = SLESSetOptionsPrefix(sles,prefix); CHKERRQ(ierr);
  ierr = SLESAppendOptionsPrefix(sles,"sub_"); CHKERRQ(ierr);
  ierr = SLESSetFromOptions(sles); CHKERRQ(ierr);

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCSubdomainsView"
int PCSubdomainsView(PC pc,Viewer viewer)
{
  VecPipeline pipe;
  SLES sles;
  int ierr,flag;

  PetscPrintf(pc->comm,">> Subdomain method\n");
  ierr = PCParallelGetLocalSLES(pc,&sles); CHKERRQ(ierr);
  ierr = SLESView(sles,viewer); CHKERRQ(ierr);
  ierr = PCParallelSubdomainsHasPipeline(pc,&flag); CHKERRQ(ierr);
  if (flag) {
    PetscPrintf(pc->comm,"-- Subdomains pipeline\n");
    ierr = PCParallelSubdomainsGetPipeline(pc,&pipe); CHKERRQ(ierr);
    ierr = VecPipelineView(pipe,viewer); CHKERRQ(ierr);
  } else PetscPrintf(pc->comm,"Subdomains have no pipeline\n");

  return 0;
}
