static int MatSolveMat_AIJ(SLES solver,Mat off_mat,Mat *off_mult)
{
  Mat off_trans;
  int nrows = ((Mat_SeqAIJ *) off_mat->data)->m;
  int offcols = ((Mat_SeqAIJ *) off_mat->data)->n;
  int col,ierr; Vec rhs,sol; Scalar *lvals;

  /* allocate work space, transpose A_{12} so that we can
   * extract columns as rows */
  ierr = VecCreateSeq(MPI_COMM_SELF,nrows,&sol); CHKERRQ(ierr);
  lvals = (Scalar *) PetscMalloc( nrows*sizeof(Scalar) ); CHKPTRQ(lvals);
  ierr = MatTranspose_AIJ(off_mat,&off_trans); CHKERRQ(ierr);

  ierr = VecCreateSeq(MPI_COMM_SELF,nrows,&rhs); CHKERRQ(ierr);
  ierr = MatCreateSeqAIJ(MPI_COMM_SELF,nrows,offcols,0,0,off_mult);
  CHKERRQ(ierr);

  /* extract successive columns (as rows of the transpose), solve,
   * and store them back */
  for (col=0; col<offcols; col++) {
    Scalar *vals,zero = 0; int nelt,*elts,its,row;
    ierr = MatGetRow(off_trans,col,&nelt,&elts,&vals); CHKERRQ(ierr);
    PetscMemzero(lvals,nrows*sizeof(Scalar));
    ierr = VecSet(&zero,rhs); CHKERRQ(ierr);
    for (row=0; row<nelt; row++) {
      lvals[elts[row]] = vals[row];
      ierr = VecSetValues(rhs,1,elts+row,vals+row,INSERT_VALUES);
      CHKERRQ(ierr);
    }
    ierr = VecAssemblyBegin(rhs); CHKERRQ(ierr);
    ierr = VecAssemblyEnd(rhs); CHKERRQ(ierr);
/*ierr = VecCreateSeqFromData(MPI_COMM_SELF,nrows,lvals,&rhs);CHKERRQ(ierr);*/
/*printf("off column vec\n");VecView(rhs,0);*/

    ierr = SLESSolve(solver,rhs,sol,&its); CHKERRQ(ierr);

    {
      Scalar *tvals;
      ierr = VecGetArray(sol,&tvals); CHKERRQ(ierr);
      for (row=0; row<nrows; row++) {
	Scalar v = tvals[row];
	ierr = MatSetValues(*off_mult,1,&row,1,&col,&v,INSERT_VALUES);
	CHKERRQ(ierr);
      }
      ierr = VecRestoreArray(sol,&tvals); CHKERRQ(ierr);
    }
    ierr = MatRestoreRow(off_trans,col,&nelt,&elts,&vals); CHKERRQ(ierr);
  }
  ierr = VecDestroy(rhs); CHKERRQ(ierr);

  ierr = MatAssemblyBegin(*off_mult,MAT_FINAL_ASSEMBLY); CHKERRQ(ierr);
  ierr = MatAssemblyEnd(*off_mult,MAT_FINAL_ASSEMBLY); CHKERRQ(ierr);
/*printf("Solved off mat\n"); MatView(off_mat,0);*/

  ierr = MatDestroy(off_trans); CHKERRQ(ierr);
  ierr = VecDestroy(sol); CHKERRQ(ierr);

  return 0;
}
