#include "src/pc/pcimpl.h"      /*I "pc.h" I*/
#include "sles.h"
#include <stdio.h>
#include "src/sys/nreg.h"
#include "sys.h"
#include "options.h"
#include "src/vec/vecimpl.h"                     /*I "vec.h" I*/
#include "parpre_subdomains.h"

/****************************************************************
 **************** ParPre Setup
 ****************************************************************/
#undef __FUNC__
#define __FUNC__ "ParPreSetup"
int ParPreSetup(MPI_Comm comm,Mat A,PC B)
{
  Vec pc_vec;
  int ierr,lsize,idum;

  ierr = PCSetOperators(B,A,A,0); CHKERRQ(ierr);
  ierr = MatGetLocalSize(A,&lsize,&idum); CHKERRQ(ierr);
  ierr = VecCreateMPI(comm,lsize,PETSC_DECIDE,&pc_vec); CHKERRQ(ierr);
  ierr = PCSetVector(B,pc_vec); CHKERRQ(ierr);
  ierr = PCSetFromOptions(B); CHKERRQ(ierr);
  ierr = PCSetUp(B); CHKERRQ(ierr);

  return 0;
}
