#include "options.h"
#include "sles.h"
#include "src/pc/pcimpl.h"
#include "parpre_pipeline.h"

typedef struct {
  PCParallelSubdomainStruct subdomains;
  int halo_width;
  IS Schwarz_rows; int Schwarz_low;
  SLES ssor_solver;
  Mat Schwarz_mat,Schwarz_off;
  VecScatter scatter_to_extended;
  VecPipeline pipe_from_extended;
  Vec normal_vec,extended_vec,extended_vec2;
} PC_Schwarz_struct;


extern int PCSchwarzSetHaloSize(PC pc, int ns);
extern int PCSetFromOptions_Schwarz(PC pc);
extern int PCDestroy_Schwarz(PetscObject obj);
extern int PCSchwarzGetLocalSLES(PC schwarz_pc,SLES *ssor_method);
extern int PCSetup_Schwarz(PC pc);
extern int PCView_Schwarz(PetscObject obj,Viewer viewer);
extern int PCSchwartzInstallSSORSubSolve(PC pc);
