#undef __FUNC__
#define __FUNC__ "ExtendMatrix"
int ExtendMatrix(Mat *Schwarz_mat,Mat base_mat,
		 /* int *nSchwarz_rows, int **Schwarz_rows,*/
		 IS *Schwarz_rows,
		 IndStash *result_rows_to_get,
		 MPI_Comm comm,
		 int glob_max_rowlen,int off_max_rowlen)
{
  Mat_MPIAIJ *Aij = (Mat_MPIAIJ *) base_mat->data;
  int ierr,*t_rows,nt_rows,*s_rows,ns_rows;
  int N = Aij->N;
  int numtids, mytid;
  Mat tmat;
  IndStash rows_to_get = *result_rows_to_get;
  int nrows, row, *xrows=0;/* *ncols, **cols; Scalar **vals;*/
  MatGatherCtx gs; Mat get_mat=0;

  MPI_Comm_size(base_mat->comm,&numtids);
  MPI_Comm_rank(base_mat->comm,&mytid);

  ierr = ISGetSize(*Schwarz_rows,&ns_rows); CHKERRQ(ierr);
  ierr = ISGetIndices(*Schwarz_rows,&s_rows); CHKERRQ(ierr);

  /* First we establish a bigger matrix that contains the
   * old matrix elements, then we get the other elements */

  /* determine the new rows */
/*{int i;
printf("Adding rows to matrix:");
for (i=0; i<rows_to_get->n; i++) printf(" %d",rows_to_get->array[i]);
printf("\n");}
*/
  nt_rows = ns_rows+rows_to_get->n;
  t_rows = (int *) PetscMalloc( nt_rows*sizeof(int) ); CHKPTRQ(t_rows);
  PetscMemcpy(t_rows,
	      s_rows,ns_rows*sizeof(int));
  PetscMemcpy(t_rows+ns_rows,
	      rows_to_get->array,rows_to_get->n*sizeof(int));

  /* allocate a bigger matrix than the earlier Schwarz matrix */
  ierr = MatCreateSeqAIJ(MPI_COMM_SELF,nt_rows,N,5,0, &tmat);
  CHKERRQ(ierr);
  {
    int i,j,idx;
    for ( i=0; i<ns_rows; i++ ) {
      int ncol,*cols;
      Scalar *vals,v;
      
      ierr = MatGetRow(*Schwarz_mat,i,&ncol,&cols,&vals); CHKERRQ(ierr);
      for (idx=0; idx<ncol; idx++) {
	j = cols[idx];
	v = vals[idx];
	ierr =  MatSetValues(tmat,1,&i,1,&j,&v,INSERT_VALUES); CHKERRQ(ierr);
	
      }
      ierr = MatRestoreRow(*Schwarz_mat,i,&ncol,&cols,&vals); CHKERRQ(ierr);
    }
  }

  /* copy the new stuff into the Schwarz information */
  ierr = ISRestoreIndices(*Schwarz_rows,&s_rows); CHKERRQ(ierr);
  ierr = ISDestroy(*Schwarz_rows); CHKERRQ(ierr);
  ierr = ISCreateGeneral(MPI_COMM_SELF,nt_rows,t_rows,Schwarz_rows);
  CHKERRQ(ierr);
  ierr = MatDestroy(*Schwarz_mat); CHKERRQ(ierr);
  *Schwarz_mat = tmat;
/*MatView(*Schwarz_mat,0);*/

  nrows = rows_to_get->n;
  if (nrows>0) {
    IS wanted;
    ierr = ISCreateGeneral(MPI_COMM_SELF,nrows,rows_to_get->array,&wanted);
    CHKERRQ(ierr);

    xrows = (int *) PetscMalloc( nrows*sizeof(int)+1 ); CHKPTRQ(xrows);
    PetscMemcpy(xrows,rows_to_get->array,nrows*sizeof(int));

    ierr = MatGatherCtxCreate
      (base_mat,wanted,&gs); CHKERRQ(ierr);
    ierr = MatGatherRows(base_mat,gs,&get_mat); CHKERRQ(ierr);
    ierr = MatGatherCtxDestroy(gs); CHKERRQ(ierr);
  }

  /* now handle the rows that are being sent;
   * we go through the rows, and any indexes that are not yet
   * local, are stashed as to get for the next halo */
  ierr = NewIndexStash(&rows_to_get); CHKERRQ(ierr);
  for (row=0; row<nrows; row++) {
    int global_row,local_row,rowlen, j,k;
    int *this_row; Scalar *this_val;

    ierr = MatGetRow(get_mat,row,&rowlen,&this_row,&this_val);
    CHKERRQ(ierr);
    global_row = xrows[row]; local_row = -1;
    for (k=0; k<ns_rows; k++) {/* global -> local */
      if (s_rows[k] == global_row) {local_row = k; break;}
    }
    if (local_row==-1) SETERRQ(1,0,"Could not find global row locally");

    for (j=0; j<rowlen; j++) {
      int idx,found; Scalar val;

      idx = this_row[j]; val = this_val[j]; found = 0;
      for (k=0; k<ns_rows; k++) {/* global -> local */
	if (s_rows[k] == idx) {idx = k; found = 1; break;}
      }
      if (found) {
      } else {
	ierr = StashIndex(rows_to_get,1,&idx); CHKERRQ(ierr);
	idx = ns_rows+rows_to_get->n-1;
      }
      ierr =  MatSetValues
	(*Schwarz_mat,1,&local_row,1,&idx,&val,INSERT_VALUES);
    }
    ierr = MatRestoreRow(get_mat,row,&rowlen,&this_row,&this_val);
    CHKERRQ(ierr);
  }

  if (get_mat) ierr = MatDestroy(get_mat); CHKERRQ(ierr);
  ierr = MatAssemblyBegin(*Schwarz_mat,MAT_FINAL_ASSEMBLY); CHKERRQ(ierr);
  ierr = MatAssemblyEnd(*Schwarz_mat,MAT_FINAL_ASSEMBLY); CHKERRQ(ierr);
  if (xrows) PetscFree(xrows);
  *result_rows_to_get = rows_to_get;

/* printf("Matrix with halo\n"); MatView(*Schwarz_mat,0);*/

  return 0;
 }

/*
  {
    int irow,row,icol,col; Scalar val;
    for (irow=0; irow<nrows; irow++) {
      row = xrows[irow];
      printf("Received row %d=%d",irow,row);
      for (icol=0; icol<ncols[irow]; icol++) {
	col = cols[irow][icol];
	val = vals[irow][icol];
	printf(" elt %d=%e",col,val);
      }
      printf("\n");
    }
  }
*/

