/*
   Defines an OVERLAPPING  preconditioner for any Mat implementation
*/
#include "src/vec/vecimpl.h"
#include "src/mat/impls/aij/mpi/mpiaij.h"
#include "parpre_subdomains.h"
#include "pcschwarz.h"
#include "src/pc/pcextra.h"

#define CHUNCKSIZE   100

extern int PCSetFromOptions_Schwarz(PC pc);

extern int ParPreTraceBackErrorHandler
    (int,char*,char*,char*,int,int,char*,void*);

#undef __FUNC__
#define __FUNC__ "PCApply_AddSchwarz"
static int PCApply_AddSchwarz(PC pc,Vec x,Vec y)
{
  PC_Schwarz_struct *pc_data = (PC_Schwarz_struct *) pc->data;
  int ierr,its;
  Scalar zero = 0.0;

  ierr = PetscPushErrorHandler(&ParPreTraceBackErrorHandler,MPI_COMM_WORLD);
  CHKERRQ(ierr);
  /*VecView(x,0);*/
  ierr = VecScatterBegin
    (x,pc_data->extended_vec,INSERT_VALUES,SCATTER_FORWARD,
     pc_data->scatter_to_extended);
  CHKERRQ(ierr);
  ierr = VecScatterEnd
    (x,pc_data->extended_vec,INSERT_VALUES,SCATTER_FORWARD,
     pc_data->scatter_to_extended);
  CHKERRQ(ierr);

  ierr = SLESSolve(pc_data->ssor_solver,
		   pc_data->extended_vec,pc_data->extended_vec2,&its);
  /*VecView(pc_data->extended_vec,0); VecView(pc_data->extended_vec2,0);*/
  CHKERRQ(ierr);

  VecSet(&zero,y);

  ierr = VecScatterBegin
    (pc_data->extended_vec2,y,ADD_VALUES,SCATTER_REVERSE,
     pc_data->scatter_to_extended);
  CHKERRQ(ierr);
  ierr = VecScatterEnd
    (pc_data->extended_vec2,y,ADD_VALUES,SCATTER_REVERSE,
     pc_data->scatter_to_extended);
  CHKERRQ(ierr);
  /*VecView(y,0);*/
  ierr = PetscPopErrorHandler(); CHKERRQ(ierr);

  return 0;

}

#undef __FUNC__
#define __FUNC__ "PCCreate_AddSchwarz"
int PCCreate_AddSchwarz(PC pc)
{
  int ierr;

  pc->apply     = PCApply_AddSchwarz;
  pc->applyrich = 0;
  pc->destroy   = PCDestroy_Schwarz;
  pc->printhelp = 0;
  pc->view      = PCView_Schwarz;
  pc->setup     = PCSetup_Schwarz;
  pc->setfrom   = PCSetFromOptions_Schwarz;
  pc->type      = PCAdditiveSchwarz;

  ierr = PCParallelSubdomainsCreate(pc,sizeof(PC_Schwarz_struct));
  CHKERRQ(ierr);

  ierr = PCSchwartzInstallSSORSubSolve(pc); CHKERRQ(ierr);
  ierr = PCParallelSubdomainPipelineSetType
    (pc,PIPELINE_NONE); CHKERRQ(ierr);

  return 0;
}
