#include "./ml_impl.h"

int SolveMultiLevel(MC_OneLevel_struct*this_level,Vec x,Vec y);

/* Transfer 1-component to 2-component, and solve there. */
#undef __FUNC__
#define __FUNC__ "SolveNextLevels"
static int SolveNextLevels
(MC_OneLevel_struct *this_level,Vec x,Vec y,Vec x_1,Vec y_1)
{
  Scalar mone=-1.0;
  int ierr;

  /* transfer to next level by (2,1) multiplication */
  ierr = MatMult(this_level->g21,x_1,this_level->g2); CHKERRQ(ierr);
  /* transfer to next level */
  ierr = VecScatterBegin(x,this_level->v2, INSERT_VALUES,SCATTER_FORWARD,
			 this_level->get_rest); CHKERRQ(ierr);
  ierr = VecScatterEnd(x,this_level->v2, INSERT_VALUES,SCATTER_FORWARD,
		       this_level->get_rest); CHKERRQ(ierr);
  ierr = VecAXPY(&mone,this_level->u2,this_level->v2); CHKERRQ(ierr);

  /* solve next level */
  if (this_level->next_level) {
    ierr = SolveMultiLevel
      (this_level->next_level,this_level->h2,this_level->g2);
    CHKERRQ(ierr);
  } else if (this_level->a22_solve) {
    int its;
    ierr = SLESSolve(this_level->a22_solve,
		     this_level->h2,this_level->g2,&its); CHKERRQ(ierr);
/*printf("input on deepest level \n");VecView(this_level->h2,0);
printf("output on deepest level\n");VecView(this_level->g2,0);*/
  } else SETERRQ(1,0,"Empty deepest level should have been caught");

  /* transfer from next level */
  ierr = VecScatterBegin(this_level->u2,y, INSERT_VALUES,SCATTER_FORWARD,
			 this_level->put_rest); CHKERRQ(ierr);
  ierr = VecScatterEnd(this_level->u2,y, INSERT_VALUES,SCATTER_FORWARD,
		       this_level->put_rest); CHKERRQ(ierr);
  /* transfer to previous level by multiplication */
  ierr = MatMult(this_level->g12,this_level->g2,y_1); CHKERRQ(ierr);

  return 0;
}

/* solve (1,1) block */
#undef __FUNC__
#define __FUNC__ "Solve1BlockFor"
static int Solve1BlockFor(MC_OneLevel_struct *this_level,Vec x,Vec y)
{
  int its,ierr;

  if (this_level->grid_choice == AMLCoarseGridDependent) {
    ierr = VecPointwiseMult(x,this_level->cdiag1,y); CHKERRQ(ierr);
  } else {
    ierr = SLESSolve(this_level->a11_solve,x,y,&its); CHKERRQ(ierr);
  }
  return 0;
}

#undef __FUNC__
#define __FUNC__ "Solve1BlockBack"
static int Solve1BlockBack(MC_OneLevel_struct *this_level,Vec x,Vec y)
{
  int its,ierr;

  if (this_level->grid_choice == AMLCoarseGridDependent) {
    ierr = VecPointwiseMult(x,this_level->cdiag1,y); CHKERRQ(ierr);
  } else {
    ierr = SLESSolve(this_level->a11_solve,x,y,&its); CHKERRQ(ierr);
  }
  return 0;
}

#undef __FUNC__
#define __FUNC__ "SolveThisLevel"
static int SolveThisLevel(MC_OneLevel_struct *this_level,Vec x,Vec y)
{
  int ierr; Scalar mone = -1.0;
  InsertMode UPDATE_VALUES;

  if (! ((int)(this_level->a22_solve) | (int)(this_level->next_level)))
    SETERRQ(1,0,"This cannot happen: end in 1-block");
  
  /* solve (1,1) block */
  ierr = VecScatterBegin(x,this_level->u1, INSERT_VALUES,SCATTER_FORWARD,
			 this_level->get_clr); CHKERRQ(ierr);
  ierr = VecScatterEnd(x,this_level->u1, INSERT_VALUES,SCATTER_FORWARD,
		       this_level->get_clr); CHKERRQ(ierr);
  ierr = Solve1BlockFor(this_level,this_level->g1,this_level->h1);
  CHKERRQ(ierr);
  if (this_level->solve_scheme==AMLSolveILU) {
    ierr = VecScatterBegin(this_level->v1,y, INSERT_VALUES,SCATTER_FORWARD,
			   this_level->put_clr); CHKERRQ(ierr);
    ierr = VecScatterEnd(this_level->v1,y, INSERT_VALUES,SCATTER_FORWARD,
			 this_level->put_clr); CHKERRQ(ierr);
    UPDATE_VALUES = ADD_VALUES;
  } else UPDATE_VALUES = INSERT_VALUES;

  /* solve next level(s) */
  ierr = SolveNextLevels(this_level,x,y,this_level->h1,this_level->g1);
  CHKERRQ(ierr);

  /* write back 1-component */
  ierr = Solve1BlockBack(this_level,this_level->g1,this_level->h1);
  CHKERRQ(ierr);
printf("Next levels after back transport and solve\n");
VecView(this_level->h1,0);
  ierr = VecScale(&mone,this_level->v1); CHKERRQ(ierr);
  ierr = VecScatterBegin(this_level->v1,y, UPDATE_VALUES,SCATTER_FORWARD,
			 this_level->put_clr); CHKERRQ(ierr);
  ierr = VecScatterEnd(this_level->v1,y, UPDATE_VALUES,SCATTER_FORWARD,
		       this_level->put_clr); CHKERRQ(ierr);
  return 0;
}

/* the main recursive solve routine */
#undef __FUNC__
#define __FUNC__ "SolveMultiLevel"
int SolveMultiLevel(MC_OneLevel_struct *this_level,Vec x,Vec y)
{
  Scalar mone = -1.0, mfrac = -2.; /* VE !!! */
  int its,ierr;

  if ((int)this_level->pre_smooth) {
    if (!(this_level->post_smooth)) SETERRQ(1,0,"AMG solve needs post smooth");
/*printf("pre smooth input @ %d\n",this_level->level);VecView(x,0);*/
    ierr = SLESSolve(this_level->pre_smooth,x,y,&its); CHKERRQ(ierr);
/*printf("pre smooth output@ %d\n",this_level->level);VecView(y,0);*/
    
    ierr = MatMult(this_level->mat,y,this_level->u); CHKERRQ(ierr);
    ierr = VecAXPY(&mone,x,this_level->u); CHKERRQ(ierr);
    
    ierr = SolveThisLevel(this_level,this_level->u,this_level->v);
    CHKERRQ(ierr);
    
    ierr = VecAXPY(&mfrac,this_level->v,y); CHKERRQ(ierr);
    ierr = MatMult(this_level->mat,y,this_level->u); CHKERRQ(ierr);
    ierr = VecAXPY(&mone,x,this_level->u); CHKERRQ(ierr);
    
    ierr = SLESSolve
      (this_level->post_smooth,this_level->u,this_level->v,&its);
    CHKERRQ(ierr);
    
    ierr = VecAXPY(&mone,this_level->v,y); CHKERRQ(ierr);
  } else {
    ierr = SolveThisLevel(this_level,x,y); CHKERRQ(ierr);
  }
/*printf("input on level %d\n",this_level->level);VecView(x,0);
printf("output on level %d\n",this_level->level);VecView(y,0);*/
  return 0;
}

