#include "petsc.h"
#include "pc.h"
#include "src/pc/pcimpl.h"
#include "ml_impl.h"

/****************************************************************
 * User Interface                                               *
 ****************************************************************/

#undef __FUNC__
#define __FUNC__ "AMLSetFillMethod"
int AMLSetFillMethod(PC pc,AMLFillMethod fill_method)
{
  PCType meth; int ierr;
  ierr = PCGetType(pc,&meth,PETSC_NULL); CHKERRQ(ierr);
  if (!(meth==PCMultiLevel)) SETERRQ(1,0,"Fill method can only be set for AML");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->fill_method = fill_method;
  }
  return 0;
}

#undef __FUNC__
#define __FUNC__ "AMLSetSolutionScheme"
int AMLSetSolutionScheme(PC pc,AMLSolveScheme solve_scheme)
{
  PCType meth; int ierr;
  ierr = PCGetType(pc,&meth,PETSC_NULL); CHKERRQ(ierr);
  if (!(meth==PCMultiLevel)) SETERRQ(1,0,"Solve scheme can only be set for AML");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->solve_scheme = solve_scheme;
  }
  return 0;
}

#undef __FUNC__
#define __FUNC__ "AMLSetCoarseGridDependent"
int AMLSetCoarseGridDependent(PC pc)
{
  PCType meth; int ierr;
  ierr = PCGetType(pc,&meth,PETSC_NULL); CHKERRQ(ierr);
  if (!(meth==PCMultiLevel)) SETERRQ(1,0,"Grid choice can only be set for AML");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->grid_choice = AMLCoarseGridDependent;
  }
  return 0;
}

#undef __FUNC__
#define __FUNC__ "AMLSetCoarseGridIndependent"
int AMLSetCoarseGridIndependent(PC pc)
{
  PCType meth; int ierr;
  ierr = PCGetType(pc,&meth,PETSC_NULL); CHKERRQ(ierr);
  if (!(meth==PCMultiLevel)) SETERRQ(1,0,"Grid choice can only be set for AML");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->grid_choice = AMLCoarseGridIndependent;
  }
  return 0;
}

#undef __FUNC__
#define __FUNC__ "AMLSetCutoffSize"
int AMLSetCutoffSize(PC pc,int siz)
{
  PCType meth; int ierr;
  ierr = PCGetType(pc,&meth,PETSC_NULL); CHKERRQ(ierr);
  if (!(meth==PCMultiLevel)) SETERRQ(1,0,"Cutoff sizes can only be set for AML");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->cutoff = siz;
  }
  return 0;
}

#undef __FUNC__
#define __FUNC__ "AMLSet11JacobiIterations"
int AMLSet11JacobiIterations(PC pc,int it)
{
  PCType meth; int ierr;
  ierr = PCGetType(pc,&meth,PETSC_NULL); CHKERRQ(ierr);
  if (!(meth==PCMultiLevel))
    SETERRQ(1,0,"11Block iterations can only be set for AML");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->it11 = it;
  }
  return 0;
}

#undef __FUNC__
#define __FUNC__ "AMLSetSmootherChoice"
int AMLSetSmootherChoice(PC pc,AMLSmootherChoice smoother)
{
  PCType meth; int ierr;
  ierr = PCGetType(pc,&meth,PETSC_NULL); CHKERRQ(ierr);
  if (!(meth==PCMultiLevel))
    SETERRQ(1,0,"Smoothers can only be set for AML");
  {
    PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
    pc_data->smoother_choice = smoother;
  }

  return 0;
}

#undef __FUNC__
#define __FUNC__ "AMLSetISFromStrong"
int AMLSetISFromStrong(PC pc)
{
  PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;

  pc_data->mis_from_strong = 1;


  return 0;
}

#undef __FUNC__
#define __FUNC__ "AMLSetISFromOriginal"
int AMLSetISFromOriginal(PC pc)
{
  PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;

  pc_data->mis_from_strong = 0;

  return 0;
}

/* obviated
#undef __FUNC__
#define __FUNC__ "PCMultiLevelGetPreSmoother"
int PCMultiLevelGetPreSmoother(PC pc,PC *local_pc)
{
  PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
  int ierr;

  ierr = SLESGetPC(pc_data->pre_smoother,local_pc); CHKERRQ(ierr);
  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCMultiLevelGetPostSmoother"
int PCMultiLevelGetPostSmoother(PC pc,PC *local_pc)
{
  PC_MCol_struct *pc_data = (PC_MCol_struct *) pc->data;
  int ierr;

  ierr = SLESGetPC(pc_data->post_smoother,local_pc); CHKERRQ(ierr);
  return 0;
}

*/
