/* additions to pc.h for the parpre routines */

#if !defined(__PARPRE_PC_PACKAGE)
#define __PARPRE_PC_PACKAGE

#include "parpre_vec.h"
#include "pc.h"
#include "sles.h"

extern int ParPreSetup(MPI_Comm comm,Mat A,PC B);
extern int PCIsParallel(PC);
extern int PCParallelGetLocalSLES(PC pc,SLES *local_sles);
extern int PCParallelGetLocalPC(PC pc,PC *local_pc);

/* schwarz methods */
extern int PCIsSchwarzMethod(PC pc);
extern int PCSchwarzSetHaloSize(PC,int);

/* generalised block ssor */
extern int PCGenBlockSSORSetGlobalFactorisation(PC pc);
extern int PCGenBlockSSORSetNoGlobalFactorisation(PC pc);

/* domain decomposition */
extern int PCDomainDecompGetInterfacePC(PC pc,PC *local_pc);

/* multilevel */
typedef enum {AMLFillNone, AMLFillDiag, AMLFillStrong,
	      AMLFillFull }AMLFillMethod;
extern int AMLSetFillMethod(PC pc,AMLFillMethod fill_method);

typedef enum {AMLSolveMG, AMLSolvePolynomial,
	      AMLSolveILU} AMLSolveScheme;
extern int AMLSetSolutionScheme(PC pc,AMLSolveScheme solve_scheme);

int PCMultiLevelGetPreSmoother(PC pc,PC *local_pc);
int PCMultiLevelGetPostSmoother(PC pc,PC *local_pc);

typedef enum {AMLCoarseGridDependent, 
	      AMLCoarseGridIndependent} AMLCoarseGridChoice;
typedef enum {AMLSmoothNone=0, AMLPreSmooth=1, AMLPostSmooth=2, 
	      AMLPrePostSmooth=3} AMLSmootherChoice;
extern int AMLSetCoarseGridDependent(PC pc);
extern int AMLSetCoarseGridIndependent(PC pc);
extern int AMLSetCutoffSize(PC pc,int siz);
extern int AMLSet11JacobiIterations(PC pc,int it);
extern int AMLSetSmootherChoice(PC pc,AMLSmootherChoice smoother);
extern int AMLSetISFromStrong(PC pc);
extern int AMLSetISFromOriginal(PC pc);

#endif
