#ifndef __PARPRE_MAT_PACKAGE 
#define __PARPRE_MAT_PACKAGE
/****************************************************************
 * prototypes of auxiliary matrix functions in ParPre           *
 ****************************************************************/
#include "mat.h"
#include "parpre_pipeline.h"

typedef struct _MatGatherCtx* MatGatherCtx;

extern int  MatCreateScatterPipeline
(Mat base_mat,PipelineType pipe_type,
 Vec *border_vec,VecPipeline *main_pipe);

extern int MatGatherCtxCreate(Mat mat,IS wanted,MatGatherCtx *rgs);
extern int MatGatherCtxDestroy(MatGatherCtx gs);
extern int MatGatherRows(Mat mat,MatGatherCtx gs, Mat *res_mat);
extern int MatGatherRowsPipelineBegin
(Mat mat,PipelineDirection ptype,MatGatherCtx gs, Mat *ret);
extern int MatGatherRowsPipelineEnd
(Mat mat,PipelineDirection ptype,MatGatherCtx gs, Mat *ret);

extern int MatrixAij2MpiAbut(int part,Mat in,MPI_Comm comm,Mat *out);
extern int MatrixAij2MpiIndex(IS idx,int m,int n,int M,int N,
			      Mat in,MPI_Comm comm,Mat *out);

#endif
