#include <stdio.h>
#include "./examples.h"

#undef __FUNC__
#define __FUNC__ "prec_setup"
int prec_setup(MPI_Comm comm,Mat A,PC the_pc)
{
  PCType pc_name = PCMultiLevel;
  int mytid,ierr;

  MPI_Comm_rank(comm,&mytid);
  /* ---------------------------------- *
   * ---- here is the crucial part ---- *
   * ---------------------------------- */
  if (!mytid) printf("Setting up AMG pc %d\n",pc_name);
  ierr = PCSetType(the_pc,pc_name); CHKERRQ(ierr);

  /* multigrid */
  ierr = AMLSetSolutionScheme(the_pc,AMLSolveMG); CHKERRQ(ierr);
  ierr = AMLSetSmootherChoice(the_pc,AMLPrePostSmooth); CHKERRQ(ierr);
  ierr = AMLSetCoarseGridIndependent(the_pc); CHKERRQ(ierr);
  ierr = AMLSetFillMethod(the_pc,AMLFillStrong); CHKERRQ(ierr);

  /* incomplete factorisation */
  /*
  ierr = AMLSetSolutionScheme(the_pc,AMLSolveILU); CHKERRQ(ierr);
  ierr = AMLSetCoarseGridDependent(the_pc); CHKERRQ(ierr);
  ierr = AMLSetFillMethod(the_pc,AMLFillDiag); CHKERRQ(ierr);
  */

  /* undocumented option */
  ierr = AMLSetISFromOriginal/*Strong*/(the_pc); CHKERRQ(ierr);

  /* set the smoothers */
  {
    PC local_pc;

    /* a11 solver */
    ierr = PCParallelGetLocalPC(the_pc,&local_pc); CHKERRQ(ierr);
    ierr = PCSetType(local_pc,PCJACOBI); CHKERRQ(ierr);
    ierr = AMLSet11JacobiIterations(the_pc,1);
    /*
      ierr = PCSetType(local_pc,PCSOR); CHKERRQ(ierr);
      ierr = PCSORSetSymmetric(local_pc,SOR_LOCAL_SYMMETRIC_SWEEP); CHKERRQ(ierr);
      ierr = PCSORSetIterations(local_pc,1); CHKERRQ(ierr);
      */
    
    /* last level solver */
    ierr = AMLSetCutoffSize(the_pc,15); CHKERRQ(ierr);
    ierr = OptionsSetValue("-lastlevel_pc_type","jacobi"); CHKERRQ(ierr);
  }
  /* ---------------------------------- */

  ierr = ParPreSetup(comm,A,the_pc); CHKERRQ(ierr);

  return 0;
}

