#include <stdio.h>
#include "./examples.h"

#undef __FUNC__
#define __FUNC__ "prec_setup"
int prec_setup(MPI_Comm comm,Mat A,PC the_pc)
{
  int mytid,ierr;

  MPI_Comm_rank(comm,&mytid);

  if (!mytid) printf("Setting up Generalised Block SSOR pc\n");
  /* ---------------------------------- *
   * ---- here is the crucial part ---- *
   * ---------------------------------- */
  ierr = PCSetType(the_pc,PCGenBlockSSOR); CHKERRQ(ierr);

  /* Declare local solve */
  {
    PC local_pc;
    ierr = PCParallelGetLocalPC(the_pc,&local_pc); CHKERRQ(ierr);
    ierr = PCSetType(local_pc,PCLU); CHKERRQ(ierr);
  }

  ierr = PCGenBlockSSORSetGlobalFactorisation(the_pc); CHKERRQ(ierr);
  ierr = PCParallelSubdomainPipelineSetType(the_pc,PIPELINE_SEQUENTIAL);
  CHKERRQ(ierr);

  /* ---------------------------------- */

  ierr = ParPreSetup(comm,A,the_pc); CHKERRQ(ierr);

  return 0;
}

