/* first couple of definitions largely copied from Scatter constructs */

#define VEC_PIPELINE_COOKIE PETSC_COOKIE+4

typedef enum {PIPELINE_DOWN=0,PIPELINE_UP=1,
		PIPELINE_CUSTOM_UP=2,PIPELINE_CUSTOM_DOWN=3 /* VE */
	    } PipelineMode;

typedef struct _PCParallel_PipeInfo *PCParallel_PipeInfo;

typedef struct _PipelineObject* PipelineObject;
typedef int (*PipelineFunction)(int,PetscObject);

typedef struct {
  VecScatterType type;
  int            n;                    /* number of components to pipeline */
  int            *slots;               /* locations of components */
  /*
       The next three fields are used on in parallel pipelines they contain 
       optimization in the special case that the "to" vector and the "from" 
       vector are the same, so one only needs copy components that truly 
       copies instead of just y[idx[i]] = y[jdx[i]] where idx[i] == jdx[i].
  */
  int            nonmatching_computed;
  int            n_nonmatching;        /* number of "from"s  != "to"s */
  int            *slots_nonmatching;   /* locations of "from"s  != "to"s */
} VecPipeline_Seq_General;

typedef struct {
  VecScatterType type;
  int            n;
  int            first;
  int            step;           
} VecPipeline_Seq_Stride;

typedef struct {
  VecScatterType type;
  int            *count;        /* elements of vector on each processor */
  Scalar         *work1;
  Scalar         *work2;        
} VecPipeline_MPI_ToAll;

typedef struct { 
  VecScatterType     type;
  int                n;        /* number of processors to send/receive */
  int                nbelow;   /* number with lower process id */
  int                nself;    /* number sending to self */
  int                *starts;  /* starting point in indices and values for each 
proc*/ 
  int                *indices; /* list of all components sent or received */
  int                *procs;   /* processors we are communicating with in scatte
r */
  MPI_Request        *requests;
  Scalar             *values;  /* buffer for all sends or receives */
                               /* note that we pack/unpack ourselves;
                                   we do not use MPI packing */
  VecPipeline_Seq_General local;    /* any part that happens to be local */
  MPI_Status         *sstatus;
} VecPipeline_MPI_General;

struct _VecPipeline;
typedef struct _VecPipeline*  VecPipeline;
struct _VecPipeline {
  PETSCHEADER
  int     to_n,from_n;
  int     inuse;   /* prevents corruption from mixing two pipelines */
  int     (*scatterbegin)(Vec,Vec,InsertMode,int,VecScatter);
  int     (*scatterend)(Vec,Vec,InsertMode,int,VecScatter);
  int     (*copy)(VecPipeline,VecPipeline);
  void    *fromdata,*todata;
  /* VE added from here on down; this makes it cast'able to VecScatter */
  int     (*pipelinebegin)(Vec,Vec,InsertMode,PipelineMode,VecPipeline);
  int     (*pipelineend)(Vec,Vec,InsertMode,PipelineMode,VecPipeline);
  PetscObject custom_pipe_data;
  PipelineFunction up_fun,dn_fun;
};

extern int VecScatterCopyToPipeline(VecScatter in,VecPipeline *out);
extern int VecPipelineBegin(Vec,Vec,InsertMode,PipelineMode,VecPipeline);
extern int VecPipelineEnd(Vec,Vec,InsertMode,PipelineMode,VecPipeline); 
extern int VecScatterSetCustomPipeline
    (VecScatter,PipelineFunction,PipelineFunction,PetscObject);

