
#ifndef lint
static char vcid[] = "$Id: bvec2.c,v 1.71 1996/04/07 22:46:18 curfman Exp bsmith $";
#endif
/*
   Implements the sequential vectors.
*/

#include <math.h>

/* #include "vecimpl.h"
#include "dvecimpl.h" 

#include "../bvec1.c"
#include "../dvec2.c" */

#include "bvec2.c"


int VecCreateSeqFromData(MPI_Comm comm,int n,Scalar *data, Vec *V)
{
  int      size = sizeof(Vec_Seq), flag;
  Vec      v;
  Vec_Seq *s;
  *V             = 0;
  MPI_Comm_compare(MPI_COMM_SELF,comm,&flag);
  if (flag == MPI_UNEQUAL) SETERRQ(1,"Must call with MPI_COMM_SELF");
  PetscHeaderCreate(v,_Vec,VEC_COOKIE,VECSEQ,comm);
  PLogObjectCreate(v);
  v->destroy     = VecDestroy_Seq; 
  /* no special destroy needed because this function only frees
   * the ->data, not the ->array. */
  v->view        = VecView_Seq;
  s              = (Vec_Seq *) PetscMalloc(size); CHKPTRQ(s);
  PetscMemcpy(&v->ops,&DvOps,sizeof(DvOps));
/*  v->ops         = &DvOps; old; the above stolen from this file */
  v->data        = (void *) s;
  s->n           = n;
  s->array       = data;
  *V = v; return 0;
}

