/*
   This file contains supplemental routines for Parallel vector operations.
 */

#include "petsc.h"
#include <math.h>
#include "src/vec/impls/mpi/pvecimpl.h"   /*I  "vec.h"   I*/

/* #include "src/vec/impls/seq/bvec1.c" */
/* #include "src/vec/impls/seq/dvec2.c" */
/* #include "pdvec.c" */
/* #include "src/vec/impls/mpi/pvec2.c" */

/* bastardised from the petsc file pbvec.c */
int VecDot_MPI( Vec xin, Vec yin, Scalar *z );
int VecSetOption_MPI(Vec v,VecOption op);
int VecDuplicate_MPI(Vec,Vec *);

static struct _VeOps DvOps = { VecDuplicate_MPI, 
            VecDuplicateVecs_Default, VecDestroyVecs_Default, VecDot_MPI, 
            VecMDot_MPI,
            VecNorm_MPI, VecDot_MPI, 
            VecMDot_MPI,
            VecScale_Seq, VecCopy_Seq,
            VecSet_Seq, VecSwap_Seq, VecAXPY_Seq, VecAXPBY_Seq,
            VecMAXPY_Seq, VecAYPX_Seq,
            VecWAXPY_Seq, VecPointwiseMult_Seq,
            VecPointwiseDivide_Seq, 
            VecSetValues_MPI,
            VecAssemblyBegin_MPI,VecAssemblyEnd_MPI,
            VecGetArray_Seq,VecGetSize_MPI,VecGetSize_Seq,
            VecGetOwnershipRange_MPI,0,VecMax_MPI,VecMin_MPI,
            VecSetRandom_Seq,
            VecSetOption_MPI};

static int VecCreateMPIBLASBaseFromData /* VE */
(MPI_Comm comm,int n,int N,int size,int rank,
 int *owners,Scalar *data,Vec *vv)
{
  Vec     v;
  Vec_MPI *s;
  int     mem,i;
  *vv = 0;

  mem           = sizeof(Vec_MPI)+(size+1)*sizeof(int);
  PetscHeaderCreate(v,_Vec,VEC_COOKIE,VECMPI,comm);
  PLogObjectCreate(v);
  PLogObjectMemory(v,mem + sizeof(struct _Vec) + (n+1)*sizeof(Scalar));
  s              = (Vec_MPI *) PetscMalloc(mem); CHKPTRQ(s);
  PetscMemcpy(&v->ops,&DvOps,sizeof(DvOps));
  v->data        = (void *) s;
  v->destroy     = VecDestroy_MPI;
  v->view        = VecView_MPI;
  s->n           = n;
  v->n           = n;
  s->N           = N;
  v->N           = N;
  s->size        = size;
  s->rank        = rank;
  v->user_data = 1;
  s->array       = data; /* ! */
/*  s->array       = (Scalar *) PetscMalloc((n+1)*sizeof(Scalar));CHKPTRQ(s->array); */
  s->ownership   = (int *) (s + 1);
  s->insertmode  = NOT_SET_VALUES;
  if (owners) {
    PetscMemcpy(s->ownership,owners,(size+1)*sizeof(int));
  }
  else {
    MPI_Allgather(&n,1,MPI_INT,s->ownership+1,1,MPI_INT,comm);
    s->ownership[0] = 0;
    for (i=2; i<=size; i++ ) {
      s->ownership[i] += s->ownership[i-1];
    }
  }
  s->stash.nmax = 10; s->stash.n = 0;
  s->stash.array = (Scalar *) PetscMalloc( 10*sizeof(Scalar) + 10*sizeof(int) );
  CHKPTRQ(s->stash.array);
  PLogObjectMemory(v,10*sizeof(Scalar) + 10 *sizeof(int));
  s->stash.idx = (int *) (s->stash.array + 10);
  *vv = v;
  return 0;

}

int VecCreateMPIFromData /* VE */
(MPI_Comm comm,int n,int N,Scalar *data,Vec *vv)
{
  int       sum, work = n; 
  int       numtids,mytid;
  *vv = 0;

  MPI_Comm_size(comm,&numtids);
  MPI_Comm_rank(comm,&mytid); 
  if (N == PETSC_DECIDE) { 
    MPI_Allreduce((void *) &work,(void *) &sum,1,MPI_INT,MPI_SUM,comm );
    N = sum;
  }
  if (n == PETSC_DECIDE) { 
    SETERRQ(1,0,"Vec from data has to specify local sizes");
  }
  return VecCreateMPIBLASBaseFromData(comm,n,N,numtids,mytid,0,data,vv);
}




