#include "pc.h" /* VE this shoudln't be, but it gets taken from petsc, not parpre */
#include "src/vec/vecimpl.h"
#include "src/pc/pcimpl.h"            /*I "pc.h" I*/
#include "pinclude/pviewer.h"
#include "src/vec/utils/vpipe.h"
#include "parpre_pc.h"
#include "src/pc/pcparallel.h"
#include "pcextra.h"
#include "src/sles/slesimpl.h"

#define CHUNCKSIZE   100

/* typedef struct {int ptr;} Locator;*/

#undef __FUNC__
#define __FUNC__ "NewIndexStash"
int NewIndexStash(IndStash *result_stash)
{
  IndStash stash;

  stash = (IndStash) PetscMalloc( sizeof(struct _IndStash) ); CHKPTRQ(stash);
  stash->nmax = CHUNCKSIZE;
  stash->n    = 0;
  stash->array = (int *) PetscMalloc( stash->nmax*sizeof(int) );
  CHKPTRQ(stash->array);
  {
    int *loc;
    loc = (int *) PetscMalloc( sizeof(int) ); CHKPTRQ(loc);
    *loc = 0;
    stash->private = (PetscObject) loc;
  }
  *result_stash = stash;
  return 0;
}

#undef __FUNC__
#define __FUNC__ "ZeroIndexStash"
int ZeroIndexStash(IndStash stash)
{
  stash->n = 0; stash->array[0] = 0;
  return 0;
}

#undef __FUNC__
#define __FUNC__ "DestroyIndexStash"
int DestroyIndexStash(IndStash stash)
{
  if (stash->array) PetscFree(stash->array); 
  return 0;
}

#undef __FUNC__
#define __FUNC__ "StashIndex"
int StashIndex(IndStash stash, int n, int *idxn)
{
  int    i,row;
  int *n_array;

  for ( i=0; i<n; i++ ) {
    row = idxn[i];
    if ( stash->n == stash->nmax ) {
      /* allocate a larger stash */
      n_array = (int *) PetscMalloc
	( (stash->nmax + CHUNCKSIZE)*(sizeof(int)));
      CHKPTRQ(n_array);
      PetscMemcpy(n_array,stash->array,stash->nmax*sizeof(int));
      if (stash->array) PetscFree(stash->array);
      stash->array = n_array;
      stash->nmax += CHUNCKSIZE;
    }
    stash->array[stash->n++]   = idxn[i];
  }
  return 0;
}

#undef __FUNC__
#define __FUNC__ "Unstash"
int Unstash(IndStash stash, int n)
{
  if (stash->n>n)
    stash->n=stash->n-n;
  else
    stash->n=0;

  return 0;
}

#undef __FUNC__
#define __FUNC__ "StashIndexFind"
int StashIndexFind(int *loc,int item,IndStash stash)
{
/*  Locator *locr = (Locator *) (stash->private);*/
  int *locr = (int *) stash->private;
  int i,locn;

  *loc = 0;
  for (i=0; i<stash->n; i++) {
    locn = *locr /*locr->ptr*/ +i; if (locn >= stash->n) locn = 0;
    if (stash->array[locn]==item) {
      *loc = *locr /*locr->ptr*/ = locn; 
      return 0;
    }
  }
printf("Looking for item %d in stash",item);
for (i=0; i<stash->n; i++) printf(" %d",stash->array[i]);
printf("\n");
  SETERRQ(1,0,"Could not find index in stash");
}

#undef __FUNC__
#define __FUNC__ "IntSort"
int IntSort(int *ar,int len)
{
  int i,j,t;
  for (j=len-1; j>=1; j--)
    for (i=0; i<j; i++)
      if (ar[i]>ar[i+1]) {t = ar[i+1]; ar[i+1]=ar[i]; ar[i]=t;}
  return 0;
}

/****************************************************************/
/* from "jacobi.c" */
typedef struct {
  Vec diag;
  Vec diagsqrt;
} PC_Jacobi;
/* from "sor.c" */
typedef struct {
  int        its;        /* inner iterations, number of sweeps */
  MatSORType sym;        /* forward, reverse, symmetric etc. */
  double     omega;
} PC_SOR;
#include "src/pc/impls/ilu/ilu.h"
/* from gbssor.c */
typedef struct {
  PCPstruct par_info;
  int global_factorisation;
} PC_GenBlockSSOR_struct;

#undef __FUNC__
#define __FUNC__ "CopySLES"
int CopySLES(SLES old,SLES *new)
{
  SLES sles; PCType typ; int siz,ierr;

  sles = (SLES) PetscMalloc(sizeof(struct _SLES)); CHKPTRQ(sles);
  PetscMemcpy(sles,old,sizeof(struct _SLES));
  sles->pc = (PC) PetscMalloc(sizeof(struct _PC)); CHKPTRQ(sles->pc);
  PetscMemcpy(sles->pc,old->pc,sizeof(struct _PC));
  ierr = PCGetType(old->pc,&typ,PETSC_NULL); CHKERRQ(ierr);
  switch (typ) 
    {
    case PCNONE : break ;
    default : 
      switch (typ) {
      case PCJACOBI : siz = sizeof(PC_Jacobi); break;
      case PCSOR : siz = sizeof(PC_SOR); break;
      case PCILU : siz = sizeof(PC_ILU); break;
      default : SETERRQ(1,0,"CopySLES unsupported type");
      }
      sles->pc->data = (void *) PetscMalloc(siz); CHKPTRQ(sles->pc->data);
      PetscMemcpy(sles->pc->data,old->pc->data,siz);
    }
  *new = sles;
  return 0;
}

