#include "petsc.h"
#include "src/pc/pcimpl.h"      /*I "pc.h" I*/
#include "sles.h"
#include <stdio.h>
#include "src/sys/nreg.h"
#include "sys.h"
#include "options.h"
#include "src/vec/vecimpl.h"                     /*I "vec.h" I*/
#include "src/vec/utils/vpipe.h"
#include "parpre_pc.h"
#include "pcparallel.h" /* VE new!!! */
/*****************************************************************
 * Here's how it works. Any parallel preconditioner that wants to use
 * these local method & comm scheme routines should have pc->data
 * be of the following form:

 typedef struct {
   SLES local_method;
   PCParallel_PipeInfo *pipe_info;
   ...
 } [pcptype]

 * The user will be able to declare

 PCParallelSetCommType( CustomPipelineType )

 * where (in vec.h)

typedef enum {PIPELINE_CUSTOM_NONE=0, PIPELINE_CUSTOM_SEQUENTIAL=1,
		PIPELINE_CUSTOM_REDBLACK=2 
	    } CustomPipelineType;

 * This pipeline type is stored in the first item of

 typedef *_PCParallel_PipeInfo PCParallel_PipeInfo
 struct _PCParallel_PipeInfo {
   CustomPipelineType pipe_type;
   int mytid,numtids;
 } ;

 *

 * The preconditioner setup routine has to have the following lines:

   [pcptype] *pc_data = ([pcptype] *) pc->data;
   PCP_CommStruct *pc_comm = pc_data->comm_method;

   if (pc_comm->setup_routine)
      (pc_comm->setup_routine) (Aij->Mvctx,pc_comm->comm_info);

 *****************************************************************/

#undef __FUNC__
#define __FUNC__ "PCParallelInitCommStruct"
int PCParallelInitCommStruct(PC pc)
{
  PCPstruct *pc_data = (PCPstruct *)pc->data;
 
  pc_data->up_fun = pc_data->dn_fun = 0;
  pc_data->pipeline_setup = 0;
  pc_data->pipeline_destroy = 0;

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCPstructSetSystem"
int PCPstructSetSystem(PCPstruct *pc_data, Mat mat, Vec vec)
{
  SLES sub_method = pc_data->local_method; PC sub_pc;
  int ierr;

  ierr = SLESSetOperators(sub_method,mat,mat,0); CHKERRQ(ierr);
  ierr = SLESGetPC(sub_method,&sub_pc); CHKERRQ(ierr);
  ierr = PCSetVector(sub_pc,vec); CHKERRQ(ierr);
  ierr = PCSetUp(sub_pc); CHKERRQ(ierr);

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelInstallSubSolve"
int PCParallelInstallSubSolve(MPI_Comm comm,SLES *solve)
{
  SLES sles; KSP subksp; PC subpc; int ierr;
  ierr = SLESCreate(comm,&sles); CHKERRQ(ierr);
  ierr = SLESGetKSP(sles,&subksp); CHKERRQ(ierr);
  ierr = KSPSetType(subksp,KSPPREONLY); CHKERRQ(ierr);
  ierr = SLESGetPC(sles,&subpc); CHKERRQ(ierr);
  ierr = PCSetType(subpc,PCNONE); CHKERRQ(ierr);
  *solve = sles;
  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelGetLocalPC"
int PCParallelGetLocalPC(PC pc,PC *local_pc)
{
  PCPstruct *data = (PCPstruct *) pc->data;
  int ierr;

  ierr = SLESGetPC(data->local_method,local_pc); CHKERRQ(ierr);
  return 0;
}

#undef __FUNC__
#define __FUNC__ "LocalSolveSetFromOptions"
int LocalSolveSetFromOptions(PC pc)
{
  SLES sles = ((PCPstruct *) pc->data)->local_method;
  char *prefix;
  int ierr;

  ierr = PCGetOptionsPrefix(pc,&prefix); CHKERRQ(ierr);
  ierr = SLESSetOptionsPrefix(sles,prefix); CHKERRQ(ierr);
  ierr = SLESAppendOptionsPrefix(sles,"sub_"); CHKERRQ(ierr);
  ierr = SLESSetFromOptions(sles); CHKERRQ(ierr);

  return 0;
}
/****************************************************************
 **************** ParPre Setup
 ****************************************************************/
#undef __FUNC__
#define __FUNC__ "ParPreSetup"
int ParPreSetup(MPI_Comm comm,Mat A,PC B)
{
  Vec pc_vec;
  int ierr,lsize,idum;

  ierr = PCSetOperators(B,A,A,0); CHKERRQ(ierr);
  ierr = MatGetLocalSize(A,&lsize,&idum); CHKERRQ(ierr);
  ierr = VecCreateMPI(comm,lsize,PETSC_DECIDE,&pc_vec); CHKERRQ(ierr);
  ierr = PCSetVector(B,pc_vec); CHKERRQ(ierr);
  ierr = PCSetFromOptions(B); CHKERRQ(ierr);
  ierr = PCSetUp(B); CHKERRQ(ierr);

  return 0;
}
