/*
   Defines an OVERLAPPING  preconditioner for any Mat implementation
*/
#include "petsc.h"
#include "src/vec/vecimpl.h"
#include "src/mat/impls/aij/mpi/mpiaij.h"
#include "../src/vec/utils/vpipe.h"
#include "parpre_pc.h"
#include "pcschwarz.h"
#include "pcextra.h"

#define CHUNCKSIZE   100

extern int PCParallelInitLocalMethod(PCPstruct *pc_data, Mat mat, Vec vec);
extern int PCParallelInitCommStruct(PC pc);
extern int ExtendMatrix(Mat *Schwarz_mat,Mat base_mat,
			int *nSchwarz_rows, int **Schwarz_rows,
			IndStash *rows_to_get, int *nt_rows,
			MPI_Comm comm,
			int glob_max_rowlen,int off_max_rowlen);
extern int MatMultAXBY_AIJ(Scalar a, Mat aijin,Vec xx,
			   Scalar b, Vec yy,Vec zz);
extern int PCSetFromOptions_Schwarz(PC pc);
extern int PCSetup_Schwarz(PC pc);
extern int ParPreTraceBackErrorHandler
    (int,char*,char*,char*,int,int,char*,void*);

#undef __FUNC__
#define __FUNC__ "PCMulSchwarzSetHaloSize"
int PCMulSchwarzSetHaloSize(PC pc, int ns)
{
  PC_Schwarz_struct *pc_data = (PC_Schwarz_struct *) pc->data;
  pc_data->halo_width = ns;
  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCApply_MulSchwarz"
static int PCApply_MulSchwarz(PC pc,Vec x,Vec y)
{
  PC_Schwarz_struct *pc_data = (PC_Schwarz_struct *) pc->data;
/*  PetscObject pipe_info = pc_data->comm_method->pipe_info;*/
  int ierr,its;
  Vec x_ltl,y_ltl;
  Scalar xone = 1.0, mone = -1.0, zero = 0.0;

  ierr = PetscPushErrorHandler(&ParPreTraceBackErrorHandler,MPI_COMM_WORLD);
  CHKERRQ(ierr);

  ierr = VecDuplicate(pc_data->domain_vec,&x_ltl); CHKERRQ(ierr);
  ierr = VecDuplicate(pc_data->domain_vec,&y_ltl); CHKERRQ(ierr);

  ierr = VecSet(&zero,y); CHKERRQ(ierr);
  ierr = VecSet(&zero,pc_data->edge_vec); CHKERRQ(ierr);

  /* the right hand side is established for this iteration */
  ierr = VecScatterBegin
    (x,pc_data->domain_vec, INSERT_VALUES,SCATTER_FORWARD/*ALL*/,
     pc_data->get_xdomain); CHKERRQ(ierr);
  ierr = VecScatterEnd
    (x,pc_data->domain_vec, INSERT_VALUES,SCATTER_FORWARD/*ALL*/,
     pc_data->get_xdomain); CHKERRQ(ierr);

  /* forward solve */
  ierr = VecPipelineBegin
    (y,pc_data->edge_vec, INSERT_VALUES,PIPELINE_CUSTOM_UP,
     pc_data->lift_edge); CHKERRQ(ierr);

  ierr = MatMultAXBY_AIJ(mone,pc_data->Schwarz_off,pc_data->edge_vec,
			 xone,pc_data->domain_vec,x_ltl); CHKERRQ(ierr);
  ierr = SLESSolve(pc_data->comm_method.local_method,x_ltl,y_ltl,&its); CHKERRQ(ierr);

  ierr = VecScatterBegin
    (y_ltl,y, INSERT_VALUES,SCATTER_FORWARD/*ALL*/,
     (VecScatter)pc_data->drop_xint); CHKERRQ(ierr);
  ierr = VecScatterEnd
    (y_ltl,y, INSERT_VALUES,SCATTER_FORWARD/*ALL*/,
     (VecScatter)pc_data->drop_xint); CHKERRQ(ierr);

  ierr = VecPipelineEnd
    (y,pc_data->edge_vec, INSERT_VALUES,PIPELINE_CUSTOM_UP,
     pc_data->lift_edge); CHKERRQ(ierr);

  /* second half of dropping the rim & establishing the edge vector,
   * leftward/down this time */
  ierr = VecPipelineBegin
    (y,pc_data->edge_vec, INSERT_VALUES,PIPELINE_CUSTOM_DOWN,
     pc_data->lift_edge); CHKERRQ(ierr);
  ierr = VecPipelineEnd
    (y,pc_data->edge_vec, INSERT_VALUES,PIPELINE_CUSTOM_DOWN,
     pc_data->lift_edge); CHKERRQ(ierr);

  /* >>>> Now the Back Solve for Symmetry <<<< */
  ierr = VecPipelineBegin
    (y,pc_data->edge_vec, INSERT_VALUES,PIPELINE_CUSTOM_DOWN,
     pc_data->lift_edge); CHKERRQ(ierr);

  ierr = MatMultAXBY_AIJ(mone,pc_data->Schwarz_off,pc_data->edge_vec,
			 xone,pc_data->domain_vec,x_ltl); CHKERRQ(ierr);
  ierr = SLESSolve(pc_data->comm_method.local_method,x_ltl,y_ltl,&its); CHKERRQ(ierr);

  ierr = VecScatterBegin
    (y_ltl,y, INSERT_VALUES,SCATTER_FORWARD/*ALL*/,
     pc_data->drop_xint); CHKERRQ(ierr);
  ierr = VecScatterEnd
    (y_ltl,y, INSERT_VALUES,SCATTER_FORWARD/*ALL*/,
     pc_data->drop_xint); CHKERRQ(ierr);

  ierr = VecPipelineEnd
    (y,pc_data->edge_vec, INSERT_VALUES,PIPELINE_CUSTOM_DOWN, 
     pc_data->lift_edge); CHKERRQ(ierr);
  
  /* overwrite some internal solutions with rims if these are more recent */
  ierr = VecPipelineBegin
    (y_ltl,y, INSERT_VALUES,PIPELINE_CUSTOM_UP,
     pc_data->drop_xrim); CHKERRQ(ierr);
  ierr = VecPipelineEnd
    (y_ltl,y, INSERT_VALUES,PIPELINE_CUSTOM_UP,
     pc_data->drop_xrim); CHKERRQ(ierr);

/*
printf("Prec final result\n");
VecView(y,0);
*/
  ierr = PetscPopErrorHandler(); CHKERRQ(ierr);
  return 0;

}

#undef __FUNC__
#define __FUNC__ "PCDestroy_MulSchwarz"
int PCDestroy_MulSchwarz(PetscObject obj)
{
  PC pc = (PC) obj;
  PC_Schwarz_struct *pc_data = (PC_Schwarz_struct *) pc->data;
  int ierr;

  ierr = SLESDestroy(pc_data->comm_method.local_method); CHKERRQ(ierr);
  ierr = MatDestroy(pc_data->Schwarz_mat); CHKERRQ(ierr);
  ierr = VecDestroy(pc_data->domain_vec); CHKERRQ(ierr);

  PetscFree(pc_data->Schwarz_rows);

  return 0;

}

#undef __FUNC__
#define __FUNC__ "PCSetup_MulSchwarz"
int PCSetup_MulSchwarz(PC pc)
{
  int ierr;
  ierr = PCSetup_Schwarz(pc); CHKERRQ(ierr);
  ierr = PCCustomPipelineSetFromOptions(pc); CHKERRQ(ierr);
  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCCreate_MulSchwarz"
int PCCreate_MulSchwarz(PC pc)
{
  int ierr;

  PC_Schwarz_struct *bij   = PetscNew(PC_Schwarz_struct);
  CHKPTRQ(bij);
  pc->apply     = PCApply_MulSchwarz;
  pc->applyrich = 0;
  pc->destroy   = PCDestroy_MulSchwarz;
  pc->printhelp = 0;
  pc->setup     = PCSetup_MulSchwarz;
  pc->setfrom   = PCSetFromOptions_Schwarz;
  pc->type      = PCMultiplicativeSchwarz;
  ierr = PCParallelInstallSubSolve(MPI_COMM_SELF,&(bij->comm_method.local_method));
  CHKERRQ(ierr);
  pc->data      = (void *) bij;
  ierr = PCParallelInitCommStruct(pc); CHKERRQ(ierr);

  return 0;
}

