/*
   Defines an OVERLAPPING  preconditioner for any Mat implementation
*/
#include "src/vec/vecimpl.h"
#include "src/mat/impls/aij/mpi/mpiaij.h"
#include "../src/vec/utils/vpipe.h"
#include "parpre_pc.h"
#include "pcschwarz.h"
#include "pcextra.h"

#define CHUNCKSIZE   100

extern int PCParallelInitLocalMethod(PCPstruct *pc_data, Mat mat, Vec vec);
extern int PCParallelInitCommStruct(PC pc);
extern int PCSetFromOptions_Schwarz(PC pc);
extern int PCSetup_Schwarz(PC pc);
extern int ParPreTraceBackErrorHandler
    (int,char*,char*,char*,int,int,char*,void*);

#undef __FUNC__
#define __FUNC__ "PCApply_AddSchwarz"
static int PCApply_AddSchwarz(PC pc,Vec x,Vec y)
{
  PC_Schwarz_struct *pc_data = (PC_Schwarz_struct *) pc->data;
  Vec z;
  int ierr,its;
  Scalar zero = 0.0;

  ierr = PetscPushErrorHandler(&ParPreTraceBackErrorHandler,MPI_COMM_WORLD);
  CHKERRQ(ierr);

  ierr = VecDuplicate(pc_data->domain_vec,&z); CHKERRQ(ierr);

  ierr = VecScatterBegin(x,pc_data->domain_vec,INSERT_VALUES,SCATTER_FORWARD/*ALL*/,
			 pc_data->get_xdomain); CHKERRQ(ierr);
  ierr = VecScatterEnd  (x,pc_data->domain_vec,INSERT_VALUES,SCATTER_FORWARD/*ALL*/,
			 pc_data->get_xdomain); CHKERRQ(ierr);

  ierr = SLESSolve(pc_data->comm_method.local_method,pc_data->domain_vec,z,&its);
  CHKERRQ(ierr);

  VecSet(&zero,y);

  ierr = VecScatterBegin(z,y,ADD_VALUES,SCATTER_FORWARD/*ALL*/,
			 pc_data->put_xdomain); CHKERRQ(ierr);
  ierr = VecScatterEnd  (z,y,ADD_VALUES,SCATTER_FORWARD/*ALL*/,
			 pc_data->put_xdomain); CHKERRQ(ierr);

  ierr = VecDestroy(z); CHKERRQ(ierr);

  ierr = PetscPopErrorHandler(); CHKERRQ(ierr);
  return 0;

}

#undef __FUNC__
#define __FUNC__ "PCDestroy_AddSchwarz"
int PCDestroy_AddSchwarz(PetscObject obj)
{
  PC pc = (PC) obj;
  PC_Schwarz_struct *pc_data = (PC_Schwarz_struct *) pc->data;
  int ierr;

  ierr = SLESDestroy(pc_data->comm_method.local_method); CHKERRQ(ierr);

  ierr = MatDestroy(pc_data->Schwarz_mat); CHKERRQ(ierr);

  ierr = VecDestroy(pc_data->domain_vec); CHKERRQ(ierr);

  ierr = VecScatterDestroy(pc_data->get_xdomain); CHKERRQ(ierr);
  ierr = VecScatterDestroy(pc_data->put_xdomain); CHKERRQ(ierr);

  PetscFree(pc_data->Schwarz_rows);

  return 0;

}

#undef __FUNC__
#define __FUNC__ "PCCreate_AddSchwarz"
int PCCreate_AddSchwarz(PC pc)
{
  int ierr;

  PC_Schwarz_struct *bij   = PetscNew(PC_Schwarz_struct);
  CHKPTRQ(bij);
  pc->apply     = PCApply_AddSchwarz;
  pc->applyrich = 0;
  pc->destroy   = PCDestroy_AddSchwarz;
  pc->printhelp = 0;
  pc->setup     = PCSetup_Schwarz;
  pc->setfrom   = PCSetFromOptions_Schwarz;
  pc->type      = PCAdditiveSchwarz;
  ierr = PCParallelInstallSubSolve(pc->comm,&(bij->comm_method.local_method));
  CHKERRQ(ierr);
  pc->data      = (void *) bij;
  ierr = PCParallelInitCommStruct(pc); CHKERRQ(ierr);

  return 0;
}
