/* additions to pc.h for the parpre routines */

#if !defined(__PARPRE_PC_PACKAGE)
#define __PARPRE_PC_PACKAGE

#include "petsc.h"
#include "mat.h"
#include "pc.h"

typedef enum {PIPELINE_CUSTOM_NONE=0, PIPELINE_CUSTOM_SEQUENTIAL=1,
		PIPELINE_CUSTOM_REDBLACK=2, PIPELINE_CUSTOM_MULTICOLOUR=3
	    } CustomPipelineType;
extern int PCParallelSetCustomPipeline(PC pc,CustomPipelineType pipe_type);

extern int PCParallelSetCommNone(PC pc);
extern int PCParallelSetCommSequential(PC pc);
extern int PCParallelSetCommMulticolour(PC pc);
extern int ParPreSetup(MPI_Comm comm,Mat A,PC B);
extern int PCIsParallel(PC);
extern int PCParallelGetLocalPC(PC pc,PC *local_pc);

/* schwarz methods */
extern int PCIsSchwarzMethod(PC pc);
extern int PCSchwarzSetHaloSize(PC,int);

/* generalised block ssor */
extern int PCGenBlockSSORSetGlobalFactorisation(PC pc);
extern int PCGenBlockSSORSetNoGlobalFactorisation(PC pc);

/* domain decomposition */
extern int PCDomainDecompGetInterfacePC(PC pc,PC *local_pc);

/* multilevel */
typedef enum {AMLFillNone, AMLFillDiag, AMLFillStrong, AMLFillFull } AMLFillMethod;
extern int AMLSetFillMethod(PC pc,AMLFillMethod fill_method);

typedef enum {AMLSolveMG, AMLSolvePolynomial, AMLSolveILU} AMLSolveScheme;
int AMLSetSolutionScheme(PC pc,AMLSolveScheme solve_scheme);

int PCMultiLevelGetPreSmoother(PC pc,PC *local_pc);
int PCMultiLevelGetPostSmoother(PC pc,PC *local_pc);
extern int PCMultiLevelGetLastLevelSolver(PC pc,PC *local_pc);

typedef enum {AMLCoarseGridDependent, AMLCoarseGridIndependent} AMLCoarseGridChoice;
typedef enum {AMLSmoothNone=0, AMLPreSmooth=1, AMLPostSmooth=2, AMLPrePostSmooth=3} AMLSmootherChoice;
extern int AMLSetCoarseGridDependent(PC pc);
extern int AMLSetCoarseGridIndependent(PC pc);
extern int AMLSetCutoffSize(PC pc,int siz);
extern int AMLSet11JacobiIterations(PC pc,int it);
extern int AMLSetSmootherChoice(PC pc,AMLSmootherChoice smoother);

#endif
