#!  /bin/sh

# make sure the env variable PETSC_DIR is properly set to the petsc home 
# /home/xyx/petsc.
# Also this utility uses find, and find does not expand through  links

#this utility is useful to call make recursively through a tree of sub dirs.

# Usage: paragon.make [options] [makefile options]

# Options:
#       all          - to create the libraries
#       testexamples - to run "testexamples" using mpirun 
#       clean        - to do make clean on all the subdirs
#
#       NONE         - suplies only the options to each makefile down the tree
#                      and runs the make file
     
#1. It goes to each sub dir 
#2. It checks if there is a makefile in that directory.
#3. If found, it invokes the make with all the options suplied to this routine



FLG=0
DEFAULT="BOPT=g "


if ( test -n $PETSC_DIR ) then
        FLG=1
fi

if (test $FLG -eq 0 ) then
        echo "$0: enviornment varible PETSC_DIR is not set."
        echo "$0: set it as follows: setenv PETSC_DIR /home/XXX/petsc"
        exit
fi


case $1 in
all)
        shift
        find . -type d -name "*" -exec $PETSC_DIR/bmake/paragon/paragon.makeindir \
        {} $DEFAULT ETSCDIR=$PETSC_DIR libfast $* \;
        ;;

testexamples)
        shift
        find . -type d -name "*" -exec $PETSC_DIR/bmake/paragon/paragon.makeindir \
        {} $DEFAULT PETSC_DIR=$PETSC_DIR examples_1 $* \;  \
         -exec $PETSC_DIR/bmake/paragon/paragon.makeindir {} $DEFAULT \
        PETSC_DIR=$PETSC_DIR runexamples_1 $* \; \
        -exec $PETSC_DIR/bmake/paragon/paragon.makeindir {} $DEFAULT \
        PETSC_DIR=$PETSC_DIR  clean $* \;
        ;;

clean)
        shift
        find . -type d -name "*" -exec $PETSC_DIR/bmake/paragon/paragon.makeindir \
        {} $DEFAULT PETSC_DIR=$PETSC_DIR clean $* \;
        ;; 

*)
find . -type d -name "*" -exec $PETSC_DIR/bmake/paragon/paragon.makeindir {} \
        $DEFAULT PETSC_DIR=$PETSC_DIR   $* \;
        ;;

esac