/*   Example Program to test ParPre Library */
/*  This is a very simple test and by no means exhaustive */

#include <stdio.h>
#include "petsc.h"
#include "parpre.h"
#include "vec.h"
#include "ksp.h"
#include "sys.h"
#include "pc.h"
#include "options.h"
#include <math.h>

/* from mat.c */
int make_mat(MPI_Comm comm,int siz,Mat *A,Vec *b,int *vs, Scalar **vv);

/* from prec.c */
int prec_setup(MPI_Comm comm,Mat A,PC *B);

/* from cg.c */
int cg(MPI_Comm comm,Mat A, PC B,double *sol, double *rhs, int lsize);

int main(int Argc,char **Args)
{
  Mat       A;
  PC        B;
  Vec       V;
  MPI_Comm comm;
  int       numtids,ierr;
  int vec_size,global_size; Scalar *rhs_values,*sol_values;

  PetscInitialize(&Argc,&Args,PETSC_NULL,PETSC_NULL);
  comm = MPI_COMM_WORLD;
  MPI_Comm_size(comm,&numtids);

  /* make Poisson matrix */
  {
    int flg;
    ierr = OptionsGetInt(PETSC_NULL,"-size",&global_size,&flg); CHKERRQ(ierr);
    if (!flg) global_size = 20;
  }
  ierr = make_mat(comm,global_size,&A,&V,&vec_size,&rhs_values);
  sol_values = (double *) malloc(vec_size*sizeof(double));

  ierr = prec_setup(comm,A,&B); CHKERRQ(ierr);

  /* execute cg method */
  ierr = cg(comm,A,B,sol_values,rhs_values,vec_size); CHKERRQ(ierr);

    /* cleanup after ourselves. */
  PCDestroy(B);
  PetscFinalize();

return 0;
}
