
#include "vec.h"
#include "mat.h"
#include "options.h"
#include "stdio.h"

static double coplx(int i,int j,int m,int n)
{
  Scalar v = 1.0;
/*  if (i>m/2) v *= 10;
  if (j>n/2) v *= 10;*/
  return -v;
}

static double coply(int i,int j,int m,int n)
{
  Scalar v = 1.0;
/*  if (i>m/2) v *= 10;
  if (j>n/2) v *= 10;*/
  return -v;
}

static int DomPt(int ii,int jj,int i,int j,int m,int n,int *J,Scalar *cv)
{
  if (i>=0 & j>=0 & i<m & j<n) {
    *J = i*n+j; 
    if (ii) *cv = coplx(i,j,m,n);
    else *cv = coply(i,j,m,n);
    return 1;
  } else return 0;
}

static int Coupling(Mat *C,int i,int ii,int j,int jj,int m,int n,int I,
		    double w,double hv,double *dv)
{
  int acpt,J,ierr; double v,cv;

  acpt = DomPt(ii,jj,i+ii,j+jj,m,n,&J,&cv);
  v = w*(hv+cv)*.5; *dv -= v;
  if (acpt) {
    ierr = MatSetValues(*C,1,&I,1,&J,&v,INSERT_VALUES);
    CHKERRQ(ierr);
  }
  return 0;
}

int make_mat(MPI_Comm comm,int m,Mat *C, Vec *V, int *nn, Scalar **rhs)
{
  int n;
  int         i,j, mytid,numtids;
  int         ierr;
  int jlo,jhi;

  MPI_Comm_rank(comm,&mytid);
  MPI_Comm_size(comm,&numtids);

  if (!mytid) {
    printf("Size: "); scanf("%d",&n); printf("=> %d\n",n);
  }
  MPI_Bcast(&n,1,MPI_INT,0,comm);
  m = n;
    
  /* create the matrix for the five point stencil */
  ierr = MatCreateMPIAIJ(comm,PETSC_DECIDE,PETSC_DECIDE,
			 m*n,m*n,0,0,0,0,C); 
  CHKERRQ(ierr);

  /* and a dummy right hand side for a linear system */
  ierr = VecCreateMPI(comm,-1,m*n,V);
  CHKERRQ(ierr);

#define NINE 0
/* parallel: j=(n*mytid)/numtids; j<(n*(mytid+1))/numtids */
jlo = (n*mytid)/numtids; jhi = (n*(mytid+1))/numtids;
/*printf("Me, %d, assembling matrix from %d to %d\n",mytid,jlo,jhi-1);*/
  for ( i=0; i<m; i++ ) { 
    for ( j=jlo; j<jhi; j++ ) {
      int I = j + n*i;
      Scalar dv=0.0, hv=(coplx(i,j,m,n)+coply(i,j,m,n))*.5,one=1.0,qrt=0.25;

      ierr = Coupling(C,i,+1,j,+0,m,n,I,one,hv,&dv); CHKERRQ(ierr);
      ierr = Coupling(C,i,-1,j,+0,m,n,I,one,hv,&dv); CHKERRQ(ierr);
      ierr = Coupling(C,i,+0,j,+1,m,n,I,one,hv,&dv); CHKERRQ(ierr);
      ierr = Coupling(C,i,+0,j,-1,m,n,I,one,hv,&dv); CHKERRQ(ierr);
      if (NINE) {
	ierr = Coupling(C,i,+1,j,+1,m,n,I,qrt,hv,&dv); CHKERRQ(ierr);
	ierr = Coupling(C,i,-1,j,+1,m,n,I,qrt,hv,&dv); CHKERRQ(ierr);
	ierr = Coupling(C,i,+1,j,-1,m,n,I,qrt,hv,&dv); CHKERRQ(ierr);
	ierr = Coupling(C,i,-1,j,-1,m,n,I,qrt,hv,&dv); CHKERRQ(ierr);
      }
      ierr = MatSetValues(*C,1,&I,1,&I,&dv,INSERT_VALUES); CHKERRQ(ierr);
      {
	Scalar vv = (Scalar) 1.0 /*(I+1)*/;
	ierr = VecSetValues(*V,1,&I,&vv,INSERT_VALUES); CHKERRQ(ierr);
      }
    }
  }

  ierr = MatAssemblyBegin(*C,MAT_FINAL_ASSEMBLY); CHKERRQ(ierr);
  ierr = MatAssemblyEnd(*C,MAT_FINAL_ASSEMBLY); CHKERRQ(ierr);
  ierr = VecAssemblyBegin(*V); CHKERRQ(ierr);
  ierr = VecAssemblyEnd(*V); CHKERRQ(ierr);
  ierr = VecGetArray(*V,rhs); CHKERRQ(ierr);
  ierr = VecGetLocalSize(*V,nn); CHKERRQ(ierr);

return 0;
}
