#include <stdio.h>
#include "petsc.h"
#include "mat.h"
#include "pc.h"

int prec_setup(MPI_Comm comm,Mat A,PC *B)
{
  PC the_pc;
  PCType pc_name = PCJACOBI;
  int mytid,ierr;

  MPI_Comm_rank(comm,&mytid);
  ierr = PCCreate(comm,&the_pc); CHKERRQ(ierr);
  /* ---------------------------------- *
   * ---- here is the crucial part ---- *
   * ---------------------------------- */
  if (!mytid) printf("Setting up JACOBI pc %d\n",pc_name);
  ierr = PCSetType(the_pc,pc_name); CHKERRQ(ierr);
  /* ---------------------------------- */

  ierr = ParPreSetup(comm,A,the_pc); CHKERRQ(ierr);

  *B = the_pc;

  return 0;
}

