#include <stdio.h>
#include "petsc.h"
#include "mat.h"
#include "pc.h"
#include "parpre_pc.h"

int prec_setup(MPI_Comm comm,Mat A,PC *B)
{
  PC the_pc;
  int mytid,ierr;

  MPI_Comm_rank(comm,&mytid);
  ierr = PCCreate(comm,&the_pc); CHKERRQ(ierr);

  if (!mytid) printf("Setting up Generalised Block SSOR pc\n");
  /* ---------------------------------- *
   * ---- here is the crucial part ---- *
   * ---------------------------------- */
  ierr = PCSetType(the_pc,PCGenBlockSSOR); CHKERRQ(ierr);

  /* Declare local solve */
  {
    PC local_pc;
    ierr = PCParallelGetLocalPC(the_pc,&local_pc); CHKERRQ(ierr);
    ierr = PCSetType(local_pc,PCILU); CHKERRQ(ierr);
  }

  ierr = PCGenBlockSSORSetNoGlobalFactorisation(the_pc); CHKERRQ(ierr);
  ierr = PCParallelSetCustomPipeline(the_pc, PIPELINE_CUSTOM_SEQUENTIAL );
  CHKERRQ(ierr);

  /* ---------------------------------- */

  ierr = ParPreSetup(comm,A,the_pc); CHKERRQ(ierr);

  *B = the_pc;

  return 0;
}

