#include <stdio.h>
#include "petsc.h"
#include "mat.h"
#include "pc.h"

int prec_setup(MPI_Comm comm,Mat A,PC *B)
{
  PC the_pc;
  PCType pc_name = PCDomainDecomp;
  int mytid,ierr;

/*  MPI_Comm_rank(comm,&mytid);*/
  ierr = PCCreate(comm,&the_pc); CHKERRQ(ierr);
  /* ---------------------------------- *
   * ---- here is the crucial part ---- *
   * ---------------------------------- */
/*  if (!mytid) printf("Setting up Domain Decomp pc %d\n",pc_name);*/
  ierr = PCSetType(the_pc,pc_name); CHKERRQ(ierr);
  /* ---------------------------------- */
  {
    PC intface_pc;
    ierr = PCDomainDecompGetInterfacePC(the_pc,&intface_pc); CHKERRQ(ierr);
    ierr = PCSetType(intface_pc,PCJACOBI); CHKERRQ(ierr);
/*
    ierr = PCSetType(intface_pc,PCAdditiveSchwarz); CHKERRQ(ierr);
    {
      PC very_local_pc;
      ierr = PCParallelGetLocalPC(intface_pc,&very_local_pc); CHKERRQ(ierr);
      ierr = PCSetType(very_local_pc,PCLU); CHKERRQ(ierr);
    }
    ierr = PCParallelSetCustomPipeline(intface_pc,PIPELINE_CUSTOM_SEQUENTIAL);
*/
  }

  /* Declare local/global aspects */
  {
    PC local_pc;
    ierr = PCParallelGetLocalPC(the_pc,&local_pc); CHKERRQ(ierr);
    ierr = PCSetType(local_pc,PCLU); CHKERRQ(ierr);
  }

  ierr = ParPreSetup(comm,A,the_pc); CHKERRQ(ierr);

  *B = the_pc;

  return 0;
}
