#include <stdio.h>
#include "petsc.h"
#include "mat.h"
#include "pc.h"

int prec_setup(MPI_Comm comm,Mat A,PC *B)
{
  PC the_pc;
  int mytid,ierr;

  MPI_Comm_rank(comm,&mytid);
  ierr = PCCreate(comm,&the_pc); CHKERRQ(ierr);

  /* ---------------------------------- *
   * ---- here is the crucial part ---- *
   * ---------------------------------- */
  if (!mytid) printf("Setting up Additive Schwarz pc %d\n",PCAdditiveSchwarz);
  ierr = PCSetType(the_pc,PCAdditiveSchwarz); CHKERRQ(ierr);

  /* parametrised setting over overlap */
  ierr = PCSchwarzSetHaloSize(the_pc,1); CHKERRQ(ierr);

  /* Declare local solve */
  {
    PC local_pc;
    ierr = PCParallelGetLocalPC(the_pc,&local_pc); CHKERRQ(ierr);
    /* set the local solve to some LU solve */
    ierr = PCSetType(local_pc,PCLU); CHKERRQ(ierr);
  }

  /* ---------------------------------- */

  ierr = ParPreSetup(comm,A,the_pc); CHKERRQ(ierr);

  *B = the_pc;

  return 0;
}

