#include <stdio.h>
#include "petsc.h"
#include "mat.h"
#include "pc.h"
#include "parpre_pc.h"

int prec_setup(MPI_Comm comm,Mat A,PC *B)
{
  PC the_pc;
  PCType pc_name = PCMultiLevel;
  int mytid,ierr;

  MPI_Comm_rank(comm,&mytid);
  ierr = PCCreate(comm,&the_pc); CHKERRQ(ierr);
  /* ---------------------------------- *
   * ---- here is the crucial part ---- *
   * ---------------------------------- */
  if (!mytid) printf("Setting up AMG pc %d\n",pc_name);
  ierr = PCSetType(the_pc,pc_name); CHKERRQ(ierr);

  ierr = AMLSetSolutionScheme(the_pc,AMLSolveMG); CHKERRQ(ierr);
  ierr = AMLSetSmootherChoice(the_pc,AMLPrePostSmooth); CHKERRQ(ierr);
  ierr = AMLSetCoarseGridIndependent(the_pc); CHKERRQ(ierr);
  ierr = AMLSetFillMethod(the_pc,AMLFillFull); CHKERRQ(ierr);

  /* set the smoothers */
  {
    PC local_pc;

    /* a11 solver */
    ierr = PCParallelGetLocalPC(the_pc,&local_pc); CHKERRQ(ierr);
    ierr = PCSetType(local_pc,PCJACOBI); CHKERRQ(ierr);
    ierr = AMLSet11JacobiIterations(the_pc,1);
/*    ierr = PCSetType(local_pc,PCSOR); CHKERRQ(ierr);
    ierr = PCSORSetSymmetric(local_pc,SOR_LOCAL_SYMMETRIC_SWEEP); CHKERRQ(ierr);
    ierr = PCSORSetIterations(local_pc,1); CHKERRQ(ierr);*/

#define LOCAL_SOR 1
#define GLOBAL_SOR 2
#define SMOOTH GLOBAL_SOR

    /* pre smoother */
    ierr = PCMultiLevelGetPreSmoother(the_pc,&local_pc); CHKERRQ(ierr);
    switch (SMOOTH) 
      {
      case LOCAL_SOR :
	ierr = PCSetType(local_pc,PCSOR); CHKERRQ(ierr);
	ierr = PCSORSetSymmetric
	  (local_pc,SOR_LOCAL_SYMMETRIC_SWEEP); CHKERRQ(ierr);
	ierr = PCSORSetIterations(local_pc,1); CHKERRQ(ierr);
	break;
      case GLOBAL_SOR :
	ierr = PCSetType(local_pc,PCGenBlockSSOR); CHKERRQ(ierr);
	{
	  PC very_local_pc;
	  ierr = PCParallelGetLocalPC(local_pc,&very_local_pc); CHKERRQ(ierr);
	  ierr = PCSetType(very_local_pc,PCILU); CHKERRQ(ierr);
	}
	ierr = PCGenBlockSSORSetNoGlobalFactorisation(local_pc); CHKERRQ(ierr);
	ierr = PCParallelSetCustomPipeline
	  (local_pc, PIPELINE_CUSTOM_SEQUENTIAL ); CHKERRQ(ierr);
	break;
      default : SETERRQ(1,"Invalid smoother choice\n"); return 1;
      }
    
    /* post smoother */
    ierr = PCMultiLevelGetPostSmoother(the_pc,&local_pc); CHKERRQ(ierr);
    switch (SMOOTH) 
      {
      case LOCAL_SOR :
	ierr = PCSetType(local_pc,PCSOR); CHKERRQ(ierr);
	ierr = PCSORSetSymmetric
	  (local_pc,SOR_LOCAL_SYMMETRIC_SWEEP); CHKERRQ(ierr);
	ierr = PCSORSetIterations(local_pc,1); CHKERRQ(ierr);
	break;
      case GLOBAL_SOR :
	ierr = PCSetType(local_pc,PCGenBlockSSOR); CHKERRQ(ierr);
	{
	  PC very_local_pc;
	  ierr = PCParallelGetLocalPC(local_pc,&very_local_pc); CHKERRQ(ierr);
	  ierr = PCSetType(very_local_pc,PCILU); CHKERRQ(ierr);
	}
	ierr = PCGenBlockSSORSetNoGlobalFactorisation(local_pc); CHKERRQ(ierr);
	ierr = PCParallelSetCustomPipeline
	  (local_pc, PIPELINE_CUSTOM_SEQUENTIAL ); CHKERRQ(ierr);
	break;
      default : SETERRQ(1,"Invalid smoother choice\n"); return 1;
      }

    /* last level solver */
    ierr = AMLSetCutoffSize(the_pc,30); CHKERRQ(ierr);
    ierr = PCMultiLevelGetLastLevelSolver(the_pc,&local_pc); CHKERRQ(ierr);
/*    ierr = PCSetType(local_pc,PCJACOBI); CHKERRQ(ierr);*/
    ierr = PCSetType(local_pc,PCSOR); CHKERRQ(ierr);
    ierr = PCSORSetSymmetric(local_pc,SOR_LOCAL_SYMMETRIC_SWEEP); CHKERRQ(ierr);
    ierr = PCSORSetIterations(local_pc,4); CHKERRQ(ierr);
  }
  /* ---------------------------------- */

  ierr = ParPreSetup(comm,A,the_pc); CHKERRQ(ierr);

  *B = the_pc;

  return 0;
}

