/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include	"o_counts.h"
make_count_from_items(	in_graph_list,		item_list, 	
			count_item_list,
			index_item_list,	limits_item_list,
			count_list, 
			size_count_list, max_size_count_list,
			g_list,
			op_code)

int			*in_graph_list,		*item_list,	
			*count_item_list,	*index_item_list,
			*limits_item_list,
			*count_list,		 *size_count_list,
			max_size_count_list,
			*g_list,
			op_code;
{
/*
make a count list from an items list
a count list has the form:
	level1 #of pairs pair1 pair2 pair3 ... level2 #of pairs
	level2> level1
	pair: graph id, count
*/

		

		int 	grf,i, j,  next, pairs_per_level, 
			*pos_pairs_per_level, total_pairs;
		int 	k,  do_it, a,b, va, vb;
		extern	 int *deleted_v, my_N, *row_col;
		register int *tmp1, *tmp2, *last,*c_list,
				 i_limit, j_limit;

		
		for(grf=0, tmp1=scratch_list; grf <max_graphs; grf++)
				*tmp1++ = 0;
		for (next=total_pairs=0, tmp2= count_list, i=limits_item_list[0] ,
			i_limit = limits_item_list[1];
			i < i_limit ; i++) {
			
			for(tmp1= last= item_list +index_item_list[i],
			c_list= count_item_list+i,
			j_limit= count_item_list[i];
			j_limit>0;  j_limit--){
				k= *tmp1++; ;
				if (op_code == VTX) {
					do_it = deleted_v[k];
					if(do_it ==0) *last++=k;
					else *c_list -=1;
					if (do_it ==0) grf = in_graph_v[k];
					
				}else { 
					do_it = k+k;
					a = row_col[do_it];
					b = row_col[do_it+1];
					va = deleted_v[a];
					vb = deleted_v[b];
					do_it =0;	
					if ((a <my_N) && (va==1)) do_it=1;
					if ((a <my_N) && (va==0)) 
						in_graph_ce[k]=
						grf=in_graph_v[a];
					if ((b <my_N) && (vb==1)) do_it=1;
					if ((b <my_N) && (vb==0)) 
						in_graph_ce[k]=
						grf=in_graph_v[b];
					if(do_it ==0) *last++=k;
					else *c_list -=1;
				}
				if(do_it==0) {	
				scratch_list[grf] += 1;
				}
			}	
			for(tmp1= item_list+ index_item_list[i],
				j_limit= count_item_list[i],
				*tmp2++=(d_phase ==1)? g_list[i]: i,
				pos_pairs_per_level = tmp2++,
				next+=2,
				pairs_per_level =0;
				j_limit>0; j_limit--){
				grf = in_graph_list[*tmp1++];
				if (scratch_list[grf] != 0){	
				*tmp2++ =grf;
				*tmp2++ = scratch_list[grf];
				next+=2,
				scratch_list[grf] = 0;
				pairs_per_level++;
				}
			}
			*pos_pairs_per_level = pairs_per_level;
			total_pairs+= pairs_per_level;
		}
	
		if (next > max_size_count_list) {
		exit_err("make_counts:size_err",case_err);
		}	

		*size_count_list = next;
}/*end make_counts*/



make_graph_count_lists(	count_list,
			size_count_list, max_graphs,
			graph_list, 
			graph_list_field_size,
			graph_list_offset,
			alpha,
			control_list, 
			field_size, offset, marker, code)
int		*count_list, 
		size_count_list, max_graphs, *graph_list, 
		graph_list_field_size,
		graph_list_offset,
		*control_list,	field_size,  offset, marker,
		code;
real_type		alpha;

{
/*
graph list has  values of grf at grf*graph_list_field_size +1, +2, +3 ... 
each value is a level
in case control_list is NULL, the graph_list_offset value in each field is 
a count
if control_list != NULL
		(control has the same form as graph list)
		but with field_size & offset
		level is set to the last level so that count so far over
		earlier level in the graph  < the corresponding
		control list value and with the level is >= corresponding
		control list value

if control_list != NULL
use with control list values set very large 
to get largest  level  of each graph
use with control list values set at alpha* total or (1-alpha)*total to
get levels of interest -- bounds within which to search 
if (control_list == NULL) returns count per graph
*/

		int grf, i,  j,  lvl,  pairs_per_level,remember;
		if (control_list != NULL){
			for (grf =0; grf <max_graphs ; grf++) {
					i = grf*field_size +offset;
					j = grf*graph_list_field_size +
					graph_list_offset;
					graph_list[j] = marker; 
					scratch_list[j] = alpha*
						control_list[i]; 
					scratch_list[j+1] = 0;
			}
		} else {for (grf =0;
				 grf <max_graphs ; grf++) 
				graph_list[grf*graph_list_field_size+
				graph_list_offset] =0;

		}

		for (i=0 ; i < size_count_list; ) {
				if (code != ADD) remember =i;
				lvl= count_list[i++];
				pairs_per_level = count_list[i++];
				for(; pairs_per_level>0; pairs_per_level--){
				grf = count_list[i++];
				if (control_list != NULL){
					j = grf*graph_list_field_size +
						graph_list_offset;
					scratch_list[j+1] += count_list[i];
					if(scratch_list[j] <
					  (scratch_list[j+1])) {
						graph_list[j] = lvl;
						scratch_list[j] = LARGE_BOUND;
					}	
					else if 
					(scratch_list[j] != LARGE_BOUND) {
						graph_list[j] = lvl;
					}
				} else  { 
					if (code == ADD)
					graph_list[
					grf*graph_list_field_size+
						graph_list_offset] +=
						 count_list[i];
					else graph_list[
					grf*graph_list_field_size+
						graph_list_offset] =
						 count_list[i];
					}
				i++;
				}/*for*/
		}/*for*/

		if(code == ADD) {
		if (d_phase ==1) stats[o_d_o] += (size_count_list/2);
		else  stats[o_l_o] += (size_count_list/2);
		}
		if (code != ADD) return(((int)remember)); 
			
}/*end make_graph_v_count*/
make_list_from_counts( 
			in1_count_list,
			size_in1_count_list,
			in2_count_list, 
			size_in2_count_list,
			out_count_list, 
			size_out_count_list, op_code)
int
			*in1_count_list, 
			size_in1_count_list,
			*in2_count_list,
			size_in2_count_list,
			*out_count_list, 
			*size_out_count_list,	op_code;
/*
a count list has the form:
	level1 #of pairs pair1 pair2 pair3 ... level2 #of pairs
	level2> level1
	pair: graph id, count

takes		two counts lists in1 and in2
if (op_code is ZERO, ADD) 
creates		a new count list (out) based on op_code
		the new list contains levels and graph ids over both in lists
		the counts are set to zero in out if op_code = ZERO
		the counts are set to the sum  if op_code =ADD 
if (op_code is CAT) 
creates		a new catenated list (out)
		of the form level1 #of triples triple1... level2a#of triples
		level2> level1
		triple: graph id, count from in1, count from in2
		
if (op_code is CAT2) 
in1 is a count list with triples insstead of pairs
in2 is a count list with pairs
out list now has 4-tuples arising from a concatenation
*/
{

			int i1, i2, lvl1, pairs1, pairs2, lvl2, o, olvl,
				field_size,
				opairs, total_opairs, old_o;
			int 	in1_off, 
				in2_off, grf_off;


			if (op_code == CAT) {  	field_size =3;
						grf_off =2;
						in1_off = in2_off = 2;
					}
			else if (op_code == CAT2) {
						field_size = 4;
						grf_off =3;
						in1_off =3;
						in2_off=2;
				}
				else {
					field_size =2;
					grf_off =1;
					in1_off = in2_off = 2;
				}

			set_to(scratch_list, (grf_off)*max_graphs,
						EMPTY);
			

			for(i1=i2=o=total_opairs=0;( (i1< size_in1_count_list)
				|| (i2 < size_in2_count_list)); ){
				if (i1 < size_in1_count_list){
					lvl1 = in1_count_list[i1];		
					pairs1 = in1_count_list[i1+1];				
				} else{  lvl1= -1;
					pairs1=0;
				}
				if (i2 < size_in2_count_list){
					lvl2 = in2_count_list[i2];		
					pairs2 = in2_count_list[i2+1];				
				} else{  lvl2= -1;
					pairs2=0;
				}
				
				if ( lvl1 == lvl2){
					mark_grf(in1_count_list+i1+2, 
						 pairs1,op_code,0,in1_off,
						grf_off);
					mark_grf(in2_count_list+i2+2, 
						 pairs2,op_code,1, in2_off,
						grf_off);
					old_o= -1;
					opairs=0;
					add_grf_to_out(
					        in1_count_list+i1+2, 
						pairs1,
						out_count_list+o+2,
						&opairs, op_code, in1_off,
						grf_off);	
					if (opairs >0){
						out_count_list[o++] = lvl1;
						old_o = o;
						out_count_list[o++] = opairs;
					}
					o+= opairs*field_size;
					if (old_o != -1)
					add_grf_to_out(
					         in2_count_list+i2+2, 
						 pairs2,
						out_count_list+o,
						&opairs,op_code, in2_off,
						 grf_off);	
					else
					add_grf_to_out(
					         in2_count_list+i2+2, 
						 pairs2,
						out_count_list+o+2,
						&opairs,op_code, in2_off,
						grf_off);	
					i1 += pairs1*in1_off +2;
					i2 += pairs2*2+2;
					if ((opairs >0) && (old_o != -1)){
						out_count_list[old_o] += opairs;
					} else if (opairs>0) {
						out_count_list[o++] = lvl1;
						out_count_list[o++] = opairs;
					} 
					o+= opairs*field_size;
					total_opairs += opairs;
				}
				if (((lvl1!= -1) && ((lvl1 <lvl2)
					|| (lvl2== -1)))) {
					mark_grf(in1_count_list+i1+2, 
						 pairs1, op_code,0,
						in1_off, grf_off);
					add_grf_to_out(
					         in1_count_list+i1+2, 
						 pairs1,
						out_count_list+o+2,
						&opairs, op_code,
						in1_off, grf_off);	
					if (opairs >0){
						out_count_list[o++] = lvl1;
						out_count_list[o++] = opairs;
					}
					i1 += pairs1*in1_off +2;
					o+= opairs*field_size;
					total_opairs += opairs;
				}
				if (((lvl2!= -1) && ((lvl2 <lvl1)
					|| (lvl1== -1)))) {
					mark_grf(in2_count_list+i2+2, 
						 pairs2, op_code,1,
						in2_off, grf_off);
					add_grf_to_out(
					         in2_count_list+i2+2, 
						 pairs2,
						out_count_list+o+2,
						&opairs,op_code,in2_off,
						grf_off);	
					if (opairs >0){
						out_count_list[o++] = lvl2;
						out_count_list[o++] = opairs;
					}
					i2 += pairs2*2+2;
					o+= opairs*field_size;
					total_opairs += opairs;
				}
			}/*for*/
				
					
	*size_out_count_list = o;
}/*end make_list_from_counts*/
mark_grf(list,	pairs, op_code, offset, list_off,  grf_off)
int	*list, pairs, op_code, offset,list_off,  grf_off;
{
		int i, j, list_limit;
		for (i=0, list_limit =list_off*pairs; i < list_limit;) {
		j = grf_off*list[i];	
		if (op_code == ADD)
			scratch_list[j] += list[i+1];	
		else if (op_code == ZERO)
			scratch_list[ j] = 1;
		else  if ((op_code == CAT) ||
				(op_code == CAT2)) {
			if (op_code == CAT2){
			if (offset ==0) {
			scratch_list[ j] = list[i+1];	
			scratch_list[ j+1] = list[i+2];	
			} else 
			scratch_list[ j+2] = list[i+1];	
			} else scratch_list[ j+offset] = list[i+1];	
		}	
		i+=list_off;
		}
}/*end mark_grf*/
add_grf_to_out	(from_list,	from_pairs, to_list, to_pairs, op_code,
		list_off, grf_off)
int              *from_list,	from_pairs, *to_list, *to_pairs, op_code,
		list_off,  grf_off;
{
		int i, j,   k, opairs, list_limit;
		for (i=opairs=j=0, list_limit =from_pairs*list_off; 
				i < list_limit;) {
			k = grf_off*from_list[i];
			if ((scratch_list[k] != EMPTY) &&
				((op_code ==ADD) || (op_code == ZERO)) ){
					to_list[j++] =	from_list[i];
					if (op_code == ADD)
						to_list[j++] =
						scratch_list[ k] 
						- EMPTY;
					else if(op_code == ZERO)
						to_list[j++] =0;	
					scratch_list[ k] =EMPTY;
					opairs++;
			}else if ((op_code == CAT) || (op_code == CAT2)) {

				if ( op_code == CAT ) {
				if ((scratch_list[k] != EMPTY) 
				||( scratch_list[k+1] != EMPTY )) {
					to_list[j++] =	from_list[i];
					if (scratch_list[k] == EMPTY)
					to_list[j++] = 0;
					else 
					to_list[j++] =
					scratch_list[k]; 
					if (scratch_list[k+1] == EMPTY)
					to_list[j++] =  0;
					else 
					to_list[j++] = 
					scratch_list[k+1]; 
					scratch_list[k] =EMPTY;
					scratch_list[k+1] =EMPTY;
					opairs++;
				}	
				} else {
				if ((scratch_list[k] != EMPTY) 
				||( scratch_list[k+1] != EMPTY )
				||( scratch_list[k+2] != EMPTY )){
					to_list[j++] =	from_list[i];
					if (scratch_list[k] 
							== EMPTY)
					to_list[j++] = 0;
					else to_list[j++] =
					scratch_list[k]; 
					if (scratch_list[k+1] 
							== EMPTY)
					to_list[j++] = 0;
					else to_list[j++] =
					scratch_list[k+1]; 
					if (scratch_list[k+2] 
							== EMPTY)
					to_list[j++] = 0;
					else to_list[j++] =
					scratch_list[k+2]; 
					scratch_list[k] =EMPTY;
					scratch_list[ k+1] =EMPTY;
					scratch_list[ k+2] =EMPTY;
					opairs++;
					}	
				}/*else*/	
			}
			i+=list_off;
		}
		*to_pairs = opairs;
}/*end add_grf_to_out*/
make_cross_count_list(	
			beta_count_list, 
			size_beta_count_list,
			eps_count_list,
			size_eps_count_list,
			kappa_count_list,
			size_kappa_count_list, max_graphs)
int		*beta_count_list,	
		size_beta_count_list,
		*eps_count_list,
		size_eps_count_list,
		*kappa_count_list,
		size_kappa_count_list,	max_graphs;
{
/*
does kappa(i) = kappa(i-1) + beta(i-1) - varepsilon(i);
*/
			int 	beta_lvl, eps_lvl, kappa_lvl,
				i,
				grf, beta,	eps,
				i_beta, i_eps, i_kappa, 
				beta_pairs, eps_pairs, kappa_pairs;

			for (i=0; i <max_graphs; i++)
				scratch_list[i] = 0;

			for (i_beta=i_eps=i_kappa=0;
				(i_kappa < size_kappa_count_list);){
				
				if(i_beta <size_beta_count_list){
				beta_lvl = beta_count_list[i_beta];
				beta_pairs = beta_count_list[i_beta+1];
				} else {beta_lvl = -1;
					beta_pairs=0;
					}
				if(i_eps <size_eps_count_list){
				eps_lvl = eps_count_list[i_eps];
				eps_pairs = eps_count_list[i_eps+1];
				} else {eps_lvl = -1;
					eps_pairs=0;
					}
				kappa_lvl = kappa_count_list[i_kappa];
				kappa_pairs = kappa_count_list[i_kappa+1];
				
				if ((beta_lvl != -1) &&(beta_lvl <= eps_lvl)	
					&& (beta_lvl < kappa_lvl)){
					for (i_beta+=2; beta_pairs >0; 
							beta_pairs--) {
						grf = 
						beta_count_list[i_beta++];
						beta = 
						beta_count_list[i_beta++];
						scratch_list[grf] += beta;
					}
				}
				else if ((eps_lvl!= -1) &&
					(eps_lvl <= kappa_lvl)){	
					for (i_eps+=2; eps_pairs >0; 
							eps_pairs--) {
						grf = eps_count_list[i_eps++];
						eps = eps_count_list[i_eps++];
						scratch_list[grf] -= eps;
					}
				}else if (
					((beta_lvl == -1) && ( eps_lvl == -1))
					|| ((beta_lvl == -1) && 
						(eps_lvl >= kappa_lvl))
					|| ((beta_lvl >= kappa_lvl) && 
						(eps_lvl >= kappa_lvl))) {
						
				for (i_kappa+=2; kappa_pairs >0; 
							kappa_pairs--) {
					grf = kappa_count_list[i_kappa++];
					kappa_count_list[i_kappa++] =
						scratch_list[grf];
					/*k(i) = k(i-1)+ beta(i-1) - e(i)*/
					/*k(i+1) = k(i)*/
				}	
				}	
		}/*outer for*/
		/*clean up*/
		for (i=0; i <max_graphs; i++)
			scratch_list[i] = 0;
}/*end make cross count_lists*/
make_count_lists(		dim,	vtx_counts, 
				size_vtx_counts,
				max_size_vtx_counts,
				beta_counts,
				size_beta_counts, 
				max_size_beta_counts,
				eps_counts, 
				size_eps_counts,
				max_size_eps_counts)

int              		dim,	*vtx_counts, *size_vtx_counts,
				max_size_vtx_counts,
				*beta_counts,
				*size_beta_counts,
				max_size_beta_counts,
				*eps_counts, *size_eps_counts,
				max_size_eps_counts;
{

			
					/* count vtxs*/
			make_count_from_items(
				in_graph_v,
				v_list[dim], count_v_list[dim],
				index_v_list[dim], limits_v_list[dim],
				vtx_counts, 
				size_vtx_counts, 
				max_size_vtx_counts,
				global_levels[dim],
				VTX);
					/* count interval begins (beta)*/
			make_count_from_items(in_graph_ce,
				ce_list_starts[dim], count_ce_list_starts[dim],
				index_ce_list_starts[dim],
				limits_ce_list_starts[dim], beta_counts,
				size_beta_counts, 
				max_size_beta_counts, 
				global_levels[dim],
				BETA);
					/* count interval ends (epsilon)*/
				
			make_count_from_items(in_graph_ce,
				ce_list_ends[dim], 
				count_ce_list_ends[dim],
				index_ce_list_ends[dim],
				limits_ce_list_ends[dim], eps_counts,
				size_eps_counts, 
				max_size_beta_counts, 
				global_levels[dim],
				EPS);
			if(d_phase ==1)
				 stats[o_d_o] += (*size_vtx_counts+
					*size_beta_counts +
					*size_eps_counts)/2;
			else
				 stats[o_l_o] += (*size_vtx_counts+
					*size_beta_counts +
					*size_eps_counts)/2;

}/*make count_lists*/
make_kappa_counts(	
			beta_list,	size_beta_list,
			max_size_beta_list,
			eps_list,	size_eps_list,
			max_size_eps_list,
			kappa_list,	size_kappa_list,
			max_size_kappa_list)			

int	
			*beta_list,	*size_beta_list,
			max_size_beta_list,
			*eps_list,	*size_eps_list,
			max_size_eps_list,
			*kappa_list,	*size_kappa_list,
			max_size_kappa_list;
{



				
			if (d_phase==1) {
				stretch_count(
				beta_list, size_beta_list, BETA);
				if (*size_beta_list > 
					max_size_beta_list) {
				exit_err("make_kappa_counts:size err1", 
						case_err);
				}
				stretch_count(
				eps_list, size_eps_list,EPS);
				if (*size_eps_list > 
					max_size_eps_list) {
				exit_err("make_kappa_counts:size err2", 
						case_err);
				}
			}
			make_list_from_counts(
			beta_list,	*size_beta_list,
			eps_list,	*size_eps_list,
			kappa_list,	size_kappa_list,
			ZERO);
		
			if (*size_kappa_list > max_size_kappa_list) {
			exit_err("make_kappa_counts:size err3", case_err);
			}
			make_cross_count_list(
			beta_list,	*size_beta_list,
			eps_list,	*size_eps_list,
			kappa_list,	*size_kappa_list,
			max_graphs);
			if (d_phase ==1) 
				 stats[o_d_o] += 
					(*size_beta_list +
					*size_eps_list)/2;
			else
				 stats[o_l_o] += 
					(*size_beta_list +
					*size_eps_list)/2;



}/*end make_kappa_counts*/
find_min_eta_coords( kappa_list, 	size_kappa_list,
		 vtx_list, 		size_vtx_list,
		  graph_list, max_graphs, field_size, dim,
		  graph_bounds,	graph_bounds_field_size) 
int               *kappa_list, 	size_kappa_list,
		  *vtx_list, 	size_vtx_list,
		  *graph_list,	 max_graphs, 		field_size,
		 dim,
		 *graph_bounds,	graph_bounds_field_size;
/*
construct graph list
graph_list [field_size*grf] has  dim
graph_list [field_size*grf+1] has level (corresponding to min eta value)
graph_list [field_size*grf+2] has (min) eta value
*/
{
			int  count, grf, i, lvl,pairs, limit, size;
			int	*tmp_list;
			tmp_list = scratch_list+ 2*max_graphs+1	;
			
						/*initialize if dim==0*/
			if (dim==0){
				for (grf=0, limit = max_graphs*field_size; 
					grf < limit; ) {
					graph_list[grf] = EMPTY_LEVEL;
					graph_list[grf+1] = EMPTY_LEVEL;
					 /* EMPTY = -1*/
					graph_list[grf+2] = LARGE_BOUND;
						/* a suitably large number*/
					grf += field_size;
				}
			}
					/*make count of etas by
					adding vtx count + kappa count,
					use scratch count list for that*/
			
		 
			make_list_from_counts(
			vtx_list,	size_vtx_list,
			kappa_list,	size_kappa_list,
			tmp_list,
			&size,
			ADD);

			
			for (i=0; i <size; ) {
				
				lvl = tmp_list[i++];
				pairs = tmp_list[i++];

				for(limit = pairs*2+i; i < limit; ){
					grf = tmp_list[i++];
					count = tmp_list[i++];
					if ((lvl >= graph_bounds[ 
					graph_bounds_field_size*grf])
					&& (lvl <= graph_bounds[
					graph_bounds_field_size*grf+1])){
						if (
						(graph_list[grf*field_size
								+1]
						== EMPTY_LEVEL) ||
						(graph_list[grf*field_size
						+2]
						>= count)){
					
							graph_list
							[grf*field_size] = 
								dim;
								/*dimension*/
							graph_list
							[grf*field_size+
							1] = lvl;
							graph_list
							[grf*field_size
								+2]
								= count;
						}/*if*/
					}
				}
			}
			if (d_phase ==1) 
					stats[o_d_o] += size/2;
			else
					stats[o_l_o] += size/2;
}/*end find_min_eta_coords*/

stretch_count( list, size_list,  code)
int		*list, *size_list,  code;
{

		int i, j,k,l,lvl,i_next,lvl_next,pairs, count, last_level;
		

		count = *size_list;
		copy(count, 1, list, 1, scratch_list);
		for (i=j=0; i<count; ) {
			lvl = scratch_list[i];
			pairs = scratch_list[i+1];

			i_next = i+pairs*2 +2;
			if (i_next < count) lvl_next
					=scratch_list[i_next];
			else {
				 lvl_next = -1;
				 last_level = lvl;
			}
			list[j++] = lvl;
			list[j++] = pairs;
			for(k=pairs,l=i+2; k>0; k--){
				list[j++] = scratch_list[l++];
				list[j++] = scratch_list[l++];
			}
			for (lvl++; lvl < lvl_next; lvl++) {
				list[j++] = lvl;
				list[j++] = pairs;
				for(k=pairs,l=i+2; k>0; k--){
					list[j++] = scratch_list[l++];
					list[j++] = 0	;
					l++;
				}
			}
			i =i_next;
		}

		if (code == EPS)  {
			list[j++] = last_level+1;
			list[j++] = max_graphs;
			for(i=0; i<max_graphs; i++) {
				list[j++] = i;
				list[j++] = 0;
			}
		}
		*size_list=j;
}
