/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include	"o_defs.h"
extern		int		*a_size, my_pid, *tree_local_column,
				local_phase_root;
re_make_tree (scratch_list)
int		*scratch_list;
{

		extern	int 	*tree_parent, *tree_chains,
				*o_n_tree_chains, *chain_index,
				*tree_child, *tree_sibling,
				size_tree_chains, *d_tree_parent,
				*d_tree_chains, *o_n_d_tree_chains,
				*d_chain_index, tree_size, d_tree_size,
				d_last_chain_index, last_chain_index, old_P;
		extern		double clock0(), stats[];
		double		last_clock;
		int		*tmp2;
	
		int i, j, k, next,*new, *old, *back_index, *back;

		last_clock = clock0();
		if (old_P >1) {
			for (i=0; i <tree_size; i++){
				chain_index[i] += d_last_chain_index;
				tree_parent[i] += d_tree_size;
			}
                        chain_index[tree_size] += d_last_chain_index;
	
			copy(tree_size,1, 
					tree_parent,1, d_tree_parent
					+d_tree_size);
			copy(tree_size+1,1, 
					chain_index,1, 
						d_chain_index
						+d_tree_size);
			copy(last_chain_index,1, 
					tree_chains,1, d_tree_chains
						+d_last_chain_index);
			copy(last_chain_index,1, 
					o_n_tree_chains,1, o_n_d_tree_chains
						+d_last_chain_index);
			free ((char *) tree_parent);
			free ((char *) tree_chains);
			free ((char *) o_n_tree_chains);
			free ((char *) chain_index);
			local_phase_root = tree_size-1;
			tree_parent = d_tree_parent;
			chain_index = d_chain_index;
			tree_chains = d_tree_chains;
			o_n_tree_chains = o_n_d_tree_chains;
			tree_size += d_tree_size;
			last_chain_index += d_last_chain_index;
		}
		else local_phase_root = tree_size-1;
		size_tree_chains = last_chain_index;
               	if ((tree_child = ( int *)
                                my_malloc (((tree_size*int_size)))) == NULL)
                                exit_err("re_make_tree:tree_child",
					 malloc_err);
               	if ((tree_sibling = ( int *)
                               my_malloc (((tree_size*int_size)))) == NULL)
                                exit_err("re_make_tree:tree_child",
					 malloc_err);
               	if ((tree_local_column = ( int *)
                               my_malloc (((last_chain_index*int_size)))) 
				== NULL)
                                exit_err("re_make_tree:tree_local_column",
					 malloc_err);
               	if ((tmp2 = ( int *)
                               my_malloc (((last_chain_index*int_size)))) 
				== NULL)
                                exit_err("re_make_tree:tmp2",
					 malloc_err);
		new = scratch_list;
		old = scratch_list+tree_size+2;	
		back_index= old+tree_size+2;
		back = back_index+tree_size+3;
		copy(tree_size+1, 1, chain_index, 1, back_index);
		copy(back_index[tree_size], 
				1, tree_chains, 1, back);
		copy(back_index[tree_size], 
				1, o_n_tree_chains, 1, tmp2);

		make_child_sibling(tree_parent, 
			tree_child, tree_sibling, tree_size);
		next =0;
		re_number_tree(0, tree_child, tree_sibling,
					 new, old, &next);
		copy(tree_size, 1, tree_parent, 1, tree_child);
		for (next=0; next <tree_size ; next++){
			if (tree_child[next] != EMPTY)	
				tree_parent[new[next]] = new
							[tree_child[next]];
			else tree_parent[new[next]] = tree_child[next];
		}	
		make_child_sibling( tree_parent,tree_child, 
			tree_sibling, tree_size);
		for (i=next=0; i <tree_size;i++){
			
			chain_index[i] = next;
			for(j= back_index[old[i]],
				k = back_index[old[i] +1];
					j <k; j++) {
				tree_chains[next] = back[j];
				o_n_tree_chains[next++] = tmp2[j];
			}
		}	
		chain_index[i] = next;
		stats[s_l_t] += clock0() -last_clock;

}/*end_re_make*/
re_number_tree(now, child, sibling, new, old, next)
int	now, 	*child, 	*sibling,  *new, 	*old, *next;
{

		int i;
		for (i=child[now]; i!= EMPTY; i = sibling[i])
			re_number_tree(i, child, sibling, new, old, next);

		new[now ] = *next;
		old[*next] = now;
		(*next) ++;
}/*end re_number_tree*/
		
make_child_sibling( parent, child, sibling, count)
int		*parent,	*child,		*sibling, count;
{
			int i ;
		for (i=0; i <count; i++)
			sibling[i]=  child[i] = EMPTY;
		
		for (i=count-1; i >=0; i--){
			if (parent[i] != EMPTY) {
				sibling[i] = child[parent[i]];
				child[parent[i]] = i;
			}
		}
}/*end_make_child_sibling*/
re_order_spd( a_subs, row_col,  a_index, a_nonz,  b,
		scratch_list)
int		a_subs,	*row_col, 	
		*a_index, 	*scratch_list;
real_type	*a_nonz,	*b;
{
		extern	 int 	N_b,*b_global_column,
				*global_column,
				g_N, old_P, tree_size, 
				real_N, N, *d_new_numbers,
				*new_numbers, last_chain_index;
		int *tmp_list1, *tmp_list2, i,j,  limit, next, row, last;
		float *tmp_b;
		extern		double clock0(), stats[];
		double		last_clock;


		last_clock = clock0();
		if (old_P >1) {
			for (i=N; i <real_N ;i++)
				new_numbers[i] = d_new_numbers[i];
			N = real_N;
		}
		tmp_list1 = scratch_list;
		tmp_list2 = scratch_list+ 2*a_subs;

		for (i=0, limit = 2*a_subs; i < limit; i++)
			row_col[i] = new_numbers[row_col[i]];

		for (i=0; i <limit; i+=2)
			if (row_col[i] > row_col[i+1])
				swap(row_col+i, row_col+i+1);

		quick_sort2(a_subs,tmp_list1,row_col);	
		inverse_perm(a_subs, tmp_list2, tmp_list1);
		permute(a_subs,2,tmp_list2,row_col,NULL);
		permute(a_subs,1,tmp_list2,NULL,a_nonz);

		copy(2*a_subs,1, row_col,1,tmp_list2); 
		
                for ( i=j=next=0; i < limit ; ) {
                        row = tmp_list2[i];
			tmp_list1[j] = row;
                        a_index[j] = next;
                        for (; ((tmp_list2[i]) == row);i+=2)
				row_col[next++] = tmp_list2[i+1];
			j++;
                }
                a_index[j] = next;
                if ((a_size = ( int *)
                                my_malloc ((j*int_size))) == NULL)
                                exit_err("o_s_glue:a_size", malloc_err);

		for (i= 0; i <j; i++) 
			a_size[i] = a_index[i+1] - a_index[i];


			
		for (i=next=0; (i<last_chain_index); i++) {
			if ( (next <j) &&(tmp_list1[next] ==
				tree_chains[i])) {
				tree_local_column[i] = next;
				next++;
			}
			else tree_local_column[i] = EMPTY;
		}
		

		quick_sort(N_b,tmp_list1,b_global_column);	
                inverse_perm(N_b, tmp_list2, tmp_list1);
                permute(N_b,1,tmp_list2,b_global_column,NULL);
                permute(N_b,1,tmp_list2,NULL,b);
		quick_sort(N,tmp_list1,global_column);	
		for (i=j=0; i <N_b; ){
			if (b_global_column[i] == 
				global_column[tmp_list1[j]]){
				b_global_column[i] = 
					new_numbers[tmp_list1[j]];
				i++, j++;
				}
			else if (b_global_column[i] > 
				global_column[tmp_list1[j]])
						j++;
				     else printf("b_glob is small\n");
		}	
		quick_sort(N_b,tmp_list1,b_global_column);	
						
			
					

		N = j;
               	if ((tmp_b = ( float *)
                                my_malloc (((N_b*real_size)))) == NULL)
                                exit_err("re_order_spd:tmp_b",
					 malloc_err);
		for (i=0; i <N_b; i++)
			tmp_b[i] = b[i];
		for(i=j=0; i <N_b;  ) {
				next = tmp_list1[i];
				next = b_global_column[next];
				if (next == tree_chains[j]){
					if (tree_local_column[j] == -1)
						printf("b_weird\n");
					b[tree_local_column[j]] =
							tmp_b[tmp_list1[i]];
					i++;
					j++;
				}	
				else if (next > tree_chains[j]){
					b[tree_local_column[j]] =0.0;
					 j++;
					}
				     else exit_err("next_small",int_err2);
		}
				

		free (((char *) tmp_b));
		free_all ();
		stats[s_l_t] += clock0() -last_clock;
	
}
