/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include	"o_defs.h"
extern 	int  my_pid;
/*
routines related to:
merging an arbitary number of lists in time proportional to the sum of
the length of lists

merges several count_lists (pointed to by list_starts) into one
final count list that adds counts over the same level in the same graph

*/
initialize_linked_list(	
					last,		
					starts,
					ends,
					list,
					next)
int					
					last,		
					*starts,
					*ends,
					*list,
					*next;

{

		int i;
		for (i= *next=0; i <last; i++)
				starts[i] = ends[i] = EMPTY;
}/*end initialize_linked_list*/
to_block_level_form	(
				count_list,
				size_count_list,
				field_size,
				field_offset,
				blocks_starts,
				blocks_ends,
				blocks_list,
				blocks_next)

/*
counts list has form:
level #of fields field field .... level #of fields field ...

each field is fo the form
      block_id value value ...
  ->                      <-
     field_size
the value at field_offset is used in conversion

the linked list blocks_XXXX has each field for a given block
 correspond to level value at field_offset ptr to next ...
*/
int
				*count_list,
				size_count_list,
				field_size,
				field_offset,
				*blocks_starts,
				*blocks_ends,
				*blocks_list,
				*blocks_next;
{

			int blk, i, lvl, next, no_of_fields;

			for (next = *blocks_next,
				i=0; i < size_count_list; ){
				lvl = count_list[i++];
				no_of_fields = count_list[i++];
				for (; no_of_fields>0; no_of_fields--){
					blk = count_list[i];
					if (blocks_ends[blk] != EMPTY){
					blocks_list[blocks_ends[blk]+2]
						= next;
					} else {
						blocks_starts[blk] =next;
						}
					blocks_ends[blk] = next;
					blocks_list[next++] = lvl;
					blocks_list[next++] = count_list[i+
							field_offset];
					blocks_list[next++] = EMPTY;
					i+= field_size;
				}
			}
			*blocks_next = next;
}/*end to_block_level_form*/
add_in_block_level_form(	max_blocks,
                        	max_levels,
				block_labels,
				levels_list,
				blocks_starts,
				blocks_ends,
				blocks_list,
				blocks_next)
int                    		max_blocks,
				max_levels,
				*block_labels,
				*levels_list,
				*blocks_starts,
				*blocks_ends,
				*blocks_list,
				*blocks_next;
{
		int blk, next,lvl ;
		for (next=0; next <2*max_levels; next++)
				levels_list[next] = 0;
		for (blk=0 ; blk < max_blocks ; blk++){
			for (next = blocks_starts[blk]; next!= EMPTY;){
				lvl = blocks_list[next];
				lvl = lvl - block_labels[my_pid];	
				levels_list[2*lvl+1] = NOT_EMPTY;
				levels_list[2*lvl]
					+= blocks_list[next+1];
				next = blocks_list[next+2];
			}
			blocks_ends[blk] = EMPTY;
			for (next = blocks_starts[blk];
				 next!= EMPTY;){
				lvl = blocks_list[next];
				lvl = lvl - block_labels[my_pid];	
				if(levels_list[2*lvl+1] != EMPTY){
				 blocks_list[next+1]=
					levels_list[2*lvl];
				levels_list[2*lvl] =0;
				levels_list[2*lvl+1] =EMPTY;
				if ( blocks_ends[blk] != EMPTY)
				blocks_list[blocks_ends[blk]+2] = next;
				blocks_ends[blk] = next;
				next = blocks_list[next+2];
				} else 
					next = blocks_list[next+2];
			}
		}	
		for (blk=0 ; blk < max_blocks ; blk++)
			if (blocks_ends[blk] != EMPTY)
				blocks_list[blocks_ends[blk] +2] = EMPTY;
}/*end add_in_block_level_form*/
to_count_list_form(
				max_levels,
				max_blocks,
				blocks_starts,
				blocks_lists,
				block_labels,
				levels_starts,
				levels_list,
				count_field_size,
				count_field_offset,
				count_list,
				size_count_list)
int
				max_levels,
				max_blocks,
				*blocks_starts,
				*blocks_lists,
				*levels_starts,
				*levels_list,
				*block_labels,
				count_field_size,
				count_field_offset,
				*count_list,
				*size_count_list;
{


			int i,lvl, next, number_of_fields,
				pos_number_of_fields;

			for (lvl=next=0; lvl < max_levels; lvl++){
				count_list[next++] = block_labels[my_pid]+
							lvl;
				pos_number_of_fields= next++;
				number_of_fields=0;
				for (i= levels_starts[lvl]; i!= EMPTY; ){
				 count_list[next] = levels_list[i++];
						/*blk */
				 count_list[next+count_field_offset] = 
						levels_list[i++];
				 next+= count_field_size;
						/*count */
				 i = levels_list[i];	
				number_of_fields++;
				}
				count_list[pos_number_of_fields] = 
					number_of_fields;	
			}
			*size_count_list = next;
}/*end to_count_list-form*/
				
				
				
				
							
string_blocks_in_levels(
					max_levels,
					max_blocks,
					block_labels,
					levels_starts,
					levels_ends,
					levels_list,
					levels_next,
					blocks_starts,
					blocks_ends,
					blocks_list)
/*
string together into levels_XXXXXX a linked list, all blocks that
have values in these levels !
*/
int
					max_levels,
					max_blocks,
					*block_labels,
					*levels_starts,
					*levels_ends,
					*levels_list,
					*levels_next,
					*blocks_starts,
					*blocks_ends,
					*blocks_list;
{

			int blk, count, i, lvl,  next;

			for (blk=0,next = *levels_next; 
				blk < max_blocks; blk++){
				for(i=blocks_starts[blk]; i != EMPTY; ){
					lvl = blocks_list[i];
					lvl -= block_labels[my_pid];
					count = blocks_list[i+1];
						if (levels_ends[lvl] != EMPTY){
	
						levels_list[levels_ends[lvl]+2]
						= next;
						} else {
						levels_starts[lvl] =
							next;
						}
						levels_ends[lvl] = next;
						levels_list[next++] = blk;
						levels_list[next++] = count;
						levels_list[next++] = EMPTY;
					i= blocks_list[i+2];
				}
			}
			*levels_next = next;
}/*end string_blocks_in_levels*/
p_way_merge_counts(	
			max_blocks,
			max_levels,
			block_labels,
			hooks,
			hooks_size,
			k_vector,
			field_size,
			field_offset,
			out_count_list,
			size_out_count_list,
			out_field_size,
			out_field_offset)

/*

merges an arbitary number of lists in time proportional to the sum of
the length of lists

merge several count_lists (pointed to by list_starts) into one
final count list that adds counts over the same level in the same graph
*/
int
			max_blocks,
			max_levels,
			*block_labels,
			hooks,
			hooks_size,
			*k_vector,
			field_size,
			field_offset,
			*out_count_list,
			*size_out_count_list,
			out_field_size,
			out_field_offset;
{
			extern		int	*d_scratch_list,  
					max_size_d_scratch_list,  
					last_used_in_d_scratch_list;

			int next, *count_list, size_count_list,
				*blocks_starts, *blocks_ends,
				*blocks_list, blocks_next,
				*levels_starts, *levels_ends,
				*levels_list, levels_next,
				save;
		
			save = last_used_in_d_scratch_list;
			blocks_starts = d_scratch_list + 
					last_used_in_d_scratch_list +1;
			blocks_ends = blocks_starts + max_blocks;
			levels_starts = blocks_ends + max_blocks;
			levels_ends= levels_starts + max_levels;
			blocks_list = levels_ends + max_levels;	

			last_used_in_d_scratch_list = 3*
						(max_blocks +max_levels) +1;	

			initialize_linked_list(	
					max_blocks,		
					blocks_starts,
					blocks_ends,
					blocks_list,
					&blocks_next);
			count_list = k_vector + hooks;
			size_count_list = hooks_size;
			to_block_level_form     (
							count_list,
							size_count_list,
							field_size,
							field_offset,
							blocks_starts,
							blocks_ends,
							blocks_list,
							&blocks_next);
			levels_list = blocks_list + blocks_next +1;	
			last_used_in_d_scratch_list += blocks_next+1;

			if (last_used_in_d_scratch_list >=
             				max_size_d_scratch_list)
					exit_err("p_way_merge1",size_err);

			add_in_block_level_form( 
						max_blocks,
						max_levels,
						block_labels,
						levels_list,
						blocks_starts,
						blocks_ends,
						blocks_list,
						&blocks_next);
			initialize_linked_list(	
					max_levels,		
					levels_starts,
					levels_ends,
					levels_list,
					&levels_next);
			if ((last_used_in_d_scratch_list+levels_next) >= 
             			max_size_d_scratch_list)
				exit_err("p_way_merge2",size_err);

			string_blocks_in_levels(
						max_levels,
						max_blocks,
						block_labels,
						levels_starts,
						levels_ends,
						levels_list,
						&levels_next,
						blocks_starts,
						blocks_ends,
						blocks_list);

		
			to_count_list_form(
						max_levels,
						max_blocks,
						blocks_starts,
						blocks_list,
						block_labels,
						levels_starts,
						levels_list,
						out_field_size,
						out_field_offset,
						out_count_list,
						size_out_count_list);
			last_used_in_d_scratch_list = save;
}/*end p_way_merge*/
