/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include	"o_defs.h"
#include	"o_ext.h"
extern		int	my_pid, N_b;
extern		int	*b_global_column;
make_items	()
/*

make 	item lists
each item list  has a corresponding index list:
index_item_list[i] 	points into item_list where there are  
			items for level i
each item list  has a corresponding count list:
count_item_list[i] 	contains the number of items at level i; used to
			keep lists compressed upon deletion
each item list  has a corresponding limits list:
limits_item_list[0] 	contains the smallest  level with any items
limits_item_list[1] 	contains the smallest  level with *no* items

(limits/index/count)_v_list, v_list[]:
				are  vertex lists per dim.
(limits/index/count)_ce_list_starts, ce_list_starts[]:
				clique or edge starts per dim
(limits/index/count)_ce_list_ends, ce_list_ends[]: 
				clique or edge ends per dim

*/
{

		int	*tmp_list1, *tmp_list2, i,j, k;
		
		extern	double clock0(), my_time;


		if((tmp_list1 = (int *) my_malloc((Asubs*int_size))) == NULL)
			exit_err("make_items:tmp_list1", malloc_err);
		if((tmp_list2 = (int *) my_malloc((Asubs*int_size))) == NULL)
			exit_err("make_items:tmp_list2", malloc_err);
		quick_sort2(Asubs,tmp_list1,row_col);	
		inverse_perm(Asubs, tmp_list2, tmp_list1);
		permute(Asubs,2,tmp_list2,global_row_col,NULL);
		permute(Asubs,2,tmp_list2,row_col,NULL);
		permute(Asubs,1,tmp_list2,NULL,a_nonz);
		quick_sort(N,global_column_srted, global_column);

		copy(my_N,1,global_column,1,b_global_column);
		quick_sort(my_N,tmp_list1,b_global_column);	
		inverse_perm(my_N, tmp_list2, tmp_list1);
		permute(my_N,1,tmp_list2,b_global_column,NULL);
		permute(my_N,1,tmp_list2,NULL,b);
		N_b = my_N;
				
		free ((char *) tmp_list1);	
		free ((char *) tmp_list2);	
	
		make_vertex_lists();
		make_edge_lists(row_col, Asubs);

}
make_vertex_lists()
{
/*
make 		v_list[], index_v_list[], set limits[] over all dims
*/
		int dim, *sorted_order, extra;
		if((sorted_order = (int *) my_malloc((N*int_size))) == NULL)
			exit_err("make_vertex_lists:sorted_order",
				malloc_err);

		for (dim=0; dim <D; dim++) {	
			
			if((limits[dim] = (int *) 
				my_malloc(((2)*int_size)) )
				== NULL)
				exit_err("make_vertex_lists_limits",
						 malloc_err);
			if((limits_int[dim] = (int *) 
				my_malloc(((2)*int_size)))
				== NULL)
				exit_err("make_vertex_lists_limits_int",
						 malloc_err);
			if((global_levels[dim] = (int *) 
				my_malloc(((N)*int_size)) )
				== NULL)
				exit_err("make_vertex_lists_global_levels",
						 malloc_err);
		
			quick_sort(N,sorted_order, xyz_int[dim]);
			fix_coords(N, sorted_order,
						 xyz_int[dim], xyz[dim],
						global_levels[dim],
						limits_int[dim],
						limits[dim]); 
			if((limits_v_list[dim] = (int *) 
				my_malloc(((2)*int_size)))
				== NULL)
				exit_err("make_vertex_lists_limits",
						 malloc_err);
			if((v_list[dim] = (int *) 
				my_malloc(((N)*int_size)))
				== NULL)
				exit_err("make_vertex_lists_0",
						 malloc_err);
			if((count_v_list[dim] = (int *) 
				my_malloc(((*(limits[dim]+1)+2)*int_size)) )
				== NULL)
				exit_err("make_vertex_lists_1", malloc_err);
			if((index_v_list[dim] = (int *) 
				my_malloc(((*(limits[dim]+1)+2)*int_size)) )
				== NULL)
				exit_err("make_vertex_lists_2", malloc_err);
			set_to(index_v_list[dim],
				(*(limits[dim] +1) +2), 0);
			set_to(count_v_list[dim],
				(*(limits[dim] +1) +2), 0);
			make_v_list( N, v_list[dim], 
					count_v_list[dim],
					index_v_list[dim],
					limits_v_list[dim],
					sorted_order,	
					xyz[dim], limits[dim]);
		}	
		free ((char *) sorted_order);
}/*end make_vertex_lists*/
fix_coords(count, order_list, xyz_glob, xyz, global_levels,
			limits_glob, limits_int) 
int	count, *order_list, *xyz_glob, *xyz, *global_levels,
			*limits_int, *limits_glob;
{
/*

assign 		a  local integer number to each distinct  coord

*/

		int 		next_int,	i,
		          	last, 	this;
		
		for(i=1, limits_int[0] =
			next_int =xyz[order_list[0]] =0, 
			global_levels[0]=
			last= limits_glob[0] = xyz_glob[order_list[0]]; 
					i <count; i++){
				this = xyz_glob[order_list[i]];
				if (this >last) {
					xyz[order_list[i]] = ++next_int;
					global_levels[next_int] = this;
					last = this;
				}
				else xyz[order_list[i]] = next_int;
		}
		limits_glob[1] = next_int+1;
		limits_int[1] = last;
}
make_v_list( count, list, count_list,
	 	index, limits_list,
		order_coords, coords, bounds)
int	count,	*list,	*count_list,
		*limits_list,
		*index,  *order_coords, *coords, *bounds;
{

/*

make 		v_list, count_v_list,  index_v_list for a given dim

*/
		int i,j,next, last;

		for (i=next=last=j=0,
			index[next] =0; 
				 i< count; i++) {
			if (order_coords[i] < my_N){
			next = coords[order_coords[i]] ;
			if ( next >last) {
				index[next]= j;
				count_list[last]= j - index[last];
			} 
			list[j] =order_coords[i]; 
			last = next;
			j++;
			}
		}
		index[next+1] = j;
		count_list[next+1] = 0;
		count_list[next]= j - index[next];
		for (i=0; (count_list[i] ==0); )
					i++;
		limits_list[0] =i;
		limits_list[1] = next+1;
					
}/*end make item_list*/
		
make_edge_lists(row_c, count_r_c)
int		*row_c, count_r_c;
{
/*

make 		ce_list_starts/ends[], index_ce_list_starts/ends[] over 
		all dims when given count_r_c edges in r_c 

when the matrix is spd, row_c corresponds to row_col
			otherwise it calls  make_macro edges 
					to  set up a list of (macro) 
					edges to correspond
					to row cliques 

*/

		extern	double clock0(), my_time;
		double	 last_clock;
		int	*list1, *list2, *list3,  *o_list1,  dim;
		if((list1 = (int *) my_malloc((2*count_r_c*int_size))) == NULL)
			 exit_err("make_edge_lists1", malloc_err);

		if (T != SYMM) {
		if((list2 = (int *) my_malloc((2*count_r_c*int_size))) == NULL)
			 exit_err("make_edge_lists2", malloc_err);
		}
		if((list3 = (int *) my_malloc((2*count_r_c*int_size))) == NULL)
			 exit_err("make_edge_lists3", malloc_err);

		if((o_list1=(int *) my_malloc((2*count_r_c*int_size))) == NULL)
			 exit_err("make_edge_lists4", malloc_err);

		if (T== SYMM) put_edge_indices (list3, count_r_c);
		for (dim=0; dim < D; dim++) {

			if (T == SYMM)
			{
			copy_and_permute(2*count_r_c,1,row_c, 
					xyz[dim],1,list1);
			list2 =  row_c;
			} 
			else 
			count_r_c = make_macro_edges(dim, row_c, 
					list1,list2,list3);

			quick_sort(count_r_c*2,o_list1,list1);	
			if((limits_ce_list_starts[dim] = (int *) 
				my_malloc(((2)*int_size)))
				== NULL)
				exit_err("make_edge_lists_limits",
						 malloc_err);
			if((ce_list_starts[dim] = (int *) 
				my_malloc((count_r_c*int_size)))
				== NULL)
				exit_err("make_edge_lists_5", malloc_err);
			if((index_ce_list_starts[dim] = (int *) 
				my_malloc(((*(limits[dim]+1)+2)*int_size)) )
				== NULL)
				exit_err("make_edge_lists_6", malloc_err);
			if((count_ce_list_starts[dim] = (int *) 
				my_malloc(((*(limits[dim]+1)+2)*int_size)) )
				== NULL)
				exit_err("make_edge_lists_7", malloc_err);
			if((limits_ce_list_ends[dim] = (int *) 
				my_malloc(((2)*int_size)))
				== NULL)
				exit_err("make_edge_lists_limits2",
						 malloc_err);
			if((ce_list_ends[dim] = (int *) 
				my_malloc((count_r_c*int_size)))
				== NULL)
				exit_err("make_edge_lists_8", malloc_err);
			if((index_ce_list_ends[dim] = (int *) 
				my_malloc(((*(limits[dim]+1)+2)*int_size)) )
				== NULL)
				exit_err("make_edge_lists_9", malloc_err);
			if((count_ce_list_ends[dim] = (int *) 
				my_malloc(((*(limits[dim]+1)+2)*int_size)) )
				== NULL)
				exit_err("make_edge_lists_10", malloc_err);

			set_to(index_ce_list_starts[dim],
				(*(limits[dim] +1) +1), 0);
			set_to(index_ce_list_ends[dim],
				(*(limits[dim] +1) +1), 0);
			set_to(count_ce_list_starts[dim],
				(*(limits[dim] +1) +1), 0);
			set_to(count_ce_list_ends[dim],
				(*(limits[dim] +1) +1), 0);
			make_e_list(2*count_r_c, 
				ce_list_starts[dim],
				ce_list_ends[dim],
				list1, list2, list3, o_list1, 
				count_ce_list_starts[dim],
				count_ce_list_ends[dim],
				index_ce_list_starts[dim],
				index_ce_list_ends[dim],
				limits_ce_list_starts[dim],
				limits_ce_list_ends[dim],
				limits[dim],
				xyz[dim]);

		}
		free ((char *) list1);
		free ((char *) o_list1);
		free ((char *) list3);
		if (T != SYMM) {
			free ((char *) list2);
		}
}/*end_make_edge_lists*/

make_e_list(count, list_starts,
		list_ends,
		list1, list2, list3, o_list1,
		count_list_starts,
		count_list_ends,
		index_list_starts,
		index_list_ends,
		limit_list_starts,
		limit_list_ends,
		limits,
		coords)

int		count,	*list_starts,	 *list_ends, *list1,  
		*list2, *list3, *o_list1,  
		*count_list_starts, *count_list_ends,
		*index_list_starts,  *index_list_ends, 
		*limit_list_starts,		*limit_list_ends,
		*limits, *coords;
{
/*

make 	ce_list_starts, ce_list_ends, index/count_ce_list_starts, 
	index/count_ce_list_ends for a given dim when given 
				list1, list2, list3, o_list1
o_list1 	is such that list1[o_list1[0]], list1[o_list1[1]].. are in
		sorted order.
list2 		is in one to one correspondence with list1;
list1[x] 	contains coords of list2[x]
list2 		is such that list2[x] and list2[x+1] make up end columns 
		of an edge when x is even
list3 		contains edge indices  in the case of T=SYMM
		in the case of non-symm matrices if list2[x] and 
		list2[x+1] contain min and max columns in  a given row 
		y then list3[x] and list3[x+1] contain y.



*/
	int 	ends_next, next,starts_next, i,
		a,b, diff, last_starts, last_ends; 

		for (i=last_starts=last_ends =ends_next = starts_next=
			index_list_starts[0] = index_list_ends[0]=0; 
				i < count; i++) {
			next = list1[o_list1[i]];
			a = ((o_list1[i] %2) ==0)? 
					list2[o_list1[i]] : 
					list2[o_list1[i]-1]; 
			b = ((o_list1[i] %2) ==0)? 
				list2[o_list1[i]+1] : 
					list2[o_list1[i]]; 
			a = coords[a];
			b = coords[b];
			if ( b<a) swap(&a,&b);
			diff = ((b-a) <0)? a-b: b-a;
			if ((diff>0)) {
				if (next==a)  { 
					/* is start end*/
					if (next> last_starts) {
				          index_list_starts[next] =
					   starts_next;
				          count_list_starts[last_starts] =
					   starts_next - 
					   index_list_starts[last_starts];
					}
					list_starts[starts_next++] =
						list3[o_list1[i]];
					last_starts = next ;
				} else if (next ==b) {
					if (next> last_ends) {
					  index_list_ends[next] = ends_next;
				          count_list_ends[last_ends] =
					   ends_next - 
					   index_list_ends[last_ends];
					}
					list_ends[ends_next++] =
						list3[o_list1[i]];
					last_ends = next ;
				}else exit_err(	"make_e_list",case_err);
			}	
		} /*for*/

		if ((last_ends +1) >= (limits[1] +2) ){
		printf("%d:error in make_e_list last (ends) %d limit %d\n",
			my_pid, last_ends, limits[1]);	
		exit_err("make_e_list(ends)",case_err);
		}
		if ((last_starts +1) >= (limits[1] +2) ){
		printf("%d:error in make_e_list last (ends) %d limit %d\n",
			my_pid, last_starts, limits[1]);	
		exit_err("make_e_list(starts)",case_err);
		}
		index_list_ends[last_ends+1] = ends_next;
		count_list_ends[last_ends+1] = 0;
		count_list_ends[last_ends] = ends_next -
						index_list_ends[last_ends];
		index_list_starts[last_starts+1] = starts_next;
		count_list_starts[last_starts+1] = 0; 
		count_list_starts[last_starts] = starts_next -
					index_list_starts[last_starts];
		for (i=0; ((count_list_starts[i] ==0) && (i <limits[1])); )
						i++;
		limit_list_starts[0] = i;
		limit_list_starts[1] = last_starts+1;
		for (i=0; ((count_list_ends[i] ==0) && ( i < limits[1])); )
						i++;
		limit_list_ends[0] = i;
		limit_list_ends[1] = last_ends+1;
		for(i=last_starts+2; i < limits[1] ; i++)
			index_list_starts[i] = count_list_starts[i] = 0;
		for(i=last_ends+2; i < limits[1] ; i++)
			index_list_ends[i] = count_list_ends[i] = 0;
} /*make_e_list*/

int	make_macro_edges(dim, row_col, list1, list2, list3)

int	dim, *row_col, *list1, *list2, *list3;
{
/*

when given a  non symmetric matrix 
treats each row as a macro-interval
is called by make_edge_lists  to set up a lists of (macro) edges
to correspond to  macro intervals in given dimension

*/

		int i, row, col_min, col_max, next_row, next_col, next,
			count, diff;
		int *coords;

		coords = xyz[dim];
		for (next=count =0,
			next_row = row_col[0], i=1; i < 2*Asubs ; ) {
			row = next_row;
			col_min = col_max = row_col[i++];
			for (; ((next_row= row_col[i++]) == row);) {
				next_col = row_col[i++];
				if  (coords[col_min] > coords[next_col])
					col_min = next_col;
				if  (coords[col_max] < coords[next_col])
					col_max = next_col;
			}
			diff = coords[col_max] - coords[col_min];
			diff = ( diff <0) ? (0 -diff): diff;
			if (diff >0) {
				list1[next] = coords[col_min];
				list2[next] =col_min; 
				list3[next++] =row ; 
				list1[next] = coords[col_max];
				list2[next] = col_max;
				list3[next++] = row;
				count++;
			}
		}
return(count);

}/*end_make_macro_edges*/
add_items(	
		to_be_added,
		index_to_be_added,
		limits,
		items_list, 
		index_list, count_list, op_code)
int		*to_be_added,
		*index_to_be_added,
		*limits,
		*items_list, 
		*index_list, *count_list, op_code;
/*
adds items to  item list
in increasing order of levels to holes
at end of each level if op_code = INC 

in decreasing order of levels, to holes
at start of each level if op_code = DECR 
the item_list is also compacted

*/
{


		int bound, i, j, last, j_count, next, item;
		if (op_code == INC){
			for (i=limits[0]; i < limits[1]; i++) {
					/* add at end */
				for (last=index_list[i]+ count_list[i], 
					bound = index_list[i+1],
					next = index_to_be_added[i];
					((next != EMPTY) && (last < bound));){
					item = to_be_added[next++];
					next = to_be_added[next];
				   	items_list[last] = item; 
					count_list[i] ++;
					last++;
					} 
					if ((last == bound) && (next != EMPTY))
					exit_err("add_items",case_err);
				if ((i+1) <limits[1]) {
					/*drag*/
					j = index_list[i+1];
					index_list[i+1] = last;
					for ( j_count = count_list[i+1];
					j_count>0; j_count--, last++, j++)
						items_list[last]=items_list[j];
				}
			}/*for*/
		} else {
			for(i=limits[1]-1; i>= limits[0]; i--){
					/*add at begining*/
				for (last=index_list[i], 
					bound = (i==limits[0])? 0: 
						index_list[i-1]+
						 count_list[i-1]-1,
					next = index_to_be_added[i];
					((next != EMPTY) && (last > bound));){
					item = to_be_added[next++];
					next = to_be_added[next];
				   	items_list[last] = item; 
					count_list[i] ++;
					last--;
				} 
				if ((last == bound) && (next != EMPTY))
						exit_err("add_items2",case_err);
				index_list[i] = last+1;
				if ((i-1) >=limits[0]) {
					/*drag*/
					for ( last = index_list[i]-1,
						j = index_list[i-1]+
						count_list[i-1]-1,
						j_count = count_list[i-1];
						j_count >0; j_count--, last--,
								j--)
						items_list[last]=items_list[j];

					index_list[i-1] =j+1; 
				}	
			}
		}

}/*end add_items*/

delete_items_v(	
		deleted_v,
		limits,
		items_list, 
		index_list, count_list)
int		*deleted_v,
		*limits,
		*items_list, 
		*index_list, *count_list;
/*
deletes items from item list
in increasing order of levels, holes
are created at end of each level if op_code = INC 

*/
{

		extern	int *in_graph_ce, *in_graph_v;
		int i, j, j_count, k, a, b, do_it,  last;

		for (i=limits[0]; i < limits[1]; i++) {
				for (j=last=index_list[i], 
					j_count = count_list[i];
					j_count>0; j_count--) {
					k = items_list[j++];
					do_it = deleted_v[k];
					if (do_it ==0)
				   		items_list[last++] = k;
					 else count_list[i] -=1;
				}/*for*/
		}/*for*/

}/*end delete_items_v*/

delete_items_ce1(	
		deleted_v,
		limits,
		items_list, 
		index_list, count_list)
int		*deleted_v,
		*limits,
		*items_list, 
		*index_list, *count_list;
/*
deletes items from item list
in increasing order of levels, holes
are created at end of each level if op_code = INC 

*/
{

		extern	int *in_graph_ce, *in_graph_v;
		int i, j, j_count, k, a, b, do_it,  last, va, vb;

		for (i=limits[0]; i < limits[1]; i++) {
				for (j=last=index_list[i], 
					j_count = count_list[i];
					j_count>0; j_count--) {
					k = items_list[j++];
					do_it =k+k;
					a= row_col[do_it];
					b = row_col[do_it+1];
					do_it=0;
					va= deleted_v[a];
					vb= deleted_v[b];
					if ((a < my_N) && (va ==1))
						do_it =1;
					if ((a < my_N) && (va ==0))
						in_graph_ce[k] = in_graph_v[a];
					if ((b < my_N) && (vb ==1))
						do_it =1;
					if ((b < my_N) && (vb ==0))
						in_graph_ce[k] = in_graph_v[b];
					if (do_it ==0)
				   		items_list[last++] = k;
					else count_list[i] -=1;
				}/*for*/
		}/*for*/

}/*end delete_items_ce*/

delete_items_ce2(	
		deleted_v,
		limits,
		items_list, 
		index_list, count_list,code)
int		*deleted_v,
		*limits,
		*items_list, 
		*index_list, *count_list,code;
/*
deletes items from item list
in increasing order of levels, holes

*/
{

		extern	int *in_graph_ce, *in_graph_v;
		int i, j, j_count, k, a, b, do_it,  last;

		for (i=limits[0]; i < limits[1]; i++) {
				for (j=last=index_list[i], 
					j_count = count_list[i];
					j_count>0; j_count--) {
					k = items_list[j++];
					do_it = k+k;
					a= row_col[do_it];
					b = row_col[do_it+1];
					do_it =0;
					if ((a >=code) || (b>=code))
						do_it=1;
					if (do_it ==0)
				   		items_list[last++] = k;
					 else count_list[i] -=1;
				}/*for*/
		}/*for*/

}/*end delete_items_ce*/
set_up_index(Asubs,M, row_col,a_index)
int	Asubs, M, *row_col, *a_index;
{

		int i,  i_limit, last_row, row;
		for (i=last_row=0, i_limit =2*Asubs; i < i_limit; ){
			a_index[last_row] = i;
			for(row=row_col[i]; (row == last_row); ){
				i+= 2;
				row = row_col[i];
			}
			last_row = row;
		}
		a_index[last_row+1] = i;
}
put_edge_indices (list, count)
int	*list,  count;
{

		int i,j;
		for (i=j=0; count >0; count--, i+=2, j++){
			list[i] = list[i+1]= j;
		}
}
make_a_index( row_col, a_index)
int		*row_col, *a_index;
{
/*

when given a  matrix 
sets pointers to the begiining of each row in row_col

*/

		int i, row,count,  next_row;

		for ( next_row = row_col[0], i=0; i < 2*Asubs ; ) {
			row = next_row;
			a_index[row] = i;
			for (count= -1; ((next_row= row_col[i]) == row); 
				count++) 
				i+=2;
		}
		a_index[row+1] = 2*Asubs;

}/*end_make_a_index*/

free_items() 
{
		int dim;

		for (dim=0; dim <D; dim++) {	
			
			free(((char *)(limits[dim])));
			free(((char *)(limits_int[dim])));
			free(((char *)(global_levels[dim])));
			free(((char *)(limits_v_list[dim])));
			free(((char *)(v_list[dim])));
			free(((char *)(count_v_list[dim])));
			free(((char *)(index_v_list[dim])));
			free(((char *)(limits_ce_list_starts[dim])));
			free(((char *)(ce_list_starts[dim])));
			free(((char *)(index_ce_list_starts[dim])));
			free(((char *)(count_ce_list_starts[dim])));
			free(((char *)(limits_ce_list_ends[dim])));
			free(((char *)(ce_list_ends[dim])));
			free(((char *)(index_ce_list_ends[dim])));
			free(((char *)(count_ce_list_ends[dim])));
		}
}
