/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include	<stdio.h>
#include	"map.h"
grid_main(file_stem,T, P ,  W, H)
char		*file_stem;
int 		T, P, W, H;
{


		int	N, Asubs, count_vtxs[MAX_P], 
			count_edges[MAX_P], *block_labels[MAX_DIMS],
			*map, *map_edges, *edges, *x_int,*y_int;
		float	*x,*y;
		double	*b, *a_nonz;

		N = W*H;
		if ((map= (int *) malloc(((N) * sizeof(int))))
					== NULL) exit_err("map",malloc_err);
		if ((map_edges= (int *) malloc(((10*N) * sizeof(int))))
					== NULL) exit_err("map_edges",
							malloc_err);
		if ((edges= (int *) malloc(((6*N) * sizeof(int))))
					== NULL) exit_err("edges",malloc_err);
		if ((x_int= (int *) malloc(((N) * sizeof(int))))
					== NULL) exit_err("x_int",
						malloc_err);
		if ((y_int= (int *) malloc(((N) * sizeof(int))))
					== NULL) exit_err("y_int",
						malloc_err);
		if ((x= (float *) malloc(((N) * sizeof(float))))
					== NULL) exit_err("x",
						malloc_err);
		if ((y= (float *) malloc(((N) * sizeof(float))))
					== NULL) exit_err("y",
						malloc_err);
		Asubs = do_grid(file_stem, W, H, 
				 P, block_labels, count_vtxs, 
				count_edges, map, map_edges, edges, 
				x_int,y_int, x,y);
		if ((b= (double *) malloc(((N) * sizeof(double))))
					== NULL) exit_err("b",malloc_err);
		if ((a_nonz= (double *) malloc(((Asubs) * sizeof(double))))
					== NULL) exit_err("a_nonz",
						malloc_err);

		make_A_b(N, Asubs, edges, a_nonz,b);
		part_mesh(file_stem, 2, N,Asubs,  P,
			block_labels, count_vtxs, 
			count_edges, map, map_edges, edges, 
			x_int, y_int, NULL, x, y, NULL, a_nonz, b);
}/*grid_main*/

do_grid(file_stem, 	W, 	H, 	P, 
			block_labels,	count_vtxs, 
			count_edges,	map,	map_edges,
			edges, 	x_int,	 y_int, x, y)
char	*file_stem;
int	W,	H, 	 P, 	**block_labels, 
		*count_vtxs,	*count_edges,
		*map,		*map_edges, 	*edges, *x_int, *y_int;
float		*x, 	*y;
{

		int 	max_dim[2], dim, per_proc, proc, 
			rem, next, i, j, N, Asubs, next_in_edges;
		int	next_nonz;

		max_dim[0] = W;
		max_dim[1] = H;
		for (dim=0; dim <2; dim ++){
			per_proc = max_dim[dim] / P; 
			rem = max_dim[dim] %P;
			next =0;	
			if ((block_labels[dim] =
				(int *) malloc(((P+1) * sizeof(int))))
					== NULL) exit_err("block",
					malloc_err);
			for (proc=0; proc < P; proc++) {
				*(block_labels[dim] +proc) = next;		
				next += per_proc;
				if (proc <rem) next++;
			}
			*(block_labels[dim] + proc) = next;
			if ( next != max_dim[dim]) exit_err ();
		}
		for(i=0; i <P; i++)
			count_edges[i] =0;


		for (i=N= Asubs= next_nonz=next_in_edges=0; i <W; i++) {
			for (j=0; j <H; j++) {
				proc=N %P;
				map[N] = proc; x_int[N] =i;
				y_int[N] =j; map_edges[Asubs] = proc;
				count_edges[proc] +=1;
				edges[next_in_edges++] = N;
				edges[next_in_edges++] = N;
				Asubs++;
				if (i< (W-1)) {
					map_edges[Asubs] = proc;
					count_edges[proc] +=1;
					edges[next_in_edges++] = N;
					edges[next_in_edges++] = N+H;
					Asubs++;
				}
				if (j <(H-1)) {
					map_edges[Asubs] = proc;
					count_edges[proc] +=1;
					edges[next_in_edges++] = N;
					edges[next_in_edges++] = N+1;
					Asubs++;
				}
				N++;
			}
		}
						
		for(i=0; i < N; i++) {
			x[i] = (float) x_int[i];
			y[i] = (float) y_int[i];
		}
return (Asubs);
}/*end_do_grid*/
		
