/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include "d_s_fact.h" 
extern		int	merge_and_convert();
d_s_fact	(	local_phase_node)

int			local_phase_node;
{
		
	int	my_side,	nprocs,		
		start_proc,	log_2_p,
	     	tmp_count,	current, 
		start_value,	next;
		

	
	extern	double stats[];
		





	
	arg_int[PARAM2] = &start_value;

	d_s_initialize_spd();
	max_mat_size_in_d_phase =
			factor_struc_sizes[local_phase_node];
	for( next=0, log_2_p=1, current = tree_parent[local_phase_node];
			current != -1;  log_2_p++, next++)
			
	{

		

		nprocs = tree_count_procs[next];
		start_proc = tree_start_procs[next];

		local_structure_spd (current,
				tree_child[current],
				tree_chains,
				chain_index,
				tree_local_column,
				
				index_list);
		
		start_value = tree_chains[chain_index[current]];
		dimensional_exchange	(
				(char *)factor_struc_received,
				&factor_struc_received_size,
				&max_factor_struc_received_size,
				(char *)send_vector,
				&send_vector_size,
				log_2_p,
				LS,
				tree_chains[chain_index[current]],
					/*msg type param*/
				processor_list,
				merge_and_convert,
				arg_int,
				NULL);
				
				
				
					
				
	
		set_up_structure_spd(
				me, 
				my_side,
				current,
				tree_child[current],
				nprocs, start_proc, 
				factor_struc_received,
				&factor_struc_received_size);


		tmp_count	= ((int) ( (double) 
			((chain_index[current+1] - chain_index[current])
					/ nprocs +1)));
		done_factor_columns += tmp_count; 
		
		done_factor_floats += (factor_struc_sizes[current]*tmp_count) -
					tmp_count *(chain_index[current+1]-
							chain_index[current]);
		

		stats[s_d_o] += factor_struc_sizes[current];
		max_mat_size_in_d_phase =
			(factor_struc_sizes[current]
			 > max_mat_size_in_d_phase)?

			(factor_struc_sizes[current])
			: max_mat_size_in_d_phase;
		max_b_size += factor_struc_sizes[tree_child[current]];


		current = tree_parent[current];

	}	



}/*end  d_s_fact*/

d_s_initialize_spd()
{
		int i;

		for (i=0; i <P; i++)
				processor_list[i] = i;
		if (( factor_struc_received  = (int *) 
				malloc((20*N*(sizeof(int))))) == NULL)
				exit_err(
				"Error allocating fact_struc_received",
					malloc_err);
		if (( send_vector  = (int *) 
				malloc((20*N*(sizeof(int))))) == NULL)
				exit_err(
					"Error allocating send_vector",
					malloc_err);
		max_factor_struc_received_size = max_send_vector_size = 20*N;




}
 


