####################################
package RIB::Object;

use strict;
use RIB::Util;
use RIB::Parser;
use XML::DOM;

sub new {
  my $proto = shift;
  my $class = ref($proto) || $proto;
  my $self  = {
    'DBH' => shift,
    'REPO_HANDLE' => shift,
    'CLASS' => shift,
    'OBJECT_HANDLE' => shift,
    'REPO_PASSWD' => shift
  };
  bless ($self, $class);
  die "DB Handle not supplied" unless $self->{'DBH'};
  die "Repo Handle not supplied" unless $self->{'REPO_HANDLE'};
  die "Object class not supplied" unless $self->{'CLASS'};
  die "Object Handle not supplied" unless $self->{'OBJECT_HANDLE'};
  return $self;
}

sub asHTML {
  my $self = shift;
  my $dbh = $self->{'DBH'};
  my $repo_handle = $self->{'REPO_HANDLE'};
  my $object_handle = $self->{'OBJECT_HANDLE'};
  my $class_name = $self->{'CLASS'};

  my $util = new RIB::Util();
  my $rp = new RIB::Parser;
  my $ribdir = $util->RibDir;
  my $riburl = $util->RibUrl;

  # get main rib password
  my $sth = $dbh->prepare("SELECT password FROM admin");
  eval { $sth->execute(); };
  if ($@) { $util->error($@); }
  my $main_password = $sth->fetchrow_array();

  # find out if objects require approval
  $sth = $dbh->prepare("SELECT object_approval_required,password,contact FROM "
                        . "repositories WHERE handle=$repo_handle");
  eval { $sth->execute(); };
  if ($@) { $util->error($@); }
  return "Error: invalid repository handle" unless $sth->rows();
  my ($object_approval_required,$repoPasswd,$contact) = $sth->fetchrow_array();
  if (defined $self->{'REPO_PASSWD'}) {
    if ($repoPasswd eq $self->{'REPO_PASSWD'} or
        $main_password eq $self->{'REPO_PASSWD'}) {
        $object_approval_required = 0;
    }
  }

  # parse repository configuration file
  unless ($rp->parse_config_file("$ribdir/docRoot/$repo_handle/config.xml")) {
    $util->error("Couldn't parse repository configuration");
  }
  my $class = $rp->getClass($class_name);
  unless ($class) {
    $util->error("Invalid class name : $class_name");
  }

  if ($object_approval_required) {
    $sth = $dbh->prepare("SELECT * FROM ${repo_handle}_${class_name} WHERE (handle=$object_handle AND approved=1) OR extends=$object_handle");
  } else {
    $sth = $dbh->prepare("SELECT * FROM ${repo_handle}_${class_name} WHERE handle=$object_handle OR extends=$object_handle");
  }
  eval { $sth->execute(); };
  if ($@) { $util->error($@); }

  if ($sth->rows == 0) {
    return "<HTML><HEAD><TITLE>Not found"
         . "</TITLE></HEAD><BODY BGCOLOR=\"#FFFFFF\"><H1>Object not "
         . "found</H1>\nThe requested object was not found.</BODY></HTML>";
  }

  my %vals = ();
  my $object_is_approved = 0;
	my $file;
  while (my $row = $sth->fetchrow_hashref) {
    if ($object_approval_required) {
      if ($row->{'handle'} ne '') {
        $object_is_approved = 1; # select only matched if approved=1
      }
    }
		$file=$row->{file};
    foreach my $col (keys %{$row}) {
      next unless my $val = $row->{$col};
      next if $val =~ /^\s*$/;
      next unless chop($col) eq '_';
      $col =~ s/_/./;
      next if $class->get_display($col) eq 'noshow' and $col ne 'Name';
      push (@{$vals{$col}},$val);
    }
  }
  if ($object_approval_required) {
    if (!($object_is_approved)) {
      die("Object approval required");
    }
  }

  my $html = "<HTML><HEAD><TITLE>"
           . $vals{"Name"}->[0]
           . "</TITLE></HEAD><BODY BGCOLOR=\"#FFFFFF\"><H1>"
           . $vals{"Name"}->[0]
           . "</H1><P>";
	if($file ne "") {
		$html .= "<FORM method='get' action='$riburl/$repo_handle/files/$file'>"
		       . "<INPUT type='submit' value='Download'>"
		       . "</FORM><P><HR><DL>";
	}
  foreach my $key (sort keys %vals) {
    if ($class->is_relationship($key)) {
      my $relationship = $class->get_relationship($key);
      next if $relationship->display() eq "noshow";
      $html .= "<DT><STRONG>" . $relationship->alt . "</STRONG>";
      foreach my $val (@{$vals{$key}}) {
        my $display = "<I>external information</I>";
        if ($val =~ m,$riburl/object.pl\?.*rh=$repo_handle,) {
          eval {
            $val =~ /\?.*class=(\w+)/;
            my $class = $1;
            $val =~ /\?.*oh=(\d+)/;
            my $oh = $1;
            my $sth2 = $dbh->prepare("SELECT Name_ FROM $repo_handle\_$class "
                                   . "WHERE handle=$oh");
            $sth2->execute();
            if ($sth2->rows) {
              $display = $sth2->fetchrow_arrayref->[0];
            } else { # destination object was deleted. usually shouldn't happen
              $display = "";  
            }
          };
          if ($@) { print STDERR $@; next; }
        }
        if ($val =~ m,/object.pl\?,) {
          $val .= "&html=1";
        }
        if ($display eq "") {
          $html .= "<DD><I>Stale reference</I>";
        } else {
          $html .= "<DD><A HREF=\"$val\">$display</A>";
        }
      }
      #$html .= "</UL>";
    }

    else {
      my $attribute = $class->get_attribute($key);
      next if $attribute->display() eq "noshow";
      $html .= "<DT><STRONG>" . $attribute->alt . "</STRONG>";
      foreach my $val (@{$vals{$key}}) {
        if ($attribute->vocabulary()) {
          my @parts = split(/!/,$val);
          foreach my $part (@parts)  {
            $html .= "<DD>$part<DL>";
          }
          foreach (0 .. $#parts) {
            $html .= "</DL>";
          }
        } elsif($attribute->dtype() eq 'url') {
          $html .= "<DD><A HREF=\"$val\">$val</A>";
        } elsif($attribute->dtype() eq 'email') {
          $html .= "<DD><A HREF=\"mailto:$val\">$val</A>";
        } else {
          $html .= "<DD>$val";
        }
      }
    }

  }
  $html .= "</DL></BODY></HTML>";
  return $html;
}

sub asXML {
  my $self = shift;
  my $dbh = $self->{'DBH'};
  my $repo_handle = $self->{'REPO_HANDLE'};
  my $object_handle = $self->{'OBJECT_HANDLE'};
  my $class_name = $self->{'CLASS'};

  my $util = new RIB::Util();
  my $rp = new RIB::Parser;
  my $ribdir = $util->RibDir;
  my $riburl = $util->RibUrl;
  my $ribversion = $util->RibVersion();

  # parse repository configuration file
  unless ($rp->parse_config_file("$ribdir/docRoot/$repo_handle/config.xml")) {
    $util->error("Couldn't parse repository configuration");
  }

  my $class = $rp->getClass($class_name);

  # get main rib password
  my $sth = $dbh->prepare("SELECT password FROM admin");
  eval { $sth->execute(); };
  if ($@) { $util->error($@); }
  my $main_password = $sth->fetchrow_array();

  # get info about this repository
  $sth = $dbh->prepare("SELECT name,contact,object_approval_required,password "
                     . "FROM repositories WHERE handle=$repo_handle");
  eval { $sth->execute(); };
  if ($@) { $util->error($@); }
  my ($repo_name,$repo_contact,$object_approval_required,$repoPasswd) 
      = $sth->fetchrow_array();
  if (defined($self->{'REPO_PASSWD'})) {
     if ($repoPasswd eq $self->{'REPO_PASSWD'}
         or $main_password eq $self->{'REPO_PASSWD'}) {
      $object_approval_required = 0;
     }
  }

  if ($object_approval_required) {
    $sth = $dbh->prepare("SELECT * FROM ${repo_handle}_${class_name} WHERE (handle=$object_handle AND approved=1) OR extends=$object_handle");
  } else {
    $sth = $dbh->prepare("SELECT * FROM ${repo_handle}_${class_name} WHERE handle=$object_handle OR extends=$object_handle");
  }
  eval { $sth->execute(); };
  if ($@) { $util->error($@); }

  my $document = new XML::DOM::Document();
  my $xml_decl = new XML::DOM::XMLDecl();
  $xml_decl->setVersion('1.0');
  $xml_decl->setStandalone('yes');
  $document->setXMLDecl($xml_decl);
  my $rib_element = $document->createElement('rib');
  $rib_element->setAttribute('version',$ribversion);
  $document->appendChild($rib_element);
  my $repo_element = $document->createElement('repository');
  $repo_element->setAttribute('name',$repo_name);
  $repo_element->setAttribute('config',"$riburl/$repo_handle/config.xml");
  $rib_element->appendChild($repo_element);
  my $class_element = $document->createElement('class');
  $class_element->setAttribute('name',$class_name);
  $repo_element->appendChild($class_element);
  my $object_element = $document->createElement('object');
  #$object_element->setAttribute('name',$class_name);
  $class_element->appendChild($object_element);

  my $object_is_approved = 0;
  while (my $row = $sth->fetchrow_hashref()) {
    if ($object_approval_required) {
      if ($row->{'handle'} ne '') {
        $object_is_approved = 1; # select only matched if approved=1
      }
    }
    foreach my $col (keys %{$row}) {
      next unless $row->{$col};
      next if $row->{$col} =~ /^\s*$/;
      my $config_name = $col;
      next unless chop($config_name) eq '_';
      $config_name =~ s/_/\./;
      my $element;
      if ($class->is_attribute($config_name)) {
        $element = $document->createElement('attribute');
      } else {
        $element = $document->createElement('relationship');
      }
	    $element->setAttribute('name',$config_name);
      $element->appendChild($document->createTextNode($row->{$col}));
      $object_element->appendChild($element);
    }
		my $file_element=$document->createElement('file');
		$file_element->setAttribute('name',$row->{file});
		$file_element->appendChild($document->createTextNode("$riburl/$repo_handle/files/$row->{file}"));
		$object_element->appendChild($file_element);
  }
  
  if ($object_approval_required) {
    if (!($object_is_approved)) {
      die("Object approval required");
    }
  }
  return $document->toString();

}

1;
