#BANGLINE
#search_rib.pl
# This script is the most current as of 07/19/01

use RIB::Util;
use diagnostics;
use strict;
use Time::Local;
use Socket;
use File::ReadBackwards;
use POSIX;
use Date::Calc qw(Add_Delta_Days Today Day_of_Week_Abbreviation Day_of_Week Add_Delta_YMD Decode_Month Delta_Days);

use CGI '-autoload';               # OO call to CGI, saves mem, better
use CGI::Carp qw(fatalsToBrowser); # errors to browser
$CGI::POST_MAX=1024 * 1;           # max 1K posts
$CGI::DISABLE_UPLOADS = 1;         # no uploads
my $q = new CGI; 
 
my $start_time = timelocal(localtime);

my $accesslog = "RIBDIR/lib/apache/logs/access_log"; # path to apache log
 
my $rib_present = 1;

my $program_name = '';
my $url = $q->url;
my $url_help = $url;
my $regex = '^(\S+) \S+ \S+ \[(.+) -\S+\] \"\S+ (.+?) \S+\"';
my(@paths) = split /\//, $0;
$program_name = $paths[$#paths];

$url_help =~ s/$paths[$#paths]$//;
$url_help =~ s/\/$//; 

$|++;
my @col_head        = ();
my @rows            = ();
my @entries         = ();
my @limited_array   = ();
my %byip            = ();
my %byfile          = ();
my %hitbydate       = ();
my %visitorbyday    = ();
my %visitorbydate   = ();
my %filesbyday      = ();
my %filebyday       = ();
my %visitorsbyfile  = ();
my %visitorbyfile   = ();
my %hitbymonth      = ();
my %visitorbymonth  = ();
my %visitorbymon    = ();
my %filesbymonth    = ();
my %filesbymon      = ();
my %hitbyyear       = ();
my %visitorbyyear   = ();
my %visitorbyyr     = ();
my %filesbyyear     = ();
my %filesbyyr       = ();
my %rh              = ();
my %oh              = ();
my %rh_requests     = ();
my %rh_visitors     = ();
my %rh_visitor      = ();
my %filesbyrhandle  = ();
my %filesbyrh       = ();
my %byquery         = ();
my %visitorsbyquery = ();
my %first_visit     = ();
my %last_visit      = ();
my %rh_oh_requests  = ();
my %rh_oh_visitors  = ();
my %rh_oh_class     = ();
my %rh_oh_classes   = ();
my $row_cnt         =  0;
my $ttl_rows        =  0;

my %hits_by_date     = ();
my %visitors_by_date = ();
my %files_by_date    = ();
my %visitor_by_date  = ();
my %file_by_date     = ();

my $rh          = $q->param('rh')          || ""; 
my $findrequest = $q->param('request')     || "";
my $includehost = $q->param('includehost') || "";
my $excludehost = $q->param('excludehost') || "";
my $startdate   = $q->param('startdate')   || "";
my $enddate     = $q->param('enddate')     || "";

###  CALL RIB SEE WHOS THERE GRAB THEIR HANDLE  ###

if ($rib_present) {
  my $util = new RIB::Util();
  $util->dbConnect();
  my $sth = $util->dbh->prepare("SELECT name, handle FROM repositories");
  eval { $sth->execute(); };
  if ($@) { $util->error($@); }
  while (my $row = $sth->fetchrow_hashref()) {
  	$rh{$row->{handle}} = $row->{name};
  }
  foreach my $rh (keys %rh) {
  	my $asset = $rh."_Asset";
    my $sth = $util->dbh->prepare("SELECT Name_, handle FROM $asset");
    eval { $sth->execute(); };
    if ($@) { $util->error($@); }
    while (my $row = $sth->fetchrow_hashref()) {
    	$oh{$row->{handle}}{$rh} = $row->{Name_} if $row->{Name_} and $row->{handle};
    }
  }
  $util->{dbh} && $util->{dbh}->disconnect();
}  

###  WRITE SEARCH STATS FORM  ###
my($first_day, $first_month, $first_year);
my($last_day, $last_month, $last_year);
open (LOG,$accesslog) or die "Can't open $accesslog for reading: $!\n";
while (<LOG>) {
	my($host, $timestamp, $request) = m#$regex#;
  next if (!($host && $timestamp && $request));
  my($date, $time) = split /:/, $timestamp, 2;
  ($first_day, $first_month, $first_year) = split /\//, $date, 3;
  $first_month = Decode_Month($first_month);
  last;
}
close LOG;
my $bw = File::ReadBackwards->new( $accesslog ) or die "Can't read $accesslog: $!";
while( defined( my $log_line = $bw->readline ) ) {
  my($host, $timestamp, $request) = ($log_line =~ m#$regex#);
  next if (!($host && $timestamp && $request)); 
  my($date, $time) = split /:/, $timestamp, 2;
  ($last_day, $last_month, $last_year) = split /\//, $date, 3;
  $last_month = Decode_Month($last_month);
  last;
}
my $total_days = Delta_Days($first_year,$first_month,$first_day,$last_year,$last_month,$last_day);


my @js_days  = (1);
if ($total_days > 30) {
	push @js_days, 7,30;
} elsif ($total_days > 7) {
	push @js_days, 7;
}
my $last_i = 0;
for(my $i = 90; $i <= $total_days;$i=$i+90) {
	push @js_days, $i;
	$last_i = $i;
}
push @js_days, $total_days unless $total_days == $last_i;
my $js_days = join ',', @js_days;
my $total_months;
my @js_months = ();
($total_days > 30)?($total_months = ceil($total_days/30)):($total_months = 1);
($total_months > 1)?(push @js_months, 1,2):(push @js_months, 1);

for(my $i = 3; $i <= $total_months;$i=$i+3) {
	push @js_months, $i;
}
push @js_months, $total_months;
my $js_months = join ',', @js_months;
my $total_years;
my @js_years = ();
($total_days > 365)?($total_years = ceil($total_days/365)):($total_years = 1);
for(my $i = 1; $i <= $total_years;$i++) {
	push @js_years, $i;
}
my $js_years = join ',', @js_years;

if($ENV{'REQUEST_METHOD'} eq 'GET') {
	
###  WRITING WEB FORM  ###
	
	print $q->header;
	my $JSCRIPT=<<END;
	  
	  function changeSelect(form) {
	    var myFixed  = [1,10,25,50,100,250,500,1000,'All'];
	  	var myDays   = [$js_days];
	  	var myMonths = [$js_months];
	  	var myYears  = [$js_years];
	  	with (document.forms[0].numreturn) {
		    for(i=options.length-1;i>=0;i--) options[i] = null;
		    if (form.reports.selectedIndex==2) {
		      for(i=0;i<myDays.length;i++)
			      options[i] = new Option(myDays[i]); 
		    } else if (form.reports.selectedIndex==3) {
		      for(i=0;i<myMonths.length;i++)
			      options[i] = new Option(myMonths[i]); 
		    } else if (form.reports.selectedIndex==4) {
		      for(i=0;i<myYears.length;i++)
			      options[i] = new Option(myYears[i]); 
		    } else {
		      for(i=0;i<myFixed.length;i++)
		        (myFixed[i]=='All')?(options[i] = new Option('All',0)):(options[i] = new Option(myFixed[i]));
			      
		    }
		    //options[0].selected = true;
		  }
	  }
    function myreadOnly (form) {
    	 if (form.reports.selectedIndex == 9) {
        form.orderby[0].disabled = false;
        form.orderby[0].checked  = true;
	      form.orderby[1].disabled = false;
        form.orderby[2].disabled = false;
      } else if (form.reports.selectedIndex > 4 || form.reports.selectedIndex < 2) {
        form.orderby[0].checked = false;
        form.orderby[1].checked = false;
        form.orderby[2].checked = false;
	      form.orderby[0].disabled = true;
	      form.orderby[1].disabled = true;
	      form.orderby[2].disabled = true;
      } else if (form.reports.selectedIndex > 1 || form.reports.selectedIndex < 4) {
        form.orderby[0].disabled = false;
        form.orderby[0].checked = true;
        form.orderby[1].disabled = true;
        form.orderby[2].disabled = true;
      } else {
        form.orderby[0].disabled = false;
        form.orderby[1].disabled = false;
        form.orderby[2].disabled = false;
        form.orderby[0].checked = true;
        form.orderby[1].checked = false;
        form.orderby[2].checked = false;
      }
    }
    function deSelect(form) {
      if (form.reports.selectedIndex > 1) {
      	form.orderby[0].blur();
      	form.orderby[1].blur();
      	form.orderby[2].blur();
        alert("When selecting the above report\\nthe Order By selections have no effect.");
        form.reports.options[0].selected = true;
        form.orderby[0].checked = false;
        form.orderby[1].checked = false;
        form.orderby[2].checked = false;
	      form.orderby[0].disabled = true;
	      form.orderby[1].disabled = true;
	      form.orderby[2].disabled = true;
	      form.reports.focus();
        
      }
    }
END

	print $q->start_html(-title=>'RIB Access Log Reports',-bgcolor=>'WHITE',-script=>"$JSCRIPT",-onload=>"myreadOnly(document.forms[0]);"),
	      $q->h3({-align=>'CENTER'},'RIB Access Log Reports'),
	      $q->startform,
	      "<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=4 ALIGN=CENTER BORDERCOLOR=BLACK>";
	        
	if (%rh) {
    print  "<TR><TH ALIGN=RIGHT>Repositories:</TH><TD COLSPAN=2><SELECT NAME=rh><OPTION VALUE=0>All</OPTION>\n";
    my @rh = reverseSortHashByCharValue(%rh);
    foreach (@rh) {
  	  print "<OPTION VALUE=$_>$rh{$_}</OPTION>\n";
  	}
  	print "</SELECT></TH></TR>\n";
	}     
	print $q->Tr([
	        $q->th({-align=>'RIGHT'},'Reports: ').$q->th({-align=>'LEFT',-colspan=>'2'},$q->popup_menu(-onChange=>'myreadOnly(this.form);changeSelect(this.form);',-name=>'reports',-value=>['Repositories','Object Classes by Repository','Requests by Day','Requests by Month','Requests by Year','Files Requested','Queries',"Visitor's","Resolve IP's",'Date/Request/Host'])),
	        $q->th({-align=>'RIGHT'},'Records to return: ').$q->th({-align=>'LEFT',-colspan=>'2'},$q->popup_menu(-name=>'numreturn',-value=>['1','10','25','50','100','250','500','1000','0'],-labels=>{0=>'All'})),
	        $q->th({-align=>'RIGHT'},'Order by: ').$q->th({-align=>'LEFT',-colspan=>'2'},$q->radio_group(-onFocus=>'deSelect(this.form);',-name=>'orderby',-value=>['date','request','host'])),
	        $q->th({-align=>'RIGHT'},'Sort report: ').$q->th({-align=>'LEFT',-colspan=>'2'},$q->radio_group(-name=>'sortby',-value=>['descending','ascending'])),
	        $q->th({-colspan=>'3'},$q->submit(-value=>'Search',-style=>'cursor:hand;color:blue'), $q->reset(-style=>'cursor:hand;color:red',-title=>' Reset '))]);
  print "</TABLE>",$q->endform,$q->end_html;
 
###  END WRITING FORM  ### 
 
} else {
	
###  PROCESS RESULTS AND RETURN   ### 
 
  my %paramsUsed = ();
  my %paramNames = (
    'orderby'    => 'Order report by:',
    'sortby'     => 'Sort report by:',
    'numreturn'  => 'Records to return:',
    'reports'    => 'Report selected:',
    'rh'         => 'Repository selected:',
  );
	
	print $q->header,$q->start_html(-title=>'RIB Access Log Report',-bgcolor=>'WHITE'),
	      $q->h3({-align=>'CENTER'},'RIB Access Log Report');
	         
	foreach ($q->param) {
		next unless $q->param($_);
		$paramsUsed{ $paramNames{$_} } = $q->param($_);
  }
  
  print $q->h3({-align=>'CENTER'},'Search Parameters'),"<TABLE ALIGN=CENTER>\n" if %paramsUsed;
  foreach ('Repository selected:','Report selected:','Order report by:','Sort report by:','Records to return:') {
  	print $q->Tr([$q->th({-align=>'RIGHT'},$_).$q->td('All')]) if (/Repository selected:/ and $paramsUsed{$_} == 0);
    next unless $paramsUsed{$_};
    my $rh_link = $q->a({-href=>"$url_help/catalog.pl?rh=$paramsUsed{$_}"}," $rh{ $paramsUsed{$_} }") if exists $rh{ $paramsUsed{$_} };
    $rh_link ||= $paramsUsed{$_};
    print $q->Tr([$q->th({-align=>'RIGHT'},$_).$q->td("$rh_link")]) if /Repository selected:/;
    print $q->Tr([$q->th({-align=>'RIGHT'},$_).$q->td($paramsUsed{$_})]) unless /Repository selected:/;
  }
  print "</TABLE><BR>" if %paramsUsed;
  
  if ($q->param('numreturn') and ($q->param('reports') eq 'Requests by Day' or $q->param('reports') eq 'Requests by Month' or $q->param('reports') eq 'Requests by Year' or $q->param('reports') eq 'Date/Request/Host')) {
  	
  	my($end_year,$end_month,$end_day,$end_date) = '';
 	  if ($q->param('reports') eq 'Requests by Day' or $q->param('reports') eq 'Requests by Month' or $q->param('reports') eq 'Requests by Year') {
 	  	my($today_year,$today_month,$today_day) = Today();
 	  	($end_year,$end_month,$end_day) = Add_Delta_Days(Today(),-$q->param('numreturn')) if ($q->param('reports') eq 'Requests by Day');
      ($end_year,$end_month,$end_day) = Add_Delta_YMD($today_year,$today_month,1,0,-$q->param('numreturn')+1,0) if ($q->param('reports') eq 'Requests by Month');
      ($end_year,$end_month,$end_day) = Add_Delta_YMD($today_year,1,1,-$q->param('numreturn')+1,0,0) if ($q->param('reports') eq 'Requests by Year');
      $end_month = "0".$end_month if length($end_month) < 2;
      $end_day = "0".$end_day if length($end_day) < 2;
      $end_date = join '/', $end_year,$end_month,$end_day;
 	  }
 	  
 	  my $bw = File::ReadBackwards->new( $accesslog ) or die "Can't read $accesslog: $!";
    while( defined( my $log_line = $bw->readline ) ) {
      last if ($q->param('numreturn') && $ttl_rows >= $q->param('numreturn'));
      my($host, $timestamp, $request) = ($log_line =~ m#$regex#);
      next if (!($host && $timestamp && $request)); 
      next unless $request =~ /\.pl|\.htm|\.gif|\.xml/;
      next if $q->param('rh') && $request !~ /rh=$rh/;
      my($date, $time) = split /:/, $timestamp, 2;
      my($day, $month, $year) = split /\//, $date, 3;
      (Decode_Month($month) < 10)?($month = "0".Decode_Month($month)):($month = Decode_Month($month));
      $date = join "/", $year, $month, $day;
      $timestamp = join "-", $date, $time;
 	   
 	    $entries[$ttl_rows++] = "$timestamp\t$request\t$host" if !$q->param('reports') or $q->param('reports') eq 'Date/Request/Host';
      
      if ($q->param('reports') eq 'Requests by Day' or $q->param('reports') eq 'Requests by Month' or $q->param('reports') eq 'Requests by Year') {
      	last if $date le $end_date and $q->param('reports')  eq 'Requests by Day';
      	last if $date lt $end_date and ($q->param('reports') eq 'Requests by Month' or $q->param('reports') eq 'Requests by Year');
        $hits_by_date{$date}++                    if $q->param('reports') eq 'Requests by Day';
        $hits_by_date{"$year/$month"}++           if $q->param('reports') eq 'Requests by Month';
        $hits_by_date{$year}++                    if $q->param('reports') eq 'Requests by Year';
    	  $visitors_by_date{"$host $date"}++        if $q->param('reports') eq 'Requests by Day';
    	  $visitors_by_date{"$host $year/$month"}++ if $q->param('reports') eq 'Requests by Month';
    	  $visitors_by_date{"$host $year"}++        if $q->param('reports') eq 'Requests by Year';
    	  my($file) = (split /\?/,$request,2)[0];
    	  $files_by_date{"$file $date"}++           if $q->param('reports') eq 'Requests by Day';
    	  $files_by_date{"$file $year/$month"}++    if $q->param('reports') eq 'Requests by Month';
    	  $files_by_date{"$file $year"}++           if $q->param('reports') eq 'Requests by Year';
      }
      
    }

  } else {
	      
	  open (LOG,$accesslog) or die "Can't open $accesslog for reading: $!\n";
	  while (<LOG>) {
  	  my($host, $timestamp, $request) = m#$regex#;
      next if (!($host && $timestamp && $request)); 
      next unless $request =~ /\.pl|\.htm|\.gif|\.xml/;
      next if $q->param('rh') && $request !~ /rh=$rh/;
      my($date, $time) = split /:/, $timestamp, 2;
      my($day, $month, $year) = split /\//, $date, 3;
      $month =~ s/^\s+|\s+$//g;
      (Decode_Month($month) < 10)?($month = "0".Decode_Month($month)):($month = Decode_Month($month));
      $date = join "/", $year, $month, $day;
      $timestamp = join "-", $date, $time;
    
      if (!$q->param('reports') or $q->param('reports') eq 'Date/Request/Host' and !$q->param('numreturn')) {
    	  $entries[$ttl_rows++] = "$timestamp\t$request\t$host";
      }
      
      if ($q->param('reports') eq 'Requests by Day' or $q->param('reports') eq 'Requests by Month' or $q->param('reports') eq 'Requests by Year') {
    	  $hits_by_date{$date}++                    if $q->param('reports') eq 'Requests by Day';
        $hits_by_date{"$year/$month"}++           if $q->param('reports') eq 'Requests by Month';
        $hits_by_date{$year}++                    if $q->param('reports') eq 'Requests by Year';
        $visitors_by_date{"$host $date"}++        if $q->param('reports') eq 'Requests by Day';
    	  $visitors_by_date{"$host $year/$month"}++ if $q->param('reports') eq 'Requests by Month';
    	  $visitors_by_date{"$host $year"}++        if $q->param('reports') eq 'Requests by Year';
    	  my($file) = (split /\?/,$request,2)[0];
    	  $files_by_date{"$file $date"}++           if $q->param('reports') eq 'Requests by Day';
    	  $files_by_date{"$file $year/$month"}++    if $q->param('reports') eq 'Requests by Month';
    	  $files_by_date{"$file $year"}++           if $q->param('reports') eq 'Requests by Year';
      }
      
    if ($q->param('reports') eq 'Repositories') {
    	(my $rhandle) = ($request =~ /rh=(\d+)/);
    	next unless $rhandle;
    	$rh_requests{"$rhandle"}++;
    	$rh_visitors{"$host $rhandle"}++;
    	my($file) = (split /\?/,$request,2)[0];
    	$filesbyrhandle{"$file $rhandle"}++;
    	$first_visit{$rhandle} = $date unless $first_visit{$rhandle};
    	$last_visit{$rhandle}  = $date;
    }
    if ($q->param('reports') eq 'Object Classes by Repository') {
    	(my $rhandle) = ($request =~ /rh=(\d+)/);
    	next unless $rhandle;
    	(my $ohandle) = ($request =~ /oh=(\d+)/);
    	next unless $ohandle;
    	(my $class)   = ($request =~ /class=(\w+)/);
    	next unless $class;
    	$rh_oh_requests{$rhandle}{$ohandle}{$class}++;
    	$rh_oh_visitors{$rhandle}{$ohandle}{$class}{$host} = 1;   	
    	$first_visit{$rhandle}{$ohandle}{$class} = $date unless $first_visit{$rhandle}{$ohandle}{$class};
    	$last_visit{$rhandle}{$ohandle}{$class}  = $date;
    }
    if ($q->param('reports') eq "Visitor's" or $q->param('reports') eq "Resolve IP's") {
    	$byip{$host}++;
    	my($file) = (split /\?/,$request,2)[0];
    	$visitorsbyfile{"$host $file"}++;
    	$first_visit{$host} = $date unless $first_visit{$host};
    	$last_visit{$host}  = $date;
    }
    if ($q->param('reports') eq 'Files Requested') {
    	my($file) = (split /\?/,$request,2)[0];
    	$byfile{$file}++;
    	$visitorsbyfile{"$host $file"}++;
    	$first_visit{$file} = $date unless $first_visit{$file};
    	$last_visit{$file}  = $date;
    }
    if ($q->param('reports') eq 'Queries') {
    	if ($request =~ /\?/) {
    	  $byquery{$request}++;
    	  $visitorsbyquery{"$host $request"}++;
    	  $first_visit{$request} = $date unless $first_visit{$request};
    	  $last_visit{$request}  = $date;
    	}
    }
  }
 }
}

###  NO REPORT REQUESTED  ###  ###  NO REPORT REQUESTED  ###  ###  NO REPORT REQUESTED  ###

if (!$q->param('reports') or $q->param('reports') eq 'Date/Request/Host') {
	
	my $entry_count = 0;
	my $color_cnt   = 0;
	my $i           = 0;
  my $color       ='';
  my($timestamp,$request,$host) = '';
  @col_head = $q->th(['Count','Date','Request','Host']);
	foreach (@entries) {
    last                                      if $q->param('orderby') eq 'date'; 
    $entries[$i++] = join ' ', (split)[1,0,2] if $q->param('orderby') eq 'request';
    $entries[$i++] = join ' ', (split)[2,0,1] if $q->param('orderby') eq 'host';
  }
  ($q->param('sortby') eq 'ascending')?(@entries = sort @entries):(@entries = reverse sort @entries);
  foreach (@entries) {
    ($color_cnt%2 == 0)?($color = '#EEEEEE'):($color = 'WHITE');
    ($timestamp,$request,$host) = split /\s+/,$_ if $q->param('orderby') eq 'date';
    ($request,$timestamp,$host) = split if $q->param('orderby') eq 'request';
    ($host,$timestamp,$request) = split if $q->param('orderby') eq 'host';
    push(@rows,$q->Tr({-BGCOLOR=>$color},$q->td({-ALIGN=>'RIGHT'},++$entry_count).$q->td([$timestamp,$q->a({-href=>$request},$request),$host])));
    $color_cnt++;    
  }
} 
	
###  REQUESTS BY DAY  ###  ###  REQUESTS BY MONTH  ###  ###  REQUESTS BY YEAR  ###

if ($q->param('reports') and ($q->param('reports') eq 'Requests by Day' or $q->param('reports') eq 'Requests by Month' or $q->param('reports') eq 'Requests by Year')) {	
	
  my %host_cnt      =();
	my %file_cnt      =();
	my $ttl_hitbydate = 0;
	my $color_cnt     = 0;
  my $color         ='';
  my $date          ='';
  my @hits_by_date  =();
       
  foreach (keys %visitors_by_date) {
	  my($host, $thisdate) = split /\s+/, $_, 2;
	  $visitor_by_date{$thisdate}++;
	  $host_cnt{$host} = 1;
	}
  foreach (keys %files_by_date) {
	  my($file, $thisdate) = split /\s+/, $_, 2;
	  $file_by_date{$thisdate}++;
	  $file_cnt{$file} = 1;
  }
  my $ttl_file = scalar keys %file_cnt;
  my $ttl_host = scalar keys %host_cnt;
	($q->param('sortby') eq 'ascending')?(@hits_by_date =  sort keys %hits_by_date):(@hits_by_date = reverse sort keys %hits_by_date);
	    
	  foreach (@hits_by_date) {
    
      ($color_cnt%2 == 0)?($color = '#EEEEEE'):($color = 'WHITE');
    	my $requests  = $hits_by_date{$_};
    	my $visitors  = $visitor_by_date{$_};
      my $files     = $file_by_date{$_};
         $files     =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($files)    > 3;
    		 $visitors  =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($visitors) > 3;
    	   $requests  =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($requests) > 3;
     ($q->param('reports') eq 'Requests by Day')?($date = join '-', $_, Day_of_Week_Abbreviation(Day_of_Week( split /\// ))):($date = $_);
     push(@rows,$q->Tr({-BGCOLOR=>$color},$q->td($date).$q->td({-align=>'RIGHT'},["$files","$visitors","$requests"])));
     $ttl_hitbydate += $hits_by_date{$_};
     $color_cnt++;
    }
     ($color_cnt%2 == 0)?($color = '#EEEEEE'):($color = 'WHITE');
     $ttl_file      =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($ttl_file)      > 3;
     $ttl_host      =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($ttl_host)      > 3;
     $ttl_hitbydate =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($ttl_hitbydate) > 3;
     push(@rows,$q->Tr({-BGCOLOR=>"$color"},$q->td('Total').$q->td({-align=>'RIGHT'},["$ttl_file","$ttl_host","$ttl_hitbydate"])));
     @col_head = $q->th({-width=>'25%'},['Date','Files','Visitors','Requests']);
     $ttl_rows = scalar keys %hits_by_date;
     goto TABLETIME;
}

###  END REQUESTS BY DAY  ###  ###  END REQUESTS BY MONTH  ###  ###  END REQUESTS BY YEAR  ###

###  RH REQUESTS  ###  ###  RH REQUESTS  ###  ###  RH REQUESTS  ###

if ($q->param('reports') and $q->param('reports') eq 'Repositories') {
	
	my %limited_hash = ();
	my %host_cnt     = ();
	my $ttl_requests =  0;
	my $color_cnt    =  0;
	my $very_first;
  my $very_last;
  my $color;
	
  ###  begin handy dandy little block  ###
	my $entry_count  = 0;
	my %file_cnt     = ();
	my @rh_requests = sortHashByValue(%rh_requests);
	splice @rh_requests, $q->param('numreturn') if $q->param('numreturn');
	foreach (@rh_requests) {
	  $limited_hash{$_} = $rh_requests{$_};
	  $very_first = $first_visit{$_} unless $very_first;
	  $very_first = $first_visit{$_} if $first_visit{$_} lt $very_first;
	  $very_last  = $last_visit{$_}  if $last_visit{$_}  gt $very_last;
	}
	foreach (keys %rh_visitors) {
	  my($host, $rh) = split /\s+/, $_, 2;
	  if ($limited_hash{$rh}) {
	    $rh_visitor{$rh}++;
	    $host_cnt{$host} = 1;
	  }
  }
  foreach (keys %filesbyrhandle) {
	  my($file, $rh) = split /\s+/, $_, 2;
	  if ($limited_hash{$rh}) {
	    $filesbyrh{$rh}++;
	    $file_cnt{$file} = 1;
	  }
  }
  my $ttl_file = scalar keys %file_cnt;
  my $ttl_host = scalar keys %host_cnt;
	###  end handy dandy little block  ###
	
	($q->param('sortby') eq 'ascending')?(@rh_requests = reverseSortHashByValue(%limited_hash)):(@rh_requests = sortHashByValue(%limited_hash));
		
    foreach (@rh_requests) {
    	($color_cnt%2 == 0)?($color = '#EEEEEE'):($color = 'WHITE');
    	my $visitors  = $rh_visitor{$_};
      my $requests  = $rh_requests{$_};
      my $files     = $filesbyrh{$_};
         $files     =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($files)    > 3;
    		 $visitors  =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($visitors) > 3;
    	   $requests  =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($requests) > 3;
    	my $rh_link = '';
    	$rh_link = $q->a({-href=>"$url_help/catalog.pl?rh=$_"}," $rh{$_}") if exists $rh{$_};
    	push(@rows,$q->Tr({-BGCOLOR=>"$color"},$q->td({-align=>'RIGHT'},++$entry_count).$q->td("$_ : $rh_link").$q->td({-align=>'RIGHT'},["$first_visit{$_}","$last_visit{$_}","$files","$visitors","$requests"])));
      $ttl_requests += $rh_requests{$_};
      $color_cnt++;
          
    }
      ($color_cnt%2 == 0)?($color = '#EEEEEE'):($color = 'WHITE');
      $ttl_file     =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($ttl_file)     > 3;
      $ttl_host     =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($ttl_host)     > 3;
    	$ttl_requests =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($ttl_requests) > 3;
      push(@rows,$q->Tr({-BGCOLOR=>"$color"},$q->td(['Total','&nbsp;']).$q->td({-align=>'RIGHT'},["$very_first","$very_last","$ttl_file","$ttl_host","$ttl_requests"])));
      @col_head = $q->th({-width=>'65'},'Count').$q->th('Repository').$q->th({-width=>'65'},['First Access','Last Access','Files','Visitors','Requests']);
    	$ttl_rows = scalar keys %rh_requests;
    	goto TABLETIME;
}

###  OBJECT CLASSES BY REPOSITORY  ###  ###  OBJECT CLASSES BY REPOSITORY  ###

if ($q->param('reports') and $q->param('reports') eq 'Object Classes by Repository') {
	
	my %rh_oh_class;
	my $util = new RIB::Util();
  $util->dbConnect();
	foreach my $rh (keys %rh_oh_requests) {
  	foreach my $oh (keys %{ $rh_oh_requests{$rh} } ) {
  		foreach my $class (keys %{ $rh_oh_requests{$rh}{$oh} } ) {
  			my $rh_class = $rh."_".$class;
  	    my $sth = $util->dbh->prepare( "SELECT Name_ FROM $rh_class WHERE handle = $oh" );
        eval { $sth->execute(); };
        if ($@) { $util->error($@); }
        $rh_oh_class{$rh}{$oh}{$class} = $sth->fetchrow_array();
        #print "RH: $rh, OH: $oh, CLASS: $class, RH_CLASS: $rh_class, RH_OH_CLASS: $rh_oh_class{$rh}{$oh}{$class}<BR>\n";
        $sth->finish();
    	}
    }
  }
	$util->{dbh} && $util->{dbh}->disconnect();
	
  my %host_cnt     = ();
	my $ttl_requests =  0;
	my $color_cnt    =  0;
	my $very_first;
  my $very_last;
  my $color;
  
  my $rh_count = 0;
  
  my @rh_oh_requests = sort numerically keys %rh_oh_requests;
  splice @rh_oh_requests, $q->param('numreturn') if $q->param('numreturn');
  @rh_oh_requests = reverse sort numerically @rh_oh_requests if $q->param('sortby') eq 'ascending';
  
  @col_head = $q->th({-width=>'65'},'Count').$q->th('Object').$q->th({-width=>'65'},['Class','First Access','Last Access','Unique Visitors','Total Requests']); 
    		
	foreach my $rh (@rh_oh_requests) {
		  
    my $entry_count  = 0;
    my $ttl_host     = 0;
    my $ttl_requests = 0;
    my %host_cnt     =();
    @rows            =();
    my $very_first   ='';
    my $very_last    ='';
    my @class_requests = ();
    
    my @oh_requests = sort numerically keys %{ $rh_oh_requests{$rh} };  
    splice @oh_requests, $q->param('numreturn') if $q->param('numreturn');
    @oh_requests = reverse sort numerically @oh_requests if $q->param('sortby') eq 'ascending';
    
    foreach my $oh (@oh_requests) {
    	
      my $requests  = $rh_oh_requests{$rh}{$oh};
    	my $visitors  = scalar keys %{ $rh_oh_visitors{$rh}{$oh} };         
    		 $visitors  =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($visitors) > 3;
    	   $requests  =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($requests) > 3;
    	
    	
    	#($q->param('sortby') eq 'ascending')?(@class_requests = reverseSortHashByValue(%{ $rh_oh_requests{$rh}{$oh} })):(@class_requests = sortHashByValue(%{ $rh_oh_requests{$rh}{$oh} }));
    	#splice @class_requests, $q->param('numreturn') if $q->param('numreturn');
    	    	  
    	foreach my $class (sort keys %{ $rh_oh_requests{$rh}{$oh} }) {
        	
        last if ($q->param('numreturn') && $entry_count >= $q->param('numreturn'));
        	
    		my $requests = $rh_oh_requests{$rh}{$oh}{$class};
    		my $visitors = scalar keys %{ $rh_oh_visitors{$rh}{$oh}{$class} };
    		   $visitors =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($visitors) > 3;
    		   $requests =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($requests) > 3;
    	  my $oh_link  = "Object Handle = $oh";
    	     $oh_link  = $q->a({-href=>"$url_help/object.pl?html=1&rh=$rh&oh=$oh&class=$class"},$rh_oh_class{$rh}{$oh}{$class}) if (defined ($rh_oh_class{$rh}{$oh}{$class}));
        ($color_cnt%2 == 0)?($color = '#EEEEEE'):($color = 'WHITE');
        push(@rows,$q->Tr({-BGCOLOR=>"$color"},$q->td({-align=>'RIGHT'},++$entry_count).$q->td("$oh_link").$q->td("$class").$q->td({-align=>'RIGHT'},["$first_visit{$rh}{$oh}{$class}","$last_visit{$rh}{$oh}{$class}","$visitors","$requests"])));
        $ttl_requests +=  $rh_oh_requests{$rh}{$oh}{$class};
        $very_first = $first_visit{$rh}{$oh}{$class} unless $very_first;
	      $very_first = $first_visit{$rh}{$oh}{$class} if $first_visit{$rh}{$oh}{$class} lt $very_first;
	      $very_last  = $last_visit{$rh}{$oh}{$class}  if $last_visit{$rh}{$oh}{$class}  gt $very_last;
	      foreach my $host (keys %{ $rh_oh_visitors{$rh}{$oh}{$class} } ) {
          $host_cnt{$host} = 1;
        }
        $row_cnt = $entry_count if $entry_count > 20;
        $ttl_host = scalar keys %host_cnt;
        $color_cnt++;
      }
    }
    ($color_cnt%2 == 0)?($color = '#EEEEEE'):($color = 'WHITE');
    $ttl_host     =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($ttl_host)     > 3;
    $ttl_requests =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($ttl_requests) > 3;
    push(@rows,$q->Tr({-BGCOLOR=>"$color"},$q->td(['Total','&nbsp;']).$q->td({-align=>'RIGHT'},['&nbsp;',"$very_first","$very_last","$ttl_host","$ttl_requests"])));
    my $rh_link = "Repository handle = $rh";
    	 $rh_link = $q->a({-href=>"$url_help/catalog.pl?rh=$rh"}," $rh{$rh}") if exists $rh{$rh};
   print $q->br,$q->table({-border=>'1',-align=>'CENTER',-bgcolor=>'WHITE',-cellspacing=>'0',-bordercolor=>'#CCCCCC',-cellpadding=>'4'},
            $q->caption($q->strong("Repository: $rh_link")),@col_head,@rows);
  
  }
 goto TABLEPASS;
}

###  VISITORS  ###  ###  VISITORS  ###  ###  VISITORS  ###

if ($q->param('reports') and $q->param('reports') eq "Visitor's") {	
	
	    my $ttl_request = 0;
	    my $entry_count = 0;
	    my $color_cnt   = 0;
      my %file_cnt    =();
      my $very_first;
	    my $very_last;
	    my $color;
      
      ###  handy dandy splice block  ###
      my %limited_hash = ();
      my @byip = sortHashByValue(%byip);
	    splice @byip, $q->param('numreturn') if $q->param('numreturn');
	    foreach (@byip) {
	    	$limited_hash{$_} = $byip{$_};
	    }
	    foreach (keys %visitorsbyfile) {
	    	my($host, $file) = split /\s+/, $_, 2;
	      if ($limited_hash{$host}) {
	        $visitorbyfile{$host}++;
	        $file_cnt{$file} = 1;
	        $very_first = $first_visit{$host} unless $very_first;
	        $very_first = $first_visit{$host} if $first_visit{$host} lt $very_first;
	        $very_last  = $last_visit{$host}  if $last_visit{$host}  gt $very_last;
	      }
      }
      my $ttl_file = scalar keys %file_cnt;
      ###  handy dandy splice block  ###
	    
	    ($q->param('sortby') eq 'ascending')?(@byip = reverseSortHashByValue(%limited_hash)):(@byip = sortHashByValue(%limited_hash));
	    	
	    foreach (@byip) {
    			
    	  ($color_cnt%2 == 0)?($color = '#EEEEEE'):($color = 'WHITE');
    	  my $by_ip  = $byip{$_};
    		my $files  = $visitorbyfile{$_};
           $files  =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($files) > 3;
    	     $by_ip  =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($by_ip) > 3;
    		push(@rows,$q->Tr({-BGCOLOR=>"$color"},$q->td({-align=>'RIGHT'},++$entry_count).$q->td("$_").$q->td({-align=>'CENTER'},["$first_visit{$_}","$last_visit{$_}"]).$q->td({-align=>'RIGHT'},["$files","$by_ip"])));
    		$color_cnt++;
    		$ttl_request += $byip{$_};
      }
      ($color_cnt%2 == 0)?($color = '#EEEEEE'):($color = 'WHITE');
    	$ttl_file      =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($ttl_file)  > 3;
      $ttl_request =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($ttl_request) > 3;
      push(@rows,$q->Tr({-BGCOLOR=>"$color"},$q->td(['Total','&nbsp;']).$q->td({-align=>'CENTER'},["$very_first","$very_last"]).$q->td({-align=>'RIGHT'},["$ttl_file","$ttl_request"])));
      @col_head = $q->th({-width=>'65'},'Count').$q->th('Visitor').$q->th({-width=>'65'},['First','Last','Files','Requests']);
      $ttl_rows = scalar keys %byip;
    	goto TABLETIME;
}

###  RESOLVE IPS VISITING HOSTS  ###

if ($q->param('reports') and $q->param('reports') eq "Resolve IP's") {	
	
	    my $ttl_request = 0;
	    my $entry_count = 0;
	    my $color_cnt   = 0;
	    my %file_cnt    =();
	    my %byhost      =();
	    my @byhost      =();
	    my $very_first;
	    my $very_last;
      my $color;
      
      ###  handy dandy splice block  ###
      my %limited_hash = ();
      my @byip = sortHashByValue(%byip);
	    splice @byip, $q->param('numreturn') if $q->param('numreturn');
	    foreach (@byip) {
	    	$limited_hash{$_} = $byip{$_};
	    }
	    foreach (keys %visitorsbyfile) {
	    	my($host, $file) = split /\s+/, $_, 2;
	      if ($limited_hash{$host}) {
	        $visitorbyfile{$host}++;
	        $file_cnt{$file} = 1;
	        $very_first = $first_visit{$host} unless $very_first;
	        $very_first = $first_visit{$host} if $first_visit{$host} lt $very_first;
	        $very_last  = $last_visit{$host}  if $last_visit{$host}  gt $very_last;
	      }
      }
	    my $ttl_file = scalar keys %file_cnt;
      ###  end handy dandy splice block  ###
	    
	    foreach (keys %limited_hash) {
	    	my $hostname = "";
        my $addr  = inet_aton($_);
        $hostname = scalar gethostbyaddr($addr,'AF_INET');
        $hostname = $_ unless $hostname;
        $byhost{$hostname} = $byip{$_};
      }
	    ($q->param('sortby') eq 'ascending')?(@byhost = reverseSortHashByValue(%byhost)):(@byhost = sortHashByValue(%byhost));
	    	
	    foreach (@byhost) {
    			
    	  ($color_cnt%2 == 0)?($color = '#EEEEEE'):($color = 'WHITE');
    		my $by_host = $byhost{$_};
    		my $files   = $visitorbyfile{$_};
           $files   =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($files)   > 3;   
           $by_host =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($by_host) > 3;
    		push(@rows,$q->Tr({-BGCOLOR=>"$color"},$q->td({-align=>'RIGHT'},++$entry_count).$q->td("$_").$q->td({-align=>'RIGHT'},["$files","$by_host"])));
    		$color_cnt++;
    		$ttl_request += $byhost{$_};
      }
      ($color_cnt%2 == 0)?($color = '#EEEEEE'):($color = 'WHITE');
      $ttl_file    =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($ttl_file)    > 3;
      $ttl_request =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($ttl_request) > 3;
      push(@rows,$q->Tr({-BGCOLOR=>"$color"},$q->td(['Total','&nbsp;']).$q->td({-align=>'RIGHT'},["$ttl_file","$ttl_request"])));
      @col_head = $q->th({-width=>'65'},'Count').$q->th('Visitor').$q->th({-width=>'65'},['Files','Total Requests']);
      $ttl_rows = scalar keys %byip;
    	goto TABLETIME;
}

###  BY FILES REQUESTED  ###  ###  BY FILES REQUESTED  ###  ###  BY FILES REQUESTED  ###

if ($q->param('reports') and $q->param('reports') eq 'Files Requested') {	
	    
	    my $ttl_files   =  0;
	    my $entry_count =  0;
	    my $color_cnt   =  0;
	    my %host_cnt    = ();
	    my $very_first;
	    my $very_last;
      my $color;
      
      ###  handy dandy splice block  ###
      my %limited_hash = ();
      my @byfile = sortHashByValue(%byfile);
	    splice @byfile, $q->param('numreturn') if $q->param('numreturn');
	    foreach (@byfile) {
	    	$limited_hash{$_} = $byfile{$_};
	    }
	    foreach (keys %visitorsbyfile) {
	    	my($host, $file) = split /\s+/, $_, 2;
	      if ($limited_hash{$file}) {
	        $visitorbyfile{$file}++;
	        $host_cnt{$host} = 1;
	        $very_first = $first_visit{$file} unless $very_first;
	        $very_first = $first_visit{$file} if $first_visit{$file} lt $very_first;
	        $very_last  = $last_visit{$file}  if $last_visit{$file}  gt $very_last;
	      }
      }
      my $ttl_host =  scalar keys %host_cnt;
         $ttl_host =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($ttl_host)  > 3;
      ###  end handy dandy splice block  end###
	    
	    ($q->param('sortby') eq 'ascending')?(@byfile = reverseSortHashByValue(%limited_hash)):(@byfile = sortHashByValue(%limited_hash));
	    	
	    foreach (@byfile) {
    			
    		($color_cnt%2 == 0)?($color = '#EEEEEE'):($color = 'WHITE');
    		my $by_file   = $byfile{$_};
    		my $visitors  = $visitorbyfile{$_};
    		   $by_file   =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($by_file)  > 3;
    		   $visitors  =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($visitors) > 3;
    		push(@rows,$q->Tr({-BGCOLOR=>"$color"},$q->td({-align=>'RIGHT'},++$entry_count).$q->td($q->a({-href=>"$_"},"$_")).$q->td({-align=>'CENTER'},["$first_visit{$_}","$last_visit{$_}"]).$q->td({-align=>'RIGHT'},["$visitors","$by_file"])));
    		$color_cnt++;
        $ttl_files += $byfile{$_};
      }
      ($color_cnt%2 == 0)?($color = '#EEEEEE'):($color = 'WHITE');
      $ttl_files =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($ttl_files) > 3;
      push(@rows,$q->Tr({-BGCOLOR=>"$color"},$q->td(['Total','&nbsp;']).$q->td({-align=>'CENTER'},["$very_first","$very_last"]).$q->td({-align=>'RIGHT'},["$ttl_host","$ttl_files"])));
      @col_head = $q->th({-width=>'65'},"Count").$q->th("File").$q->th({-width=>'65'},["First Access","Last Access","Unique Visitors","Total Requests"]);
      $ttl_rows = scalar keys %byfile;
    	goto TABLETIME;
}

###  BY QUERIES  ###  ###  BY QUERIES  ###  ###  BY QUERIES  ###  ###  BY QUERIES  ###

if ($q->param('reports') and $q->param('reports') eq 'Queries') {	
	    
	    my %visitorbyquery = ();
	    my %host_cnt       = ();
	    my $ttl_queries    =  0;
	    my $entry_count    =  0;
	    my $color_cnt      =  0;
	    my $very_first;
	    my $very_last;
      my $color;
      
      ###  handy dandy splice block  ###
      my %limited_hash = ();
      my @byquery = sortHashByValue(%byquery);
	    splice @byquery, $q->param('numreturn') if $q->param('numreturn');
	    foreach (@byquery) {
	    	$limited_hash{$_} = $byquery{$_};
	    }
	    foreach (keys %visitorsbyquery) {
	    	my($host, $query) = split /\s+/, $_, 2;
	      if ($limited_hash{$query}) {
	        $visitorbyquery{$query}++;
	        $host_cnt{$host} = 1;
	        $very_first = $first_visit{$query} unless $very_first;
	        $very_first = $first_visit{$query} if $first_visit{$query} lt $very_first;
	        $very_last  = $last_visit{$query}  if $last_visit{$query}  gt $very_last;
	      }
      }
      my $ttl_host =  scalar keys %host_cnt;
         $ttl_host =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($ttl_host)  > 3;
      ###  end handy dandy splice block  end  ###
	    
	    ($q->param('sortby') eq 'ascending')?(@byquery = reverseSortHashByValue(%limited_hash)):(@byquery = sortHashByValue(%limited_hash));
	    	
	    foreach (@byquery) {
    			
        ($color_cnt%2 == 0)?($color = '#EEEEEE'):($color = 'WHITE');
    		my $by_query  = $byquery{$_};
    		my $visitors  = $visitorbyquery{$_};
    		   $by_query  =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($by_query) > 3;
    		   $visitors  =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($visitors) > 3;
    		push(@rows,$q->Tr({-BGCOLOR=>"$color"},$q->td({-align=>'RIGHT'},++$entry_count).$q->td($q->a({-href=>"$_"},"$_")).$q->td({-align=>'CENTER'},["$first_visit{$_}","$last_visit{$_}"]).$q->td({-align=>'RIGHT'},["$visitors","$by_query"])));
    		$color_cnt++;
        $ttl_queries += $byquery{$_};
      }
      ($color_cnt%2 == 0)?($color = '#EEEEEE'):($color = 'WHITE');
      $ttl_queries =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($ttl_queries) > 3;
      push(@rows,$q->Tr({-BGCOLOR=>"$color"},$q->td(['Total','&nbsp;']).$q->td({-align=>'CENTER'},["$very_first","$very_last"]).$q->td({-align=>'RIGHT'},["$ttl_host","$ttl_queries"])));
      @col_head = $q->th({-width=>'65'},"Count").$q->th("Query").$q->th({-width=>'65'},["First Access","Last Access","Unique Visitors","Total Requests"]);
      $ttl_rows = scalar keys %byquery;
    	goto TABLETIME;
}

###  PRINT HTML OUTPUT  ###

TABLETIME:  
$row_cnt = 0;
unless ($ENV{'REQUEST_METHOD'} eq 'GET') {
  my $row_cnt_text;
  if ($q->param('numreturn') && ($ttl_rows > $q->param('numreturn'))) {
  	$ttl_rows =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($ttl_rows) > 3;
  	$row_cnt_text = "Displaying ".$q->param('numreturn'). " of $ttl_rows records" ;
  	$row_cnt = $q->param('numreturn');
  } elsif ($q->param('numreturn') && ($ttl_rows < $q->param('numreturn'))) {
  	$row_cnt = $ttl_rows;
  	$ttl_rows =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($ttl_rows) > 3;
  	$row_cnt_text = "Displaying $ttl_rows of $ttl_rows records";
  } else {
  	$ttl_rows =~ s/(\d)(?=(\d\d\d)+(\D|$))/$1\,/g if length($ttl_rows) > 3;
  	$row_cnt = $ttl_rows;
  	$row_cnt_text = "Displaying $ttl_rows records";
  }
  print $q->center($q->b("$row_cnt_text"));
  print $q->table({-border=>'1',-align=>'CENTER',-bgcolor=>'WHITE',-cellspacing=>'0',-bordercolor=>'#CCCCCC',-cellpadding=>'4'},@col_head,@rows);
          
}

TABLEPASS:
my $end_time = timelocal(localtime);
my $elapsed_time = $end_time - $start_time;
print $q->br,$q->br,$q->center($q->a({-href=>'#top',-style=>'text-decoration:none'},'- top -')) if $row_cnt >= 20;
print "<BR><BR>\n<FONT SIZE=\"-1\" COLOR=\"#DDDDDD\">",scalar localtime,"<BR><BR>$elapsed_time seconds</FONT><BR>\n";
print $q->end_html; 

###  HANDY DANDY SORT BY VALUE ROUTINES FOR HASHES  ###

sub sortHashByValue {
    my(%hash) = @_;
    return sort { $hash{$b} <=> $hash{$a} } keys %hash;
}
sub reverseSortHashByCharValue {
    my(%hash) = @_;
    return sort { $hash{$a} cmp $hash{$b} } keys %hash;
}
sub reverseSortHashByValue {
    my(%hash) = @_;
    return sort { $hash{$a} <=> $hash{$b} } keys %hash;
}
sub numerically { $a <=> $b; }

undef(%hitbydate);
undef(%hitbymonth);
undef(%hitbyyear);
undef(%visitorbydate);
undef(%visitorbyday);
undef(%filesbyday);
undef(%filebyday);
undef(%visitorbymonth);
undef(%visitorbymon);
undef(%filesbymonth);
undef(%filesbymon);
undef(%visitorbyyear);
undef(%visitorbyyr); 
undef(%filesbyyear);
undef(%filesbyyr);
undef(%first_visit);
undef(%last_visit); 
undef($findrequest);
undef($includehost);
undef($excludehost);
undef($startdate);
undef($enddate); 
undef($rh);
undef(%rh);
undef(%oh);
undef(@col_head);
undef(@rows);
undef($ttl_rows);
undef(%byip);
undef(%byfile);
undef(@limited_array);
undef(%rh_oh_class);
undef(%rh_oh_classes);
undef(%hits_by_date);
undef(%visitors_by_date);
undef(%files_by_date);
undef(%file_by_date);
undef(%visitor_by_date);
undef(@js_days);
undef(@js_months);
undef(@js_years);