#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;

##############################################
my $util = new RIB::Util();
my $ribdir = $util->RibDir;
my $riburl = $util->RibUrl;

unless (param('rh') =~ /^\d+$/) {
  $util->error("repository handle not specified in input");
}
unless (param('repoPasswd')) {
  param('repoPasswd',param('password'));
}

$util->dbConnect();

unless ($util->authenticateTry(param('repoPasswd'),param('rh'))) {
  print header,
        start_html('-title'=>'Enter repository password',-BGCOLOR=>'#FFFFFF'),
        center(h1('Enter Repository Password')),
        p,hr,p;
  if (defined param('repoPasswd')) {
    print "The password that you entered was incorrect. Please try again.<P>\n";
  }
  print "Please enter the repository password or main RIB password in the form below<p>\n",
        start_form,
        password_field(-name=>'repoPasswd', -size=>50, -maxlength=>80),
        hidden(-name=>'rh'),
        submit(-value=>'Submit'), end_form, 
        p,hr,p,
        "<A HREF=\"top.pl\">RIB management page</A>\n",
        end_html;
  goto FALLOFF;
}

my $sth = $util->dbh->prepare("SELECT name FROM repositories WHERE handle="
                            . param('rh'));
my $repoName;
eval { $sth->execute(); };
if ($@) { $util->error($@); }
unless ($sth->rows() >= 1) {
  $util->error("The repository you have requested to administrate does not exist.");
}
$repoName = $sth->fetchrow_array();

my $repoHandle = param('rh');
my $repoPasswd= param('repoPasswd');


my $tmpname = $repoName;
$tmpname =~ s/\s/\&nbsp;/g;
$tmpname =~ s/"/\&quot;/g;

print header, start_html('-title'=>"Administrate $repoName",-BGCOLOR=>'#FFFFFF');
print << "EOF";
<TABLE WIDTH="100%" CELLPADDING="0" CELLSPACING="0">
  <TR>
    <TD ALIGN="LEFT" VALIGN="TOP">
      <STRONG><FONT SIZE="+1">$tmpname</FONT></STRONG>
    </TD>
    <TD VALIGN="TOP" ALIGN="RIGHT">
EOF

if (param('came_from_top')) {
  my $mainPW = param('password');
print << "EOF";
      <FORM ACTION="top.pl" METHOD="POST">
        <INPUT TYPE="hidden" NAME="password" VALUE="$mainPW">
        <INPUT TYPE="submit" VALUE="RIB management page">
      </FORM>
EOF
} else {
print << "EOF";
      <FORM ACTION="top.pl" METHOD="POST">
        <INPUT TYPE="submit" VALUE="RIB management page">
      </FORM>
EOF
}

$tmpname = $repoName;
$tmpname =~ s/'/\\'/;
$tmpname =~ s/'/\\"/;

my $tmppasswd = $repoPasswd;
$tmppasswd =~ s/'/\\'/;
$tmppasswd =~ s/'/\\"/;

print <<"EOF";
    </TD>
  </TR>
</TABLE>


<!--"CONVERTED_APPLET"-->
<!-- CONVERTER VERSION 1.1 -->
<OBJECT classid="clsid:8AD9C840-044E-11D1-B3E9-00805F499D93"
WIDTH = "100%" HEIGHT = "90%"  codebase="http://java.sun.com/products/plugin/1.1.2/jinstall-112-win32.cab#Version=1,1,2,0">
<PARAM NAME = CODE VALUE = "org.nhse.rib.RibInterface.class" >
<PARAM NAME = CODEBASE VALUE = "$riburl/java" >
<PARAM NAME = ARCHIVE VALUE = "RIB.jar" >

<PARAM NAME="type" VALUE="application/x-java-applet;version=1.1.2">
<PARAM NAME = "repoHandle" VALUE ="$repoHandle">
<PARAM NAME = "repoPasswd" VALUE ="$tmppasswd">
<PARAM NAME = "repoName" VALUE ="$tmpname">
<PARAM NAME = "ribUrl" VALUE ="$riburl">
<COMMENT>
<SCRIPT LANGUAGE="JavaScript"><!--
document.writeln('<embed align="baseline" border="0" width="'+Math.floor(window.innerWidth*.90)+'" height="'+Math.floor(window.innerHeight*.85)+'"  type="application/x-java-applet;version=1.1.2" java_code="org.nhse.rib.RibInterface.class" java_archive="RIB.jar" java_codebase="$riburl/java" repoHandle="$repoHandle" repoPasswd="$tmppasswd" repoName="$tmpname" ribUrl="$riburl" pluginspage="http://www.nhse.org/RIB/plugins.html">')
//--></SCRIPT>
<NOEMBED>
If you can read this then it means that the java plugin is not enabled
in your browser. You can download the plugin for java 1.1.2 at
<A HREF="http://java.sun.com/products/plugin">Sun's web site</A>.
</NOEMBED></EMBED>
</OBJECT>

<!--
<APPLET  CODE = "org.nhse.rib.RibInterface.class" CODEBASE = "$riburl/java" ARCHIVE = "RIB.jar" WIDTH = "100%" HEIGHT = "90%" >
<PARAM NAME = "repoHandle" VALUE ="$repoHandle">
<PARAM NAME = "repoPasswd" VALUE ="$repoPasswd">
<PARAM NAME = "repoName" VALUE ="$repoName">
<PARAM NAME = "ribUrl" VALUE ="$riburl">
If you can read this then it means that java is not enabled in your browser. 
After reenabling java, reload this page to start the RIB administration
interface.
</APPLET>
-->
<!--"END_CONVERTED_APPLET"-->

EOF

print end_html;

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
