/*
 * Decompiled with CFR 0.152.
 */
package org.nhse.rib;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.nhse.rib.ButtonPushMouseListener;
import org.nhse.rib.HelpButton;
import org.nhse.rib.RibComm;
import org.nhse.rib.RibInterface;

public class RibTemplateEditor
extends JDialog {
    Cursor waitCursor = Cursor.getPredefinedCursor(3);
    Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    RibInterface ribInterface;
    JTextArea jTextArea;
    JTextArea key;
    RibComm ribComm;
    JButton saveButton;
    JButton cancelButton;
    String url;
    JScrollPane editScrollPane;
    JScrollPane keyScrollPane;
    boolean fComponentsAdjusted = false;

    public RibTemplateEditor(RibInterface ribInterface, RibComm ribComm, Frame frame) {
        super(frame, true);
        this.setTitle("Template Editor");
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        ((Component)this).setSize(0, 0);
        this.setVisible(false);
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
        this.ribInterface = ribInterface;
        this.ribComm = ribComm;
        JToolBar jToolBar = new JToolBar();
        ((Container)jToolBar).setLayout(new FlowLayout());
        this.saveButton = new JButton("  Save  ");
        this.cancelButton = new JButton("  Cancel  ");
        this.jTextArea = new JTextArea(30, 50);
        this.jTextArea.setLineWrap(true);
        this.jTextArea.setWrapStyleWord(true);
        this.jTextArea.setCursor(Cursor.getPredefinedCursor(2));
        this.jTextArea.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                RibTemplateEditor.this.saveButton.setEnabled(true);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                RibTemplateEditor.this.saveButton.setEnabled(true);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                RibTemplateEditor.this.saveButton.setEnabled(true);
            }
        });
        this.editScrollPane = new JScrollPane(this.jTextArea);
        this.getContentPane().add((Component)this.editScrollPane, "Center");
        this.key = new JTextArea(30, 50);
        this.key.setBackground(Color.black);
        this.key.setForeground(Color.white);
        this.key.setEditable(false);
        this.key.setText("\nSubstitution Keys\n==================================\n\n<!-- RIB -->\n     Placeholder for information generated by RIB\n\nABOUT_URL\n     URL to repository information page generated by RIB\n\nADVANCED_SEARCH_URL\n     URL to the repository Advanced Search page\n\nCATALOG_URL\n     Replaced with URL to the repository Catalog\n\nDATA_MODEL_URL\n     URL to the repository data model\n\nJOIN_URL\n     Replaced with URL to the repository Join page\n\nREPOSITORY_HANDLE\n     The repository's interoperation handle\n\nREPOSITORY_CONTACT\n     Replaced with the repository's contact email address\n\nREPOSITORY_NAME\n     Replaced with the repository name\n\nRIB_LOGO\n     The \"Powered By RIB\" logo in an HTML anchor tag\n\nSEARCH_URL\n     Replaced with URL to the repository Search page\n\nWHATS_NEW_URL\n     Replaced with URL to the repository What's New page");
        this.key.setCaretPosition(0);
        this.keyScrollPane = new JScrollPane(this.key);
        this.keyScrollPane.setHorizontalScrollBarPolicy(31);
        this.key.setCursor(Cursor.getPredefinedCursor(2));
        jToolBar.setFloatable(false);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RibTemplateEditor.this.setVisible(false);
                RibTemplateEditor.this.dispose();
            }
        });
        this.saveButton.setEnabled(false);
        this.saveButton.addMouseListener(new ButtonPushMouseListener(this.saveButton));
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = RibTemplateEditor.this.jTextArea.getText();
                string.trim();
                if (string.length() == 0) {
                    RibTemplateEditor.this.ribInterface.showAlert("Can't save an empty template");
                    RibTemplateEditor.this.saveButton.setEnabled(false);
                    return;
                }
                if (string.indexOf("<!-- RIB -->") == -1) {
                    RibTemplateEditor.this.ribInterface.showAlert("Template must contain <!-- RIB --> somewhere in its text.");
                    RibTemplateEditor.this.saveButton.setBorder(new BevelBorder(0));
                    RibTemplateEditor.this.saveButton.setEnabled(false);
                    return;
                }
                RibTemplateEditor.this.setCursor(RibTemplateEditor.this.waitCursor);
                RibTemplateEditor.this.ribInterface.showStatus("Accessing network...");
                try {
                    try {
                        String string2 = RibTemplateEditor.this.ribComm.saveTemplate(RibTemplateEditor.this.url, string);
                        if (!string2.equals("ok")) {
                            RibTemplateEditor.this.ribInterface.showAlert(string2);
                        } else {
                            RibTemplateEditor.this.setVisible(false);
                            RibTemplateEditor.this.dispose();
                        }
                    }
                    catch (Exception exception) {
                        RibTemplateEditor.this.ribInterface.showAlert(exception.toString());
                    }
                    Object var4_5 = null;
                    RibTemplateEditor.this.setCursor(RibTemplateEditor.this.defaultCursor);
                    RibTemplateEditor.this.ribInterface.showStatus("");
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    RibTemplateEditor.this.setCursor(RibTemplateEditor.this.defaultCursor);
                    RibTemplateEditor.this.ribInterface.showStatus("");
                    throw throwable;
                }
            }
        });
        this.cancelButton.addMouseListener(new ButtonPushMouseListener(this.cancelButton));
        final JButton jButton = new JButton("  View Substitution Keys  ");
        jButton.addMouseListener(new ButtonPushMouseListener(jButton));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jTextArea.isShowing()) {
                    this.getContentPane().remove(editScrollPane);
                    this.getContentPane().add((Component)keyScrollPane, "Center");
                    jButton.setText("  Return to template  ");
                    saveButton.setVisible(false);
                    cancelButton.setVisible(false);
                } else {
                    this.getContentPane().remove(keyScrollPane);
                    this.getContentPane().add((Component)editScrollPane, "Center");
                    jButton.setText("  View Substitution Keys  ");
                    saveButton.setVisible(true);
                    cancelButton.setVisible(true);
                }
                this.pack();
                this.repaint();
            }
        });
        HelpButton helpButton = new HelpButton("catalog_templates.html", this.ribInterface);
        helpButton.setMaximumSize(new Dimension(helpButton.getPreferredSize().width, this.cancelButton.getPreferredSize().height));
        helpButton.setPreferredSize(new Dimension(helpButton.getPreferredSize().width, this.cancelButton.getPreferredSize().height));
        helpButton.setToolTipText("Display help on the template editor");
        jToolBar.add(this.saveButton);
        jToolBar.add(this.cancelButton);
        jToolBar.add(jButton);
        jToolBar.add(helpButton);
        this.getContentPane().add((Component)jToolBar, "South");
    }

    void RibTemplateEditor_WindowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
        Component[] componentArray = this.getContentPane().getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Point point = componentArray[n].getLocation();
            point.translate(insets.left, insets.top);
            componentArray[n].setLocation(point);
            ++n;
        }
        this.fComponentsAdjusted = true;
    }

    public void loadURL(String string) {
        this.url = string;
        this.jTextArea.setText("");
        try {
            String string2;
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            InputStream inputStream = (InputStream)uRLConnection.getContent();
            String string3 = new String();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                string3 = String.valueOf(string3) + string2 + '\n';
            }
            this.jTextArea.setText(string3);
            this.jTextArea.setCaretPosition(0);
        }
        catch (Exception exception) {
            this.ribInterface.showAlert(exception.toString());
            return;
        }
        this.pack();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == RibTemplateEditor.this) {
                RibTemplateEditor.this.RibTemplateEditor_WindowClosing(windowEvent);
            }
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Key"};
        String[] vals = new String[]{"ADVANCED_SEARCH_URL", "   URL to the repository Advanced Search page", "CATALOG_URL", "   URL to the repository Catalog", "DATA_MODEL_URL", "   URL to the repository data model", "JOIN_URL", "   URL to the repository Join page", "REPOSITORY_CONTACT", "   The contact email address", "REPOSITORY_NAME", "   The name of the repository", "REPOSITORY_HANDLE", "   The repository's interoperation handle", "SEARCH_URL", "   URL to the repository Search page", "WHATS_NEW_URL", "   URL to the repository What's New page"};

        MyTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return 12;
        }

        public Object getValueAt(int n, int n2) {
            return this.vals[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

