/*
 * Decompiled with CFR 0.152.
 */
package org.nhse.rib;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.nhse.rib.ButtonPushMouseListener;
import org.nhse.rib.HelpButton;
import org.nhse.rib.RibComm;
import org.nhse.rib.RibInterface;
import org.nhse.rib.RibUtil;
import org.nhse.rib.TableSorter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RibInteropShell
extends JPanel {
    RibComm ribComm;
    RibInterface ribInterface;
    Vector repoList = new Vector();
    Vector columnNames = new Vector();
    JTable table;
    TableSorter sorter;
    JScrollPane scrollpane = null;
    Hashtable intervalHash;
    String[] intervals;

    public RibInteropShell(RibInterface ribInterface, RibComm ribComm) {
        this.setLayout(new FlowLayout(1, 5, 5));
        this.setBackground(Color.white);
        this.setSize(0, 0);
        this.ribInterface = ribInterface;
        this.ribComm = ribComm;
        this.setLayout(new BorderLayout());
        this.intervalHash = RibUtil.getInteropIntervals();
        this.intervals = RibUtil.getSortedInteropIntervals();
        this.sorter = new TableSorter(new MyTableModel());
        this.table = new JTable(this.sorter);
        this.table.setShowHorizontalLines(false);
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        this.table.addMouseListener(new PopupListener());
        this.scrollpane = new JScrollPane(this.table);
        this.add((Component)this.scrollpane, "Center");
        JToolBar jToolBar = new JToolBar();
        jToolBar.setBorder(new BevelBorder(1));
        ((Container)jToolBar).setLayout(new BoxLayout(jToolBar, 0));
        jToolBar.setFloatable(false);
        JButton jButton = new JButton("  Create  ");
        jButton.addMouseListener(new ButtonPushMouseListener(jButton));
        jToolBar.add(jButton);
        jButton.setToolTipText("Create a new interoperation");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = new String[RibInteropShell.this.repoList.size()];
                int n = 0;
                Enumeration enumeration = RibInteropShell.this.repoList.elements();
                while (enumeration.hasMoreElements()) {
                    Vector vector = (Vector)enumeration.nextElement();
                    stringArray[n] = String.valueOf(RibInteropShell.this.ribInterface.ribUrl) + "/cgi-bin/repository.pl?rh=" + (String)vector.elementAt(3);
                    ++n;
                }
                RibInteropShell.this.ribInterface.createInterop(stringArray);
            }
        });
        jToolBar.add(Box.createHorizontalStrut(2));
        JButton jButton2 = new JButton("  Refresh  ");
        jButton2.addMouseListener(new ButtonPushMouseListener(jButton2));
        jToolBar.add(Box.createHorizontalStrut(2));
        jToolBar.add(jButton2);
        jButton2.setToolTipText("Contact server to refresh \"Last Attempt\" column below");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RibInteropShell.this.ribInterface.showStatus("Accessing network...");
                RibInteropShell.this.ribInterface.setCursor(Cursor.getPredefinedCursor(3));
                RibInteropShell.this.refreshTable();
                RibInteropShell.this.ribInterface.showStatus("");
                RibInteropShell.this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        HelpButton helpButton = new HelpButton("interoperation.html", this.ribInterface);
        helpButton.setMaximumSize(new Dimension(helpButton.getPreferredSize().width, jButton2.getPreferredSize().height));
        helpButton.setToolTipText("Display help on interoperation");
        jToolBar.add(Box.createHorizontalStrut(2));
        jToolBar.add(helpButton);
        this.add((Component)jToolBar, "North");
        this.refreshTable();
    }

    static /* synthetic */ void access$0(RibInteropShell ribInteropShell) {
        ribInteropShell.showLog();
    }

    public void listObjects() {
        Object object;
        int n = this.table.getSelectedRowCount();
        String[] stringArray = new String[n];
        int[] nArray = this.table.getSelectedRows();
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            stringArray[n2] = (String)this.sorter.getValueAt(n3, 3);
            ++n2;
        }
        this.ribInterface.showStatus("Accessing network...");
        this.ribInterface.setCursor(Cursor.getPredefinedCursor(3));
        NodeList nodeList = null;
        try {
            nodeList = this.ribComm.listInteropObjects(stringArray);
        }
        catch (Exception exception) {
            this.ribInterface.showAlert(exception.toString());
        }
        this.ribInterface.showStatus("");
        this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
        if (nodeList.getLength() == 0) {
            this.ribInterface.showAlert("There are no objects from the selected interoperation(s)");
            return;
        }
        Vector<String> vector = new Vector<String>();
        final Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n4 = 0;
        while (n4 < nodeList.getLength()) {
            object = (Element)nodeList.item(n4);
            vector.addElement(object.getAttribute("name"));
            hashtable.put(object.getAttribute("name"), object.getAttribute("url"));
            ++n4;
        }
        object = RibUtil.sortStringVector(vector);
        final JList jList = new JList(object);
        jList.setSelectionMode(0);
        jList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                block3: {
                    if (mouseEvent.getClickCount() != 2) break block3;
                    try {
                        String string = new String((String)hashtable.get((String)jList.getSelectedValue()));
                        if (string.indexOf("/rib/repositories/") < 0) {
                            string = String.valueOf(string) + "&html=1";
                        }
                        URL uRL = new URL(string);
                        ribInterface.getAppletContext().showDocument(uRL, "_blank");
                    }
                    catch (Exception exception) {
                        ribInterface.showAlert(exception.toString());
                    }
                }
            }
        });
        Container container = this.getParent();
        while (!(container instanceof Frame)) {
            container = ((Component)container).getParent();
        }
        final JDialog jDialog = new JDialog((Frame)container, "Interoperation objects", true);
        jDialog.getContentPane().setLayout(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        ((Container)jToolBar).setLayout(new FlowLayout());
        JButton jButton = new JButton("  Ok  ");
        jToolBar.setFloatable(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)jDialog).setVisible(false);
                jDialog.dispose();
            }
        });
        jButton.addMouseListener(new ButtonPushMouseListener(jButton));
        jToolBar.add(jButton);
        JScrollPane jScrollPane = new JScrollPane(jList);
        jDialog.getContentPane().add((Component)jScrollPane, "Center");
        jDialog.getContentPane().add((Component)jToolBar, "South");
        jDialog.getContentPane().add((Component)new JLabel("   Double click an object to view it   "), "North");
        jDialog.pack();
        jDialog.setLocationRelativeTo(this.ribInterface);
        jDialog.show();
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)jDialog).setVisible(false);
                jDialog.dispose();
            }
        });
    }

    public void refreshTable() {
        NodeList nodeList = null;
        this.ribInterface.showStatus("Accessing network...");
        this.ribInterface.setCursor(Cursor.getPredefinedCursor(3));
        try {
            nodeList = this.ribComm.listInterops();
        }
        catch (Exception exception) {
            this.ribInterface.showAlert(exception.toString());
        }
        this.ribInterface.showStatus("");
        this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
        if (nodeList == null) {
            return;
        }
        this.repoList = new Vector(nodeList.getLength());
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            String string = element.getAttribute("name");
            String string2 = element.getAttribute("handle");
            String string3 = element.getAttribute("url");
            String string4 = element.getAttribute("last_attempt");
            String string5 = element.getAttribute("last_success");
            String string6 = element.getAttribute("update_interval");
            String string7 = element.getAttribute("checkpoint");
            String string8 = element.getAttribute("last_failure");
            if (string != null && string2 != null && string3 != null && string4 != null && string5 != null && string6 != null && string7 != null && string8 != null) {
                String string9;
                Object object;
                Vector<String> vector = new Vector<String>(5);
                vector.addElement(string);
                String string10 = null;
                Enumeration enumeration = this.intervalHash.keys();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    string9 = String.valueOf(this.intervalHash.get(object));
                    if (!string9.equals(string6)) continue;
                    string10 = new String((String)object);
                    break;
                }
                if (string10 != null) {
                    vector.addElement(string10);
                } else {
                    object = Integer.valueOf(string6);
                    string9 = String.valueOf(String.valueOf((Integer)object / 3600)) + " hours";
                    if (string9.equals("0 hours")) {
                        string9 = String.valueOf(String.valueOf((Integer)object / 60)) + " minutes";
                    }
                    vector.addElement(string9);
                }
                try {
                    object = String.valueOf(string4.substring(0, 4)) + "/" + string4.substring(4, 6) + "/" + string4.substring(6, 8) + " at " + string4.substring(8, 10) + ":" + string4.substring(10, 12);
                    if (string4.equals("00000000000000")) {
                        vector.addElement("never tried");
                    } else if (Long.parseLong(string4, 10) > Long.parseLong(string5, 10)) {
                        if (Long.parseLong(string7, 10) > Long.parseLong(string8, 10)) {
                            vector.addElement(String.valueOf(object) + " (running)");
                        } else {
                            vector.addElement(String.valueOf(object) + " (failed)");
                        }
                    } else {
                        vector.addElement(String.valueOf(object) + " (completed)");
                    }
                }
                catch (Exception exception) {
                    vector.addElement("???" + exception.toString());
                    this.ribInterface.showAlert(exception.toString());
                }
                vector.addElement(string2);
                vector.addElement(string3);
                this.repoList.addElement(vector);
            }
            ++n;
        }
        this.sorter.tableChanged(new TableModelEvent(this.table.getModel()));
        this.sorter.sortByColumn(0);
    }

    private void showLog() {
        int n = this.table.getSelectedRow();
        String string = (String)this.sorter.getValueAt(n, 3);
        this.ribInterface.showStatus("Accessing network...");
        this.ribInterface.setCursor(Cursor.getPredefinedCursor(3));
        try {
            try {
                String string2;
                Reader reader = this.ribComm.getInteropLog(string);
                Container container = this.getParent();
                while (!(container instanceof Frame)) {
                    container = ((Component)container).getParent();
                }
                final JDialog jDialog = new JDialog((Frame)container, "Interoperation log", true);
                jDialog.getContentPane().setLayout(new BorderLayout());
                JToolBar jToolBar = new JToolBar();
                ((Container)jToolBar).setLayout(new FlowLayout());
                JButton jButton = new JButton("  Ok  ");
                JTextArea jTextArea = new JTextArea(30, 60);
                jToolBar.setFloatable(false);
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ((Component)jDialog).setVisible(false);
                        jDialog.dispose();
                    }
                });
                jButton.addMouseListener(new ButtonPushMouseListener(jButton));
                jToolBar.add(jButton);
                String string3 = new String();
                BufferedReader bufferedReader = new BufferedReader(reader);
                while ((string2 = bufferedReader.readLine()) != null) {
                    string3 = String.valueOf(string3) + string2 + "\n";
                }
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                jTextArea.setCursor(Cursor.getPredefinedCursor(2));
                jTextArea.setEditable(false);
                jTextArea.setText(string3);
                jTextArea.setCaretPosition(0);
                JScrollPane jScrollPane = new JScrollPane(jTextArea);
                jDialog.getContentPane().add((Component)jScrollPane, "Center");
                jDialog.getContentPane().add((Component)jToolBar, "South");
                jDialog.pack();
                jDialog.setLocationRelativeTo(this.ribInterface);
                jDialog.show();
                jDialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        ((Component)jDialog).setVisible(false);
                        jDialog.dispose();
                    }
                });
            }
            catch (Exception exception) {
                this.ribInterface.showAlert(exception.toString());
            }
            Object var4_14 = null;
            this.ribInterface.showStatus("");
        }
        catch (Throwable throwable) {
            Object var4_15 = null;
            this.ribInterface.showStatus("");
            this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
    }

    class MyTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Repository Name", "Update Interval", "Last Attempt"};

        MyTableModel() {
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return RibInteropShell.this.repoList.size();
        }

        public Object getValueAt(int n, int n2) {
            Vector vector = (Vector)RibInteropShell.this.repoList.elementAt(n);
            return vector.elementAt(n2);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            Vector vector = (Vector)RibInteropShell.this.repoList.elementAt(n);
            vector.setElementAt(object, n2);
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        static /* synthetic */ RibInteropShell access$0(PopupListener popupListener) {
            return popupListener.RibInteropShell.this;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            if (mouseEvent.getClickCount() == 2) {
                RibInteropShell.this.listObjects();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        public void showPopup(MouseEvent mouseEvent) {
            int n = RibInteropShell.this.table.getSelectedRowCount();
            if (n < 1) {
                return;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("List objects from interoperation");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ PopupListener this$1;
                {
                    this.this$1 = popupListener;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    PopupListener.access$0(this.this$1).listObjects();
                }
            });
            JMenuItem jMenuItem2 = new JMenuItem("View last update log");
            if (n > 1) {
                jMenuItem2.setEnabled(false);
            }
            jPopupMenu.add(jMenuItem2);
            jMenuItem2.addActionListener(new ActionListener(this){
                private final /* synthetic */ PopupListener this$1;
                {
                    this.this$1 = popupListener;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    RibInteropShell.access$0(PopupListener.access$0(this.this$1));
                }
            });
            JMenuItem jMenuItem3 = new JMenuItem("Start an update");
            jMenuItem3.addActionListener(new ActionListener(n, this){
                private final /* synthetic */ PopupListener this$1;
                private final /* synthetic */ int val$rowCount;
                {
                    this.val$rowCount = n;
                    this.this$1 = popupListener;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    String[] stringArray = new String[this.val$rowCount];
                    int[] nArray = PopupListener.access$0((PopupListener)this.this$1).table.getSelectedRows();
                    String string = "Are you sure that you want to start an update for the selected repository?";
                    if (nArray.length > 1) {
                        string = "Are you sure that you want to start an update for the " + nArray.length + " selected repositories?";
                    }
                    if ((n = JOptionPane.showConfirmDialog(PopupListener.access$0((PopupListener)this.this$1).ribInterface, string, "Confirm update", 0, 3, null)) == 1) {
                        return;
                    }
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        int n3 = nArray[n2];
                        stringArray[n2] = (String)PopupListener.access$0((PopupListener)this.this$1).sorter.getValueAt(n3, 3);
                        ++n2;
                    }
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.showStatus("Accessing network...");
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.setCursor(Cursor.getPredefinedCursor(3));
                    String string2 = PopupListener.access$0((PopupListener)this.this$1).ribComm.forceInteropUpdate(stringArray);
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.showStatus("");
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.setCursor(Cursor.getPredefinedCursor(0));
                    if (!string2.equals("ok")) {
                        PopupListener.access$0((PopupListener)this.this$1).ribInterface.showAlert(string2);
                        return;
                    }
                    String string3 = "The update has started in a background process. When the process has completed\nyou can view the results by pressing the \"Refresh\" button above.";
                    JOptionPane.showMessageDialog(PopupListener.access$0((PopupListener)this.this$1).ribInterface, string3);
                    PopupListener.access$0(this.this$1).refreshTable();
                }
            });
            jPopupMenu.add(jMenuItem3);
            JMenuItem jMenuItem4 = new JMenuItem("Delete");
            jMenuItem4.addActionListener(new ActionListener(n, this){
                private final /* synthetic */ PopupListener this$1;
                private final /* synthetic */ int val$rowCount;
                {
                    this.val$rowCount = n;
                    this.this$1 = popupListener;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    String[] stringArray = new String[this.val$rowCount];
                    int[] nArray = PopupListener.access$0((PopupListener)this.this$1).table.getSelectedRows();
                    String string = "Are you sure that you want to delete\nthe selected interoperation from the list?";
                    if (nArray.length > 1) {
                        string = "Are you sure that you want to delete the\n" + nArray.length + " selected repositories from the list?";
                    }
                    if ((n = JOptionPane.showConfirmDialog(PopupListener.access$0((PopupListener)this.this$1).ribInterface, string, "Confirm delete", 0, 3, null)) == 1) {
                        return;
                    }
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        int n3 = nArray[n2];
                        stringArray[n2] = (String)PopupListener.access$0((PopupListener)this.this$1).sorter.getValueAt(n3, 3);
                        ++n2;
                    }
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.showStatus("Accessing network...");
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.setCursor(Cursor.getPredefinedCursor(3));
                    String string2 = PopupListener.access$0((PopupListener)this.this$1).ribComm.deleteInterops(stringArray);
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.showStatus("");
                    PopupListener.access$0((PopupListener)this.this$1).ribInterface.setCursor(Cursor.getPredefinedCursor(0));
                    if (!string2.equals("ok")) {
                        PopupListener.access$0((PopupListener)this.this$1).ribInterface.showAlert(string2);
                    }
                    PopupListener.access$0(this.this$1).refreshTable();
                }
            });
            jPopupMenu.add(jMenuItem4);
            JMenu jMenu = new JMenu("Set update interval");
            jPopupMenu.add(jMenu);
            int n2 = 0;
            while (n2 < RibInteropShell.this.intervals.length) {
                JMenuItem jMenuItem5 = new JMenuItem(RibInteropShell.this.intervals[n2]);
                jMenuItem5.addActionListener(new UpdateIntervals());
                jMenu.add(jMenuItem5);
                ++n2;
            }
            jPopupMenu.pack();
            if (mouseEvent.getY() - RibInteropShell.this.scrollpane.getViewport().getViewPosition().y + jPopupMenu.getPreferredSize().height > RibInteropShell.this.scrollpane.getViewport().getHeight()) {
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY() - jPopupMenu.getPreferredSize().height);
            } else {
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class UpdateIntervals
    implements ActionListener {
        UpdateIntervals() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            int n;
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string2 = jMenuItem.getText();
            String string3 = (String)RibInteropShell.this.intervalHash.get(string2);
            int[] nArray = RibInteropShell.this.table.getSelectedRows();
            String[] stringArray = new String[nArray.length];
            if (nArray.length > 1 && (n = JOptionPane.showConfirmDialog(RibInteropShell.this.ribInterface, string = "Are you sure you want to change the update\ninterval for the " + nArray.length + " selected repositories?", "Confirm update", 0, 3, null)) == 1) {
                return;
            }
            int n2 = 0;
            while (n2 < nArray.length) {
                n = nArray[n2];
                stringArray[n2] = (String)RibInteropShell.this.sorter.getValueAt(n, 3);
                ++n2;
            }
            RibInteropShell.this.ribInterface.showStatus("Accessing network...");
            RibInteropShell.this.ribInterface.setCursor(Cursor.getPredefinedCursor(3));
            String string4 = RibInteropShell.this.ribComm.setUpdateIntervals(stringArray, string3);
            RibInteropShell.this.ribInterface.showStatus("");
            RibInteropShell.this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
            if (!string4.equals("ok")) {
                RibInteropShell.this.ribInterface.showAlert(string4);
                return;
            }
            RibInteropShell.this.refreshTable();
        }
    }
}

