/*
 * Decompiled with CFR 0.152.
 */
package org.nhse.rib;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.nhse.rib.ButtonPushMouseListener;
import org.nhse.rib.HelpButton;
import org.nhse.rib.RibAttribute;
import org.nhse.rib.RibCatalogInfo;
import org.nhse.rib.RibClass;
import org.nhse.rib.RibComm;
import org.nhse.rib.RibConfig;
import org.nhse.rib.RibConfigEditor;
import org.nhse.rib.RibHelpPane;
import org.nhse.rib.RibInteropShell;
import org.nhse.rib.RibObjectBrowser;
import org.nhse.rib.RibObjectEditor;
import org.nhse.rib.RibTemplateEditor;
import org.nhse.rib.RibUtil;
import org.w3c.dom.Element;

public class RibInterface
extends JApplet {
    JTabbedPane mainPanel = new JTabbedPane();
    JPanel helpPanel = new JPanel();
    JPanel objectsPanel = new JPanel();
    JPanel catalogPanel = new JPanel();
    JPanel filesPanel = new JPanel();
    JPanel interopPanel = new JPanel();
    JPanel propertiesPanel = new JPanel();
    String repoHandle;
    String repoPasswd;
    String repoName;
    String ribUrl;
    String repoUrl;
    String configUrl;
    String cgiUrl;
    RibInterface ribInterface = null;
    RibComm ribComm = null;
    Cursor waitCursor = Cursor.getPredefinedCursor(3);
    Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    ImageIcon deleteButtonIcon;
    ImageIcon createButtonIcon;
    ImageIcon browseButtonIcon;
    ImageIcon helpButtonIcon;

    public void createInterop(final String[] stringArray) {
        this.interopPanel.removeAll();
        this.interopPanel.repaint();
        final JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel("Repository type:   ");
        jPanel2.add(jLabel);
        String[] stringArray2 = new String[]{"Local repository", "Remote repository"};
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray2);
        jComboBox.setSelectedIndex(-1);
        jComboBox.setBackground(Color.white);
        jPanel2.add(jComboBox);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Serializable serializable;
                Object object;
                Object object2;
                int n = jPanel.getComponentCount() - 1;
                while (n > 0) {
                    jPanel.remove(n);
                    --n;
                }
                String string = (String)jComboBox.getSelectedItem();
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new BoxLayout(jPanel2, 1));
                JTextField jTextField = new JTextField(40);
                JTextField jTextField2 = new JTextField(40);
                JButton jButton = new JButton("  Submit  ");
                jButton.setEnabled(false);
                jTextField.getDocument().addDocumentListener(new EnsureNonemptyDocumentListener(jButton));
                if (string.equals("Local repository")) {
                    Object object3;
                    Object object4;
                    Object object5;
                    this.showStatus("Accessing network...");
                    this.setCursor(waitCursor);
                    object2 = null;
                    try {
                        object2 = ribComm.listRepositories();
                    }
                    catch (Exception exception) {
                        this.showAlert(exception.toString());
                    }
                    object = null;
                    try {
                        object = ribComm.getCatalogInfo();
                    }
                    catch (Exception exception) {
                        this.showAlert(exception.toString());
                    }
                    this.showStatus("");
                    this.setCursor(defaultCursor);
                    if (object == null) {
                        return;
                    }
                    if (object2 == null) {
                        return;
                    }
                    serializable = new Vector(object2.getLength());
                    Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
                    int n2 = 0;
                    while (n2 < object2.getLength()) {
                        object5 = (Element)object2.item(n2);
                        object4 = object5.getAttribute("name");
                        if (object4 != null && (object3 = object5.getAttribute("interop_handle")) != null && !((String)object4).equals(((RibCatalogInfo)object).getName())) {
                            ((Vector)serializable).addElement(object4);
                            hashtable.put(object4, object3);
                        }
                        ++n2;
                    }
                    if (((Vector)serializable).size() == 0) {
                        this.showAlert("There are no local repositories available for interoperation.");
                        this.createInterop(stringArray);
                        return;
                    }
                    object5 = new JPanel(new FlowLayout(0));
                    object4 = new JLabel("Repository name :   ");
                    ((Container)object5).add((Component)object4);
                    object3 = new JComboBox(serializable);
                    ((JComboBox)object3).setSelectedIndex(-1);
                    ((JComponent)object3).setBackground(Color.white);
                    ((JComboBox)object3).addActionListener(new ActionListener((JComboBox)object3, jTextField2, hashtable, jTextField){
                        private final /* synthetic */ JTextField val$nameTextField;
                        private final /* synthetic */ JComboBox val$jcb2;
                        private final /* synthetic */ Hashtable val$repoHandles;
                        private final /* synthetic */ JTextField val$urlTextField;
                        {
                            this.val$jcb2 = jComboBox;
                            this.val$nameTextField = jTextField;
                            this.val$repoHandles = hashtable;
                            this.val$urlTextField = jTextField2;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            this.val$urlTextField.setText((String)this.val$repoHandles.get(this.val$jcb2.getSelectedItem()));
                            this.val$nameTextField.setText((String)this.val$jcb2.getSelectedItem());
                        }
                    });
                    ((Container)object5).add((Component)object3);
                    ((JComponent)object5).setMaximumSize(((JComponent)object5).getPreferredSize());
                    ((JComponent)object5).setAlignmentX(0.0f);
                    jPanel2.add((Component)object5);
                } else if (string.equals("Remote repository")) {
                    object2 = new JPanel(new FlowLayout(0));
                    object = new JLabel("Interoperation handle :   ");
                    ((Container)object2).add((Component)object);
                    jTextField.setCursor(Cursor.getPredefinedCursor(2));
                    ((Container)object2).add(jTextField);
                    ((JComponent)object2).setAlignmentX(0.0f);
                    ((JComponent)object2).setMaximumSize(((JComponent)object2).getPreferredSize());
                    jPanel2.add((Component)object2);
                    serializable = new JPanel(new FlowLayout(0));
                    JLabel jLabel = new JLabel("Repository name :   ");
                    ((Container)serializable).add(jLabel);
                    jTextField2.setCursor(Cursor.getPredefinedCursor(2));
                    ((Container)serializable).add(jTextField2);
                    ((JComponent)serializable).setAlignmentX(0.0f);
                    ((JComponent)serializable).setMaximumSize(((JComponent)serializable).getPreferredSize());
                    jPanel2.add((Component)serializable);
                }
                object2 = new JPanel(new FlowLayout(0));
                object = new JLabel("Update interval :   ");
                ((Container)object2).add((Component)object);
                serializable = new JComboBox<String>(RibUtil.getSortedInteropIntervals());
                ((JComboBox)serializable).setSelectedIndex(5);
                ((JComponent)serializable).setBackground(Color.white);
                ((Container)object2).add((Component)serializable);
                jButton.addMouseListener(new ButtonPushMouseListener(jButton));
                ((Container)object2).add(jButton);
                jButton.addActionListener(new ActionListener(stringArray, (JComboBox)serializable, jTextField2, this, jTextField){
                    private final /* synthetic */ JComboBox val$jcb2;
                    private final /* synthetic */ JTextField val$nameTextField;
                    private final /* synthetic */ RibInterface this$0;
                    private final /* synthetic */ String[] val$handles;
                    private final /* synthetic */ JTextField val$urlTextField;
                    {
                        this.val$handles = stringArray;
                        this.val$jcb2 = jComboBox;
                        this.val$nameTextField = jTextField;
                        this.this$0 = ribInterface;
                        this.val$urlTextField = jTextField2;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = this.val$urlTextField.getText();
                        string.trim();
                        int n = 0;
                        while (n < this.val$handles.length) {
                            if (string.equals(this.val$handles[n])) {
                                this.this$0.showAlert("You are already interoperating with this repository");
                                return;
                            }
                            ++n;
                        }
                        if (string.equals(String.valueOf(this.this$0.ribInterface.ribUrl) + "/cgi-bin/repository.pl?rh=" + this.this$0.ribInterface.repoHandle)) {
                            this.this$0.showAlert("The handle that you specified belongs to the repository you are\ncurrently administrating. A repository cannot interoperate with itself.");
                            return;
                        }
                        String string2 = this.val$nameTextField.getText();
                        string2.trim();
                        try {
                            new URL(string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            this.this$0.showAlert("Malformed URL : " + string);
                            this.val$urlTextField.requestFocus();
                            return;
                        }
                        Hashtable hashtable = RibUtil.getInteropIntervals();
                        String string3 = (String)hashtable.get(this.val$jcb2.getSelectedItem());
                        this.this$0.showStatus("Accessing network...");
                        this.this$0.setCursor(this.this$0.waitCursor);
                        String string4 = this.this$0.ribComm.createInterop(string, string3, string2);
                        this.this$0.showStatus("");
                        this.this$0.setCursor(this.this$0.defaultCursor);
                        if (!string4.equals("ok")) {
                            this.this$0.showAlert(string4);
                        } else {
                            this.this$0.showInteropList();
                        }
                    }
                });
                ((JComponent)object2).setMaximumSize(((JComponent)object2).getPreferredSize());
                ((JComponent)object2).setAlignmentX(0.0f);
                jPanel2.add((Component)object2);
                jPanel2.setMaximumSize(jPanel2.getPreferredSize());
                jPanel2.setAlignmentX(0.0f);
                jPanel.add(jPanel2);
                jPanel2.revalidate();
                jTextField.requestFocus();
            }
        });
        JButton jButton = new JButton("  Cancel  ");
        jButton.addMouseListener(new ButtonPushMouseListener(jButton));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RibInterface.this.showInteropList();
            }
        });
        jPanel2.add(jButton);
        HelpButton helpButton = new HelpButton("interop_create.html", this.ribInterface);
        helpButton.setMaximumSize(new Dimension(helpButton.getPreferredSize().width, jButton.getPreferredSize().height));
        helpButton.setPreferredSize(new Dimension(helpButton.getPreferredSize().width, jButton.getPreferredSize().height));
        helpButton.setToolTipText("Display help on creating interoperations");
        jPanel2.add(helpButton);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setMaximumSize(jPanel2.getPreferredSize());
        jPanel.add(jPanel2);
        this.interopPanel.add((Component)jPanel, "North");
        jPanel.revalidate();
    }

    public void createObject(String string) {
        try {
            this.objectsPanel.remove(0);
        }
        catch (Exception exception) {}
        this.objectsPanel.repaint();
        this.showStatus("Accessing network...");
        this.setCursor(this.waitCursor);
        RibConfig ribConfig = new RibConfig(this.configUrl);
        RibObjectEditor ribObjectEditor = new RibObjectEditor(this.ribInterface, ribConfig, this.ribComm);
        ribObjectEditor.createObject(string);
        this.objectsPanel.add((Component)ribObjectEditor, "Center");
        this.objectsPanel.revalidate();
        this.showStatus("");
        this.setCursor(this.defaultCursor);
    }

    public void editObject(String string, String string2, String string3) {
        try {
            this.objectsPanel.remove(0);
        }
        catch (Exception exception) {}
        this.objectsPanel.repaint();
        this.setCursor(this.waitCursor);
        this.showStatus("Accessing network...");
        RibConfig ribConfig = new RibConfig(this.configUrl);
        RibObjectEditor ribObjectEditor = new RibObjectEditor(this.ribInterface, ribConfig, this.ribComm);
        ribObjectEditor.editObject(string3, string, string2);
        this.objectsPanel.add((Component)ribObjectEditor, "Center");
        ribObjectEditor.revalidate();
        this.objectsPanel.revalidate();
        this.objectsPanel.repaint();
        this.setCursor(this.defaultCursor);
        this.showStatus("");
    }

    public void help(String string) {
        this.mainPanel.setSelectedComponent(this.helpPanel);
        RibHelpPane ribHelpPane = (RibHelpPane)this.helpPanel.getComponent(0);
        ribHelpPane.gotoURL(String.valueOf(this.ribUrl) + "/doc/" + string);
    }

    public void importObject(String string, String string2) {
        try {
            this.objectsPanel.remove(0);
        }
        catch (Exception exception) {}
        this.objectsPanel.repaint();
        this.setCursor(this.waitCursor);
        this.showStatus("Accessing network...");
        RibConfig ribConfig = new RibConfig(this.configUrl);
        RibObjectEditor ribObjectEditor = new RibObjectEditor(this.ribInterface, ribConfig, this.ribComm);
        ribObjectEditor.importObject(string2, string);
        this.objectsPanel.add((Component)ribObjectEditor, "Center");
        ribObjectEditor.revalidate();
        this.objectsPanel.revalidate();
        this.objectsPanel.repaint();
        this.setCursor(this.defaultCursor);
        this.showStatus("");
    }

    public void init() {
        URL uRL;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 0));
        this.getContentPane().setBackground(Color.white);
        this.getContentPane().add(this.mainPanel);
        this.repoHandle = this.getParameter("repoHandle");
        this.repoPasswd = this.getParameter("repoPasswd");
        this.repoName = this.getParameter("repoName");
        this.ribUrl = this.getParameter("ribUrl");
        this.repoUrl = String.valueOf(this.ribUrl) + "/" + this.repoHandle;
        this.configUrl = String.valueOf(this.repoUrl) + "/config.xml";
        this.cgiUrl = new String(this.ribUrl);
        SymChange symChange = new SymChange();
        this.mainPanel.addChangeListener(symChange);
        this.mainPanel.addTab(" Help ", this.helpPanel);
        this.helpPanel.setLayout(new GridLayout(1, 1));
        this.helpPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.mainPanel.addTab(" Manage Objects ", this.objectsPanel);
        this.objectsPanel.setLayout(new BorderLayout());
        this.objectsPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.mainPanel.addTab(" Manage Catalog ", this.catalogPanel);
        this.catalogPanel.setLayout(new BoxLayout(this.catalogPanel, 1));
        this.mainPanel.addTab(" Interoperation ", this.interopPanel);
        this.interopPanel.setLayout(new BoxLayout(this.interopPanel, 1));
        this.mainPanel.addTab(" Repository Properties ", this.propertiesPanel);
        this.propertiesPanel.setLayout(new BoxLayout(this.propertiesPanel, 1));
        this.ribInterface = this;
        this.ribComm = new RibComm(this.cgiUrl, this.repoHandle, this.repoPasswd, this);
        this.getRootPane().setGlassPane(new MyGlassPane());
        try {
            uRL = new URL(String.valueOf(this.ribInterface.ribUrl) + "/images/delete.gif");
            this.deleteButtonIcon = new ImageIcon(uRL);
        }
        catch (Exception exception) {
            this.deleteButtonIcon = null;
        }
        try {
            uRL = new URL(String.valueOf(this.ribInterface.ribUrl) + "/images/browse.gif");
            this.browseButtonIcon = new ImageIcon(uRL);
        }
        catch (Exception exception) {
            this.browseButtonIcon = null;
        }
        try {
            uRL = new URL(String.valueOf(this.ribInterface.ribUrl) + "/images/create.gif");
            this.createButtonIcon = new ImageIcon(uRL);
        }
        catch (Exception exception) {
            this.createButtonIcon = null;
        }
        try {
            uRL = new URL(String.valueOf(this.ribInterface.ribUrl) + "/images/help.gif");
            this.helpButtonIcon = new ImageIcon(uRL);
        }
        catch (Exception exception) {
            this.helpButtonIcon = null;
        }
    }

    private void initCatalogPanel() {
        this.catalogPanel.removeAll();
        this.setCursor(this.waitCursor);
        this.showStatus("Accessing network...");
        RibCatalogInfo ribCatalogInfo = null;
        try {
            ribCatalogInfo = this.ribComm.getCatalogInfo();
        }
        catch (Exception exception) {
            this.showAlert(exception.toString());
        }
        this.setCursor(this.defaultCursor);
        this.showStatus("");
        if (ribCatalogInfo == null) {
            return;
        }
        final RibCatalogInfo ribCatalogInfo2 = ribCatalogInfo;
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        JMenuItem jMenuItem = new JMenuItem("  Catalog  ");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URL uRL = new URL(String.valueOf(RibInterface.this.cgiUrl) + "/catalog.pl?rh=" + RibInterface.this.repoHandle);
                    RibInterface.this.getAppletContext().showDocument(uRL, "_blank");
                }
                catch (Exception exception) {
                    RibInterface.this.showAlert(exception.toString());
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("  Join  ");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URL uRL = new URL(String.valueOf(RibInterface.this.cgiUrl) + "/join.pl?rh=" + RibInterface.this.repoHandle);
                    RibInterface.this.getAppletContext().showDocument(uRL, "_blank");
                }
                catch (Exception exception) {
                    RibInterface.this.showAlert(exception.toString());
                }
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem("  Search  ");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URL uRL = new URL(String.valueOf(RibInterface.this.cgiUrl) + "/search.pl?rh=" + RibInterface.this.repoHandle);
                    RibInterface.this.getAppletContext().showDocument(uRL, "_blank");
                }
                catch (Exception exception) {
                    RibInterface.this.showAlert(exception.toString());
                }
            }
        });
        JMenuItem jMenuItem4 = new JMenuItem("  Advanced Search  ");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URL uRL = new URL(String.valueOf(RibInterface.this.cgiUrl) + "/advancedSearch.pl?rh=" + RibInterface.this.repoHandle);
                    RibInterface.this.getAppletContext().showDocument(uRL, "_blank");
                }
                catch (Exception exception) {
                    RibInterface.this.showAlert(exception.toString());
                }
            }
        });
        JMenuItem jMenuItem5 = new JMenuItem("  What's New  ");
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URL uRL = new URL(String.valueOf(RibInterface.this.cgiUrl) + "/whatsNew.pl?rh=" + RibInterface.this.repoHandle);
                    RibInterface.this.getAppletContext().showDocument(uRL, "_blank");
                }
                catch (Exception exception) {
                    RibInterface.this.showAlert(exception.toString());
                }
            }
        });
        final JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.add(jMenuItem4);
        jPopupMenu.add(jMenuItem5);
        jPopupMenu.pack();
        final JButton jButton = new JButton("  View  ");
        jButton.setPreferredSize(new Dimension(jPopupMenu.getPreferredSize().width, jButton.getPreferredSize().height));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jPopupMenu.show(jButton, 0, jButton.getHeight());
            }
        });
        jButton.addMouseListener(new ButtonPushMouseListener(jButton));
        Container container = this.getParent();
        while (!(container instanceof Frame)) {
            container = ((Component)container).getParent();
        }
        final RibTemplateEditor ribTemplateEditor = new RibTemplateEditor(this.ribInterface, this.ribComm, (Frame)container);
        JMenuItem jMenuItem6 = new JMenuItem("  Catalog  ");
        JMenuItem jMenuItem7 = new JMenuItem("  Join  ");
        JMenuItem jMenuItem8 = new JMenuItem("  Search  ");
        JMenuItem jMenuItem9 = new JMenuItem("  Advanced Search  ");
        JMenuItem jMenuItem10 = new JMenuItem("  What's New  ");
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                this.showStatus("Accessing network...");
                this.setCursor(waitCursor);
                ribTemplateEditor.loadURL(String.valueOf(repoUrl) + "/catalog_template.html");
                ribTemplateEditor.setLocationRelativeTo(ribInterface);
                ribTemplateEditor.show();
                this.showStatus("");
                this.setCursor(defaultCursor);
            }
        });
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                this.showStatus("Accessing network...");
                this.setCursor(waitCursor);
                ribTemplateEditor.loadURL(String.valueOf(repoUrl) + "/join_template.html");
                ribTemplateEditor.show();
                this.showStatus("");
                this.setCursor(defaultCursor);
            }
        });
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                this.showStatus("Accessing network...");
                this.setCursor(waitCursor);
                ribTemplateEditor.loadURL(String.valueOf(repoUrl) + "/search_template.html");
                ribTemplateEditor.show();
                this.showStatus("");
                this.setCursor(defaultCursor);
            }
        });
        jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                this.showStatus("Accessing network...");
                this.setCursor(waitCursor);
                ribTemplateEditor.loadURL(String.valueOf(repoUrl) + "/advanced_search_template.html");
                ribTemplateEditor.show();
                this.showStatus("");
                this.setCursor(defaultCursor);
            }
        });
        jMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                this.showStatus("Accessing network...");
                this.setCursor(waitCursor);
                ribTemplateEditor.loadURL(String.valueOf(repoUrl) + "/whats_new_template.html");
                ribTemplateEditor.show();
                this.showStatus("");
                this.setCursor(defaultCursor);
            }
        });
        final JPopupMenu jPopupMenu2 = new JPopupMenu();
        jPopupMenu2.add(jMenuItem6);
        jPopupMenu2.add(jMenuItem7);
        jPopupMenu2.add(jMenuItem8);
        jPopupMenu2.add(jMenuItem9);
        jPopupMenu2.add(jMenuItem10);
        jPopupMenu2.pack();
        final JButton jButton2 = new JButton("  Edit Template  ");
        jButton2.setPreferredSize(new Dimension(jPopupMenu2.getPreferredSize().width, jButton2.getPreferredSize().height));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jPopupMenu2.show(jButton2, 0, jButton2.getHeight());
            }
        });
        jButton2.addMouseListener(new ButtonPushMouseListener(jButton2));
        HelpButton helpButton = new HelpButton("manage_catalog.html", this.ribInterface);
        helpButton.setMaximumSize(new Dimension(helpButton.getPreferredSize().width, jButton2.getPreferredSize().height));
        helpButton.setPreferredSize(new Dimension(helpButton.getPreferredSize().width, jButton2.getPreferredSize().height));
        helpButton.setToolTipText("Display help on managing the catalog");
        jToolBar.add(jButton);
        jToolBar.add(Box.createHorizontalStrut(10));
        jToolBar.add(jButton2);
        jToolBar.add(Box.createHorizontalStrut(10));
        jToolBar.add(helpButton);
        jToolBar.setAlignmentX(0.0f);
        jToolBar.setMaximumSize(jToolBar.getPreferredSize());
        this.catalogPanel.add(Box.createRigidArea(new Dimension(5, 5)));
        this.catalogPanel.add(jToolBar);
        final JPanel jPanel = new JPanel(new FlowLayout(0));
        final JLabel jLabel = new JLabel("Primary class is " + ribCatalogInfo2.getPrimaryClass());
        final JPanel jPanel2 = new JPanel(new FlowLayout(0));
        final JLabel jLabel2 = new JLabel("Primary attribute is " + ribCatalogInfo2.getPrimaryAttribute());
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalStrut(5));
        final JComboBox jComboBox = new JComboBox();
        jComboBox.setVisible(false);
        jComboBox.setBackground(Color.white);
        final JButton jButton3 = new JButton("  Change  ");
        final JButton jButton4 = new JButton("  Cancel  ");
        jPanel2.add(jLabel2);
        jPanel2.add(Box.createHorizontalStrut(5));
        final JComboBox jComboBox2 = new JComboBox();
        jComboBox2.setVisible(false);
        jComboBox2.setBackground(Color.white);
        final JButton jButton5 = new JButton("  Change  ");
        final JButton jButton6 = new JButton("  Cancel  ");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                this.setCursor(waitCursor);
                this.showStatus("Accessing network...");
                SwingUtilities.invokeLater(new Thread(jButton3){
                    private final /* synthetic */ JButton val$changePrimClass;
                    {
                        this.val$changePrimClass = jButton;
                    }

                    public void run() {
                        this.val$changePrimClass.setEnabled(false);
                    }
                });
                jButton5.setEnabled(false);
                jButton4.setVisible(true);
                jButton6.setVisible(false);
                jComboBox2.setVisible(false);
                RibConfig ribConfig = new RibConfig(configUrl);
                ribConfig.parse();
                if (jComboBox.getItemCount() > 0) {
                    jComboBox.removeAllItems();
                }
                Enumeration enumeration = ribConfig.getClassNames(false).elements();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (string.equals(ribCatalogInfo2.getPrimaryClass())) continue;
                    jComboBox.addItem(string);
                }
                if (jComboBox.getItemCount() == 0) {
                    this.showAlert(String.valueOf(ribCatalogInfo2.getPrimaryClass()) + " is the only class in this repository's data model");
                } else {
                    jComboBox.insertItemAt("--Choose a new primary class--", 0);
                    jComboBox.setSelectedIndex(0);
                    jComboBox.setVisible(true);
                    jComboBox.revalidate();
                }
                jPanel.setMaximumSize(jPanel.getPreferredSize());
                this.setCursor(defaultCursor);
                this.showStatus("");
            }
        });
        jButton3.addMouseListener(new ButtonPushMouseListener(jButton3));
        jPanel.add(jButton3);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(jComboBox);
        jPanel.add(Box.createHorizontalStrut(2));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jButton4.setVisible(false);
                jButton3.setEnabled(true);
                jButton5.setEnabled(true);
                jComboBox.setVisible(false);
            }
        });
        jButton4.addMouseListener(new ButtonPushMouseListener(jButton4));
        jPanel.add(jButton4);
        jButton4.setVisible(false);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                if (jComboBox.getSelectedIndex() == 0) {
                    return;
                }
                if (jComboBox.getItemCount() == 0) {
                    return;
                }
                String string = "Making this change will cause the catalog to show objects of\nthe chosen class. Side effects of this change are that the primary\nattribute is set to null and any objects currently appearing in the\ncatalog as a result of interoperation will be removed. If the\nrepositories being interoperated with contain objects of the chosen\nclass then those objects will appear in the catalog on the next\ninteroperation update. Proceed with this change?";
                Object[] objectArray = new Object[]{"Yes", "No"};
                int n = JOptionPane.showOptionDialog(ribInterface, string, "Confirm new primary class", -1, 3, null, objectArray, objectArray[0]);
                if (n == 0) {
                    this.setCursor(waitCursor);
                    this.showStatus("Accessing network...");
                    jButton3.setEnabled(true);
                    jButton5.setEnabled(true);
                    jButton4.setVisible(false);
                    jComboBox.setVisible(false);
                    String string2 = (String)jComboBox.getSelectedItem();
                    String string3 = ribComm.changePrimClass(string2, "");
                    if (string3.equals("ok")) {
                        ribCatalogInfo2.setPrimaryClass(string2);
                        JPanel jPanel3 = (JPanel)catalogPanel.getComponent(7);
                        jPanel3.setMaximumSize(jPanel3.getPreferredSize());
                        jLabel.setText("Primary class is " + ribCatalogInfo2.getPrimaryClass());
                        jPanel.setMaximumSize(jPanel.getPreferredSize());
                        jLabel.revalidate();
                        ribCatalogInfo2.setPrimaryAttribute(null);
                        jLabel2.setText("Primary attribute is null");
                        jPanel2.setMaximumSize(jPanel2.getPreferredSize());
                        jLabel2.revalidate();
                    } else {
                        this.showAlert(string3);
                    }
                    this.setCursor(defaultCursor);
                    this.showStatus("");
                } else if (n == 1) {
                    jButton3.setEnabled(true);
                    jButton5.setEnabled(true);
                    jButton4.setVisible(false);
                    jComboBox.setVisible(false);
                }
            }
        });
        jPanel.setAlignmentX(0.0f);
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Thread(jButton5){
                    private final /* synthetic */ JButton val$changePrimAttr;
                    {
                        this.val$changePrimAttr = jButton;
                    }

                    public void run() {
                        this.val$changePrimAttr.setEnabled(false);
                    }
                });
                this.setCursor(waitCursor);
                this.showStatus("Accessing network...");
                RibConfig ribConfig = new RibConfig(configUrl);
                ribConfig.parse();
                if (jComboBox2.getItemCount() > 0) {
                    jComboBox2.removeAllItems();
                }
                RibClass ribClass = ribConfig.getClass(ribCatalogInfo2.getPrimaryClass());
                Enumeration enumeration = ribClass.getAttributes().elements();
                while (enumeration.hasMoreElements()) {
                    RibAttribute ribAttribute = (RibAttribute)enumeration.nextElement();
                    String string = ribAttribute.getName();
                    if (string.equals(ribCatalogInfo2.getPrimaryAttribute()) || !ribAttribute.hasVocabulary()) continue;
                    jComboBox2.addItem(string);
                }
                if (jComboBox2.getItemCount() == 0) {
                    if (ribCatalogInfo2.getPrimaryAttribute() == null) {
                        this.showAlert(String.valueOf(ribCatalogInfo2.getPrimaryClass()) + " does not contain an attribute with a vocabulary");
                    } else {
                        this.showAlert("The primary attribute must contain a vocabulary. " + ribCatalogInfo2.getPrimaryClass() + " does\nnot contain an attribute with a vocabulary other than " + ribCatalogInfo2.getPrimaryAttribute());
                    }
                } else {
                    jComboBox2.insertItemAt("--Choose a new primary attribute--", 0);
                    jComboBox2.setSelectedIndex(0);
                    jButton6.setVisible(true);
                    jComboBox2.setVisible(true);
                    jComboBox2.revalidate();
                }
                jPanel2.setMaximumSize(jPanel2.getPreferredSize());
                this.setCursor(defaultCursor);
                this.showStatus("");
            }
        });
        jButton5.addMouseListener(new ButtonPushMouseListener(jButton5));
        jPanel2.add(jButton5);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(jComboBox2);
        jPanel2.add(Box.createHorizontalStrut(2));
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jButton6.setVisible(false);
                jButton5.setEnabled(true);
                jComboBox2.setVisible(false);
            }
        });
        jButton6.addMouseListener(new ButtonPushMouseListener(jButton6));
        jPanel2.add(jButton6);
        jButton6.setVisible(false);
        jComboBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                if (jComboBox.getSelectedIndex() == 0) {
                    return;
                }
                if (jComboBox.getItemCount() == 0) {
                    return;
                }
                String string = "Making this change will cause the catalog to be sorted by\nthe chosen attribute. A side effect of making this change is\nthat any objects currently appearing in the catalog as a result\nof interoperation will be temporarily removed until the next\ninteroperation update. Proceed with this change?";
                Object[] objectArray = new Object[]{"Yes", "No"};
                int n = JOptionPane.showOptionDialog(ribInterface, string, "Confirm new primary attribute", -1, 3, null, objectArray, objectArray[0]);
                if (n == 0) {
                    this.setCursor(waitCursor);
                    this.showStatus("Accessing network...");
                    jButton6.setVisible(false);
                    jButton5.setEnabled(true);
                    jComboBox.setVisible(false);
                    String string2 = (String)jComboBox.getSelectedItem();
                    String string3 = ribComm.changePrimClass(ribCatalogInfo2.getPrimaryClass(), string2);
                    if (string3.equals("ok")) {
                        ribCatalogInfo2.setPrimaryAttribute(string2);
                        jLabel2.setText("Primary attribute is " + ribCatalogInfo2.getPrimaryAttribute());
                        jPanel2.setMaximumSize(jPanel2.getPreferredSize());
                        jPanel2.revalidate();
                    } else {
                        this.showAlert(string3);
                    }
                    this.setCursor(defaultCursor);
                    this.showStatus("");
                } else if (n == 1) {
                    jButton5.setEnabled(true);
                    jButton6.setVisible(false);
                    jComboBox.setVisible(false);
                }
            }
        });
        jPanel2.setAlignmentX(0.0f);
        this.catalogPanel.add(Box.createRigidArea(new Dimension(5, 5)));
        jPanel.setMaximumSize(jPanel.getMinimumSize());
        this.catalogPanel.add(jPanel);
        jPanel.revalidate();
        this.catalogPanel.add(Box.createRigidArea(new Dimension(5, 5)));
        jPanel2.setMaximumSize(jPanel2.getPreferredSize());
        this.catalogPanel.add(jPanel2);
        jPanel2.revalidate();
        ButtonGroup buttonGroup = new ButtonGroup();
        final JRadioButton jRadioButton = new JRadioButton("Yes");
        final JRadioButton jRadioButton2 = new JRadioButton("No");
        if (ribCatalogInfo2.isObjectApprovalRequired()) {
            jRadioButton.setSelected(true);
            jRadioButton2.setSelected(false);
        } else {
            jRadioButton.setSelected(false);
            jRadioButton2.setSelected(true);
        }
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!jRadioButton2.isSelected() && !ribCatalogInfo2.isObjectApprovalRequired()) {
                    this.setCursor(waitCursor);
                    this.showStatus("Accessing network...");
                    String string = ribComm.objectApprovalRequired(true);
                    if (!string.equals("ok")) {
                        this.showAlert(string);
                        jRadioButton2.setSelected(true);
                    } else {
                        ribCatalogInfo2.setObjectApprovalRequired(true);
                    }
                    this.setCursor(defaultCursor);
                    this.showStatus("");
                }
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!jRadioButton.isSelected() && ribCatalogInfo2.isObjectApprovalRequired()) {
                    this.setCursor(waitCursor);
                    this.showStatus("Accessing network");
                    String string = ribComm.objectApprovalRequired(false);
                    if (!string.equals("ok")) {
                        this.showAlert(string);
                        jRadioButton.setSelected(true);
                    } else {
                        ribCatalogInfo2.setObjectApprovalRequired(false);
                    }
                    this.setCursor(defaultCursor);
                    this.showStatus("");
                }
            }
        });
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        JPanel jPanel3 = new JPanel();
        JLabel jLabel3 = new JLabel("Require object approval?     ");
        jPanel3.add(jLabel3);
        jPanel3.add(jRadioButton);
        jPanel3.add(jRadioButton2);
        jPanel3.setAlignmentX(0.0f);
        jPanel3.setMaximumSize(jPanel3.getPreferredSize());
        this.catalogPanel.add(jPanel3);
        jPanel3.revalidate();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        final JRadioButton jRadioButton3 = new JRadioButton("Yes");
        final JRadioButton jRadioButton4 = new JRadioButton("No");
        if (ribCatalogInfo2.isJoinEnabled()) {
            jRadioButton3.setSelected(true);
            jRadioButton4.setSelected(false);
        } else {
            jRadioButton3.setSelected(false);
            jRadioButton4.setSelected(true);
        }
        jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!jRadioButton4.isSelected() && !ribCatalogInfo2.isJoinEnabled()) {
                    this.setCursor(waitCursor);
                    this.showStatus("Accessing network");
                    String string = ribComm.enableJoin(true);
                    if (!string.equals("ok")) {
                        this.showAlert(string);
                        jRadioButton4.setSelected(true);
                    } else {
                        ribCatalogInfo2.setJoinEnabled(true);
                    }
                    this.setCursor(defaultCursor);
                    this.showStatus("");
                }
            }
        });
        jRadioButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!jRadioButton3.isSelected() && ribCatalogInfo2.isJoinEnabled()) {
                    this.setCursor(waitCursor);
                    this.showStatus("Accessing network");
                    String string = ribComm.enableJoin(false);
                    if (!string.equals("ok")) {
                        this.showAlert(string);
                        jRadioButton3.setSelected(true);
                    } else {
                        ribCatalogInfo2.setJoinEnabled(false);
                    }
                    this.setCursor(defaultCursor);
                    this.showStatus("");
                }
            }
        });
        buttonGroup2.add(jRadioButton3);
        buttonGroup2.add(jRadioButton4);
        JPanel jPanel4 = new JPanel();
        JLabel jLabel4 = new JLabel("Enable joins?");
        jLabel4.setPreferredSize(jLabel3.getPreferredSize());
        jPanel4.add(jLabel4);
        jPanel4.add(jRadioButton3);
        jPanel4.add(jRadioButton4);
        jPanel4.setAlignmentX(0.0f);
        jPanel4.setMaximumSize(jPanel4.getPreferredSize());
        this.catalogPanel.add(jPanel4);
        jPanel4.revalidate();
        ButtonGroup buttonGroup3 = new ButtonGroup();
        final JRadioButton jRadioButton5 = new JRadioButton("Yes");
        final JRadioButton jRadioButton6 = new JRadioButton("No");
        if (ribCatalogInfo2.isWhatsNewEnabled()) {
            jRadioButton5.setSelected(true);
            jRadioButton6.setSelected(false);
        } else {
            jRadioButton5.setSelected(false);
            jRadioButton6.setSelected(true);
        }
        jRadioButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!jRadioButton6.isSelected() && !ribCatalogInfo2.isWhatsNewEnabled()) {
                    this.setCursor(waitCursor);
                    this.showStatus("Accessing network");
                    String string = ribComm.enableWhatsNew(true);
                    if (!string.equals("ok")) {
                        this.showAlert(string);
                        jRadioButton6.setSelected(true);
                    } else {
                        ribCatalogInfo2.setWhatsNewEnabled(true);
                    }
                    this.showStatus("");
                    this.setCursor(defaultCursor);
                }
            }
        });
        jRadioButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!jRadioButton5.isSelected() && ribCatalogInfo2.isWhatsNewEnabled()) {
                    this.setCursor(waitCursor);
                    this.showStatus("Accessing network");
                    String string = ribComm.enableWhatsNew(false);
                    if (!string.equals("ok")) {
                        this.showAlert(string);
                        jRadioButton5.setSelected(true);
                    } else {
                        ribCatalogInfo2.setWhatsNewEnabled(false);
                    }
                    this.setCursor(defaultCursor);
                    this.showStatus("");
                }
            }
        });
        buttonGroup3.add(jRadioButton5);
        buttonGroup3.add(jRadioButton6);
        JPanel jPanel5 = new JPanel();
        JLabel jLabel5 = new JLabel("Enable \"What's New\"?");
        jLabel5.setPreferredSize(jLabel3.getPreferredSize());
        jPanel5.add(jLabel5);
        jPanel5.add(jRadioButton5);
        jPanel5.add(jRadioButton6);
        jPanel5.setAlignmentX(0.0f);
        jPanel5.setMaximumSize(jPanel5.getPreferredSize());
        this.catalogPanel.add(jPanel5);
        jPanel5.revalidate();
        JButton jButton7 = new JButton("  Catalog Password...  ");
        jButton7.addMouseListener(new ButtonPushMouseListener(jButton7));
        jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RibInterface.this.setCursor(RibInterface.this.waitCursor);
                RibInterface.this.showStatus("Accessing network...");
                String string = RibInterface.this.ribComm.getCatalogPasswd();
                RibInterface.this.setCursor(RibInterface.this.defaultCursor);
                RibInterface.this.showStatus("");
                String string2 = RibUtil.getAlphanumericsymbolDialogInput("Catalog password:", 12, RibInterface.this.getContentPane(), string);
                if (string2 == null) {
                    return;
                }
                if (!string2.equals(string)) {
                    RibInterface.this.setCursor(RibInterface.this.waitCursor);
                    RibInterface.this.showStatus("Accessing network...");
                    String string3 = RibInterface.this.ribComm.setCatalogPasswd(string2);
                    if (!string3.equals("ok")) {
                        RibInterface.this.showAlert(string3);
                    }
                    RibInterface.this.setCursor(RibInterface.this.defaultCursor);
                    RibInterface.this.showStatus("");
                }
            }
        });
        JPanel jPanel6 = new JPanel();
        jPanel6.add(jButton7);
        jPanel6.setAlignmentX(0.0f);
        jPanel6.setMaximumSize(jPanel6.getPreferredSize());
        this.catalogPanel.add(jPanel6);
        jPanel6.revalidate();
    }

    public void initHelpPanel() {
        this.helpPanel.setLayout(new GridLayout(1, 1));
        RibHelpPane ribHelpPane = new RibHelpPane(this);
        this.helpPanel.add(ribHelpPane);
        ribHelpPane.revalidate();
    }

    private void initInteropPanel() {
        this.showInteropList();
    }

    public void initObjectsPanel() {
        this.showStatus("Accessing network ...");
        this.setCursor(this.waitCursor);
        this.objectsPanel.removeAll();
        this.objectsPanel.repaint();
        RibConfig ribConfig = new RibConfig(this.configUrl);
        ribConfig.parse();
        if (ribConfig.getClassNames(false).size() == 0) {
            this.showAlert("Error : Cannot parse repository data model");
        } else {
            JPanel jPanel = new JPanel(new FlowLayout(0));
            JLabel jLabel = new JLabel("Class :");
            jPanel.add(jLabel);
            Vector vector = ribConfig.getClassNames(false);
            JComboBox jComboBox = new JComboBox(vector);
            jComboBox.setSelectedIndex(-1);
            jComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RibInterface.this.showObjectsList();
                }
            });
            jComboBox.setBackground(Color.white);
            jComboBox.setMaximumRowCount(jComboBox.getItemCount());
            jPanel.add(jComboBox);
            HelpButton helpButton = new HelpButton("manage_objects.html", this.ribInterface);
            helpButton.setMaximumSize(new Dimension(helpButton.getPreferredSize().width, jComboBox.getPreferredSize().height));
            helpButton.setToolTipText("Display help on managing objects");
            jPanel.add(helpButton);
            this.objectsPanel.add((Component)jPanel, "North");
            jPanel.revalidate();
        }
        this.setCursor(this.defaultCursor);
        this.showStatus("");
    }

    public void initPropertiesPanel() {
        this.propertiesPanel.removeAll();
        this.propertiesPanel.repaint();
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel("Action :");
        jPanel.add(jLabel);
        String[] stringArray = new String[]{"Data Model Editor", "Change Name", "Change Contact", "Change Password"};
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedIndex(-1);
        jComboBox.addActionListener(new PropertiesActionChosen());
        jComboBox.setBackground(Color.white);
        jPanel.add(jComboBox);
        HelpButton helpButton = new HelpButton("repo_properties.html", this.ribInterface);
        helpButton.setMaximumSize(new Dimension(helpButton.getPreferredSize().width, jComboBox.getPreferredSize().height));
        helpButton.setToolTipText("Display help on repository properties");
        jPanel.add(helpButton);
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        jPanel.setAlignmentX(0.0f);
        this.propertiesPanel.add(jPanel);
        jPanel.revalidate();
    }

    void mainPanel_stateChanged(ChangeEvent changeEvent) {
        Object[] objectArray;
        String string;
        int n;
        RibConfigEditor ribConfigEditor;
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        JPanel jPanel = (JPanel)jTabbedPane.getSelectedComponent();
        if (jPanel != this.propertiesPanel && this.propertiesPanel.getComponentCount() == 2 && this.propertiesPanel.getComponent(1) instanceof RibConfigEditor && (ribConfigEditor = (RibConfigEditor)this.propertiesPanel.getComponent(1)).am_dirty() && (n = JOptionPane.showOptionDialog(this.ribInterface, string = "The data model being edited in the Properties panel has not been saved.\nWould you like to save the data model at this time?", "Confirm", -1, 3, null, objectArray = new String[]{"Yes", "No"}, objectArray[0])) == 0) {
            jTabbedPane.setSelectedComponent(this.propertiesPanel);
            ribConfigEditor.saveButton.doClick();
        }
        if (jPanel == this.helpPanel) {
            if (this.helpPanel.getComponentCount() == 0) {
                this.initHelpPanel();
            }
        } else if (jPanel == this.objectsPanel) {
            if (this.objectsPanel.getComponentCount() == 0) {
                this.initObjectsPanel();
            }
        } else if (jPanel == this.catalogPanel) {
            this.initCatalogPanel();
        } else if (jPanel == this.interopPanel) {
            if (this.interopPanel.getComponentCount() == 0) {
                this.initInteropPanel();
            }
        } else if (jPanel == this.propertiesPanel && this.propertiesPanel.getComponentCount() == 0) {
            this.initPropertiesPanel();
        }
    }

    public void showAlert(final String string) {
        SwingUtilities.invokeLater(new Thread(){

            public void run() {
                JOptionPane.showMessageDialog(ribInterface, string, "Alert", 0);
            }
        });
    }

    public void showInteropList() {
        this.interopPanel.removeAll();
        this.interopPanel.repaint();
        this.setCursor(this.waitCursor);
        this.showStatus("Accessing network...");
        RibInteropShell ribInteropShell = new RibInteropShell(this.ribInterface, this.ribComm);
        this.interopPanel.add((Component)ribInteropShell, "Center");
        ribInteropShell.revalidate();
        this.interopPanel.revalidate();
        this.interopPanel.repaint();
        this.setCursor(this.defaultCursor);
        this.showStatus("");
    }

    public void showObjectsList() {
        this.objectsPanel.repaint();
        JPanel jPanel = (JPanel)this.objectsPanel.getComponent(0);
        JComboBox jComboBox = (JComboBox)jPanel.getComponent(1);
        String string = (String)jComboBox.getSelectedItem();
        this.setCursor(this.waitCursor);
        this.showStatus("Accessing network...");
        RibObjectBrowser ribObjectBrowser = new RibObjectBrowser(this.ribInterface, this.ribComm, string);
        this.objectsPanel.add((Component)ribObjectBrowser, "Center");
        ribObjectBrowser.revalidate();
        this.objectsPanel.revalidate();
        this.objectsPanel.repaint();
        this.setCursor(this.defaultCursor);
        this.showStatus("");
        try {
            this.objectsPanel.remove(0);
        }
        catch (Exception exception) {}
    }

    public void showObjectsList(String string) {
        try {
            this.objectsPanel.remove(0);
        }
        catch (Exception exception) {}
        this.objectsPanel.repaint();
        this.setCursor(this.waitCursor);
        this.showStatus("Accessing network...");
        RibObjectBrowser ribObjectBrowser = new RibObjectBrowser(this.ribInterface, this.ribComm, string);
        this.objectsPanel.add((Component)ribObjectBrowser, "Center");
        ribObjectBrowser.revalidate();
        this.objectsPanel.revalidate();
        this.objectsPanel.repaint();
        this.setCursor(this.defaultCursor);
        this.showStatus("");
    }

    class MyGlassPane
    extends JComponent {
        public MyGlassPane() {
            this.addMouseListener(new MouseAdapter(){});
        }
    }

    class SymChange
    implements ChangeListener {
        SymChange() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object == RibInterface.this.mainPanel) {
                RibInterface.this.mainPanel_stateChanged(changeEvent);
            }
        }
    }

    class PropertiesActionChosen
    implements ActionListener {
        PropertiesActionChosen() {
        }

        static /* synthetic */ RibInterface access$0(PropertiesActionChosen propertiesActionChosen) {
            return propertiesActionChosen.RibInterface.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = RibInterface.this.propertiesPanel.getComponentCount() - 1;
            while (n > 0) {
                RibInterface.this.propertiesPanel.remove(n);
                --n;
            }
            RibInterface.this.propertiesPanel.repaint();
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            String string = (String)jComboBox.getSelectedItem();
            if (string.equals("Data Model Editor")) {
                RibInterface.this.setCursor(RibInterface.this.waitCursor);
                RibInterface.this.showStatus("Accessing network");
                RibConfig ribConfig = new RibConfig(RibInterface.this.configUrl);
                ribConfig.parse();
                if (ribConfig.getClassNames(false).size() == 0) {
                    JPanel jPanel = new JPanel(new GridLayout());
                    JLabel jLabel = new JLabel("Error: Cannot parse data model. " + ribConfig.errorMsg);
                    jPanel.add(jLabel);
                    RibInterface.this.propertiesPanel.add(jPanel);
                    jLabel.revalidate();
                } else {
                    RibConfigEditor ribConfigEditor = new RibConfigEditor(ribConfig, RibInterface.this.ribComm, RibInterface.this.ribInterface);
                    ribConfigEditor.setAlignmentX(0.0f);
                    RibInterface.this.propertiesPanel.add(ribConfigEditor);
                    ribConfigEditor.revalidate();
                }
                RibInterface.this.setCursor(RibInterface.this.defaultCursor);
                RibInterface.this.showStatus("");
            } else if (string.equals("Change Name")) {
                RibInterface.this.setCursor(RibInterface.this.waitCursor);
                RibInterface.this.showStatus("Accessing network...");
                RibCatalogInfo ribCatalogInfo = null;
                try {
                    ribCatalogInfo = RibInterface.this.ribComm.getCatalogInfo();
                }
                catch (Exception exception) {
                    RibInterface.this.showAlert(exception.toString());
                }
                RibInterface.this.setCursor(RibInterface.this.defaultCursor);
                RibInterface.this.showStatus("");
                if (ribCatalogInfo == null) {
                    return;
                }
                RibCatalogInfo ribCatalogInfo2 = ribCatalogInfo;
                JPanel jPanel = new JPanel(new FlowLayout(0));
                JLabel jLabel = new JLabel("New Name :");
                jPanel.add(jLabel);
                jPanel.add(Box.createHorizontalStrut(5));
                JTextField jTextField = new JTextField(ribCatalogInfo2.getName(), 30);
                jTextField.setBorder(new BevelBorder(1));
                jPanel.add(jTextField);
                jPanel.setAlignmentX(0.0f);
                jPanel.setMaximumSize(jPanel.getPreferredSize());
                RibInterface.this.propertiesPanel.add(jPanel);
                jPanel.revalidate();
                JPanel jPanel2 = new JPanel(new FlowLayout(0, 3, 3));
                JButton jButton = new JButton("  Submit  ");
                jButton.addActionListener(new ActionListener(jTextField, this){
                    private final /* synthetic */ JTextField val$jtf;
                    private final /* synthetic */ PropertiesActionChosen this$1;
                    {
                        this.val$jtf = jTextField;
                        this.this$1 = propertiesActionChosen;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        PropertiesActionChosen.access$0(this.this$1).setCursor(PropertiesActionChosen.access$0((PropertiesActionChosen)this.this$1).waitCursor);
                        PropertiesActionChosen.access$0(this.this$1).showStatus("Accessing network...");
                        String string = PropertiesActionChosen.access$0((PropertiesActionChosen)this.this$1).ribComm.changeName(this.val$jtf.getText());
                        if (string.equals("ok")) {
                            PropertiesActionChosen.access$0(this.this$1).initPropertiesPanel();
                        } else {
                            PropertiesActionChosen.access$0(this.this$1).showAlert(string);
                        }
                        PropertiesActionChosen.access$0(this.this$1).setCursor(PropertiesActionChosen.access$0((PropertiesActionChosen)this.this$1).defaultCursor);
                        PropertiesActionChosen.access$0(this.this$1).showStatus("");
                    }
                });
                jButton.setEnabled(false);
                jButton.addMouseListener(new ButtonPushMouseListener(jButton));
                jPanel2.add(jButton);
                JButton jButton2 = new JButton("  Cancel  ");
                jButton2.addActionListener(new ActionListener(this){
                    private final /* synthetic */ PropertiesActionChosen this$1;
                    {
                        this.this$1 = propertiesActionChosen;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        PropertiesActionChosen.access$0(this.this$1).initPropertiesPanel();
                    }
                });
                jButton2.addMouseListener(new ButtonPushMouseListener(jButton2));
                jPanel2.add(jButton2);
                jPanel2.setMaximumSize(jPanel2.getPreferredSize());
                jPanel2.setAlignmentX(0.0f);
                RibInterface.this.propertiesPanel.add(jPanel2);
                jTextField.getDocument().addDocumentListener(new EnsureNonemptyDocumentListener(jButton));
                jTextField.requestFocus();
            } else if (string.equals("Change Contact")) {
                RibInterface.this.setCursor(RibInterface.this.waitCursor);
                RibInterface.this.showStatus("Accessing network...");
                RibCatalogInfo ribCatalogInfo = null;
                try {
                    ribCatalogInfo = RibInterface.this.ribComm.getCatalogInfo();
                }
                catch (Exception exception) {
                    RibInterface.this.showAlert(exception.toString());
                }
                RibInterface.this.setCursor(RibInterface.this.defaultCursor);
                RibInterface.this.showStatus("");
                if (ribCatalogInfo == null) {
                    return;
                }
                RibCatalogInfo ribCatalogInfo3 = ribCatalogInfo;
                JPanel jPanel = new JPanel(new FlowLayout(0));
                JLabel jLabel = new JLabel("New Contact Address :");
                jPanel.add(jLabel);
                jPanel.add(Box.createHorizontalStrut(5));
                JTextField jTextField = new JTextField(ribCatalogInfo3.getContact(), 30);
                JButton jButton = new JButton("  Submit  ");
                jTextField.setBorder(new BevelBorder(1));
                jPanel.add(jTextField);
                jPanel.setAlignmentX(0.0f);
                jPanel.setMaximumSize(jPanel.getPreferredSize());
                RibInterface.this.propertiesPanel.add(jPanel);
                jPanel.revalidate();
                JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
                jButton.addActionListener(new ActionListener(jTextField, this){
                    private final /* synthetic */ JTextField val$jtf;
                    private final /* synthetic */ PropertiesActionChosen this$1;
                    {
                        this.val$jtf = jTextField;
                        this.this$1 = propertiesActionChosen;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        PropertiesActionChosen.access$0(this.this$1).setCursor(PropertiesActionChosen.access$0((PropertiesActionChosen)this.this$1).waitCursor);
                        PropertiesActionChosen.access$0(this.this$1).showStatus("Accessing network...");
                        String string = PropertiesActionChosen.access$0((PropertiesActionChosen)this.this$1).ribComm.changeContact(this.val$jtf.getText());
                        if (string.equals("ok")) {
                            PropertiesActionChosen.access$0(this.this$1).initPropertiesPanel();
                        } else {
                            PropertiesActionChosen.access$0(this.this$1).showAlert(string);
                        }
                        PropertiesActionChosen.access$0(this.this$1).setCursor(PropertiesActionChosen.access$0((PropertiesActionChosen)this.this$1).defaultCursor);
                        PropertiesActionChosen.access$0(this.this$1).showStatus("");
                    }
                });
                jButton.setEnabled(false);
                jButton.addMouseListener(new ButtonPushMouseListener(jButton));
                jPanel3.add(jButton);
                JButton jButton3 = new JButton("  Cancel  ");
                jButton3.addActionListener(new ActionListener(this){
                    private final /* synthetic */ PropertiesActionChosen this$1;
                    {
                        this.this$1 = propertiesActionChosen;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        PropertiesActionChosen.access$0(this.this$1).initPropertiesPanel();
                    }
                });
                jButton3.addMouseListener(new ButtonPushMouseListener(jButton3));
                jPanel3.add(jButton3);
                jPanel3.setMaximumSize(jPanel3.getPreferredSize());
                jPanel3.setAlignmentX(0.0f);
                RibInterface.this.propertiesPanel.add(jPanel3);
                jTextField.getDocument().addDocumentListener(new EnsureNonemptyDocumentListener(jButton));
                jTextField.requestFocus();
            } else if (string.equals("Change Password")) {
                JPanel jPanel = new JPanel(new FlowLayout(0));
                JLabel jLabel = new JLabel("New Password :");
                jPanel.add(jLabel);
                jPanel.add(Box.createHorizontalStrut(5));
                JTextField jTextField = new JTextField(30);
                jTextField.setBorder(new BevelBorder(1));
                jPanel.add(jTextField);
                jPanel.setAlignmentX(0.0f);
                jPanel.setMaximumSize(jPanel.getPreferredSize());
                RibInterface.this.propertiesPanel.add(jPanel);
                jPanel.revalidate();
                JPanel jPanel4 = new JPanel(new FlowLayout(0, 5, 5));
                JButton jButton = new JButton("  Submit  ");
                jButton.addActionListener(new ActionListener(jTextField, this){
                    private final /* synthetic */ JTextField val$jtf;
                    private final /* synthetic */ PropertiesActionChosen this$1;
                    {
                        this.val$jtf = jTextField;
                        this.this$1 = propertiesActionChosen;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        PropertiesActionChosen.access$0(this.this$1).setCursor(PropertiesActionChosen.access$0((PropertiesActionChosen)this.this$1).waitCursor);
                        PropertiesActionChosen.access$0(this.this$1).showStatus("Accessing network...");
                        if (this.val$jtf.getText().length() < 6) {
                            PropertiesActionChosen.access$0(this.this$1).showAlert("Passwords should be at least six characters");
                            return;
                        }
                        String string = PropertiesActionChosen.access$0((PropertiesActionChosen)this.this$1).ribComm.changePasswd(this.val$jtf.getText());
                        if (string.equals("ok")) {
                            PropertiesActionChosen.access$0((PropertiesActionChosen)this.this$1).repoPasswd = this.val$jtf.getText();
                            PropertiesActionChosen.access$0(this.this$1).initPropertiesPanel();
                        } else {
                            PropertiesActionChosen.access$0(this.this$1).showAlert(string);
                        }
                        PropertiesActionChosen.access$0(this.this$1).setCursor(PropertiesActionChosen.access$0((PropertiesActionChosen)this.this$1).defaultCursor);
                        PropertiesActionChosen.access$0(this.this$1).showStatus("");
                    }
                });
                jButton.setEnabled(false);
                jButton.addMouseListener(new ButtonPushMouseListener(jButton));
                jPanel4.add(jButton);
                JButton jButton4 = new JButton("  Cancel  ");
                jButton4.addActionListener(new ActionListener(this){
                    private final /* synthetic */ PropertiesActionChosen this$1;
                    {
                        this.this$1 = propertiesActionChosen;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        PropertiesActionChosen.access$0(this.this$1).initPropertiesPanel();
                    }
                });
                jButton4.addMouseListener(new ButtonPushMouseListener(jButton4));
                jPanel4.add(jButton4);
                jPanel4.setMaximumSize(jPanel4.getPreferredSize());
                jPanel4.setAlignmentX(0.0f);
                RibInterface.this.propertiesPanel.add(jPanel4);
                jTextField.getDocument().addDocumentListener(new EnsureNonemptyDocumentListener(jButton));
                jTextField.requestFocus();
            }
        }
    }

    class EnsureNonemptyDocumentListener
    implements DocumentListener {
        JButton button;

        EnsureNonemptyDocumentListener(JButton jButton) {
            this.button = jButton;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (documentEvent.getDocument().getLength() == 0) {
                this.button.setEnabled(false);
            } else if (documentEvent.getDocument().getLength() > 0) {
                this.button.setEnabled(true);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }
    }
}

