/*
 * Decompiled with CFR 0.152.
 */
package org.nhse.rib;

import java.util.Enumeration;
import java.util.Vector;
import org.nhse.rib.RibAttribute;
import org.nhse.rib.RibRelationship;
import org.nhse.rib.RibUtil;

public class RibClass {
    private String name = null;
    private String ext = null;
    private Vector attributes = new Vector();
    private Vector relationships = new Vector();
    private RibClass parentClass = null;

    public void addAttribute(RibAttribute ribAttribute) {
        this.attributes.addElement(ribAttribute);
    }

    public void addRelationship(RibRelationship ribRelationship) {
        this.relationships.addElement(ribRelationship);
    }

    public boolean checkForAttribute(String string) {
        RibAttribute ribAttribute;
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            ribAttribute = (RibAttribute)enumeration.nextElement();
            if (!ribAttribute.getName().equals(string)) continue;
            return true;
        }
        ribAttribute = this.parentClass.getAttribute(string);
        return ribAttribute != null;
    }

    public boolean checkForRelationship(String string) {
        RibRelationship ribRelationship;
        Enumeration enumeration = this.relationships.elements();
        while (enumeration.hasMoreElements()) {
            ribRelationship = (RibRelationship)enumeration.nextElement();
            if (!ribRelationship.getName().equals(string)) continue;
            return true;
        }
        ribRelationship = this.parentClass.getRelationship(string);
        return ribRelationship != null;
    }

    public RibAttribute getAttribute(String string) {
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            RibAttribute ribAttribute = (RibAttribute)enumeration.nextElement();
            if (!ribAttribute.getName().equals(string)) continue;
            return ribAttribute;
        }
        if (this.parentClass != null) {
            return this.parentClass.getAttribute(string);
        }
        return null;
    }

    public Vector getAttributeNames() {
        Vector vector = this.getAttributes();
        Vector<String> vector2 = new Vector<String>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            vector2.addElement(((RibAttribute)enumeration.nextElement()).getName());
        }
        return RibUtil.sortStringVector(vector2);
    }

    public Vector getAttributes() {
        if (this.parentClass == null) {
            return this.attributes;
        }
        Vector vector = (Vector)this.attributes.clone();
        Vector vector2 = this.getNativeAttributeNames();
        Enumeration enumeration = this.parentClass.getAttributes().elements();
        while (enumeration.hasMoreElements()) {
            RibAttribute ribAttribute = (RibAttribute)enumeration.nextElement();
            if (vector2.indexOf(ribAttribute.getName()) != -1) continue;
            vector.addElement(ribAttribute);
        }
        return vector;
    }

    public String getExtends() {
        return this.ext;
    }

    public String getName() {
        return this.name;
    }

    public Vector getNativeAttributeNames() {
        Vector<String> vector = new Vector<String>(this.attributes.size());
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((RibAttribute)enumeration.nextElement()).getName());
        }
        return RibUtil.sortStringVector(vector);
    }

    public Vector getNativeAttributes() {
        return this.attributes;
    }

    public Vector getNativeAttributes(boolean bl) {
        if (bl) {
            Vector<RibAttribute> vector = new Vector<RibAttribute>(this.attributes.size());
            Enumeration enumeration = this.getNativeAttributeNames().elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                vector.addElement(this.getAttribute(string));
            }
            return vector;
        }
        return this.attributes;
    }

    public Vector getNativeRelationshipNames() {
        Vector<String> vector = new Vector<String>(this.relationships.size());
        Enumeration enumeration = this.relationships.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((RibRelationship)enumeration.nextElement()).getName());
        }
        return RibUtil.sortStringVector(vector);
    }

    public Vector getNativeRelationships() {
        return this.relationships;
    }

    public Vector getNativeRelationships(boolean bl) {
        if (bl) {
            Vector<RibRelationship> vector = new Vector<RibRelationship>(this.relationships.size());
            Enumeration enumeration = this.getNativeRelationshipNames().elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                vector.addElement(this.getRelationship(string));
            }
            return vector;
        }
        return this.relationships;
    }

    public RibClass getParentClass() {
        return this.parentClass;
    }

    public RibRelationship getRelationship(String string) {
        Enumeration enumeration = this.relationships.elements();
        while (enumeration.hasMoreElements()) {
            RibRelationship ribRelationship = (RibRelationship)enumeration.nextElement();
            if (!ribRelationship.getName().equals(string)) continue;
            return ribRelationship;
        }
        if (this.parentClass != null) {
            return this.parentClass.getRelationship(string);
        }
        return null;
    }

    public Vector getRelationshipNames() {
        Vector vector = this.getRelationships();
        Vector<String> vector2 = new Vector<String>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            vector2.addElement(((RibRelationship)enumeration.nextElement()).getName());
        }
        return RibUtil.sortStringVector(vector2);
    }

    public Vector getRelationships() {
        if (this.parentClass == null) {
            return this.relationships;
        }
        Vector vector = (Vector)this.relationships.clone();
        Vector vector2 = this.getNativeRelationshipNames();
        Enumeration enumeration = this.parentClass.getRelationships().elements();
        while (enumeration.hasMoreElements()) {
            RibRelationship ribRelationship = (RibRelationship)enumeration.nextElement();
            if (vector2.indexOf(ribRelationship.getName()) != -1) continue;
            vector.addElement(ribRelationship);
        }
        return vector;
    }

    public void removeAttribute(RibAttribute ribAttribute) {
        this.attributes.removeElement(ribAttribute);
    }

    public void removeRelationship(RibRelationship ribRelationship) {
        this.relationships.removeElement(ribRelationship);
    }

    public void setExtends(String string) {
        if (string != null) {
            this.ext = new String(string);
        }
    }

    public void setName(String string) {
        if (string != null) {
            this.name = new String(string);
        }
    }

    public void setParentClass(RibClass ribClass) {
        this.parentClass = ribClass;
    }

    public String toString() {
        String string = new String();
        string = String.valueOf(string) + this.name + " extends " + this.ext + "\n";
        string = String.valueOf(string) + "------------------------\n";
        int n = 0;
        while (n < this.attributes.size()) {
            RibAttribute ribAttribute = (RibAttribute)this.attributes.elementAt(n);
            string = String.valueOf(string) + ribAttribute.toString() + "\n";
            ++n;
        }
        int n2 = 0;
        while (n2 < this.relationships.size()) {
            RibRelationship ribRelationship = (RibRelationship)this.relationships.elementAt(n2);
            string = String.valueOf(string) + ribRelationship.toString() + "\n";
            ++n2;
        }
        string = String.valueOf(string) + "\n";
        return string;
    }
}

