####################################
package RIB::WhatsNew;
use strict;
use DBI;
use RIB::Util;
use RIB::VocabularyTerm;
use RIB::Parser;

sub new {
  my $proto = shift;
  my $class = ref($proto) || $proto;
  my $self  = {
    'DBH' => undef,
    'REPO_HANDLE' => undef,
    'CONFIG' => undef,
    'PRIMARY_ATTR' => undef,
    'PRIMARY_CLASS' => undef
  };
  bless ($self, $class);
  return $self;
}

sub dbh {
  my $self = shift;
  if (@_) { $self->{'DBH'} = shift; }
  return $self->{'DBH'};
}

sub repoHandle {
  my $self = shift;
  if (@_) { $self->{'REPO_HANDLE'} = shift; }
  return $self->{'REPO_HANDLE'};
}

sub config {
  my $self = shift;
  if (@_) { $self->{'CONFIG'} = shift; }
  return $self->{'CONFIG'};
}

sub primAttr {
  my $self = shift;
  if (@_) { $self->{'PRIMARY_ATTRIBUTE'} = shift; }
  return $self->{'PRIMARY_ATTRIBUTE'};
}

sub primClass {
  my $self = shift;
  if (@_) { $self->{'PRIMARY_CLASS'} = shift; }
  return $self->{'PRIMARY_CLASS'};
}

sub whats_new {
  my ($self,$days) = @_;
  $days ||= 30;
  my $util = new RIB::Util;
  my $ribdir = $util->RibDir;
  my $riburl = $util->RibUrl;

  # get catalog info
  my $sth = $self->dbh->prepare("SELECT primary_class, name, contact, object_approval_required, whats_new_enabled FROM repositories WHERE handle=" . $self->repoHandle());
  eval { $sth->execute(); };
  if ($@) { $util->error($@); }
  my $catalog_info = $sth->fetchrow_hashref();
  my $repoHandle = $self->repoHandle();
  my $primClass = $catalog_info->{'primary_class'};
  my $name = $catalog_info->{'name'};
  my $contact = $catalog_info->{'contact'};
  my $prefix = "$riburl/object.pl?rh=$repoHandle&class=$primClass&html=1&oh=";

  if ($days !~ /^\d+/ or $days>500) {
    $util->error("Bad argument : $days");
  }
  if (!($catalog_info->{'whats_new_enabled'})) {
    $util->error("The \"What's New\" feature is not enabled for this repository");
  }

  my @entries = ();

  if ($catalog_info->{'object_approval_required'}) {
    $sth = $self->dbh->prepare("SELECT Name_, handle, date_format(created, '%W, %M %d %Y'),created FROM $repoHandle\_$primClass WHERE TO_DAYS(NOW()) - TO_DAYS(created) <= $days AND approved=1 AND handle IS NOT NULL ORDER BY created DESC");
  } else {
    $sth = $self->dbh->prepare("SELECT Name_, handle, date_format(created, '%W, %M %d %Y'),created FROM $repoHandle\_$primClass WHERE TO_DAYS(NOW()) - TO_DAYS(created) <= $days AND handle IS NOT NULL ORDER BY created DESC");
  }
  eval { $sth->execute(); };
  if ($@) { $util->error("Can't create what's new page. $@"); }
  while (my $row = $sth->fetchrow_arrayref()) {
    push (@entries,[$row->[0],$prefix.$row->[1],$row->[2],$row->[3]]);
  }
  # interop entries
  $sth = $self->dbh->prepare("SELECT DISTINCT Name_, url, date_format(created, '%W, %M %d %Y'),created FROM $repoHandle\_interop_objects WHERE TO_DAYS(NOW()) - TO_DAYS(created) <= $days ORDER BY created DESC");
  eval { $sth->execute(); };
  if ($@) { $util->error("Can't create what's new page. $@"); }
  while (my $row = $sth->fetchrow_arrayref()) {
    my $url = $row->[1];
    #unless ($url =~ s,(rib/repositories/[^/]+/)objects/,${1}catalog/,) {
    unless ($url =~ m,rib/repositories/[^/]+/objects/,) {
      $url .= "&html=1";
    }
    push (@entries,[$row->[0],$url,$row->[2],$row->[3]]);
  }

  my $buf = << "EOF";
<P>
<FORM METHOD="POST" ACTION="$riburl/whatsNew.pl">
<STRONG>What's new in the last
<SELECT NAME="days">
  <OPTION VALUE="1">1
  <OPTION VALUE="7">7
  <OPTION VALUE="15">15
  <OPTION VALUE="30">30
  <OPTION VALUE="60">60
  <OPTION VALUE="90">90
  <OPTION VALUE="180">180
  <OPTION VALUE="365">365
</SELECT> days?</STRONG><BR>
<INPUT TYPE="SUBMIT" VALUE="Submit">
<INPUT TYPE="HIDDEN" NAME="rh" VALUE="$repoHandle">
</FORM>
<P><HR><P>
EOF
$buf =~ s/VALUE="$days"/SELECTED VALUE="$days"/;

  my $last_date = "";
  if (@entries) {
    $buf .= "<dl>\n";
    foreach my $entry (sort {$a->[3] <=> $b->[3]} @entries) {
      my $new_date = $entry->[2];
      if ($last_date ne $new_date) {
        $buf .= "<dt><strong>$new_date</strong>\n";
        $last_date = $new_date;
      }
      $buf .= "<dd><a href=\""
            . $entry->[1]
            . "\">"
            . $entry->[0]
            . "</a>\n";
    }
    $buf .= "</dl>";
  } else {
    $buf .= "No new $primClass objects have been added to this repository in the last $days days.";
  }

  # run the catalog through the template
  unless (open (TEMPLATE, "$ribdir/docRoot/$repoHandle/whats_new_template.html")) {
    $util->error("Can't open template : $!");
  }
  my $html = undef;
  while (<TEMPLATE>) {
    s/\bREPOSITORY_NAME\b/$name/g;
    s/\bREPOSITORY_CONTACT\b/$contact/g;
    s/\bSEARCH_URL\b/$riburl\/search.pl\?rh=$repoHandle/g;
    s/\bADVANCED_SEARCH_URL\b/$riburl\/advancedSearch.pl\?rh=$repoHandle/g;
    s/\bJOIN_URL\b/$riburl\/join.pl\?rh=$repoHandle/g;
    s/\bWHATS_NEW_URL\b/$riburl\/whatsNew.pl\?rh=$repoHandle/g;
    s/\bCATALOG_URL\b/$riburl\/catalog.pl\?rh=$repoHandle/g;
    s/\bDATA_MODEL_URL\b/$riburl\/$repoHandle\/config.xml/g;
    s/\bREPOSITORY_HANDLE\b/$riburl\/repository.pl\?rh=$repoHandle/g;
    s/\bABOUT_URL\b/$riburl\/about.pl\?rh=$repoHandle/g;
    s/\bRIB_LOGO\b/<A HREF="http:\/\/www.nhse.org\/RIB\/"><IMG ALIGN="CENTER" WIDTH="72" HEIGHT="82" BORDER="0" SRC="$riburl\/images\/poweredRIB.gif"><\/A>/g;
    $html.=$_;
    $html.="\n".$buf if /<!-- RIB -->/i;
  }
  return $html;
}

1;
