#BANGLINE

##############################################
use strict;
use CGI qw/:standard/;
use RIB::Util;
use XML::DOM;

##############################################

my $util = new RIB::Util();

unless (param('rh') =~ /^\d+$/) {
  $util->error("repository handle not specified in input");
}
my $rib_url = $util->RibUrl;
my $ribversion = $util->RibVersion();

$util->dbConnect();

my $table_name = param('rh') . "_interop_registry";
my $sth = $util->dbh->prepare("SELECT name,url,handle,last_attempt,last_success,"
                            . "update_interval,checkpoint,last_failure FROM "
                            . $table_name);
eval { $sth->execute(); };
if ($@) { $util->error($@); }

my $document = new XML::DOM::Document();
my $xml_decl = new XML::DOM::XMLDecl();
$xml_decl->setVersion('1.0');
$xml_decl->setStandalone('yes');
$document->setXMLDecl($xml_decl);
my $rib_element = $document->createElement('rib');
$rib_element->setAttribute('version',$ribversion);
$document->appendChild($rib_element);
my $repo_element = $document->createElement('repository');
$repo_element->setAttribute('handle',param('rh'));
$repo_element->setAttribute('config',"$rib_url/".param('rh')."/config.xml");
$rib_element->appendChild($repo_element);

while (my $row = $sth->fetchrow_hashref()) {
  my $tmp = $document->createElement('interoperation');
  $tmp->setAttribute('name',$row->{'name'});
  $tmp->setAttribute('url',$row->{'url'});
  $tmp->setAttribute('handle',$row->{'handle'});
  $tmp->setAttribute('last_attempt',$row->{'last_attempt'});
  $tmp->setAttribute('last_success',$row->{'last_success'});
  $tmp->setAttribute('update_interval',$row->{'update_interval'});
  $tmp->setAttribute('checkpoint',$row->{'checkpoint'});
  $tmp->setAttribute('last_failure',$row->{'last_failure'});
  $repo_element->appendChild($tmp);
}


print header(-type=>"text/xml"),
      $document->toString();

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
