#BANGLINE

##############################################
use strict;
use CGI qw/:standard/;
use RIB::Util;
use XML::DOM;

##############################################

my $util = new RIB::Util();

unless (param('rh') =~ /^\d+$/) {
  $util->error("repository handle not specified in input");
}
my $rib_url = $util->RibUrl;
my $ribversion = $util->RibVersion();

$util->dbConnect();
$util->authenticate(param('repoPasswd'),param('rh'));

my $sth = $util->dbh->prepare("SELECT name,contact,primary_class, primary_attribute, is_locked, join_enabled, whats_new_enabled, object_approval_required from repositories where handle=" . param('rh'));

eval { $sth->execute(); };
if ($@) { $util->error($@); }
my $row;
unless ($row = $sth->fetchrow_hashref()) {
  $util->error("Can't fetch catalog info for " . param('rh'));
}

my $document = new XML::DOM::Document();
my $xml_decl = new XML::DOM::XMLDecl();
$xml_decl->setVersion('1.0');
$xml_decl->setStandalone('yes');
$document->setXMLDecl($xml_decl);
my $rib_element = $document->createElement('rib');
$rib_element->setAttribute('version',$ribversion);
$document->appendChild($rib_element);
my $repo_element = $document->createElement('repository');
$repo_element->setAttribute('handle',param('rh'));
$repo_element->setAttribute('name',$row->{'name'});
$repo_element->setAttribute('contact',$row->{'contact'});
$repo_element->setAttribute('config',"$rib_url/".param('rh')."/config.xml");
$repo_element->setAttribute('primary_class',$row->{'primary_class'});
$repo_element->setAttribute('primary_attribute',$row->{'primary_attribute'});
$repo_element->setAttribute('is_locked',$row->{'is_locked'});
$repo_element->setAttribute('join_enabled',$row->{'join_enabled'});
$repo_element->setAttribute('whats_new_enabled',$row->{'whats_new_enabled'});
$repo_element->setAttribute('object_approval_required',$row->{'object_approval_required'});
$rib_element->appendChild($repo_element);

print header(-type=>'text/xml'),
      $document->toString();

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
