/*
 * Decompiled with CFR 0.152.
 */
package org.nhse.rib;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.nhse.rib.TableMap;

public class TableSorter
extends TableMap {
    int[] indexes;
    Vector sortingColumns = new Vector();
    boolean ascending = true;
    int compares;
    TableSorter foo;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public TableSorter() {
        this.indexes = new int[0];
        this.foo = this;
    }

    public TableSorter(TableModel model) {
        this.setModel(model);
        this.foo = this;
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        JTable tableView = table;
        tableView.setColumnSelectionAllowed(false);
        1 listMouseListener = new 1(tableView, this);
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    public void checkModel() {
        if (this.indexes.length != this.model.getRowCount()) {
            System.err.println("Sorter not informed of a change in model.");
        }
    }

    public int compare(int row1, int row2) {
        ++this.compares;
        int level = 0;
        while (level < this.sortingColumns.size()) {
            Integer column = (Integer)this.sortingColumns.elementAt(level);
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result != 0) {
                return this.ascending ? result : -result;
            }
            ++level;
        }
        return 0;
    }

    public int compareRowsByColumn(int row1, int row2, int column) {
        Class<?> type = this.model.getColumnClass(column);
        TableModel data = this.model;
        Object o1 = data.getValueAt(row1, column);
        Object o2 = data.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (type.getSuperclass() == (class$java$lang$Number != null ? class$java$lang$Number : (class$java$lang$Number = TableSorter.class$("java.lang.Number")))) {
            Number n2;
            double d2;
            Number n1 = (Number)data.getValueAt(row1, column);
            double d1 = n1.doubleValue();
            if (d1 < (d2 = (n2 = (Number)data.getValueAt(row2, column)).doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
        if (type == (class$java$util$Date != null ? class$java$util$Date : (class$java$util$Date = TableSorter.class$("java.util.Date")))) {
            Date d2;
            long n2;
            Date d1 = (Date)data.getValueAt(row1, column);
            long n1 = d1.getTime();
            if (n1 < (n2 = (d2 = (Date)data.getValueAt(row2, column)).getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (type == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = TableSorter.class$("java.lang.String")))) {
            String s1 = (String)data.getValueAt(row1, column);
            String s2 = (String)data.getValueAt(row2, column);
            int result = s1.toLowerCase().compareTo(s2.toLowerCase());
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == (class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = TableSorter.class$("java.lang.Boolean")))) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)data.getValueAt(row1, column);
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)data.getValueAt(row2, column)).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
        Object v1 = data.getValueAt(row1, column);
        String s1 = v1.toString();
        Object v2 = data.getValueAt(row2, column);
        String s2 = v2.toString();
        int result = s1.toLowerCase().compareTo(s2.toLowerCase());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public Object getValueAt(int aRow, int aColumn) {
        this.checkModel();
        return this.model.getValueAt(this.indexes[aRow], aColumn);
    }

    public void n2sort() {
        int i = 0;
        while (i < this.getRowCount()) {
            int j = i + 1;
            while (j < this.getRowCount()) {
                if (this.compare(this.indexes[i], this.indexes[j]) == -1) {
                    this.swap(i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public void reallocateIndexes() {
        int rowCount = this.model.getRowCount();
        this.indexes = new int[rowCount];
        int row = 0;
        while (row < rowCount) {
            this.indexes[row] = row;
            ++row;
        }
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        this.reallocateIndexes();
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.checkModel();
        this.model.setValueAt(aValue, this.indexes[aRow], aColumn);
    }

    public void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            int i = low;
            while (i < high) {
                to[i] = from[i];
                ++i;
            }
            return;
        }
        int i = low;
        while (i < high) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
            ++i;
        }
    }

    public void sort(Object sender) {
        this.checkModel();
        this.compares = 0;
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public void sortByColumn(int column) {
        this.sortByColumn(column, true);
    }

    public void sortByColumn(int column, boolean ascending) {
        this.ascending = ascending;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(column));
        this.sort(this);
        super.tableChanged(new TableModelEvent(this));
    }

    public void swap(int i, int j) {
        int tmp = this.indexes[i];
        this.indexes[i] = this.indexes[j];
        this.indexes[j] = tmp;
    }

    public void tableChanged(TableModelEvent e) {
        this.reallocateIndexes();
        super.tableChanged(e);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private static final class 1
    extends MouseAdapter {
        private final /* synthetic */ TableSorter this$0;
        private final /* synthetic */ JTable val$tableView;

        /* synthetic */ 1(JTable val$tableView, TableSorter this$0) {
            this.val$tableView = val$tableView;
            this.this$0 = this$0;
        }

        public void mouseClicked(MouseEvent e) {
            TableColumnModel columnModel = this.val$tableView.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = this.val$tableView.convertColumnIndexToModel(viewColumn);
            if (e.getClickCount() == 1 && column != -1) {
                int shiftPressed = e.getModifiers() & 1;
                boolean ascending = shiftPressed == 0;
                this.this$0.foo.sortByColumn(column, ascending);
            }
        }
    }
}

