#BANGLINE

##############################################
use strict;
use CGI qw/:standard/;
use RIB::Util;
use XML::DOM;

##############################################

my $util = new RIB::Util();

unless (param('rh') =~ /^\d+$/) {
  $util->error("repository handle not specified in input");
}
my $rib_url = $util->RibUrl;
my $ribversion = $util->RibVersion();

$util->dbConnect();

my $table1 = param('rh') . "_interop_registry";
my $table2 = param('rh') . "_interop_objects";

my $document = new XML::DOM::Document();
my $xml_decl = new XML::DOM::XMLDecl();
$xml_decl->setVersion('1.0');
$xml_decl->setStandalone('yes');
$document->setXMLDecl($xml_decl);
my $rib_element = $document->createElement('rib');
$rib_element->setAttribute('version',$ribversion);
$document->appendChild($rib_element);
my $repo_element = $document->createElement('repository');
$repo_element->setAttribute('handle',param('rh'));
$repo_element->setAttribute('config',"$rib_url/".param('rh')."/config.xml");
$rib_element->appendChild($repo_element);

foreach my $x (param()) {
  next unless $x =~ /^ih\d+$/;
  my $handle = param($x);
  next unless $handle =~ /^\d+$/;
  my $sth = $util->dbh->prepare("SELECT name,url,last_attempt,last_success,"
                              . "update_interval FROM $table1 WHERE handle="
                              . $handle);
  eval { $sth->execute(); };
  if ($@) { $util->error($@); }
  my $row = $sth->fetchrow_hashref();
  my $interop = $document->createElement('interoperation');
  $interop->setAttribute('name',$row->{'name'});
  $interop->setAttribute('url',$row->{'url'});
  $interop->setAttribute('handle',$handle);
  $interop->setAttribute('last_attempt',$row->{'last_attempt'});
  $interop->setAttribute('last_success',$row->{'last_success'});
  $interop->setAttribute('update_interval',$row->{'update_interval'});
  $repo_element->appendChild($interop);
  $sth = $util->dbh->prepare("SELECT DISTINCT Name_,url,last_modified,created FROM "
                              .  "$table2 WHERE owner_handle=$handle");
  eval { $sth->execute(); };
  if ($@) { $util->error($@); }
  while (my $row2=$sth->fetchrow_hashref()) {
    my $object = $document->createElement('object');
    $object->setAttribute('name',$row2->{'Name_'});
    $object->setAttribute('url',$row2->{'url'});
    $object->setAttribute('owner_handle',$handle);
    $object->setAttribute('last_modified',$row2->{'last_modified'});
    $interop->appendChild($object);
  }
}
print header(-type=>"text/xml"),
      $document->toString();

FALLOFF:
$util->{dbh} && $util->{dbh}->disconnect();
