#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;

##########################################
my $util = new RIB::Util();
my $ribdir = $util->RibDir();
my $riburl = $util->RibUrl();
my $MAXHITS = 50;

# determine repository handle
my $repoHandle = param('rh');
unless ($repoHandle =~ /^\d+$/) {
  $util->error("Properly formatted repository handle not supplied");
}
eval { $util->dbConnect(); };
if ($@) { $util->error("Database error $@"); }


##########################################
# get repository properties
my $sth = $util->dbh->prepare("SELECT name,contact,object_approval_required,"
                            . "primary_class FROM "
                            . "repositories WHERE handle=$repoHandle");
eval { $sth->execute(); };
if ($@) { $util->error("Database error $@"); }
my $row = $sth->fetchrow_hashref();
my $repoName = $row->{'name'};
my $repoContact = $row->{'contact'};
my $object_approval_required = $row->{'object_approval_required'};
my $primary_class = $row->{'primary_class'};

print header;
unless (open (TEMPLATE, "$ribdir/docRoot/$repoHandle/advanced_search_template.html")) {
  $util->error("Can't open join template : $!");
}
while (<TEMPLATE>) {
  s/\bREPOSITORY_NAME\b/$repoName/g;
  s/\bREPOSITORY_CONTACT\b/$repoContact/g;
  s/\bSEARCH_URL\b/$riburl\/search.pl\?rh=$repoHandle/g;
  s/\bADVANCED_SEARCH_URL\b/$riburl\/advancedSearch.pl\?rh=$repoHandle/g;
  s/\bJOIN_URL\b/$riburl\/join.pl\?rh=$repoHandle/g;
  s/\bWHATS_NEW_URL\b/$riburl\/whatsNew.pl\?rh=$repoHandle/g;
  s/\bCATALOG_URL\b/$riburl\/catalog.pl\?rh=$repoHandle/g;
  s/\bDATA_MODEL_URL\b/$riburl\/$repoHandle\/config.xml/g;
  s/\bREPOSITORY_HANDLE\b/$riburl\/repository.pl\?rh=$repoHandle/g;
  s/\bABOUT_URL\b/$riburl\/about.pl\?rh=$repoHandle/g;
  s/\bRIB_LOGO\b/<A HREF="http:\/\/www.nhse.org\/RIB\/"><IMG ALIGN="CENTER" WIDTH="72" HEIGHT="82" BORDER="0" SRC="$riburl\/images\/poweredRIB.gif"><\/A>/g;


  print;
  if (/<!-- RIB -->/i) {
    print "Please choose the type of advanced query you wish to perform :<UL>",
          "<LI><A HREF=existSearch.pl?rh=$repoHandle>Existence Query</A>",
          "<LI><A HREF=vocabSearch.pl?rh=$repoHandle>Vocabulary Query</A>",
          "</UL>";
  }
}

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
