/*
 * Decompiled with CFR 0.152.
 */
package org.nhse.rib;

import java.util.Enumeration;
import java.util.Vector;
import org.nhse.rib.RibAttribute;
import org.nhse.rib.RibRelationship;
import org.nhse.rib.RibUtil;

public class RibClass {
    private String name;
    private String ext;
    private Vector attributes = new Vector();
    private Vector relationships = new Vector();
    private RibClass parentClass;

    public void addAttribute(RibAttribute attribute) {
        this.attributes.addElement(attribute);
    }

    public void addRelationship(RibRelationship relationship) {
        this.relationships.addElement(relationship);
    }

    public boolean checkForAttribute(String attrName) {
        Enumeration e = this.attributes.elements();
        while (e.hasMoreElements()) {
            RibAttribute attr = (RibAttribute)e.nextElement();
            if (!attr.getName().equals(attrName)) continue;
            return true;
        }
        RibAttribute ra = this.parentClass.getAttribute(attrName);
        return ra != null;
    }

    public boolean checkForRelationship(String relName) {
        Enumeration e = this.relationships.elements();
        while (e.hasMoreElements()) {
            RibRelationship rel = (RibRelationship)e.nextElement();
            if (!rel.getName().equals(relName)) continue;
            return true;
        }
        RibRelationship rr = this.parentClass.getRelationship(relName);
        return rr != null;
    }

    public RibAttribute getAttribute(String attrName) {
        Enumeration e = this.attributes.elements();
        while (e.hasMoreElements()) {
            RibAttribute tmp = (RibAttribute)e.nextElement();
            if (!tmp.getName().equals(attrName)) continue;
            return tmp;
        }
        if (this.parentClass != null) {
            return this.parentClass.getAttribute(attrName);
        }
        return null;
    }

    public Vector getAttributeNames() {
        Vector attr = this.getAttributes();
        Vector<String> names = new Vector<String>(attr.size());
        Enumeration e = attr.elements();
        while (e.hasMoreElements()) {
            names.addElement(((RibAttribute)e.nextElement()).getName());
        }
        return RibUtil.sortStringVector(names);
    }

    public Vector getAttributes() {
        if (this.parentClass == null) {
            return this.attributes;
        }
        Vector list = (Vector)this.attributes.clone();
        Vector attributeNames = this.getNativeAttributeNames();
        Enumeration e = this.parentClass.getAttributes().elements();
        while (e.hasMoreElements()) {
            RibAttribute ra = (RibAttribute)e.nextElement();
            if (attributeNames.indexOf(ra.getName()) != -1) continue;
            list.addElement(ra);
        }
        return list;
    }

    public String getExtends() {
        return this.ext;
    }

    public String getName() {
        return this.name;
    }

    public Vector getNativeAttributeNames() {
        Vector<String> names = new Vector<String>(this.attributes.size());
        Enumeration e = this.attributes.elements();
        while (e.hasMoreElements()) {
            names.addElement(((RibAttribute)e.nextElement()).getName());
        }
        return RibUtil.sortStringVector(names);
    }

    public Vector getNativeAttributes() {
        return this.attributes;
    }

    public Vector getNativeAttributes(boolean sort) {
        if (sort) {
            Vector<RibAttribute> sorted = new Vector<RibAttribute>(this.attributes.size());
            Enumeration e = this.getNativeAttributeNames().elements();
            while (e.hasMoreElements()) {
                String attributeName = (String)e.nextElement();
                sorted.addElement(this.getAttribute(attributeName));
            }
            return sorted;
        }
        return this.attributes;
    }

    public Vector getNativeRelationshipNames() {
        Vector<String> names = new Vector<String>(this.relationships.size());
        Enumeration e = this.relationships.elements();
        while (e.hasMoreElements()) {
            names.addElement(((RibRelationship)e.nextElement()).getName());
        }
        return RibUtil.sortStringVector(names);
    }

    public Vector getNativeRelationships() {
        return this.relationships;
    }

    public Vector getNativeRelationships(boolean sort) {
        if (sort) {
            Vector<RibRelationship> sorted = new Vector<RibRelationship>(this.relationships.size());
            Enumeration e = this.getNativeRelationshipNames().elements();
            while (e.hasMoreElements()) {
                String relationshipName = (String)e.nextElement();
                sorted.addElement(this.getRelationship(relationshipName));
            }
            return sorted;
        }
        return this.relationships;
    }

    public RibClass getParentClass() {
        return this.parentClass;
    }

    public RibRelationship getRelationship(String relName) {
        Enumeration e = this.relationships.elements();
        while (e.hasMoreElements()) {
            RibRelationship tmp = (RibRelationship)e.nextElement();
            if (!tmp.getName().equals(relName)) continue;
            return tmp;
        }
        if (this.parentClass != null) {
            return this.parentClass.getRelationship(relName);
        }
        return null;
    }

    public Vector getRelationshipNames() {
        Vector rel = this.getRelationships();
        Vector<String> names = new Vector<String>(rel.size());
        Enumeration e = rel.elements();
        while (e.hasMoreElements()) {
            names.addElement(((RibRelationship)e.nextElement()).getName());
        }
        return RibUtil.sortStringVector(names);
    }

    public Vector getRelationships() {
        if (this.parentClass == null) {
            return this.relationships;
        }
        Vector list = (Vector)this.relationships.clone();
        Vector relationshipNames = this.getNativeRelationshipNames();
        Enumeration e = this.parentClass.getRelationships().elements();
        while (e.hasMoreElements()) {
            RibRelationship rr = (RibRelationship)e.nextElement();
            if (relationshipNames.indexOf(rr.getName()) != -1) continue;
            list.addElement(rr);
        }
        return list;
    }

    public void removeAttribute(RibAttribute attribute) {
        this.attributes.removeElement(attribute);
    }

    public void removeRelationship(RibRelationship relationship) {
        this.relationships.removeElement(relationship);
    }

    public void setExtends(String e) {
        if (e != null) {
            this.ext = new String(e);
        }
    }

    public void setName(String n) {
        if (n != null) {
            this.name = new String(n);
        }
    }

    public void setParentClass(RibClass rc) {
        this.parentClass = rc;
    }

    public String toString() {
        String out = new String();
        out = String.valueOf(out) + this.name + " extends " + this.ext + "\n";
        out = String.valueOf(out) + "------------------------\n";
        int j = 0;
        while (j < this.attributes.size()) {
            RibAttribute myAttribute = (RibAttribute)this.attributes.elementAt(j);
            out = String.valueOf(out) + myAttribute.toString() + "\n";
            ++j;
        }
        int j2 = 0;
        while (j2 < this.relationships.size()) {
            RibRelationship myRelationship = (RibRelationship)this.relationships.elementAt(j2);
            out = String.valueOf(out) + myRelationship.toString() + "\n";
            ++j2;
        }
        out = String.valueOf(out) + "\n";
        return out;
    }
}

