
/* $Id: xpvm.h,v 3.20 1995/07/27 14:49:02 kohl Exp $ */

/* System Header Files */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include <malloc.h>
#include <signal.h>
#include <pwd.h>
#include <math.h>

#define PI (M_PI)

/* Header Files */

#include <tk.h>

#include "const.h"

#include <pvm3.h>

#include "../src/tdpro.h"

#ifdef USE_PVM_33
#include "compat.reverse.h"
#else
#include <pvmtev.h>
#include <pvmtevstr.h>
#endif

#include "trace.h"

#include "compat.pvmtev.h"

typedef void (*vfp)();
typedef int (*ifp)();

/* Program Data Structures */

struct trie_struct
{
	int valid;
	char *str;
	void *value;
	/* TRIE */ struct trie_struct *next;
};

typedef struct trie_struct *TRIE;

struct tcl_glob_struct
{
	char *name;
	int type;
	char *char_value;
	int int_value;
};

typedef struct tcl_glob_struct *TCL_GLOBAL;

struct trace_mask_group_struct
{
	char *name;
	char *tmask;
	/* TRACE_MASK_GROUP */ struct trace_mask_group_struct *next;
};

typedef struct trace_mask_group_struct *TRACE_MASK_GROUP;

struct trace_mask_index_struct
{
	char *name;
	int index;
	/* TRACE_MASK_INDEX */ struct trace_mask_index_struct *next;
};

typedef struct trace_mask_index_struct *TRACE_MASK_INDEX;

struct did_struct
{
	char name[4];
	char *desc;
	/* DID */ struct did_struct *next;
};

typedef struct did_struct *DID;

struct datadesc_struct
{
	DID did;
	int dt;
	int array;
	/* DATADESC */ struct datadesc_struct *next;
};

typedef struct datadesc_struct *DATADESC;

struct tevdesc_struct
{
	char *name;
	int eid;
	int entry_exit;
	int index;
	int hid;
	int dump;
	DATADESC ddesc;
	/* TEVDESC */ struct tevdesc_struct *next;
};

typedef struct tevdesc_struct *TEVDESC;

typedef void *VALUE;

struct tevrec_struct
{
	DATADESC ddesc;
	VALUE value;
	int num;
	/* TEVREC */ struct tevrec_struct *next;
};

typedef struct tevrec_struct *TEVREC;

struct gobj_struct
{
	int id;
	int coords[MAX_GOBJ_COORDS];
	char *color;
};

typedef struct gobj_struct *GOBJ;

struct msg_struct
{
	/* TASK */ struct task_struct *ST;
	/* TASK */ struct task_struct *DT;
	int src_tid;
	int dst_tid;
	int msgtag;
	int nbytes;
	int assbytes;
	struct timeval sendtime;
	struct timeval recvtime;
	GOBJ line;
	/* MSG */ struct msg_struct *prev;
	/* MSG */ struct msg_struct *next;
};

typedef struct msg_struct *MSG;

struct msgq_struct
{
	MSG msg;
	GOBJ rect;
	/* MSGQ */ struct msgq_struct *next;
};

typedef struct msgq_struct *MSGQ;

struct msg_grid_struct
{
	MSG msg;
	/* MSG_GRID */ struct msg_grid_struct *next;
};

typedef struct msg_grid_struct *MSG_GRID;

struct tevtask_struct
{
	int tid;
	int tevstatus;
	int outstatus;
	int *tevlist;
	int tevsize;
	/* TEVTASK */ struct tevtask_struct *next;
};

typedef struct tevtask_struct *TEVTASK;

struct state_struct
{
	int status;
	char *callstr;
	GOBJ rect;
	struct timeval starttime;
	struct timeval endtime;
	/* STATE */ struct state_struct *next;
};

typedef struct state_struct *STATE;

struct task_struct
{
	char *name;
	int tid;
	int ptid;
	int pvmd_tid;
	/* HOST */ struct host_struct *host;
	int flags;
	int status;

	/* Space-Time / Call Trace Info */
	int index;
	int y1, y2;
	GOBJ st_label;
	GOBJ ct_label;
	GOBJ ct_callstr;
	STATE states;

	/* Message Queue Info */
	MSGQ msgq;
	GOBJ mqmark;
	int mqcnt;
	int mqbytes;

	/* TASK */ struct task_struct *next;
};

typedef struct task_struct *TASK;

struct ut_state_struct
{
	int valid;
	GOBJ running;
	GOBJ system;
	GOBJ idle;
	int counts[MAX_STATE];
	struct timeval starttime;
	struct timeval endtime;
	/* UT_STATE */ struct ut_state_struct *next;
};

typedef struct ut_state_struct *UT_STATE;

struct arch_struct
{
	char *code;
	char *name;
	int height;
	int width;
	/* ARCH */ struct arch_struct *next;
};

typedef struct arch_struct *ARCH;

struct netlink_struct
{
	GOBJ link;
	int msg_bytes;
	int msg_bw;
	struct timeval bw_start;
	struct timeval bw_end;
};

typedef struct netlink_struct *NETLINK;

struct host_struct
{
	char *name;
	char *alias;
	char *refname;
	ARCH arch;
	struct timeval delta;
	int pvmd_tid;
	int in_pvm;
	int speed;

	/* Tracing Info */
	int *tevlist;
	int tevsize;

	/* Network Fields */
	int index;
	int status;
	int counts[MAX_STATE];
	char *color;
	char *menuvar;
	GOBJ icon;
	GOBJ nme;
	GOBJ box;
	NETLINK links[MAX_LINK];

	/* NETWORK */ struct network_struct *subnet;

	/* HOST */ struct host_struct *next;
};

typedef struct host_struct *HOST;

struct network_struct
{
	int type;
	char *NET_C;
	HOST host_list;
	NETLINK *links;
	int nlinks;
};

typedef struct network_struct *NETWORK;

/* Routines */

TRIE		create_triestack();

void		*lookup_trie();

TCL_GLOBAL	create_tcl_global();

TRACE_MASK_GROUP	create_trace_mask_group(),
					lookup_trace_mask_group();

TRACE_MASK_INDEX	create_trace_mask_index(),
					lookup_trace_mask_name();

DID			create_did();

DATADESC	create_datadesc();

TEVDESC		create_tevdesc(), add_tevdesc(), get_tevdesc();

VALUE		make_value(), copy_value();

TEVREC		create_tevrec(), get_tevrec();

GOBJ		create_gobj();

MSG			create_msg();

MSGQ		create_msgq();

MSG_GRID	create_msg_grid();

TEVTASK		create_tevtask(), get_tevtask_tid();

STATE		create_state();

TASK		create_task(), get_task_tid();

UT_STATE	create_ut_state();

ARCH		create_arch(), get_arch_code(), check_arch();

NETLINK		create_netlink();

HOST		create_host(), get_host_name(), get_host_index(),
			get_host_tid();

NETWORK		create_network();

double	distance();
double	angle_of();

char	*pvm_event_string();
char	*host_alias_str();
char	*tevrec_string();
char	*strip33_name();
char	*center_str();
char	*host_name();
char	*trunc_str();
char	*upper_str();
char	*copy_str();
char	*date_str();
char	*pad_num();

FILE	*fopen();

/* Externals */

extern	struct Pvmtevinfo	pvmtevinfo[];

extern	struct Pvmtevdid	pvmtevdidlist[];

extern	char	*pvm_errlist[];

extern	int		pvm_nerr;

extern	int 	errno;

/* Global Variables */

#ifndef DO_GLOBALS

extern	char	*SIGNAL_STRS[NUM_SIGNALS];

extern	char	*HOST_CMD_STRS[MAX_HID];

extern	char	*HOST_CMD_HELP[MAX_HID];

extern	char	*HOST_MENU_HELP_STR;

extern	char	*TYPE_STRS[16];

extern	char	TMP_CMD[1024];

extern	char	*TMP_COLOR;

extern	char	*TMP_HOST;

extern	struct timeval	CURRENT_TIME;
extern	struct timeval	BASE_TIME;
extern	struct timeval	TRACE_TIME;

extern	int		PROCESS_COUNTER_OVERWRITE;
extern	int		PROCESS_COUNTER_PLAYBACK;

extern	int		RECV_TIMER_OVERWRITE;
extern	int		RECV_TIMER_PLAYBACK;

extern	int		PROCESS_COUNTER_INTERVAL;
extern	int		RECV_TIMER_INTERVAL;

extern	int		TRACE_OVERWRITE_FLAG;
extern	int		TRACE_PROCESS_LOCK;
extern	int		TRACE_MODE_PENDING;
extern	int		TRACE_FILE_STATUS;
extern	int		TRACE_GROUP_TASKS;
extern	int		TRACE_DO_SPAWN;
extern	int		TRACE_PENDING;
extern	int		TRACE_ACTIVE;
extern	int		TRACE_STATUS;
extern	int		TRACE_FORMAT;
extern	int		TRACE_BUF;

extern	char		*CURRENT_TRACE_MASK;

extern	Pvmtmask	TRACE_MASK;
extern	Pvmtmask	TRACE33_MASK;

extern	Pvmtmask	TRACE_MASK_CLEAR;
extern	Pvmtmask	TRACE33_MASK_CLEAR;

extern	int		TEV33_TRACE[TRACE33_MAX];

extern	int		TEV33_TYPE[TRACE33_MAX];

extern	char	TRACE_FILE[1024];

extern	FILE	*TRACE_OUT;
extern	FILE	*TRACE_IN;

extern	char	OUTPUT_FILE[1024];

extern	FILE	*OUTPUT_FP;

extern	int		GROUPS_ALIVE;

extern	Tcl_Interp	*interp;

extern	Tk_Window	Top;

extern	Display		*Disp;

extern	TRIE	EVENT_TRIE33;
extern	TRIE	HANDLE_TRIE;
extern	TRIE	EVENT_TRIE;

extern	TRIE	DID_TRIE;

extern	TRACE_MASK_GROUP	*CURRENT_GROUP_LIST;

extern	TRACE_MASK_GROUP	TM33_GROUP_LIST;
extern	TRACE_MASK_GROUP	TM_GROUP_LIST;

extern	TRACE_MASK_INDEX	*CURRENT_INDEX_LIST;

extern	TRACE_MASK_INDEX	TM33_INDEX_LIST;
extern	TRACE_MASK_INDEX	TM_INDEX_LIST;

extern	DID			DID_LIST;

extern	TEVDESC		*TEVDESC_LIST;

extern	int			TEVDESC_SIZE;

extern	TEVREC		TMP_TR;

extern	MSG			PENDING_MSG_LIST;

extern	MSG_GRID	**PENDING_MSG_GRID;

extern	int			MSG_GRID_SIZE;

extern	MSG			MSG_LIST;

extern	TEVTASK		TEVTASK_LIST;

extern	TASK		TASK_LIST;

extern	int			NTASKS;

extern	UT_STATE	UT_LIST;

extern	ARCH		ARCH_LIST;

extern	NETWORK		MAIN_NET;

extern	char	*HOST_NAME;

extern	char	*HOST_ALIAS;

extern	char	*HOME_DIR;

extern	char	*XPVM_DIR;

extern	char	*HOSTFILE;

extern	char	*screen_name;
extern	char	*base_name;

extern	int 	NHOSTS;

extern	char	**Argv;
extern	int 	Argc;

extern	int		ST_SCROLL_MARK;
extern	int		UT_SCROLL_MARK;

extern	int		TIMEIDX;

extern	int		NEW_PVM;

extern	int		TMP_CMP;

extern	int		TMP_CC;

extern	int 	MYTID;

extern	int 	speed;

extern	int 	Qflag;
extern	int		Nflag;
extern	int		Xflag;
extern	int 	eflag;
extern	int 	tflag;
extern	int 	vflag;

/* TCL Globals */

extern	TCL_GLOBAL	TMP_GLOBAL;

extern	TCL_GLOBAL	DEPTH;

extern	TCL_GLOBAL	FRAME_BORDER;

extern	TCL_GLOBAL	FRAME_OFFSET;

extern	TCL_GLOBAL	BORDER_SPACE;

extern	TCL_GLOBAL	ROW_HEIGHT;

extern	TCL_GLOBAL	ICON_BORDER;

extern	TCL_GLOBAL	ICON_SPACE;

extern	TCL_GLOBAL	NET_CHEIGHT;

extern	TCL_GLOBAL	NET_HHEIGHT;

extern	TCL_GLOBAL	NET_CWIDTH;

extern	TCL_GLOBAL	NET_HWIDTH;

extern	TCL_GLOBAL	NET_SCROLL;

extern	TCL_GLOBAL	NET_FLASH;

extern	TCL_GLOBAL	NET_SPACE;

extern	TCL_GLOBAL	NET_XVIEW;

extern	TCL_GLOBAL	NET_YVIEW;

extern	TCL_GLOBAL	NET_SIZE;

extern	int		UT_MAX_NTASKS;

extern	int		MSG_DEFAULT_NBYTES;

extern	int		MQ_MAX_NBYTES;

extern	TCL_GLOBAL	NET_RUNNING_COLOR;
extern	TCL_GLOBAL	NET_SYSTEM_COLOR;
extern	TCL_GLOBAL	NET_IDLE_COLOR;
extern	TCL_GLOBAL	NET_EMPTY_COLOR;
extern	TCL_GLOBAL	NET_FG_COLOR;

extern	TCL_GLOBAL	NET_ALIVE_COLOR;
extern	TCL_GLOBAL	NET_DEAD_COLOR;

extern	TCL_GLOBAL	NET_VOLUME7_COLOR;
extern	TCL_GLOBAL	NET_VOLUME6_COLOR;
extern	TCL_GLOBAL	NET_VOLUME5_COLOR;
extern	TCL_GLOBAL	NET_VOLUME4_COLOR;
extern	TCL_GLOBAL	NET_VOLUME3_COLOR;
extern	TCL_GLOBAL	NET_VOLUME2_COLOR;
extern	TCL_GLOBAL	NET_VOLUME1_COLOR;
extern	TCL_GLOBAL	NET_VOLUME0_COLOR;

extern	TCL_GLOBAL	ST_OUTLINE_COLOR;
extern	TCL_GLOBAL	ST_RUNNING_COLOR;
extern	TCL_GLOBAL	ST_SYSTEM_COLOR;
extern	TCL_GLOBAL	ST_IDLE_COLOR;
extern	TCL_GLOBAL	ST_COMM_COLOR;

extern	TCL_GLOBAL	UT_RUNNING_COLOR;
extern	TCL_GLOBAL	UT_SYSTEM_COLOR;
extern	TCL_GLOBAL	UT_IDLE_COLOR;

extern	TCL_GLOBAL	MQ_MSG_NOSIZE_COLOR;
extern	TCL_GLOBAL	MQ_MSG_SIZE_COLOR;
extern	TCL_GLOBAL	MQ_OUTLINE_COLOR;

extern	TCL_GLOBAL	FG_COLOR;

extern	TCL_GLOBAL	ST_CANVAS_HEIGHT;

extern	TCL_GLOBAL	ST_TIMELINE;

extern	TCL_GLOBAL	ST_CHEIGHT;

extern	TCL_GLOBAL	ST_CWIDTH;

extern	TCL_GLOBAL	ST_LABEL_HT;

extern	TCL_GLOBAL	ST_RECT_HT;

extern	TCL_GLOBAL	STL_YVIEW;

extern	TCL_GLOBAL	ST_ACTIVE;

extern	TCL_GLOBAL	ST_TIMEID;

extern	TCL_GLOBAL	ST_XVIEW;

extern	TCL_GLOBAL	TIMEID_PRIM;

extern	TCL_GLOBAL	TIMEX;

extern	TCL_GLOBAL	SCALE;

extern	TCL_GLOBAL	UT_CANVAS_HEIGHT;

extern	TCL_GLOBAL	UT_CHEIGHT;

extern	TCL_GLOBAL	UT_CWIDTH;

extern	TCL_GLOBAL	UT_ACTIVE;

extern	TCL_GLOBAL	UT_TIMEID;

extern	TCL_GLOBAL	UT_XVIEW;

extern	TCL_GLOBAL	MQ_TASK_WT;

extern	TCL_GLOBAL	MQ_CHEIGHT;

extern	TCL_GLOBAL	MQ_ACTIVE;

extern	TCL_GLOBAL	MQ_CWIDTH;

extern	TCL_GLOBAL	MQ_XVIEW;

extern	TCL_GLOBAL	CT_QUERY_INDEX;

extern	TCL_GLOBAL	CT_CHEIGHT;

extern	TCL_GLOBAL	CT_ACTIVE;

extern	TCL_GLOBAL	CT_YVIEW;

extern	char	*NET_C;
extern	char	*NET_SBH;
extern	char	*NET_SBV;

extern	char	*CTRL;

extern	char	*ST;
extern	char	*ST_L;
extern	char	*ST_C;
extern	char	*ST_SBH;
extern	char	*ST_SBV;

extern	char	*SP;

extern	char	*KL;
extern	char	*KL_C;
extern	char	*KL_SBH;
extern	char	*KL_SBV;

extern	char	*SG;
extern	char	*SG_C;
extern	char	*SG_SBH;
extern	char	*SG_SBV;
extern	char	*SG_LF;
extern	char	*SG_LFC;
extern	char	*SG_LFCW;
extern	char	*SG_LSBV;

extern	char	*OV;

extern	char	*UT;
extern	char	*UT_C;
extern	char	*UT_SBH;

extern	char	*MQ;
extern	char	*MQ_C;
extern	char	*MQ_SBH;

extern	char	*CT;
extern	char	*CT_L;
extern	char	*CT_C;
extern	char	*CT_SBH;
extern	char	*CT_SBV;

extern	char	*TO;
extern	char	*TO_C;
extern	char	*TO_SBH;
extern	char	*TO_SBV;

#else

char	*SIGNAL_STRS[NUM_SIGNALS] =
{
	"SIGHUP",
	"SIGINT",
	"SIGQUIT",
	"SIGILL",
	"SIGTRAP",
	"SIGABRT",
	"SIGEMT",
	"SIGFPE",
	"SIGKILL",
	"SIGBUS",
	"SIGSEGV",
	"SIGSYS",
	"SIGPIPE",
	"SIGALRM",
	"SIGTERM",
	"SIGURG",
	"SIGSTOP",
	"SIGTSTP",
	"SIGCONT",
	"SIGCHLD",
	"SIGTTIN",
	"SIGTTOU",
	"SIGIO",
	"SIGXCPU",
	"SIGXFSZ",
	"SIGVTALRM",
	"SIGPROF",
	"SIGWINCH",
	"SIGLOST",
	"SIGUSR1",
	"SIGUSR2"
};

char	*HOST_CMD_STRS[MAX_HID] =
{
	"Add All Hosts",
	"Other Hosts..."
};

char	*HOST_CMD_HELP[MAX_HID] =
{
"Simultaneously Add All Hosts on the Menu to the PVM Virtual Machine",
"Raise / Lower Dialog to Add Another Host (Not Already on Menu)"
};

char	*HOST_MENU_HELP_STR = "Add / Delete Host";

char	*TYPE_STRS[16] =
{
	"void",
	"char",
	"float",
	"double",
	"double",
	"float",
	"int",
	"int",
	"int",
	"int",
	"int",
	"int",
	"char",
	"void",
	"void",
	"void"
};

char	TMP_CMD[1024];

char	*TMP_COLOR;

char	*TMP_HOST;

struct timeval	CURRENT_TIME;
struct timeval	BASE_TIME;
struct timeval	TRACE_TIME;

int		PROCESS_COUNTER_OVERWRITE;
int		PROCESS_COUNTER_PLAYBACK;

int		RECV_TIMER_OVERWRITE;
int		RECV_TIMER_PLAYBACK;

int		PROCESS_COUNTER_INTERVAL;
int		RECV_TIMER_INTERVAL;

int		TRACE_OVERWRITE_FLAG;
int		TRACE_PROCESS_LOCK;
int		TRACE_MODE_PENDING;
int		TRACE_FILE_STATUS;
int		TRACE_GROUP_TASKS;
int		TRACE_DO_SPAWN;
int		TRACE_PENDING;
int		TRACE_ACTIVE;
int		TRACE_STATUS;
int		TRACE_FORMAT;
int		TRACE_BUF;

char		*CURRENT_TRACE_MASK;

Pvmtmask	TRACE_MASK;
Pvmtmask	TRACE33_MASK;

Pvmtmask	TRACE_MASK_CLEAR;
Pvmtmask	TRACE33_MASK_CLEAR;

int		TEV33_TRACE[TRACE33_MAX];

int		TEV33_TYPE[TRACE33_MAX];

char	TRACE_FILE[1024];

FILE	*TRACE_OUT;
FILE	*TRACE_IN;

char	OUTPUT_FILE[1024];

FILE	*OUTPUT_FP;

int		GROUPS_ALIVE;

Tcl_Interp	*interp;

Tk_Window	Top;

Display		*Disp;

TRIE	EVENT_TRIE33;
TRIE	HANDLE_TRIE;
TRIE	EVENT_TRIE;

TRIE	DID_TRIE;

TRACE_MASK_GROUP	*CURRENT_GROUP_LIST;

TRACE_MASK_GROUP	TM33_GROUP_LIST;
TRACE_MASK_GROUP	TM_GROUP_LIST;

TRACE_MASK_INDEX	*CURRENT_INDEX_LIST;

TRACE_MASK_INDEX	TM33_INDEX_LIST;
TRACE_MASK_INDEX	TM_INDEX_LIST;

DID			DID_LIST;

TEVDESC		*TEVDESC_LIST;

int			TEVDESC_SIZE;

TEVREC		TMP_TR;

MSG			PENDING_MSG_LIST;

MSG_GRID	**PENDING_MSG_GRID;

int			MSG_GRID_SIZE;

MSG			MSG_LIST;

TEVTASK		TEVTASK_LIST;

TASK		TASK_LIST;

int			NTASKS;

UT_STATE	UT_LIST;

ARCH		ARCH_LIST;

NETWORK		MAIN_NET;

char	*HOST_NAME;

char	*HOST_ALIAS;

char	*HOME_DIR;

char	*XPVM_DIR;

char	*HOSTFILE;

char	*screen_name = (char *) NULL;
char	*base_name = (char *) NULL;

int 	NHOSTS;

char	**Argv;
int 	Argc;

int		ST_SCROLL_MARK;
int		UT_SCROLL_MARK;

int		TIMEIDX;

int		NEW_PVM;

int		TMP_CMP;

int		TMP_CC;

int 	MYTID;

int 	speed;

int 	Qflag;
int		Nflag;
int		Xflag;
int 	eflag;
int 	tflag;
int 	vflag;

/* TCL Globals */

TCL_GLOBAL	TMP_GLOBAL;

TCL_GLOBAL	DEPTH;

TCL_GLOBAL	FRAME_BORDER;

TCL_GLOBAL	FRAME_OFFSET;

TCL_GLOBAL	BORDER_SPACE;

TCL_GLOBAL	ROW_HEIGHT;

TCL_GLOBAL	ICON_BORDER;

TCL_GLOBAL	ICON_SPACE;

TCL_GLOBAL	NET_CHEIGHT;

TCL_GLOBAL	NET_HHEIGHT;

TCL_GLOBAL	NET_CWIDTH;

TCL_GLOBAL	NET_HWIDTH;

TCL_GLOBAL	NET_SCROLL;

TCL_GLOBAL	NET_FLASH;

TCL_GLOBAL	NET_SPACE;

TCL_GLOBAL	NET_XVIEW;

TCL_GLOBAL	NET_YVIEW;

TCL_GLOBAL	NET_SIZE;

int		UT_MAX_NTASKS;

int		MSG_DEFAULT_NBYTES;

int		MQ_MAX_NBYTES;

TCL_GLOBAL	NET_RUNNING_COLOR;
TCL_GLOBAL	NET_SYSTEM_COLOR;
TCL_GLOBAL	NET_IDLE_COLOR;
TCL_GLOBAL	NET_EMPTY_COLOR;
TCL_GLOBAL	NET_FG_COLOR;

TCL_GLOBAL	NET_ALIVE_COLOR;
TCL_GLOBAL	NET_DEAD_COLOR;

TCL_GLOBAL	NET_VOLUME7_COLOR;
TCL_GLOBAL	NET_VOLUME6_COLOR;
TCL_GLOBAL	NET_VOLUME5_COLOR;
TCL_GLOBAL	NET_VOLUME4_COLOR;
TCL_GLOBAL	NET_VOLUME3_COLOR;
TCL_GLOBAL	NET_VOLUME2_COLOR;
TCL_GLOBAL	NET_VOLUME1_COLOR;
TCL_GLOBAL	NET_VOLUME0_COLOR;

TCL_GLOBAL	ST_OUTLINE_COLOR;
TCL_GLOBAL	ST_RUNNING_COLOR;
TCL_GLOBAL	ST_SYSTEM_COLOR;
TCL_GLOBAL	ST_IDLE_COLOR;
TCL_GLOBAL	ST_COMM_COLOR;

TCL_GLOBAL	UT_RUNNING_COLOR;
TCL_GLOBAL	UT_SYSTEM_COLOR;
TCL_GLOBAL	UT_IDLE_COLOR;

TCL_GLOBAL	MQ_MSG_NOSIZE_COLOR;
TCL_GLOBAL	MQ_MSG_SIZE_COLOR;
TCL_GLOBAL	MQ_OUTLINE_COLOR;

TCL_GLOBAL	FG_COLOR;

TCL_GLOBAL	ST_CANVAS_HEIGHT;

TCL_GLOBAL	ST_TIMELINE;

TCL_GLOBAL	ST_CHEIGHT;

TCL_GLOBAL	ST_CWIDTH;

TCL_GLOBAL	ST_LABEL_HT;

TCL_GLOBAL	ST_RECT_HT;

TCL_GLOBAL	STL_YVIEW;

TCL_GLOBAL	ST_ACTIVE;

TCL_GLOBAL	ST_TIMEID;

TCL_GLOBAL	ST_XVIEW;

TCL_GLOBAL	TIMEID_PRIM;

TCL_GLOBAL	TIMEX;

TCL_GLOBAL	SCALE;

TCL_GLOBAL	UT_CANVAS_HEIGHT;

TCL_GLOBAL	UT_CHEIGHT;

TCL_GLOBAL	UT_CWIDTH;

TCL_GLOBAL	UT_ACTIVE;

TCL_GLOBAL	UT_TIMEID;

TCL_GLOBAL	UT_XVIEW;

TCL_GLOBAL	MQ_TASK_WT;

TCL_GLOBAL	MQ_CHEIGHT;

TCL_GLOBAL	MQ_ACTIVE;

TCL_GLOBAL	MQ_CWIDTH;

TCL_GLOBAL	MQ_XVIEW;

TCL_GLOBAL	CT_QUERY_INDEX;

TCL_GLOBAL	CT_CHEIGHT;

TCL_GLOBAL	CT_ACTIVE;

TCL_GLOBAL	CT_YVIEW;

char	*NET_C;
char	*NET_SBH;
char	*NET_SBV;

char	*CTRL;

char	*ST;
char	*ST_L;
char	*ST_C;
char	*ST_SBH;
char	*ST_SBV;

char	*SP;

char	*KL;
char	*KL_C;
char	*KL_SBH;
char	*KL_SBV;

char	*SG;
char	*SG_C;
char	*SG_SBH;
char	*SG_SBV;
char	*SG_LF;
char	*SG_LFC;
char	*SG_LFCW;
char	*SG_LSBV;

char	*OV;

char	*UT;
char	*UT_C;
char	*UT_SBH;

char	*MQ;
char	*MQ_C;
char	*MQ_SBH;

char	*CT;
char	*CT_L;
char	*CT_C;
char	*CT_SBH;
char	*CT_SBV;

char	*TO;
char	*TO_C;
char	*TO_SBH;
char	*TO_SBV;

#endif

