
static char rcsid[] =
	"$Id: xpvm.c,v 3.20 1995/07/27 14:48:49 kohl Exp $";

#define DO_GLOBALS

#include "xpvm.h"

int Tcl_AppInit();

Tk_IdleProc *recv_event_proc();

/* Command Routines */

int initialize_tcl_globals_proc();
int update_scroll_marks_proc();
int define_trace_mask_proc();
int trace_file_status_proc();
int get_trace_format_proc();
int reset_trace_file_proc();
int ut_adjust_height_proc();
int check_max_scale_proc();
int trace_overwrite_proc();
int get_hosts_menu_list();
int network_set_menuvar();
int set_query_time_proc();
int task_ct_update_proc();
int network_reset_proc();
int task_ct_query_proc();
int network_host_find();
int fix_help_line_cmd();
int task_arrange_proc();
int comm_arrange_proc();
int double_click_proc();
int load_bitmap_file();
int output_file_proc();
int reset_views_proc();
int strip_label_cmd();
int trace_file_proc();
int trace_mask_proc();
int title_info_proc();
int comm_query_proc();
int task_label_proc();
int task_query_proc();
int task_reset_proc();
int mq_arrange_proc();
int task_zoom_proc();
int comm_zoom_proc();
int time_zoom_proc();
int mq_update_proc();
int get_tasks_proc();
int reset_pvm_proc();
int ut_toggle_proc();
int playback_proc();
int ut_reset_proc();
int mq_query_proc();
int mq_reset_proc();
int ut_zoom_proc();
int define_arch();
int hosts_proc();
int tasks_proc();
int quit_proc();
int halt_proc();
int pad_cmd();

/* MAIN */

#ifdef USE_TCL73_TK36

extern int main();

int *tclDummyMainPtr = (int *) main;

#else

int
main( argc, argv )
int argc;
char **argv;
{
	char **mung_argv;
	int mung_argc;
	int i;

	/* Mung Argv to Circumvent TK Stupidity */

	mung_argc = argc + 1;

	mung_argv = (char **) malloc( (unsigned) mung_argc
		* sizeof( char * ) );
	memcheck( mung_argv, "Munged Argv List" );

	mung_argv[0] = argv[0];

	mung_argv[1] = copy_str( "-" );

	for ( i=2 ; i <= mung_argc ; i++ )
		mung_argv[i] = argv[ i - 1 ];

	/* Pass to TK */

	Tk_Main( mung_argc, mung_argv, Tcl_AppInit );

	return( 0 );
}

#endif

int Tcl_AppInit( itp )
Tcl_Interp *itp;
{
	/* Save Interpreter */

	interp = itp;

	/* Get Main Window */

	Top = Tk_MainWindow( interp );

	if ( Top == NULL )
		return( TCL_ERROR );

	Disp = Tk_Display( Top );

	/* Initialize Program Constants */

	if ( read_args() == TCL_ERROR )
		return( TCL_ERROR );

	/* Initialize Program Constants & Structs */

	if ( program_init() == TCL_ERROR )
		return( TCL_ERROR );

	/* Initialize Modules */

	if ( tcl_init() == TCL_ERROR )
		return( TCL_ERROR );

	if ( pvm_init() == TCL_ERROR )
		return( TCL_ERROR );

	if ( window_init() == TCL_ERROR )
		return( TCL_ERROR );

	/* Set Up User-Specific Startup File */

	tcl_RcFileName = "~/.xpvmrc";

	/* Return to tkMain to Start Tk_MainLoop() */

	return( TCL_OK );
}

read_args()
{
	char tmp[1024];

	char *argv_str;

	int i, j, k;
	int do_usage;
	int len;

	argv_str = GET_TCL_GLOBAL( interp, "argv" );

	if ( Tcl_SplitList( interp, argv_str, &Argc, &Argv ) == TCL_ERROR )
		return( TCL_ERROR );

	HOST_NAME = (char *) NULL;

	HOSTFILE = (char *) NULL;

	MSG_DEFAULT_NBYTES = 64;

	Nflag = 0;
	Xflag = 0;

	/* Qflag = 0; */

	eflag = 0;
	tflag = 0;
	vflag = 0;

	do_usage = 0;

	for ( i=0 ; i < Argc ; i++ )
	{
		if ( Argv[i][0] == '-' )
		{
			k = i + 1;

			len = strlen( Argv[i] );

			for ( j=0 ; j < len ; j++ )
			{
				switch ( Argv[i][j] )
				{
					case 'H': usage(); break;

					case 'N':
					{
						if ( HOST_NAME != NULL )
							free( HOST_NAME );

						HOST_NAME = copy_str( Argv[k++] );

						Nflag++;

						break;
					}

					case 'T':
					{
						sprintf( tmp, "set trace_file \"%s\"",
							Argv[k++] );

						Tcl_Eval( interp, tmp );

						break;
					}

					case 'M':
					{
						MSG_DEFAULT_NBYTES = atoi( Argv[k++] );

						break;
					}

					case 'S': dump_sddf_headers(); break;

					case 'X': Xflag++; break;

					/* case 'Q': Qflag++; break; */

					case 'e': eflag++; break;

					case 't': tflag++; break;

					case 'v': vflag++; break;

					case '-': break;

					default:
					{
						printf( "Unknown Option -%c\n", Argv[i][j] );

						do_usage++;

						break;
					}
				}
			}

			i = k - 1;
		}

		/* Hostfile */
		else
		{
			if ( HOSTFILE != NULL )
				free( HOSTFILE );

			HOSTFILE = copy_str( Argv[i] );
		}
	}

	if ( do_usage )
		usage();

	return( TCL_OK );
}

usage()
{
	printf( "\nusage:  xpvm [ hostfile ] [ -T trace ] [ -N name ] " );
	printf( "\t[ -M nbytes ] " );
	printf( "[ -HSetv ]\n\n" );

	printf( "where:\n" );
	printf( "------\n" );

	printf( "hostfile   = Alternate XPVM Hostfile (~/.xpvm_hosts)\n" );

	printf( "-T trace   = Use \"trace\" as Default Trace File\n" );

	printf( "-N name\t   = Use \"name\" as Local Network Hostname\n" );

	printf( "-M nbytes  = Set Default Message Size to \"nbytes\"\n" );

	printf( "-H\t   = Print This Help Information\n" );
	printf( "-S\t   = Dump SDDF Trace File Headers (and exit)\n" );

	/* printf( "-Q\t   = Use Cached Group Servers\n" ); */

	printf( "-e\t   = Dump Raw PVM Event Text\n" );
	printf( "-t\t   = Text Mode, No Animation in Views\n" );
	printf( "-v\t   = Verbose Operation\n" );

	printf( "\n" );

	exit( 0 );
}

program_init()
{
	struct passwd *pw;

	char hname[1024];
	char tmp[2048];

	char *getenv();

	char *xpvm_dir;
	char *stripped;
	char *uppered;
	char *pvstr;
	char *home;

	int entry_exit;
	int release;
	int version;
	int fmt;
	int i;

	/*
	 * Signals Set in pvm_init() - after pvmd started 
	 */

	/* Get Hostname */

	if ( HOST_NAME == NULL )
	{
		if ( gethostname( hname, 1024 ) == -1 )
		{
			perror( "Getting Hostname" );

			HOST_NAME = (char *) NULL;
		}

		else
			HOST_NAME = copy_str( hname );
	}

	HOST_ALIAS = host_alias_str( HOST_NAME );

	/* Get Home Directory */

	home = getenv("HOME");

	if ( home == NULL )
	{
		if ( (pw = getpwuid( getuid() )) != NULL )
			home = pw->pw_dir;

		else
			home = "/";

		HOME_DIR = copy_str( home );
	}

	else
		HOME_DIR = home;

	/* Get XPVM Main Directory */

	xpvm_dir = getenv("XPVM_ROOT");

	if ( xpvm_dir == NULL )
	{
		sprintf( tmp, "%s", XPVM_DEFAULT_DIR );

		if ( tmp[0] != '/' )
			sprintf( tmp, "%s/%s", HOME_DIR, XPVM_DEFAULT_DIR );

		XPVM_DIR = copy_str( tmp );
	}

	else
		XPVM_DIR = xpvm_dir;

	/* Check Hostfile */

	if ( HOSTFILE == NULL )
	{
		sprintf( tmp, "%s", DEFAULT_HOSTFILE );

		if ( tmp[0] != '/' )
			sprintf( tmp, "%s/%s", HOME_DIR, DEFAULT_HOSTFILE );
		
		HOSTFILE = copy_str( tmp );
	}

	/* Messages List */

	PENDING_MSG_LIST = (MSG) NULL;

	PENDING_MSG_GRID = (MSG_GRID **) NULL;

	MSG_GRID_SIZE = 0;

	MSG_LIST = (MSG) NULL;

	MQ_MAX_NBYTES = 1;

	/* Tasks List */

	TASK_LIST = (TASK) NULL;

	NTASKS = 0;

	/* Utilization State List */

	UT_LIST = (UT_STATE) NULL;

	UT_MAX_NTASKS = 1;

	/* Main Network */

	MAIN_NET = create_network();

	MAIN_NET->type = NETWORK_BUS;

	NHOSTS = 0;

	/* Architectures List */

	ARCH_LIST = (ARCH) NULL;

	/* TEV Descriptor List */

	TEVDESC_LIST = (TEVDESC *) NULL;

	TEVDESC_SIZE = -1;

	/* TEV Tasks List */

	TEVTASK_LIST = (TEVTASK) NULL;

	/* Trace Mask Group Lists */

	CURRENT_GROUP_LIST = (TRACE_MASK_GROUP *) NULL;

	TM33_GROUP_LIST = (TRACE_MASK_GROUP) NULL;
	TM_GROUP_LIST = (TRACE_MASK_GROUP) NULL;

	/* PVM 3.3 Trace Mask Index List */

	CURRENT_INDEX_LIST = (TRACE_MASK_INDEX *) NULL;

	TM33_INDEX_LIST = (TRACE_MASK_INDEX) NULL;
	TM_INDEX_LIST = (TRACE_MASK_INDEX) NULL;

	/* PVM 3.3 TRACING INIT */

	/* PVM 3.3 Trace Mask Indices */

	for ( i=TEV33_FIRST ; i <= TEV33_MAX ; i++ )
	{
		stripped = strip33_name( TEV33_TRACE_NAMES[i], &entry_exit );

		if ( entry_exit == ENTRY_TEV )
			set_trace_mask_index( &TM33_INDEX_LIST, stripped, i );

		TEV33_TYPE[i] = entry_exit;
	}

	for ( i=(TEV33_MAX + 1) ; i < TRACE33_MAX ; i++ )
		TEV33_TYPE[i] = IGNORE_TEV;

	/* Special PVM 3.3 Event Types */

	TEV33_TYPE[ TEV33_NEWTASK ]			= IGNORE_TEV;
	TEV33_TYPE[ TEV33_SPNTASK ]			= IGNORE_TEV;
	TEV33_TYPE[ TEV33_ENDTASK ]			= IGNORE_TEV;

	TEV33_TYPE[ TEV33_EXIT0 ]			= IGNORE_TEV;
	TEV33_TYPE[ TEV33_EXIT1 ]			= IGNORE_TEV;

	/* PVM 3.3 Trace Descriptor Status */

	for ( i=0 ; i < TRACE33_MAX ; i++ )
		TEV33_TRACE[i] = 0;

	/* PVM 3.4 TRACING INIT */

	/* PVM 3.4 Trace Mask Indices */

	for ( i=TEV_FIRST ; i <= TEV_MAX ; i++ )
	{
		uppered = upper_str( pvmtevinfo[i].name );

		set_trace_mask_index( &TM_INDEX_LIST, uppered, i );
	}

	/* Set Up Trace Event Lookup Tries */

	init_did_trie();

	init_event_trie33();

	init_event_trie();

	/* Set Default Trace Buffering */

	TRACE_BUF = 1;

	/* Set Trace Format */

	pvstr = pvm_version();

	if ( sscanf( pvstr, "%d.%d", &release, &version ) != 2 )
	{
		printf( "\nError: Unknown PVM Version Identifier \"%s\"\n\n",
			pvstr );
	}

	else
	{
		if ( release == 3 )
		{
			if ( version < 3 )
			{
				printf( "Error: Tracing Not Supported for PVM %d.%d\n",
					release, version );

				exit( 1 );
			}

			else if ( version == 3 )
				fmt = TEV_FMT_33;

			else
				fmt = TEV_FMT_34;
		}

		else
			fmt = TEV_FMT_34;

		set_trace_format( fmt, FALSE );
	}

	/* Initialize Time Vars */

	PROCESS_COUNTER_OVERWRITE = 4;
	PROCESS_COUNTER_PLAYBACK = 6;

	RECV_TIMER_OVERWRITE = 40;
	RECV_TIMER_PLAYBACK = 100;

	CURRENT_TIME.tv_sec = -1;
	CURRENT_TIME.tv_usec = -1;

	BASE_TIME.tv_sec = -1;
	BASE_TIME.tv_usec = -1;

	TRACE_TIME.tv_sec = -1;
	TRACE_TIME.tv_usec = -1;

	ST_SCROLL_MARK = 0;
	UT_SCROLL_MARK = 0;

	TIMEIDX = -1;

	/* Initialize Trace Globals */

	TRACE_FILE_STATUS = TRACE_FILE_OVERWRITE;

	PROCESS_COUNTER_INTERVAL = PROCESS_COUNTER_OVERWRITE;
	RECV_TIMER_INTERVAL = RECV_TIMER_OVERWRITE;

	TRACE_MODE_PENDING = TRACE_MODE_NONE;

	TRACE_PROCESS_LOCK = TRACE_UNLOCKED;

	TRACE_OVERWRITE_FLAG = FALSE;

	TRACE_STATUS = TRACE_FWD;

	TRACE_DO_SPAWN = FALSE;

	TRACE_PENDING = 0;

	TRACE_ACTIVE = FALSE;

	strcpy( TRACE_FILE, "" );

	TRACE_OUT = (FILE *) NULL;
	TRACE_IN = (FILE *) NULL;

	strcpy( OUTPUT_FILE, "" );

	OUTPUT_FP = (FILE *) NULL;

	TRACE_GROUP_TASKS = FALSE;

	/* Misc Globals */

	GROUPS_ALIVE = FALSE;

	return( TCL_OK );
}

tcl_init()
{
	/* Initialize TCL / TK */

	if ( Tcl_Init( interp ) == TCL_ERROR )
		return( TCL_ERROR );

	if ( Tk_Init( interp ) == TCL_ERROR )
		return( TCL_ERROR );

	/* Create TCL Commands for Action Routines */

	/* Main Console Commands */

	Tcl_CreateCommand( interp, "reset_trace_file",
		reset_trace_file_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "reset_views", reset_views_proc,
		(ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "reset_pvm", reset_pvm_proc,
		(ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "pvm_hosts", hosts_proc,
		(ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "pvm_tasks", tasks_proc,
		(ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "pvm_quit", quit_proc,
		(ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "pvm_halt", halt_proc,
		(ClientData) NULL, (vfp) NULL );

	/* Trace Playback Commands */

	Tcl_CreateCommand( interp, "trace_file_status_handle",
		trace_file_status_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "trace_overwrite_result",
		trace_overwrite_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "trace_file_handle", trace_file_proc,
		(ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "get_trace_format",
		get_trace_format_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "pvm_trace_mask", trace_mask_proc,
		(ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "trace_rewind", playback_proc,
		(ClientData) TRACE_REWIND, (vfp) NULL );

	Tcl_CreateCommand( interp, "trace_stop", playback_proc,
		(ClientData) TRACE_STOP, (vfp) NULL );

	Tcl_CreateCommand( interp, "trace_fwd", playback_proc,
		(ClientData) TRACE_FWD, (vfp) NULL );

	Tcl_CreateCommand( interp, "trace_fwdstep", playback_proc,
		(ClientData) TRACE_FWDSTEP, (vfp) NULL );

	/* Network View Commands */

	Tcl_CreateCommand( interp, "netSetMenuvar",
		network_set_menuvar, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "netReset",
		network_reset_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "netHostFind",
		network_host_find, (ClientData) NULL, (vfp) NULL );

	/* Space-Time Task Commands */

	Tcl_CreateCommand( interp, "taskArrange",
		task_arrange_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "taskCTUpdate",
		task_ct_update_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "taskCTQuery",
		task_ct_query_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "taskLabel",
		task_label_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "taskQuery",
		task_query_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "taskReset",
		task_reset_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "taskZoom",
		task_zoom_proc, (ClientData) NULL, (vfp) NULL );

	/* Space-Time Communication Commands */

	Tcl_CreateCommand( interp, "commArrange",
		comm_arrange_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "commQuery",
		comm_query_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "commZoom",
		comm_zoom_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "mqArrange",
		mq_arrange_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "mqUpdate",
		mq_update_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "mqQuery",
		mq_query_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "mqReset",
		mq_reset_proc, (ClientData) NULL, (vfp) NULL );

	/* Utilization View Commands */

	Tcl_CreateCommand( interp, "utAdjustHeight",
		ut_adjust_height_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "utToggle",
		ut_toggle_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "utReset",
		ut_reset_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "utZoom",
		ut_zoom_proc, (ClientData) NULL, (vfp) NULL );

	/* Menu & Miscellaneous Commands */

	Tcl_CreateCommand( interp, "initialize_tcl_globals",
		initialize_tcl_globals_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "update_scroll_marks",
		update_scroll_marks_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "define_trace_mask",
		define_trace_mask_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "output_file_handle", output_file_proc,
		(ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "load_bitmap_file", load_bitmap_file,
		(ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "pvm_get_tasks", get_tasks_proc,
		(ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "fix_help_line", fix_help_line_cmd,
		(ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "strip_label", strip_label_cmd,
		(ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "title_info", title_info_proc,
		(ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "get_hosts_menu_list",
		get_hosts_menu_list, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "define_arch", define_arch,
		(ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "double_click", double_click_proc,
		(ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "check_max_scale",
		check_max_scale_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "set_query_time",
		set_query_time_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "timeZoom",
		time_zoom_proc, (ClientData) NULL, (vfp) NULL );

	Tcl_CreateCommand( interp, "pad", pad_cmd,
		(ClientData) NULL, (vfp) NULL );

	return( TCL_OK );
}

pvm_init()
{
	char tmp[1024];

	char *av[4];
	int ac;

	int inum;
	int se;
	int cc;
	int i;

	/* Start PVM (if necessary) */

	av[0] = (char *) NULL;

	ac = 0;

	if ( HOSTFILE != NULL )
		av[ac++] = copy_str( HOSTFILE );

	if ( Nflag )
	{
		sprintf( tmp, "-n%s", HOST_NAME );

		av[ac++] = copy_str( tmp );
	}

	pvm_setopt( PvmResvTids, 1 );

	pvm_setopt( PvmRoute, PvmDontRoute );

	se = pvm_setopt( PvmAutoErr, 0 );

	cc = pvm_start_pvmd( ac, av, FALSE );

	if ( cc < 0 )
	{
		if ( cc == PvmDupHost )
		{
			printf( "Connecting to PVMD already running... " );
			fflush( stdout );

			NEW_PVM = FALSE;
		}

		else
		{
			pvm_perror( "Can't Start PVM" );

			exit( -1 );
		}
	}

	else
	{
		printf( "New PVMD started... " );
		fflush( stdout );

		NEW_PVM = TRUE;
	}

	pvm_setopt( PvmAutoErr, se );

	/* Get My TID */

	MYTID = pvm_mytid();

	if ( MYTID < 0 )
	{
		pvm_perror( "Error Joining PVM" );

		exit( -1 );
	}

	else
		printf( "XPVM connected as tid %x.\n", MYTID );

	/* Set Desired Signals After pvm_mytid() - match new console */

	signal( SIGTERM, SIG_IGN );
	signal( SIGALRM, SIG_IGN );

	signal( SIGINT, (vfp) quit_proc );
	signal( SIGQUIT, (vfp) quit_proc );

	/* Set Up Host Add Notify */

	pvm_notify( PvmHostAdd, 99, -1, (int *) NULL );

	/* Set PVM Options */

	pvm_setopt( PvmTraceCode, 666 );
	pvm_setopt( PvmTraceTid, MYTID );

	set_trace_buffer( TRACE_BUF );

	pvm_setopt( PvmOutputCode, 667 );
	pvm_setopt( PvmOutputTid, MYTID );

	trace_mask_init( TRACE33_MASK, &TM33_GROUP_LIST, TEV_FMT_33 );

	trace_mask_init( TRACE_MASK, &TM_GROUP_LIST, TEV_FMT_34 );

	INIT_TRACE_MASK( TRACE33_MASK_CLEAR, TEV_FMT_33 );

	INIT_TRACE_MASK( TRACE_MASK_CLEAR, TEV_FMT_34 );

	pvm_settmask( PvmTaskChild, CURRENT_TRACE_MASK );

	/* Set Up XPVM Group, Start Group Server (if necessary) */

	printf( "Setting up XPVM Group... " );
	fflush( stdout );

	inum = pvm_joingroup( "xpvm" );

	if ( inum != 0 )
	{
		if ( inum < 0 )
			pvm_perror( "Joining XPVM Group" );
		
		else
		{
			printf( "\nWarning: XPVM Already in Group, Instance=%d\n\n",
				inum );
		}

		cc = pvm_config( (int *) NULL, (int *) NULL,
			(struct pvmhostinfo **) NULL );

		if ( cc < 0 )
			error_exit();
	}

	else
		printf( "done.\n" );

	GROUPS_ALIVE = TRUE;

	read_hostfile();

	return( TCL_OK );
}

trace_mask_init( TMASK, TMG_LIST, fmt )
char *TMASK;
TRACE_MASK_GROUP *TMG_LIST;
int fmt;
{
	TRACE_MASK_GROUP TMG;

	char name[255];

	int j;

	/* Initialize Trace Mask */

	INIT_TRACE_MASK( TMASK, fmt );

	/* Do ALL_EVENTS Group Mask Hard-Wired */

	TMG = *TMG_LIST = create_trace_mask_group();

	sprintf( name, "ALL_%s_EVENTS",
		fmt == TEV_FMT_33 ? "3_3" : "3_4" );

	TMG->name = copy_str( name );

	TMG->tmask = (char *) malloc( (unsigned) TRACE_MASK_LENGTH( fmt )
		* sizeof(char) );
	memcheck( TMG->tmask, "Group Trace Mask" );

	INIT_TRACE_MASK( TMG->tmask, fmt );

	for ( j=FIRST_EVENT( fmt ) ; j <= LAST_EVENT( fmt ) ;
		j += EVENT_INCR( fmt ) )
	{
		SET_TRACE_MASK( TMG->tmask, fmt, j );
	}
}

window_init()
{
	static char fname[1024];

	FILE *fptest;

	/* Set up GLOBAL structs */

	define_tcl_globals();

	/* Create Interface - TCL Script */

	fptest = fopen( "xpvm.tcl", "r" );

	if ( fptest != NULL )
	{
		strcpy( fname, "xpvm.tcl" );

		fclose( fptest );
	}

	else
		sprintf( fname, "%s/xpvm.tcl", XPVM_DIR );

	if ( Tcl_EvalFile( interp, fname ) == TCL_ERROR )
		return( TCL_ERROR );

	/* Check Hosts */

	initialize_hosts();

	/* If Host Status Events are Pending, Do Them Now */

	if ( !TRACE_PENDING )
		TRACE_PENDING = save_host_status_events();

	/* Initialize Trace Controls Setting */

	set_trace_controls();

	/* Set Up Event Polling Proc */

	Tk_DoWhenIdle( (Tk_IdleProc *) recv_event_proc, (ClientData) NULL );

	return( TCL_OK );
}

define_tcl_globals()
{
	/* Drawing Constants */

	FRAME_BORDER = MAKE_TCL_GLOBAL( "frame_border", TCL_GLOBAL_INT );

	FRAME_OFFSET = MAKE_TCL_GLOBAL( "FRAME_OFFSET", TCL_GLOBAL_INT );

	BORDER_SPACE = MAKE_TCL_GLOBAL( "border_space", TCL_GLOBAL_INT );

	ROW_HEIGHT = MAKE_TCL_GLOBAL( "row_height", TCL_GLOBAL_INT );

	DEPTH = MAKE_TCL_GLOBAL( "depth", TCL_GLOBAL_INT );

	/* Network Constants */

	NET_CHEIGHT = MAKE_TCL_GLOBAL( "net_cheight", TCL_GLOBAL_INT );

	NET_HHEIGHT = MAKE_TCL_GLOBAL( "net_hheight", TCL_GLOBAL_INT );

	NET_CWIDTH = MAKE_TCL_GLOBAL( "net_cwidth", TCL_GLOBAL_INT );

	NET_HWIDTH = MAKE_TCL_GLOBAL( "net_hwidth", TCL_GLOBAL_INT );

	ICON_BORDER = MAKE_TCL_GLOBAL( "icon_border", TCL_GLOBAL_INT );

	ICON_SPACE = MAKE_TCL_GLOBAL( "icon_space", TCL_GLOBAL_INT );

	NET_SCROLL = MAKE_TCL_GLOBAL( "net_scroll", TCL_GLOBAL_INT );

	NET_FLASH = MAKE_TCL_GLOBAL( "net_flash", TCL_GLOBAL_INT );

	NET_SPACE = MAKE_TCL_GLOBAL( "net_space", TCL_GLOBAL_INT );

	NET_XVIEW = MAKE_TCL_GLOBAL( "net_xview", TCL_GLOBAL_INT );

	NET_YVIEW = MAKE_TCL_GLOBAL( "net_yview", TCL_GLOBAL_INT );

	NET_SIZE = MAKE_TCL_GLOBAL( "net_size", TCL_GLOBAL_INT );

	/* Space-Time Constants */

	ST_CANVAS_HEIGHT = MAKE_TCL_GLOBAL( "st_canvas_height",
		TCL_GLOBAL_INT );

	ST_TIMELINE = MAKE_TCL_GLOBAL( "st_timeline", TCL_GLOBAL_INT );

	ST_CHEIGHT = MAKE_TCL_GLOBAL( "st_cheight", TCL_GLOBAL_INT );

	ST_CWIDTH = MAKE_TCL_GLOBAL( "st_cwidth", TCL_GLOBAL_INT );

	ST_LABEL_HT = MAKE_TCL_GLOBAL( "st_label_ht", TCL_GLOBAL_INT );

	ST_RECT_HT = MAKE_TCL_GLOBAL( "st_rect_ht", TCL_GLOBAL_INT );

	STL_YVIEW = MAKE_TCL_GLOBAL( "stl_yview", TCL_GLOBAL_INT );

	ST_ACTIVE = MAKE_TCL_GLOBAL( "st_active", TCL_GLOBAL_CHAR );

	ST_TIMEID = MAKE_TCL_GLOBAL( "st_timeid", TCL_GLOBAL_INT );

	ST_XVIEW = MAKE_TCL_GLOBAL( "st_xview", TCL_GLOBAL_INT );

	TIMEID_PRIM = MAKE_TCL_GLOBAL( "timeid_prim", TCL_GLOBAL_CHAR );

	TIMEX = MAKE_TCL_GLOBAL( "timex", TCL_GLOBAL_INT );

	SCALE = MAKE_TCL_GLOBAL( "scale", TCL_GLOBAL_INT );

	/* Utilization View Constants */

	UT_CANVAS_HEIGHT = MAKE_TCL_GLOBAL( "ut_canvas_height",
		TCL_GLOBAL_INT );

	UT_CHEIGHT = MAKE_TCL_GLOBAL( "ut_cheight", TCL_GLOBAL_INT );

	UT_CWIDTH = MAKE_TCL_GLOBAL( "ut_cwidth", TCL_GLOBAL_INT );

	UT_ACTIVE = MAKE_TCL_GLOBAL( "ut_active", TCL_GLOBAL_CHAR );

	UT_TIMEID = MAKE_TCL_GLOBAL( "ut_timeid", TCL_GLOBAL_INT );

	UT_XVIEW = MAKE_TCL_GLOBAL( "ut_xview", TCL_GLOBAL_INT );

	/* Message Queue Constants */

	MQ_TASK_WT = MAKE_TCL_GLOBAL( "mq_task_wt", TCL_GLOBAL_INT );

	MQ_CHEIGHT = MAKE_TCL_GLOBAL( "mq_cheight", TCL_GLOBAL_INT );

	MQ_ACTIVE = MAKE_TCL_GLOBAL( "mq_active", TCL_GLOBAL_CHAR );

	MQ_CWIDTH = MAKE_TCL_GLOBAL( "mq_cwidth", TCL_GLOBAL_INT );

	MQ_XVIEW = MAKE_TCL_GLOBAL( "mq_xview", TCL_GLOBAL_INT );

	/* Call Trace Constants */

	CT_QUERY_INDEX = MAKE_TCL_GLOBAL( "ct_query_index",
		TCL_GLOBAL_INT );

	CT_CHEIGHT = MAKE_TCL_GLOBAL( "ct_cheight", TCL_GLOBAL_INT );

	CT_ACTIVE = MAKE_TCL_GLOBAL( "ct_active", TCL_GLOBAL_CHAR );

	CT_YVIEW = MAKE_TCL_GLOBAL( "ct_yview", TCL_GLOBAL_INT );

	/* Colors */

	NET_RUNNING_COLOR = MAKE_TCL_GLOBAL( "net_running_color",
		TCL_GLOBAL_CHAR );

	NET_SYSTEM_COLOR = MAKE_TCL_GLOBAL( "net_system_color",
		TCL_GLOBAL_CHAR );

	NET_IDLE_COLOR = MAKE_TCL_GLOBAL( "net_idle_color",
		TCL_GLOBAL_CHAR );

	NET_EMPTY_COLOR = MAKE_TCL_GLOBAL( "net_empty_color",
		TCL_GLOBAL_CHAR );

	NET_FG_COLOR = MAKE_TCL_GLOBAL( "net_fg_color", TCL_GLOBAL_CHAR );

	NET_ALIVE_COLOR = MAKE_TCL_GLOBAL( "net_alive_color",
		TCL_GLOBAL_CHAR );

	NET_DEAD_COLOR = MAKE_TCL_GLOBAL( "net_dead_color",
		TCL_GLOBAL_CHAR );

	NET_VOLUME7_COLOR = MAKE_TCL_GLOBAL( "net_volume7_color",
		TCL_GLOBAL_CHAR );
	NET_VOLUME6_COLOR = MAKE_TCL_GLOBAL( "net_volume6_color",
		TCL_GLOBAL_CHAR );
	NET_VOLUME5_COLOR = MAKE_TCL_GLOBAL( "net_volume5_color",
		TCL_GLOBAL_CHAR );
	NET_VOLUME4_COLOR = MAKE_TCL_GLOBAL( "net_volume4_color",
		TCL_GLOBAL_CHAR );
	NET_VOLUME3_COLOR = MAKE_TCL_GLOBAL( "net_volume3_color",
		TCL_GLOBAL_CHAR );
	NET_VOLUME2_COLOR = MAKE_TCL_GLOBAL( "net_volume2_color",
		TCL_GLOBAL_CHAR );
	NET_VOLUME1_COLOR = MAKE_TCL_GLOBAL( "net_volume1_color",
		TCL_GLOBAL_CHAR );
	NET_VOLUME0_COLOR = MAKE_TCL_GLOBAL( "net_volume0_color",
		TCL_GLOBAL_CHAR );

	ST_OUTLINE_COLOR = MAKE_TCL_GLOBAL( "st_outline_color",
		TCL_GLOBAL_CHAR );

	ST_RUNNING_COLOR = MAKE_TCL_GLOBAL( "st_running_color",
		TCL_GLOBAL_CHAR );

	ST_SYSTEM_COLOR = MAKE_TCL_GLOBAL( "st_system_color",
		TCL_GLOBAL_CHAR );

	ST_IDLE_COLOR = MAKE_TCL_GLOBAL( "st_idle_color", TCL_GLOBAL_CHAR );

	ST_COMM_COLOR = MAKE_TCL_GLOBAL( "st_comm_color", TCL_GLOBAL_CHAR );

	UT_RUNNING_COLOR = MAKE_TCL_GLOBAL( "ut_running_color",
		TCL_GLOBAL_CHAR );

	UT_SYSTEM_COLOR = MAKE_TCL_GLOBAL( "ut_system_color",
		TCL_GLOBAL_CHAR );

	UT_IDLE_COLOR = MAKE_TCL_GLOBAL( "ut_idle_color", TCL_GLOBAL_CHAR );

	MQ_MSG_NOSIZE_COLOR = MAKE_TCL_GLOBAL( "mq_msg_nosize_color",
		TCL_GLOBAL_CHAR );

	MQ_MSG_SIZE_COLOR = MAKE_TCL_GLOBAL( "mq_msg_size_color",
		TCL_GLOBAL_CHAR );

	MQ_OUTLINE_COLOR = MAKE_TCL_GLOBAL( "mq_outline_color",
		TCL_GLOBAL_CHAR );

	FG_COLOR = MAKE_TCL_GLOBAL( "fg_color", TCL_GLOBAL_CHAR );
}

/* ARGSUSED */
int initialize_tcl_globals_proc( clientData, itp, argc, argv )
ClientData clientData;
Tcl_Interp *itp;
int argc;
char **argv;
{
	/* Window Names */

	NET_C = GET_TCL_GLOBAL( interp, "NET_C" );
	NET_SBH = GET_TCL_GLOBAL( interp, "NET_SBH" );
	NET_SBV = GET_TCL_GLOBAL( interp, "NET_SBV" );

	MAIN_NET->NET_C = NET_C;

	CTRL = GET_TCL_GLOBAL( interp, "CTRL" );

	ST = GET_TCL_GLOBAL( interp, "ST" );
	ST_L = GET_TCL_GLOBAL( interp, "ST_L" );
	ST_C = GET_TCL_GLOBAL( interp, "ST_C" );
	ST_SBH = GET_TCL_GLOBAL( interp, "ST_SBH" );
	ST_SBV = GET_TCL_GLOBAL( interp, "ST_SBV" );

	SP = GET_TCL_GLOBAL( interp, "SP" );

	KL = GET_TCL_GLOBAL( interp, "KL" );
	KL_C = GET_TCL_GLOBAL( interp, "KL_C" );
	KL_SBH = GET_TCL_GLOBAL( interp, "KL_SBH" );
	KL_SBV = GET_TCL_GLOBAL( interp, "KL_SBV" );

	SG = GET_TCL_GLOBAL( interp, "SG" );
	SG_C = GET_TCL_GLOBAL( interp, "SG_C" );
	SG_SBH = GET_TCL_GLOBAL( interp, "SG_SBH" );
	SG_SBV = GET_TCL_GLOBAL( interp, "SG_SBV" );
	SG_LF = GET_TCL_GLOBAL( interp, "SG_LF" );
	SG_LFC = GET_TCL_GLOBAL( interp, "SG_LFC" );
	SG_LFCW = GET_TCL_GLOBAL( interp, "SG_LFCW" );
	SG_LSBV = GET_TCL_GLOBAL( interp, "SG_LSBV" );

	OV = GET_TCL_GLOBAL( interp, "OV" );

	UT = GET_TCL_GLOBAL( interp, "UT" );
	UT_C = GET_TCL_GLOBAL( interp, "UT_C" );
	UT_SBH = GET_TCL_GLOBAL( interp, "UT_SBH" );

	MQ = GET_TCL_GLOBAL( interp, "MQ" );
	MQ_C = GET_TCL_GLOBAL( interp, "MQ_C" );
	MQ_SBH = GET_TCL_GLOBAL( interp, "MQ_SBH" );

	CT = GET_TCL_GLOBAL( interp, "CT" );
	CT_L = GET_TCL_GLOBAL( interp, "CT_L" );
	CT_C = GET_TCL_GLOBAL( interp, "CT_C" );
	CT_SBH = GET_TCL_GLOBAL( interp, "CT_SBH" );
	CT_SBV = GET_TCL_GLOBAL( interp, "CT_SBV" );

	TO = GET_TCL_GLOBAL( interp, "TO" );
	TO_C = GET_TCL_GLOBAL( interp, "TO_C" );
	TO_SBH = GET_TCL_GLOBAL( interp, "TO_SBH" );
	TO_SBV = GET_TCL_GLOBAL( interp, "TO_SBV" );

	return( TCL_OK );
}

